const pveOnlineHelpInfo = {
   "ceph_rados_block_devices" : {
      "link" : "/pve-docs/chapter-pvesm.html#ceph_rados_block_devices",
      "title" : "Ceph RADOS Block Devices (RBD)"
   },
   "chapter_gui" : {
      "link" : "/pve-docs/chapter-pve-gui.html#chapter_gui",
      "title" : "Graphical User Interface"
   },
   "chapter_ha_manager" : {
      "link" : "/pve-docs/chapter-ha-manager.html#chapter_ha_manager",
      "title" : "High Availability"
   },
   "chapter_lvm" : {
      "link" : "/pve-docs/chapter-sysadmin.html#chapter_lvm",
      "title" : "Logical Volume Manager (LVM)"
   },
   "chapter_notifications" : {
      "link" : "/pve-docs/chapter-notifications.html#chapter_notifications",
      "title" : "Notifications"
   },
   "chapter_pct" : {
      "link" : "/pve-docs/chapter-pct.html#chapter_pct",
      "title" : "Proxmox Container Toolkit"
   },
   "chapter_pve_firewall" : {
      "link" : "/pve-docs/chapter-pve-firewall.html#chapter_pve_firewall",
      "title" : "Proxmox VE Firewall"
   },
   "chapter_pveceph" : {
      "link" : "/pve-docs/chapter-pveceph.html#chapter_pveceph",
      "title" : "Deploy Hyper-Converged Ceph Cluster"
   },
   "chapter_pvecm" : {
      "link" : "/pve-docs/chapter-pvecm.html#chapter_pvecm",
      "title" : "Cluster Manager"
   },
   "chapter_pvesdn" : {
      "link" : "/pve-docs/chapter-pvesdn.html#chapter_pvesdn",
      "title" : "Software-Defined Network"
   },
   "chapter_pvesr" : {
      "link" : "/pve-docs/chapter-pvesr.html#chapter_pvesr",
      "title" : "Storage Replication"
   },
   "chapter_storage" : {
      "link" : "/pve-docs/chapter-pvesm.html#chapter_storage",
      "title" : "Proxmox VE Storage"
   },
   "chapter_system_administration" : {
      "link" : "/pve-docs/chapter-sysadmin.html#chapter_system_administration",
      "title" : "Host System Administration"
   },
   "chapter_user_management" : {
      "link" : "/pve-docs/chapter-pveum.html#chapter_user_management",
      "title" : "User Management"
   },
   "chapter_virtual_machines" : {
      "link" : "/pve-docs/chapter-qm.html#chapter_virtual_machines",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "chapter_vzdump" : {
      "link" : "/pve-docs/chapter-vzdump.html#chapter_vzdump",
      "title" : "Backup and Restore"
   },
   "chapter_zfs" : {
      "link" : "/pve-docs/chapter-sysadmin.html#chapter_zfs",
      "title" : "ZFS on Linux"
   },
   "datacenter_configuration_file" : {
      "link" : "/pve-docs/pve-admin-guide.html#datacenter_configuration_file",
      "title" : "Datacenter Configuration"
   },
   "external_metric_server" : {
      "link" : "/pve-docs/chapter-sysadmin.html#external_metric_server",
      "title" : "External Metric Server"
   },
   "getting_help" : {
      "link" : "/pve-docs/pve-admin-guide.html#getting_help",
      "title" : "Getting Help"
   },
   "gui_consent_banner" : {
      "link" : "/pve-docs/chapter-pve-gui.html#gui_consent_banner",
      "subtitle" : "Consent Banner",
      "title" : "Graphical User Interface"
   },
   "gui_my_settings" : {
      "link" : "/pve-docs/chapter-pve-gui.html#gui_my_settings",
      "subtitle" : "My Settings",
      "title" : "Graphical User Interface"
   },
   "ha_manager_crs" : {
      "link" : "/pve-docs/chapter-ha-manager.html#ha_manager_crs",
      "subtitle" : "Cluster Resource Scheduling",
      "title" : "High Availability"
   },
   "ha_manager_fencing" : {
      "link" : "/pve-docs/chapter-ha-manager.html#ha_manager_fencing",
      "subtitle" : "Fencing",
      "title" : "High Availability"
   },
   "ha_manager_groups" : {
      "link" : "/pve-docs/chapter-ha-manager.html#ha_manager_groups",
      "subtitle" : "Groups",
      "title" : "High Availability"
   },
   "ha_manager_resource_config" : {
      "link" : "/pve-docs/chapter-ha-manager.html#ha_manager_resource_config",
      "subtitle" : "Resources",
      "title" : "High Availability"
   },
   "ha_manager_resources" : {
      "link" : "/pve-docs/chapter-ha-manager.html#ha_manager_resources",
      "subtitle" : "Resources",
      "title" : "High Availability"
   },
   "ha_manager_shutdown_policy" : {
      "link" : "/pve-docs/chapter-ha-manager.html#ha_manager_shutdown_policy",
      "subtitle" : "Shutdown Policy",
      "title" : "High Availability"
   },
   "markdown_basics" : {
      "link" : "/pve-docs/pve-admin-guide.html#markdown_basics",
      "title" : "Markdown Primer"
   },
   "metric_server_graphite" : {
      "link" : "/pve-docs/chapter-sysadmin.html#metric_server_graphite",
      "subtitle" : "Graphite server configuration",
      "title" : "External Metric Server"
   },
   "metric_server_influxdb" : {
      "link" : "/pve-docs/chapter-sysadmin.html#metric_server_influxdb",
      "subtitle" : "Influxdb plugin configuration",
      "title" : "External Metric Server"
   },
   "notification_matchers" : {
      "link" : "/pve-docs/chapter-notifications.html#notification_matchers",
      "subtitle" : "Notification Matchers",
      "title" : "Notifications"
   },
   "notification_targets_gotify" : {
      "link" : "/pve-docs/chapter-notifications.html#notification_targets_gotify",
      "subtitle" : "Gotify",
      "title" : "Notifications"
   },
   "notification_targets_sendmail" : {
      "link" : "/pve-docs/chapter-notifications.html#notification_targets_sendmail",
      "subtitle" : "Sendmail",
      "title" : "Notifications"
   },
   "notification_targets_smtp" : {
      "link" : "/pve-docs/chapter-notifications.html#notification_targets_smtp",
      "subtitle" : "SMTP",
      "title" : "Notifications"
   },
   "notification_targets_webhook" : {
      "link" : "/pve-docs/chapter-notifications.html#notification_targets_webhook",
      "subtitle" : "Webhook",
      "title" : "Notifications"
   },
   "pct_configuration" : {
      "link" : "/pve-docs/chapter-pct.html#pct_configuration",
      "subtitle" : "Configuration",
      "title" : "Proxmox Container Toolkit"
   },
   "pct_container_images" : {
      "link" : "/pve-docs/chapter-pct.html#pct_container_images",
      "subtitle" : "Container Images",
      "title" : "Proxmox Container Toolkit"
   },
   "pct_container_network" : {
      "link" : "/pve-docs/chapter-pct.html#pct_container_network",
      "subtitle" : "Network",
      "title" : "Proxmox Container Toolkit"
   },
   "pct_container_storage" : {
      "link" : "/pve-docs/chapter-pct.html#pct_container_storage",
      "subtitle" : "Container Storage",
      "title" : "Proxmox Container Toolkit"
   },
   "pct_cpu" : {
      "link" : "/pve-docs/chapter-pct.html#pct_cpu",
      "subtitle" : "CPU",
      "title" : "Proxmox Container Toolkit"
   },
   "pct_general" : {
      "link" : "/pve-docs/chapter-pct.html#pct_general",
      "subtitle" : "General Settings",
      "title" : "Proxmox Container Toolkit"
   },
   "pct_memory" : {
      "link" : "/pve-docs/chapter-pct.html#pct_memory",
      "subtitle" : "Memory",
      "title" : "Proxmox Container Toolkit"
   },
   "pct_migration" : {
      "link" : "/pve-docs/chapter-pct.html#pct_migration",
      "subtitle" : "Migration",
      "title" : "Proxmox Container Toolkit"
   },
   "pct_options" : {
      "link" : "/pve-docs/chapter-pct.html#pct_options",
      "subtitle" : "Options",
      "title" : "Proxmox Container Toolkit"
   },
   "pct_startup_and_shutdown" : {
      "link" : "/pve-docs/chapter-pct.html#pct_startup_and_shutdown",
      "subtitle" : "Automatic Start and Shutdown of Containers",
      "title" : "Proxmox Container Toolkit"
   },
   "proxmox_node_management" : {
      "link" : "/pve-docs/chapter-sysadmin.html#proxmox_node_management",
      "title" : "Proxmox Node Management"
   },
   "pve_admin_guide" : {
      "link" : "/pve-docs/pve-admin-guide.html",
      "title" : "Proxmox VE Administration Guide"
   },
   "pve_ceph_install" : {
      "link" : "/pve-docs/chapter-pveceph.html#pve_ceph_install",
      "subtitle" : "CLI Installation of Ceph Packages",
      "title" : "Deploy Hyper-Converged Ceph Cluster"
   },
   "pve_ceph_osds" : {
      "link" : "/pve-docs/chapter-pveceph.html#pve_ceph_osds",
      "subtitle" : "Ceph OSDs",
      "title" : "Deploy Hyper-Converged Ceph Cluster"
   },
   "pve_ceph_pools" : {
      "link" : "/pve-docs/chapter-pveceph.html#pve_ceph_pools",
      "subtitle" : "Ceph Pools",
      "title" : "Deploy Hyper-Converged Ceph Cluster"
   },
   "pve_documentation_index" : {
      "link" : "/pve-docs/index.html",
      "title" : "Proxmox VE Documentation Index"
   },
   "pve_firewall_cluster_wide_setup" : {
      "link" : "/pve-docs/chapter-pve-firewall.html#pve_firewall_cluster_wide_setup",
      "subtitle" : "Cluster Wide Setup",
      "title" : "Proxmox VE Firewall"
   },
   "pve_firewall_host_specific_configuration" : {
      "link" : "/pve-docs/chapter-pve-firewall.html#pve_firewall_host_specific_configuration",
      "subtitle" : "Host Specific Configuration",
      "title" : "Proxmox VE Firewall"
   },
   "pve_firewall_ip_aliases" : {
      "link" : "/pve-docs/chapter-pve-firewall.html#pve_firewall_ip_aliases",
      "subtitle" : "IP Aliases",
      "title" : "Proxmox VE Firewall"
   },
   "pve_firewall_ip_sets" : {
      "link" : "/pve-docs/chapter-pve-firewall.html#pve_firewall_ip_sets",
      "subtitle" : "IP Sets",
      "title" : "Proxmox VE Firewall"
   },
   "pve_firewall_security_groups" : {
      "link" : "/pve-docs/chapter-pve-firewall.html#pve_firewall_security_groups",
      "subtitle" : "Security Groups",
      "title" : "Proxmox VE Firewall"
   },
   "pve_firewall_vm_container_configuration" : {
      "link" : "/pve-docs/chapter-pve-firewall.html#pve_firewall_vm_container_configuration",
      "subtitle" : "VM/Container Configuration",
      "title" : "Proxmox VE Firewall"
   },
   "pve_service_daemons" : {
      "link" : "/pve-docs/index.html#_service_daemons",
      "title" : "Service Daemons"
   },
   "pveceph_fs" : {
      "link" : "/pve-docs/chapter-pveceph.html#pveceph_fs",
      "subtitle" : "CephFS",
      "title" : "Deploy Hyper-Converged Ceph Cluster"
   },
   "pveceph_fs_create" : {
      "link" : "/pve-docs/chapter-pveceph.html#pveceph_fs_create",
      "subtitle" : "Create CephFS",
      "title" : "Deploy Hyper-Converged Ceph Cluster"
   },
   "pvecm_create_cluster" : {
      "link" : "/pve-docs/chapter-pvecm.html#pvecm_create_cluster",
      "subtitle" : "Create a Cluster",
      "title" : "Cluster Manager"
   },
   "pvecm_join_node_to_cluster" : {
      "link" : "/pve-docs/chapter-pvecm.html#pvecm_join_node_to_cluster",
      "subtitle" : "Adding Nodes to the Cluster",
      "title" : "Cluster Manager"
   },
   "pvesdn_config_controllers" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_config_controllers",
      "subtitle" : "Controllers",
      "title" : "Software-Defined Network"
   },
   "pvesdn_config_vnet" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_config_vnet",
      "subtitle" : "VNets",
      "title" : "Software-Defined Network"
   },
   "pvesdn_config_zone" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_config_zone",
      "subtitle" : "Zones",
      "title" : "Software-Defined Network"
   },
   "pvesdn_controller_plugin_evpn" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_controller_plugin_evpn",
      "subtitle" : "EVPN Controller",
      "title" : "Software-Defined Network"
   },
   "pvesdn_dns_plugin_powerdns" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_dns_plugin_powerdns",
      "subtitle" : "PowerDNS Plugin",
      "title" : "Software-Defined Network"
   },
   "pvesdn_firewall_integration" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_firewall_integration",
      "subtitle" : "Firewall Integration",
      "title" : "Software-Defined Network"
   },
   "pvesdn_ipam_plugin_netbox" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_ipam_plugin_netbox",
      "subtitle" : "NetBox IPAM Plugin",
      "title" : "Software-Defined Network"
   },
   "pvesdn_ipam_plugin_phpipam" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_ipam_plugin_phpipam",
      "subtitle" : "phpIPAM Plugin",
      "title" : "Software-Defined Network"
   },
   "pvesdn_ipam_plugin_pveipam" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_ipam_plugin_pveipam",
      "subtitle" : "PVE IPAM Plugin",
      "title" : "Software-Defined Network"
   },
   "pvesdn_zone_plugin_evpn" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_zone_plugin_evpn",
      "subtitle" : "EVPN Zones",
      "title" : "Software-Defined Network"
   },
   "pvesdn_zone_plugin_qinq" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_zone_plugin_qinq",
      "subtitle" : "QinQ Zones",
      "title" : "Software-Defined Network"
   },
   "pvesdn_zone_plugin_simple" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_zone_plugin_simple",
      "subtitle" : "Simple Zones",
      "title" : "Software-Defined Network"
   },
   "pvesdn_zone_plugin_vlan" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_zone_plugin_vlan",
      "subtitle" : "VLAN Zones",
      "title" : "Software-Defined Network"
   },
   "pvesdn_zone_plugin_vxlan" : {
      "link" : "/pve-docs/chapter-pvesdn.html#pvesdn_zone_plugin_vxlan",
      "subtitle" : "VXLAN Zones",
      "title" : "Software-Defined Network"
   },
   "pvesr_schedule_time_format" : {
      "link" : "/pve-docs/chapter-pvesr.html#pvesr_schedule_time_format",
      "subtitle" : "Schedule Format",
      "title" : "Storage Replication"
   },
   "pveum_authentication_realms" : {
      "link" : "/pve-docs/chapter-pveum.html#pveum_authentication_realms",
      "subtitle" : "Authentication Realms",
      "title" : "User Management"
   },
   "pveum_configure_u2f" : {
      "link" : "/pve-docs/chapter-pveum.html#pveum_configure_u2f",
      "subtitle" : "Server Side U2F Configuration",
      "title" : "User Management"
   },
   "pveum_configure_webauthn" : {
      "link" : "/pve-docs/chapter-pveum.html#pveum_configure_webauthn",
      "subtitle" : "Server Side Webauthn Configuration",
      "title" : "User Management"
   },
   "pveum_groups" : {
      "link" : "/pve-docs/chapter-pveum.html#pveum_groups",
      "subtitle" : "Groups",
      "title" : "User Management"
   },
   "pveum_ldap_sync" : {
      "link" : "/pve-docs/chapter-pveum.html#pveum_ldap_sync",
      "subtitle" : "Syncing LDAP-Based Realms",
      "title" : "User Management"
   },
   "pveum_permission_management" : {
      "link" : "/pve-docs/chapter-pveum.html#pveum_permission_management",
      "subtitle" : "Permission Management",
      "title" : "User Management"
   },
   "pveum_pools" : {
      "link" : "/pve-docs/chapter-pveum.html#pveum_pools",
      "subtitle" : "Pools",
      "title" : "User Management"
   },
   "pveum_roles" : {
      "link" : "/pve-docs/chapter-pveum.html#pveum_roles",
      "subtitle" : "Roles",
      "title" : "User Management"
   },
   "pveum_tokens" : {
      "link" : "/pve-docs/chapter-pveum.html#pveum_tokens",
      "subtitle" : "API Tokens",
      "title" : "User Management"
   },
   "pveum_users" : {
      "link" : "/pve-docs/chapter-pveum.html#pveum_users",
      "subtitle" : "Users",
      "title" : "User Management"
   },
   "qm_bios_and_uefi" : {
      "link" : "/pve-docs/chapter-qm.html#qm_bios_and_uefi",
      "subtitle" : "BIOS and UEFI",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_bootorder" : {
      "link" : "/pve-docs/chapter-qm.html#qm_bootorder",
      "subtitle" : "Device Boot Order",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_cloud_init" : {
      "link" : "/pve-docs/chapter-qm.html#qm_cloud_init",
      "title" : "Cloud-Init Support"
   },
   "qm_copy_and_clone" : {
      "link" : "/pve-docs/chapter-qm.html#qm_copy_and_clone",
      "subtitle" : "Copies and Clones",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_cpu" : {
      "link" : "/pve-docs/chapter-qm.html#qm_cpu",
      "subtitle" : "CPU",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_display" : {
      "link" : "/pve-docs/chapter-qm.html#qm_display",
      "subtitle" : "Display",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_general_settings" : {
      "link" : "/pve-docs/chapter-qm.html#qm_general_settings",
      "subtitle" : "General Settings",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_hard_disk" : {
      "link" : "/pve-docs/chapter-qm.html#qm_hard_disk",
      "subtitle" : "Hard Disk",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_import_virtual_machines" : {
      "link" : "/pve-docs/chapter-qm.html#qm_import_virtual_machines",
      "subtitle" : "Importing Virtual Machines",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_machine_type" : {
      "link" : "/pve-docs/chapter-qm.html#qm_machine_type",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_memory" : {
      "link" : "/pve-docs/chapter-qm.html#qm_memory",
      "subtitle" : "Memory",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_migration" : {
      "link" : "/pve-docs/chapter-qm.html#qm_migration",
      "subtitle" : "Migration",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_network_device" : {
      "link" : "/pve-docs/chapter-qm.html#qm_network_device",
      "subtitle" : "Network Device",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_options" : {
      "link" : "/pve-docs/chapter-qm.html#qm_options",
      "subtitle" : "Options",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_os_settings" : {
      "link" : "/pve-docs/chapter-qm.html#qm_os_settings",
      "subtitle" : "OS Settings",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_pci_passthrough_vm_config" : {
      "link" : "/pve-docs/chapter-qm.html#qm_pci_passthrough_vm_config",
      "subtitle" : "VM Configuration",
      "title" : "PCI(e) Passthrough"
   },
   "qm_qemu_agent" : {
      "link" : "/pve-docs/chapter-qm.html#qm_qemu_agent",
      "subtitle" : "QEMU Guest Agent",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_spice_enhancements" : {
      "link" : "/pve-docs/chapter-qm.html#qm_spice_enhancements",
      "subtitle" : "SPICE Enhancements",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_startup_and_shutdown" : {
      "link" : "/pve-docs/chapter-qm.html#qm_startup_and_shutdown",
      "subtitle" : "Automatic Start and Shutdown of Virtual Machines",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_system_settings" : {
      "link" : "/pve-docs/chapter-qm.html#qm_system_settings",
      "subtitle" : "System Settings",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_usb_passthrough" : {
      "link" : "/pve-docs/chapter-qm.html#qm_usb_passthrough",
      "subtitle" : "USB Passthrough",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_virtio_rng" : {
      "link" : "/pve-docs/chapter-qm.html#qm_virtio_rng",
      "subtitle" : "VirtIO RNG",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_virtiofs" : {
      "link" : "/pve-docs/chapter-qm.html#qm_virtiofs",
      "subtitle" : "Virtiofs",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "qm_virtual_machines_settings" : {
      "link" : "/pve-docs/chapter-qm.html#qm_virtual_machines_settings",
      "subtitle" : "Virtual Machines Settings",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "resource_mapping" : {
      "link" : "/pve-docs/chapter-qm.html#resource_mapping",
      "subtitle" : "Resource Mapping",
      "title" : "QEMU/KVM Virtual Machines"
   },
   "storage_btrfs" : {
      "link" : "/pve-docs/chapter-pvesm.html#storage_btrfs",
      "title" : "BTRFS Backend"
   },
   "storage_cephfs" : {
      "link" : "/pve-docs/chapter-pvesm.html#storage_cephfs",
      "title" : "Ceph Filesystem (CephFS)"
   },
   "storage_cifs" : {
      "link" : "/pve-docs/chapter-pvesm.html#storage_cifs",
      "title" : "CIFS Backend"
   },
   "storage_directory" : {
      "link" : "/pve-docs/chapter-pvesm.html#storage_directory",
      "title" : "Directory Backend"
   },
   "storage_glusterfs" : {
      "link" : "/pve-docs/chapter-pvesm.html#storage_glusterfs",
      "title" : "GlusterFS Backend"
   },
   "storage_lvm" : {
      "link" : "/pve-docs/chapter-pvesm.html#storage_lvm",
      "title" : "LVM Backend"
   },
   "storage_lvmthin" : {
      "link" : "/pve-docs/chapter-pvesm.html#storage_lvmthin",
      "title" : "LVM thin Backend"
   },
   "storage_nfs" : {
      "link" : "/pve-docs/chapter-pvesm.html#storage_nfs",
      "title" : "NFS Backend"
   },
   "storage_open_iscsi" : {
      "link" : "/pve-docs/chapter-pvesm.html#storage_open_iscsi",
      "title" : "Open-iSCSI initiator"
   },
   "storage_pbs" : {
      "link" : "/pve-docs/chapter-pvesm.html#storage_pbs",
      "title" : "Proxmox Backup Server"
   },
   "storage_pbs_encryption" : {
      "link" : "/pve-docs/chapter-pvesm.html#storage_pbs_encryption",
      "subtitle" : "Encryption",
      "title" : "Proxmox Backup Server"
   },
   "storage_zfspool" : {
      "link" : "/pve-docs/chapter-pvesm.html#storage_zfspool",
      "title" : "Local ZFS Pool Backend"
   },
   "sysadmin_certificate_management" : {
      "link" : "/pve-docs/chapter-sysadmin.html#sysadmin_certificate_management",
      "title" : "Certificate Management"
   },
   "sysadmin_certs_acme_account" : {
      "link" : "/pve-docs/chapter-sysadmin.html#sysadmin_certs_acme_account",
      "subtitle" : "ACME Account",
      "title" : "Certificate Management"
   },
   "sysadmin_network_configuration" : {
      "link" : "/pve-docs/chapter-sysadmin.html#sysadmin_network_configuration",
      "title" : "Network Configuration"
   },
   "sysadmin_package_repositories" : {
      "link" : "/pve-docs/chapter-sysadmin.html#sysadmin_package_repositories",
      "title" : "Package Repositories"
   },
   "user-realms-ad" : {
      "link" : "/pve-docs/chapter-pveum.html#user-realms-ad",
      "subtitle" : "Microsoft Active Directory (AD)",
      "title" : "User Management"
   },
   "user-realms-ldap" : {
      "link" : "/pve-docs/chapter-pveum.html#user-realms-ldap",
      "subtitle" : "LDAP",
      "title" : "User Management"
   },
   "user-realms-pam" : {
      "link" : "/pve-docs/chapter-pveum.html#user-realms-pam",
      "subtitle" : "Linux PAM Standard Authentication",
      "title" : "User Management"
   },
   "user_mgmt" : {
      "link" : "/pve-docs/chapter-pveum.html#user_mgmt",
      "title" : "User Management"
   },
   "vzdump_retention" : {
      "link" : "/pve-docs/chapter-vzdump.html#vzdump_retention",
      "subtitle" : "Backup Retention",
      "title" : "Backup and Restore"
   }
};
// Some configuration values are complex strings - so we need parsers/generators for them.
Ext.define('PVE.Parser', {
    statics: {
        // this class only contains static functions

        printACME: function (value) {
            if (Ext.isArray(value.domains)) {
                value.domains = value.domains.join(';');
            }
            return PVE.Parser.printPropertyString(value);
        },

        parseACME: function (value) {
            if (!value) {
                return {};
            }

            let res = {};
            try {
                value.split(',').forEach((property) => {
                    let [k, v] = property.split('=', 2);
                    if (Ext.isDefined(v)) {
                        res[k] = v;
                    } else {
                        throw `Failed to parse key-value pair: ${property}`;
                    }
                });
            } catch (err) {
                console.warn(err);
                return undefined;
            }

            if (res.domains !== undefined) {
                res.domains = res.domains.split(/;/);
            }

            return res;
        },

        parseBoolean: function (value, default_value) {
            if (!Ext.isDefined(value)) {
                return default_value;
            }
            value = value.toLowerCase();
            return value === '1' || value === 'on' || value === 'yes' || value === 'true';
        },

        parsePropertyString: function (value, defaultKey) {
            let res = {};

            if (typeof value !== 'string' || value === '') {
                return res;
            }

            try {
                value.split(',').forEach((property) => {
                    let [k, v] = property.split('=', 2);
                    if (Ext.isDefined(v)) {
                        res[k] = v;
                    } else if (Ext.isDefined(defaultKey)) {
                        if (Ext.isDefined(res[defaultKey])) {
                            throw 'defaultKey may be only defined once in propertyString';
                        }
                        res[defaultKey] = k; // k is the value in this case
                    } else {
                        throw `Failed to parse key-value pair: ${property}`;
                    }
                });
            } catch (err) {
                console.warn(err);
                return undefined;
            }

            return res;
        },

        printPropertyString: function (data, defaultKey) {
            var stringparts = [],
                gotDefaultKeyVal = false,
                defaultKeyVal;

            Ext.Object.each(data, function (key, value) {
                if (defaultKey !== undefined && key === defaultKey) {
                    gotDefaultKeyVal = true;
                    defaultKeyVal = value;
                } else if (value !== '') {
                    stringparts.push(key + '=' + value);
                }
            });

            stringparts = stringparts.sort();
            if (gotDefaultKeyVal) {
                stringparts.unshift(defaultKeyVal);
            }

            return stringparts.join(',');
        },

        parseQemuNetwork: function (key, value) {
            if (!(key && value)) {
                return undefined;
            }

            let res = {},
                errors = false;
            Ext.Array.each(value.split(','), function (p) {
                if (!p || p.match(/^\s*$/)) {
                    return undefined; // continue
                }

                let match_res;

                if (
                    (match_res = p.match(
                        /^(ne2k_pci|e1000e?|e1000-82540em|e1000-82544gc|e1000-82545em|vmxnet3|rtl8139|pcnet|virtio|ne2k_isa|i82551|i82557b|i82559er)(=([0-9a-f]{2}(:[0-9a-f]{2}){5}))?$/i,
                    )) !== null
                ) {
                    res.model = match_res[1].toLowerCase();
                    if (match_res[3]) {
                        res.macaddr = match_res[3];
                    }
                } else if ((match_res = p.match(/^bridge=(\S+)$/)) !== null) {
                    res.bridge = match_res[1];
                } else if ((match_res = p.match(/^rate=(\d+(\.\d+)?|\.\d+)$/)) !== null) {
                    res.rate = match_res[1];
                } else if ((match_res = p.match(/^tag=(\d+(\.\d+)?)$/)) !== null) {
                    res.tag = match_res[1];
                } else if ((match_res = p.match(/^firewall=(\d+)$/)) !== null) {
                    res.firewall = match_res[1];
                } else if ((match_res = p.match(/^link_down=(\d+)$/)) !== null) {
                    res.disconnect = match_res[1];
                } else if ((match_res = p.match(/^queues=(\d+)$/)) !== null) {
                    res.queues = match_res[1];
                } else if (
                    (match_res = p.match(/^trunks=(\d+(?:-\d+)?(?:;\d+(?:-\d+)?)*)$/)) !== null
                ) {
                    res.trunks = match_res[1];
                } else if ((match_res = p.match(/^mtu=(\d+)$/)) !== null) {
                    res.mtu = match_res[1];
                } else {
                    errors = true;
                    return false; // break
                }
                return undefined; // continue
            });

            if (errors || !res.model) {
                return undefined;
            }

            return res;
        },

        printQemuNetwork: function (net) {
            var netstr = net.model;
            if (net.macaddr) {
                netstr += '=' + net.macaddr;
            }
            if (net.bridge) {
                netstr += ',bridge=' + net.bridge;
                if (net.tag) {
                    netstr += ',tag=' + net.tag;
                }
                if (net.firewall) {
                    netstr += ',firewall=' + net.firewall;
                }
            }
            if (net.rate) {
                netstr += ',rate=' + net.rate;
            }
            if (net.queues) {
                netstr += ',queues=' + net.queues;
            }
            if (net.disconnect) {
                netstr += ',link_down=' + net.disconnect;
            }
            if (net.trunks) {
                netstr += ',trunks=' + net.trunks;
            }
            if (net.mtu) {
                netstr += ',mtu=' + net.mtu;
            }
            return netstr;
        },

        parseQemuDrive: function (key, value) {
            if (!(key && value)) {
                return undefined;
            }

            const [, bus, index] = key.match(/^([a-z]+)(\d+)$/);
            if (!bus) {
                return undefined;
            }
            let res = {
                interface: bus,
                index,
            };

            var errors = false;
            Ext.Array.each(value.split(','), function (p) {
                if (!p || p.match(/^\s*$/)) {
                    return undefined; // continue
                }
                let match = p.match(/^([a-z_]+)=(\S+)$/);
                if (!match) {
                    if (!p.match(/[=]/)) {
                        res.file = p;
                        return undefined; // continue
                    }
                    errors = true;
                    return false; // break
                }
                let [, k, v] = match;
                if (k === 'volume') {
                    k = 'file';
                }

                if (Ext.isDefined(res[k])) {
                    errors = true;
                    return false; // break
                }

                if (k === 'cache' && v === 'off') {
                    v = 'none';
                }

                res[k] = v;

                return undefined; // continue
            });

            if (errors || !res.file) {
                return undefined;
            }

            return res;
        },

        printQemuDrive: function (drive) {
            var drivestr = drive.file;

            Ext.Object.each(drive, function (key, value) {
                if (
                    !Ext.isDefined(value) ||
                    key === 'file' ||
                    key === 'index' ||
                    key === 'interface'
                ) {
                    return; // continue
                }
                drivestr += ',' + key + '=' + value;
            });

            return drivestr;
        },

        parseIPConfig: function (key, value) {
            if (!(key && value)) {
                return undefined; // continue
            }

            let res = {};
            try {
                value.split(',').forEach((p) => {
                    if (!p || p.match(/^\s*$/)) {
                        return; // continue
                    }

                    const match = p.match(/^(ip|gw|ip6|gw6)=(\S+)$/);
                    if (!match) {
                        throw `could not parse as IP config: ${p}`;
                    }
                    let [, k, v] = match;
                    res[k] = v;
                });
            } catch (err) {
                console.warn(err);
                return undefined; // continue
            }

            return res;
        },

        printIPConfig: function (cfg) {
            return Object.entries(cfg)
                .filter(([k, v]) => v && k.match(/^(ip|gw|ip6|gw6)$/))
                .map(([k, v]) => `${k}=${v}`)
                .join(',');
        },

        parseLxcNetwork: function (value) {
            if (!value) {
                return undefined;
            }

            let data = {};
            value.split(',').forEach((p) => {
                if (!p || p.match(/^\s*$/)) {
                    return; // continue
                }
                let match_res = p.match(/^(bridge|hwaddr|mtu|name|ip|ip6|gw|gw6|tag|rate)=(\S+)$/);
                if (match_res) {
                    data[match_res[1]] = match_res[2];
                } else if ((match_res = p.match(/^firewall=(\d+)$/)) !== null) {
                    data.firewall = PVE.Parser.parseBoolean(match_res[1]);
                } else if ((match_res = p.match(/^link_down=(\d+)$/)) !== null) {
                    data.link_down = PVE.Parser.parseBoolean(match_res[1]);
                } else if (!p.match(/^type=\S+$/)) {
                    console.warn(`could not parse LXC network string ${p}`);
                }
            });

            return data;
        },

        printLxcNetwork: function (config) {
            let knownKeys = {
                bridge: 1,
                firewall: 1,
                gw6: 1,
                gw: 1,
                hwaddr: 1,
                ip6: 1,
                ip: 1,
                mtu: 1,
                name: 1,
                rate: 1,
                tag: 1,
                link_down: 1,
            };
            return Object.entries(config)
                .filter(([k, v]) => v !== undefined && v !== '' && knownKeys[k])
                .map(([k, v]) => `${k}=${v}`)
                .join(',');
        },

        parseLxcMountPoint: function (value) {
            if (!value) {
                return undefined;
            }

            let res = {};
            let errors = false;
            Ext.Array.each(value.split(','), function (p) {
                if (!p || p.match(/^\s*$/)) {
                    return undefined; // continue
                }
                let match = p.match(/^([a-z_]+)=(.+)$/);
                if (!match) {
                    if (!p.match(/[=]/)) {
                        res.file = p;
                        return undefined; // continue
                    }
                    errors = true;
                    return false; // break
                }
                let [, k, v] = match;
                if (k === 'volume') {
                    k = 'file';
                }

                if (Ext.isDefined(res[k])) {
                    errors = true;
                    return false; // break
                }

                res[k] = v;

                return undefined;
            });

            if (errors || !res.file) {
                return undefined;
            }

            const match = res.file.match(/^([a-z][a-z0-9\-_.]*[a-z0-9]):/i);
            if (match) {
                res.storage = match[1];
                res.type = 'volume';
            } else if (res.file.match(/^\/dev\//)) {
                res.type = 'device';
            } else {
                res.type = 'bind';
            }

            return res;
        },

        printLxcMountPoint: function (mp) {
            let drivestr = mp.file;
            for (const [key, value] of Object.entries(mp)) {
                if (
                    !Ext.isDefined(value) ||
                    key === 'file' ||
                    key === 'type' ||
                    key === 'storage'
                ) {
                    continue;
                }
                drivestr += `,${key}=${value}`;
            }
            return drivestr;
        },

        parseStartup: function (value) {
            if (value === undefined) {
                return undefined;
            }

            let res = {};
            try {
                value.split(',').forEach((p) => {
                    if (!p || p.match(/^\s*$/)) {
                        return; // continue
                    }

                    let match_res;
                    if ((match_res = p.match(/^(order)?=(\d+)$/)) !== null) {
                        res.order = match_res[2];
                    } else if ((match_res = p.match(/^up=(\d+)$/)) !== null) {
                        res.up = match_res[1];
                    } else if ((match_res = p.match(/^down=(\d+)$/)) !== null) {
                        res.down = match_res[1];
                    } else {
                        throw `could not parse startup config ${p}`;
                    }
                });
            } catch (err) {
                console.warn(err);
                return undefined;
            }

            return res;
        },

        printStartup: function (startup) {
            let arr = [];
            if (startup.order !== undefined && startup.order !== '') {
                arr.push('order=' + startup.order);
            }
            if (startup.up !== undefined && startup.up !== '') {
                arr.push('up=' + startup.up);
            }
            if (startup.down !== undefined && startup.down !== '') {
                arr.push('down=' + startup.down);
            }

            return arr.join(',');
        },

        parseQemuSmbios1: function (value) {
            let res = value.split(',').reduce((acc, currentValue) => {
                const [k, v] = currentValue.split(/[=](.+)/);
                acc[k] = v;
                return acc;
            }, {});

            if (PVE.Parser.parseBoolean(res.base64, false)) {
                for (const [k, v] of Object.entries(res)) {
                    if (k !== 'uuid') {
                        res[k] = Ext.util.Base64.decode(v);
                    }
                }
            }

            return res;
        },

        printQemuSmbios1: function (data) {
            let base64 = false;
            let datastr = Object.entries(data)
                .map(([key, value]) => {
                    if (value === '') {
                        return undefined;
                    }
                    if (key !== 'uuid') {
                        base64 = true; // smbios values can be arbitrary, so encode and mark config as such
                        value = Ext.util.Base64.encode(value);
                    }
                    return `${key}=${value}`;
                })
                .filter((v) => v !== undefined)
                .join(',');

            if (base64) {
                datastr += ',base64=1';
            }
            return datastr;
        },

        parseTfaConfig: function (value) {
            let res = {};
            value.split(',').forEach((p) => {
                const [k, v] = p.split('=', 2);
                res[k] = v;
            });

            return res;
        },

        parseTfaType: function (value) {
            let match;
            if (!value || !value.length) {
                return undefined;
            } else if (value === 'x!oath') {
                return 'totp';
            } else if ((match = value.match(/^x!(.+)$/)) !== null) {
                return match[1];
            } else {
                return 1;
            }
        },

        parseQemuCpu: function (value) {
            if (!value) {
                return {};
            }

            let res = {};
            let errors = false;
            Ext.Array.each(value.split(','), function (p) {
                if (!p || p.match(/^\s*$/)) {
                    return undefined; // continue
                }

                if (!p.match(/[=]/)) {
                    if (Ext.isDefined(res.cpu)) {
                        errors = true;
                        return false; // break
                    }
                    res.cputype = p;
                    return undefined; // continue
                }

                let match = p.match(/^([a-z_-]+)=(\S+)$/);
                if (!match || Ext.isDefined(res[match[1]])) {
                    errors = true;
                    return false; // break
                }

                let [, k, v] = match;
                res[k] = v;

                return undefined;
            });

            if (errors || !res.cputype) {
                return undefined;
            }

            return res;
        },

        printQemuCpu: function (cpu) {
            let cpustr = cpu.cputype;
            let optstr = '';

            Ext.Object.each(cpu, function (key, value) {
                if (!Ext.isDefined(value) || key === 'cputype') {
                    return; // continue
                }
                optstr += ',' + key + '=' + value;
            });

            if (!cpustr) {
                if (optstr) {
                    return 'kvm64' + optstr;
                } else {
                    return undefined;
                }
            }

            return cpustr + optstr;
        },

        parseSSHKey: function (key) {
            //                |--- options can have quotes--|     type    key        comment
            let keyre = /^(?:((?:[^\s"]|"(?:\\.|[^"\\])*")+)\s+)?(\S+)\s+(\S+)(?:\s+(.*))?$/;
            let typere =
                /^(?:(?:sk-)?(?:ssh-(?:dss|rsa|ed25519)|ecdsa-sha2-nistp\d+)(?:@(?:[a-z0-9_-]+\.)+[a-z]{2,})?)$/;

            let m = key.match(keyre);
            if (!m || m.length < 3 || !m[2]) {
                // [2] is always either type or key
                return null;
            }
            if (m[1] && m[1].match(typere)) {
                return {
                    type: m[1],
                    key: m[2],
                    comment: m[3],
                };
            }
            if (m[2].match(typere)) {
                return {
                    options: m[1],
                    type: m[2],
                    key: m[3],
                    comment: m[4],
                };
            }
            return null;
        },

        parseACMEPluginData: function (data) {
            let res = {};
            let extradata = [];
            data.split('\n').forEach((line) => {
                // capture everything after the first = as value
                let [key, value] = line.split(/[=](.+)/);
                if (value !== undefined) {
                    res[key] = value;
                } else {
                    extradata.push(line);
                }
            });
            return [res, extradata];
        },

        filterPropertyStringList: function (list, filterFn, defaultKey) {
            return list.filter((entry) =>
                filterFn(PVE.Parser.parsePropertyString(entry, defaultKey)),
            );
        },
    },
});
/* This state provider keeps part of the state inside the browser history.
 *
 * We compress (shorten) url using dictionary based compression, i.e., we use
 * column separated list instead of url encoded hash:
 *  #v\d*       version/format
 *  :=          indicates string values
 *  :\d+        lookup value in dictionary hash
 *  #v1:=value1:5:=value2:=value3:...
 */

Ext.define('PVE.StateProvider', {
    extend: 'Ext.state.LocalStorageProvider',

    // private
    setHV: function (name, newvalue, fireEvents) {
        let me = this;

        let changes = false;
        let oldtext = Ext.encode(me.UIState[name]);
        let newtext = Ext.encode(newvalue);
        if (newtext !== oldtext) {
            changes = true;
            me.UIState[name] = newvalue;
            if (fireEvents) {
                me.fireEvent('statechange', me, name, { value: newvalue });
            }
        }
        return changes;
    },

    // private
    hslist: [
        // order is important for notifications
        // [ name, default ]
        ['view', 'server'],
        ['rid', 'root'],
        ['ltab', 'tasks'],
        ['nodetab', ''],
        ['storagetab', ''],
        ['sdntab', ''],
        ['pooltab', ''],
        ['kvmtab', ''],
        ['lxctab', ''],
        ['dctab', ''],
    ],

    hprefix: 'v1',

    compDict: {
        tfa: 54,
        sdn: 53,
        cloudinit: 52,
        replication: 51,
        system: 50,
        monitor: 49,
        'ha-fencing': 48,
        'ha-groups': 47,
        'ha-resources': 46,
        'ceph-log': 45,
        'ceph-crushmap': 44,
        'ceph-pools': 43,
        'ceph-osdtree': 42,
        'ceph-disklist': 41,
        'ceph-monlist': 40,
        'ceph-config': 39,
        ceph: 38,
        'firewall-fwlog': 37,
        'firewall-options': 36,
        'firewall-ipset': 35,
        'firewall-aliases': 34,
        'firewall-sg': 33,
        firewall: 32,
        apt: 31,
        members: 30,
        snapshot: 29,
        ha: 28,
        support: 27,
        pools: 26,
        syslog: 25,
        ubc: 24,
        initlog: 23,
        openvz: 22,
        backup: 21,
        resources: 20,
        content: 19,
        root: 18,
        domains: 17,
        roles: 16,
        groups: 15,
        users: 14,
        time: 13,
        dns: 12,
        network: 11,
        services: 10,
        options: 9,
        console: 8,
        hardware: 7,
        permissions: 6,
        summary: 5,
        tasks: 4,
        clog: 3,
        storage: 2,
        folder: 1,
        server: 0,
    },

    decodeHToken: function (token) {
        let me = this;

        let state = {};
        if (!token) {
            me.hslist.forEach(([k, v]) => {
                state[k] = v;
            });
            return state;
        }

        let [prefix, ...items] = token.split(':');

        if (prefix !== me.hprefix) {
            return me.decodeHToken();
        }

        Ext.Array.each(me.hslist, function (rec) {
            let value = items.shift();
            if (value) {
                if (value[0] === '=') {
                    value = decodeURIComponent(value.slice(1));
                }
                for (const [key, hash] of Object.entries(me.compDict)) {
                    if (String(value) === String(hash)) {
                        value = key;
                        break;
                    }
                }
            }
            state[rec[0]] = value;
        });

        return state;
    },

    encodeHToken: function (state) {
        let me = this;

        let ctoken = me.hprefix;
        Ext.Array.each(me.hslist, function (rec) {
            let value = state[rec[0]];
            if (!Ext.isDefined(value)) {
                value = rec[1];
            }
            value = encodeURIComponent(value);
            if (!value) {
                ctoken += ':';
            } else if (Ext.isDefined(me.compDict[value])) {
                ctoken += ':' + me.compDict[value];
            } else {
                ctoken += ':=' + value;
            }
        });

        return ctoken;
    },

    constructor: function (config) {
        let me = this;

        me.callParent([config]);

        me.UIState = me.decodeHToken(); // set default

        let history_change_cb = function (token) {
            if (!token) {
                Ext.History.back();
                return;
            }

            let newstate = me.decodeHToken(token);
            Ext.Array.each(me.hslist, function (rec) {
                if (typeof newstate[rec[0]] === 'undefined') {
                    return;
                }
                me.setHV(rec[0], newstate[rec[0]], true);
            });
        };

        let start_token = Ext.History.getToken();
        if (start_token) {
            history_change_cb(start_token);
        } else {
            let htext = me.encodeHToken(me.UIState);
            Ext.History.add(htext);
        }

        Ext.History.on('change', history_change_cb);
    },

    get: function (name, defaultValue) {
        let me = this;

        let data;
        if (typeof me.UIState[name] !== 'undefined') {
            data = { value: me.UIState[name] };
        } else {
            data = me.callParent(arguments);
            if (!data && name === 'GuiCap') {
                data = {
                    vms: {},
                    storage: {},
                    access: {},
                    nodes: {},
                    dc: {},
                    sdn: {},
                };
            }
        }
        return data;
    },

    clear: function (name) {
        let me = this;

        if (typeof me.UIState[name] !== 'undefined') {
            me.UIState[name] = null;
        }
        me.callParent(arguments);
    },

    set: function (name, value, fireevent) {
        let me = this;

        if (typeof me.UIState[name] !== 'undefined') {
            let newvalue = value ? value.value : null;
            if (me.setHV(name, newvalue, fireevent)) {
                let htext = me.encodeHToken(me.UIState);
                Ext.History.add(htext);
            }
        } else {
            me.callParent(arguments);
        }
    },
});
Ext.ns('PVE');

console.log('Starting Proxmox VE Manager');

Ext.Ajax.defaultHeaders = {
    Accept: 'application/json',
};

Ext.define('PVE.Utils', {
    utilities: {
        // this singleton contains miscellaneous utilities

        toolkit: undefined, // (extjs|touch), set inside Toolkit.js

        bus_match: /^(ide|sata|virtio|scsi)(\d+)$/,

        log_severity_hash: {
            0: 'panic',
            1: 'alert',
            2: 'critical',
            3: 'error',
            4: 'warning',
            5: 'notice',
            6: 'info',
            7: 'debug',
        },

        support_level_hash: {
            c: gettext('Community'),
            b: gettext('Basic'),
            s: gettext('Standard'),
            p: gettext('Premium'),
        },

        noSubKeyHtml:
            'You do not have a valid subscription for this server. Please visit ' +
            '<a target="_blank" href="https://www.proxmox.com/en/proxmox-virtual-environment/pricing">' +
            'www.proxmox.com</a> to get a list of available options.',

        getClusterSubscriptionLevel: async function () {
            let { result } = await Proxmox.Async.api2({ url: '/cluster/status' });
            let levelMap = Object.fromEntries(
                result.data.filter((v) => v.type === 'node').map((v) => [v.name, v.level]),
            );
            return levelMap;
        },

        kvm_ostypes: {
            Linux: [
                { desc: '6.x - 2.6 Kernel', val: 'l26' },
                { desc: '2.4 Kernel', val: 'l24' },
            ],
            'Microsoft Windows': [
                { desc: '11/2022/2025', val: 'win11' },
                { desc: '10/2016/2019', val: 'win10' },
                { desc: '8.x/2012/2012r2', val: 'win8' },
                { desc: '7/2008r2', val: 'win7' },
                { desc: 'Vista/2008', val: 'w2k8' },
                { desc: 'XP/2003', val: 'wxp' },
                { desc: '2000', val: 'w2k' },
            ],
            'Solaris Kernel': [{ desc: '-', val: 'solaris' }],
            Other: [{ desc: '-', val: 'other' }],
        },

        is_windows: function (ostype) {
            for (let entry of PVE.Utils.kvm_ostypes['Microsoft Windows']) {
                if (entry.val === ostype) {
                    return true;
                }
            }
            return false;
        },

        get_health_icon: function (state, circle) {
            if (circle === undefined) {
                circle = false;
            }

            if (state === undefined) {
                state = 'uknown';
            }

            var icon = 'faded fa-question';
            switch (state) {
                case 'good':
                    icon = 'good fa-check';
                    break;
                case 'upgrade':
                    icon = 'warning fa-upload';
                    break;
                case 'old':
                    icon = 'warning fa-refresh';
                    break;
                case 'warning':
                    icon = 'warning fa-exclamation';
                    break;
                case 'critical':
                    icon = 'critical fa-times';
                    break;
                default:
                    break;
            }

            if (circle) {
                icon += '-circle';
            }

            return icon;
        },

        parse_ceph_version: function (service) {
            if (service.ceph_version_short) {
                return service.ceph_version_short;
            }

            if (service.ceph_version) {
                // See PVE/Ceph/Tools.pm - get_local_version
                const match = service.ceph_version.match(/^ceph.*\sv?(\d+(?:\.\d+)+)/);
                if (match) {
                    return match[1];
                }
            }

            return undefined;
        },

        compare_ceph_versions: function (a, b) {
            let avers = [];
            let bvers = [];

            if (a === b) {
                return 0;
            }

            if (Ext.isArray(a)) {
                avers = a.slice(); // copy array
            } else {
                avers = a.toString().split('.');
            }

            if (Ext.isArray(b)) {
                bvers = b.slice(); // copy array
            } else {
                bvers = b.toString().split('.');
            }

            for (;;) {
                let av = avers.shift();
                let bv = bvers.shift();

                if (av === undefined && bv === undefined) {
                    return 0;
                } else if (av === undefined) {
                    return -1;
                } else if (bv === undefined) {
                    return 1;
                } else {
                    let diff = parseInt(av, 10) - parseInt(bv, 10);
                    if (diff !== 0) {
                        return diff;
                    }
                    // else we need to look at the next parts
                }
            }
        },

        get_ceph_icon_html: function (health, fw) {
            var state = PVE.Utils.map_ceph_health[health];
            var cls = PVE.Utils.get_health_icon(state);
            if (fw) {
                cls += ' fa-fw';
            }
            return "<i class='fa " + cls + "'></i> ";
        },

        map_ceph_health: {
            HEALTH_OK: 'good',
            HEALTH_UPGRADE: 'upgrade',
            HEALTH_OLD: 'old',
            HEALTH_WARN: 'warning',
            HEALTH_ERR: 'critical',
        },

        render_sdn_pending: function (rec, value, key, index) {
            if (rec.data.state === undefined || rec.data.state === null) {
                return Ext.htmlEncode(value);
            }

            if (rec.data.state === 'deleted') {
                if (value === undefined) {
                    return ' ';
                } else {
                    return `<div style="text-decoration: line-through;">${Ext.htmlEncode(value)}</div>`;
                }
            } else if (rec.data.pending[key] !== undefined && rec.data.pending[key] !== null) {
                if (rec.data.pending[key] === 'deleted') {
                    return ' ';
                } else {
                    return Ext.htmlEncode(rec.data.pending[key]);
                }
            }
            return Ext.htmlEncode(value);
        },

        render_sdn_pending_state: function (rec, value) {
            if (value === undefined || value === null) {
                return ' ';
            }

            let icon = `<i class="fa fa-fw fa-refresh warning"></i>`;

            if (value === 'deleted') {
                return `<span>${icon}${Ext.htmlEncode(value)}</span>`;
            }

            let tip = gettext('Pending Changes') + ': <br>';

            for (const [key, keyvalue] of Object.entries(rec.data.pending)) {
                if (
                    (rec.data[key] !== undefined && rec.data.pending[key] !== rec.data[key]) ||
                    rec.data[key] === undefined
                ) {
                    tip += `${Ext.htmlEncode(key)}: ${Ext.htmlEncode(keyvalue)} <br>`;
                }
            }
            return `<span data-qtip="${Ext.htmlEncode(tip)}">${icon}${Ext.htmlEncode(value)}</span>`;
        },

        render_ceph_health: function (healthObj) {
            var state = {
                iconCls: PVE.Utils.get_health_icon(),
                text: '',
            };

            if (!healthObj || !healthObj.status) {
                return state;
            }

            var health = PVE.Utils.map_ceph_health[healthObj.status];

            state.iconCls = PVE.Utils.get_health_icon(health, true);
            state.text = healthObj.status;

            return state;
        },

        render_zfs_health: function (value) {
            if (typeof value === 'undefined') {
                return '';
            }
            var iconCls = 'question-circle';
            switch (value) {
                case 'AVAIL':
                case 'ONLINE':
                    iconCls = 'check-circle good';
                    break;
                case 'REMOVED':
                case 'DEGRADED':
                    iconCls = 'exclamation-circle warning';
                    break;
                case 'UNAVAIL':
                case 'FAULTED':
                case 'OFFLINE':
                    iconCls = 'times-circle critical';
                    break;
                default: //unknown
            }

            return '<i class="fa fa-' + iconCls + '"></i> ' + value;
        },

        render_pbs_fingerprint: (fp) => fp.substring(0, 23),

        render_backup_encryption: function (v, meta, record) {
            if (!v) {
                return gettext('No');
            }

            let tip = '';
            if (v.match(/^[a-fA-F0-9]{2}:/)) {
                // fingerprint
                tip = `Key fingerprint ${PVE.Utils.render_pbs_fingerprint(v)}`;
            }
            let icon = `<i class="fa fa-fw fa-lock good"></i>`;
            return `<span data-qtip="${tip}">${icon} ${gettext('Encrypted')}</span>`;
        },

        render_backup_verification: function (v, meta, record) {
            let i = (cls, txt) => `<i class="fa fa-fw fa-${cls}"></i> ${txt}`;
            if (v === undefined || v === null) {
                return i('question-circle-o warning', gettext('None'));
            }
            let tip = '';
            let txt = gettext('Failed');
            let iconCls = 'times critical';
            if (v.state === 'ok') {
                txt = gettext('OK');
                iconCls = 'check good';
                let now = Date.now() / 1000;
                let task = Proxmox.Utils.parse_task_upid(v.upid);
                let verify_time = Proxmox.Utils.render_timestamp(task.starttime);
                tip = `Last verify task started on ${verify_time}`;
                if (now - v.starttime > 30 * 24 * 60 * 60) {
                    tip = `Last verify task over 30 days ago: ${verify_time}`;
                    iconCls = 'check warning';
                }
            }
            return `<span data-qtip="${tip}"> ${i(iconCls, txt)} </span>`;
        },

        render_backup_status: function (value, meta, record) {
            if (typeof value === 'undefined') {
                return '';
            }

            let iconCls = 'check-circle good';
            let text = gettext('Yes');

            if (!PVE.Parser.parseBoolean(value.toString())) {
                iconCls = 'times-circle critical';

                text = gettext('No');

                let reason = record.get('reason');
                if (typeof reason !== 'undefined') {
                    if (reason in PVE.Utils.backup_reasons_table) {
                        reason = PVE.Utils.backup_reasons_table[record.get('reason')];
                    }
                    text = `${text} - ${reason}`;
                }
            }

            return `<i class="fa fa-${iconCls}"></i> ${text}`;
        },

        render_backup_days_of_week: function (val) {
            var dows = ['sun', 'mon', 'tue', 'wed', 'thu', 'fri', 'sat'];
            var selected = [];
            var cur = -1;
            val.split(',').forEach(function (day) {
                cur++;
                var dow = (dows.indexOf(day) + 6) % 7;
                if (cur === dow) {
                    if (selected.length === 0 || selected[selected.length - 1] === 0) {
                        selected.push(1);
                    } else {
                        selected[selected.length - 1]++;
                    }
                } else {
                    while (cur < dow) {
                        cur++;
                        selected.push(0);
                    }
                    selected.push(1);
                }
            });

            cur = -1;
            var days = [];
            selected.forEach(function (item) {
                cur++;
                if (item > 2) {
                    days.push(
                        Ext.Date.dayNames[cur + 1] + '-' + Ext.Date.dayNames[(cur + item) % 7],
                    );
                    cur += item - 1;
                } else if (item === 2) {
                    days.push(Ext.Date.dayNames[cur + 1]);
                    days.push(Ext.Date.dayNames[(cur + 2) % 7]);
                    cur++;
                } else if (item === 1) {
                    days.push(Ext.Date.dayNames[(cur + 1) % 7]);
                }
            });
            return days.join(', ');
        },

        render_backup_selection: function (value, metaData, record) {
            let allExceptText = gettext('All except {0}');
            let allText = '-- ' + gettext('All') + ' --';
            if (record.data.all) {
                if (record.data.exclude) {
                    return Ext.String.format(allExceptText, record.data.exclude);
                }
                return allText;
            }
            if (record.data.vmid) {
                return record.data.vmid;
            }

            if (record.data.pool) {
                return "Pool '" + record.data.pool + "'";
            }

            return '-';
        },

        backup_reasons_table: {
            'backup=yes': gettext('Enabled'),
            'backup=no': gettext('Disabled'),
            enabled: gettext('Enabled'),
            disabled: gettext('Disabled'),
            'not a volume': gettext('Not a volume'),
            'efidisk but no OMVF BIOS': gettext('EFI Disk without OMVF BIOS'),
        },

        renderNotFound: (what) => Ext.String.format(gettext('No {0} found'), what),

        get_kvm_osinfo: function (value) {
            var info = { base: 'Other' }; // default
            if (value) {
                Ext.each(Object.keys(PVE.Utils.kvm_ostypes), function (k) {
                    Ext.each(PVE.Utils.kvm_ostypes[k], function (e) {
                        if (e.val === value) {
                            info = { desc: e.desc, base: k };
                        }
                    });
                });
            }
            return info;
        },

        render_kvm_ostype: function (value) {
            var osinfo = PVE.Utils.get_kvm_osinfo(value);
            if (osinfo.desc && osinfo.desc !== '-') {
                return osinfo.base + ' ' + osinfo.desc;
            } else {
                return osinfo.base;
            }
        },

        render_hotplug_features: function (value) {
            var fa = [];

            if (!value || value === '0') {
                return gettext('Disabled');
            }

            if (value === '1') {
                value = 'disk,network,usb';
            }

            Ext.each(value.split(','), function (el) {
                if (el === 'disk') {
                    fa.push(gettext('Disk'));
                } else if (el === 'network') {
                    fa.push(gettext('Network'));
                } else if (el === 'usb') {
                    fa.push('USB');
                } else if (el === 'memory') {
                    fa.push(gettext('Memory'));
                } else if (el === 'cpu') {
                    fa.push(gettext('CPU'));
                } else {
                    fa.push(el);
                }
            });

            return fa.join(', ');
        },

        render_localtime: function (value) {
            if (value === '__default__') {
                return Proxmox.Utils.defaultText + ' (' + gettext('Enabled for Windows') + ')';
            }
            return Proxmox.Utils.format_boolean(value);
        },

        render_qga_features: function (config) {
            if (!config) {
                return Proxmox.Utils.defaultText + ' (' + Proxmox.Utils.disabledText + ')';
            }
            let qga = PVE.Parser.parsePropertyString(config, 'enabled');
            if (!PVE.Parser.parseBoolean(qga.enabled)) {
                return Proxmox.Utils.disabledText;
            }
            delete qga.enabled;

            let agentstring = Proxmox.Utils.enabledText;

            for (const [key, value] of Object.entries(qga)) {
                let displayText = Proxmox.Utils.disabledText;
                if (key === 'type') {
                    let map = {
                        isa: 'ISA',
                        virtio: 'VirtIO',
                    };
                    displayText = map[value] || Proxmox.Utils.unknownText;
                } else if (key === 'freeze-fs-on-backup' && PVE.Parser.parseBoolean(value)) {
                    continue;
                } else if (PVE.Parser.parseBoolean(value)) {
                    displayText = Proxmox.Utils.enabledText;
                }
                agentstring += `, ${key}: ${displayText}`;
            }

            return agentstring;
        },

        render_qemu_machine: function (value) {
            return value || Proxmox.Utils.defaultText + ' (i440fx)';
        },

        render_qemu_bios: function (value) {
            if (!value) {
                return Proxmox.Utils.defaultText + ' (SeaBIOS)';
            } else if (value === 'seabios') {
                return 'SeaBIOS';
            } else if (value === 'ovmf') {
                return 'OVMF (UEFI)';
            } else {
                return value;
            }
        },

        render_dc_ha_opts: function (value) {
            if (!value) {
                return Proxmox.Utils.defaultText;
            } else {
                return PVE.Parser.printPropertyString(value);
            }
        },
        render_as_property_string: (v) =>
            !v ? Proxmox.Utils.defaultText : PVE.Parser.printPropertyString(v),

        render_scsihw: function (value) {
            if (!value || value === '__default__') {
                return Proxmox.Utils.defaultText + ' (LSI 53C895A)';
            } else if (value === 'lsi') {
                return 'LSI 53C895A';
            } else if (value === 'lsi53c810') {
                return 'LSI 53C810';
            } else if (value === 'megasas') {
                return 'MegaRAID SAS 8708EM2';
            } else if (value === 'virtio-scsi-pci') {
                return 'VirtIO SCSI';
            } else if (value === 'virtio-scsi-single') {
                return 'VirtIO SCSI single';
            } else if (value === 'pvscsi') {
                return 'VMware PVSCSI';
            } else {
                return value;
            }
        },

        render_spice_enhancements: function (values) {
            let props = PVE.Parser.parsePropertyString(values);
            if (Ext.Object.isEmpty(props)) {
                return Proxmox.Utils.noneText;
            }

            let output = [];
            if (PVE.Parser.parseBoolean(props.foldersharing)) {
                output.push('Folder Sharing: ' + gettext('Enabled'));
            }
            if (props.videostreaming === 'all' || props.videostreaming === 'filter') {
                output.push('Video Streaming: ' + props.videostreaming);
            }
            return output.join(', ');
        },

        // fixme: auto-generate this
        // for now, please keep in sync with PVE::Tools::kvmkeymaps
        kvm_keymaps: {
            __default__: Proxmox.Utils.defaultText,
            //ar: 'Arabic',
            da: 'Danish',
            de: 'German',
            'de-ch': 'German (Swiss)',
            'en-gb': 'English (UK)',
            'en-us': 'English (USA)',
            es: 'Spanish',
            //et: 'Estonia',
            fi: 'Finnish',
            //fo: 'Faroe Islands',
            fr: 'French',
            'fr-be': 'French (Belgium)',
            'fr-ca': 'French (Canada)',
            'fr-ch': 'French (Swiss)',
            //hr: 'Croatia',
            hu: 'Hungarian',
            is: 'Icelandic',
            it: 'Italian',
            ja: 'Japanese',
            lt: 'Lithuanian',
            //lv: 'Latvian',
            mk: 'Macedonian',
            nl: 'Dutch',
            //'nl-be': 'Dutch (Belgium)',
            no: 'Norwegian',
            pl: 'Polish',
            pt: 'Portuguese',
            'pt-br': 'Portuguese (Brazil)',
            //ru: 'Russian',
            sl: 'Slovenian',
            sv: 'Swedish',
            //th: 'Thai',
            tr: 'Turkish',
        },

        kvm_vga_drivers: {
            __default__: Proxmox.Utils.defaultText,
            std: gettext('Standard VGA'),
            vmware: gettext('VMware compatible'),
            qxl: 'SPICE',
            qxl2: 'SPICE dual monitor',
            qxl3: 'SPICE three monitors',
            qxl4: 'SPICE four monitors',
            serial0: gettext('Serial terminal') + ' 0',
            serial1: gettext('Serial terminal') + ' 1',
            serial2: gettext('Serial terminal') + ' 2',
            serial3: gettext('Serial terminal') + ' 3',
            virtio: 'VirtIO-GPU',
            'virtio-gl': 'VirGL GPU',
            none: Proxmox.Utils.noneText,
        },

        render_kvm_language: function (value) {
            if (!value || value === '__default__') {
                return Proxmox.Utils.defaultText;
            }
            let text = PVE.Utils.kvm_keymaps[value];
            return text ? `${text} (${value})` : value;
        },

        console_map: {
            __default__: Proxmox.Utils.defaultText + ' (xterm.js)',
            vv: 'SPICE (remote-viewer)',
            html5: 'HTML5 (noVNC)',
            xtermjs: 'xterm.js',
        },

        render_console_viewer: function (value) {
            value = value || '__default__';
            return PVE.Utils.console_map[value] || value;
        },

        render_kvm_vga_driver: function (value) {
            if (!value) {
                return Proxmox.Utils.defaultText;
            }
            let vga = PVE.Parser.parsePropertyString(value, 'type');
            let text = PVE.Utils.kvm_vga_drivers[vga.type];
            if (!vga.type) {
                text = Proxmox.Utils.defaultText;
            }
            return text ? `${text} (${value})` : value;
        },

        render_kvm_startup: function (value) {
            var startup = PVE.Parser.parseStartup(value);

            var res = 'order=';
            if (startup.order === undefined) {
                res += 'any';
            } else {
                res += startup.order;
            }
            if (startup.up !== undefined) {
                res += ',up=' + startup.up;
            }
            if (startup.down !== undefined) {
                res += ',down=' + startup.down;
            }

            return res;
        },

        extractFormActionError: function (action) {
            var msg;
            switch (action.failureType) {
                case Ext.form.action.Action.CLIENT_INVALID:
                    msg = gettext('Form fields may not be submitted with invalid values');
                    break;
                case Ext.form.action.Action.CONNECT_FAILURE: {
                    msg = gettext('Connection error');
                    let resp = action.response;
                    if (resp.status && resp.statusText) {
                        msg += ' ' + resp.status + ': ' + resp.statusText;
                    }
                    break;
                }
                case Ext.form.action.Action.LOAD_FAILURE:
                case Ext.form.action.Action.SERVER_INVALID:
                    msg = Proxmox.Utils.extractRequestError(action.result, true);
                    break;
            }
            return msg;
        },

        contentTypes: {
            images: gettext('Disk image'),
            backup: gettext('Backup'),
            vztmpl: gettext('Container template'),
            iso: gettext('ISO image'),
            rootdir: gettext('Container'),
            snippets: gettext('Snippets'),
            import: gettext('Import'),
        },

        // volume can be a full volume info object, in which case the format parameter is ignored, or
        // you can pass the volume ID and format as separate string parameters.
        volume_is_qemu_backup: function (volume, format) {
            let volid, subtype;
            if (typeof volume === 'string') {
                volid = volume;
            } else if (typeof volume === 'object') {
                ({ volid, format, subtype } = volume);
            } else {
                console.error('internal error - unexpected type', volume);
            }
            return format === 'pbs-vm' || volid.match(':backup/vzdump-qemu-') || subtype === 'qemu';
        },

        volume_is_lxc_backup: function (volume) {
            return (
                volume.format === 'pbs-ct' ||
                volume.volid.match(':backup/vzdump-(lxc|openvz)-') ||
                volume.subtype === 'lxc'
            );
        },

        authSchema: {
            ad: {
                name: gettext('Active Directory Server'),
                ipanel: 'pveAuthADPanel',
                syncipanel: 'pveAuthLDAPSyncPanel',
                add: true,
                tfa: true,
                pwchange: true,
            },
            ldap: {
                name: gettext('LDAP Server'),
                ipanel: 'pveAuthLDAPPanel',
                syncipanel: 'pveAuthLDAPSyncPanel',
                add: true,
                tfa: true,
                pwchange: true,
            },
            openid: {
                name: gettext('OpenID Connect Server'),
                ipanel: 'pveAuthOpenIDPanel',
                add: true,
                tfa: false,
                pwchange: false,
                iconCls: 'pmx-itype-icon-openid-logo',
            },
            pam: {
                name: 'Linux PAM',
                ipanel: 'pveAuthBasePanel',
                add: false,
                tfa: true,
                pwchange: true,
            },
            pve: {
                name: 'Proxmox VE authentication server',
                ipanel: 'pveAuthBasePanel',
                add: false,
                tfa: true,
                pwchange: true,
            },
        },

        storageSchema: {
            dir: {
                name: Proxmox.Utils.directoryText,
                ipanel: 'DirInputPanel',
                faIcon: 'folder',
                backups: true,
            },
            lvm: {
                name: 'LVM',
                ipanel: 'LVMInputPanel',
                faIcon: 'folder',
                backups: false,
            },
            lvmthin: {
                name: 'LVM-Thin',
                ipanel: 'LvmThinInputPanel',
                faIcon: 'folder',
                backups: false,
            },
            btrfs: {
                name: 'BTRFS',
                ipanel: 'BTRFSInputPanel',
                faIcon: 'folder',
                backups: true,
            },
            nfs: {
                name: 'NFS',
                ipanel: 'NFSInputPanel',
                faIcon: 'building',
                backups: true,
            },
            cifs: {
                name: 'SMB/CIFS',
                ipanel: 'CIFSInputPanel',
                faIcon: 'building',
                backups: true,
            },
            glusterfs: {
                name: 'GlusterFS',
                ipanel: 'GlusterFsInputPanel',
                faIcon: 'building',
                backups: true,
            },
            iscsi: {
                name: 'iSCSI',
                ipanel: 'IScsiInputPanel',
                faIcon: 'building',
                backups: false,
            },
            cephfs: {
                name: 'CephFS',
                ipanel: 'CephFSInputPanel',
                faIcon: 'building',
                backups: true,
            },
            pvecephfs: {
                name: 'CephFS (PVE)',
                ipanel: 'CephFSInputPanel',
                hideAdd: true,
                faIcon: 'building',
                backups: true,
            },
            rbd: {
                name: 'RBD',
                ipanel: 'RBDInputPanel',
                faIcon: 'building',
                backups: false,
            },
            pveceph: {
                name: 'RBD (PVE)',
                ipanel: 'RBDInputPanel',
                hideAdd: true,
                faIcon: 'building',
                backups: false,
            },
            zfs: {
                name: 'ZFS over iSCSI',
                ipanel: 'ZFSInputPanel',
                faIcon: 'building',
                backups: false,
            },
            zfspool: {
                name: 'ZFS',
                ipanel: 'ZFSPoolInputPanel',
                faIcon: 'folder',
                backups: false,
            },
            pbs: {
                name: 'Proxmox Backup Server',
                ipanel: 'PBSInputPanel',
                faIcon: 'floppy-o',
                backups: true,
            },
            drbd: {
                name: 'DRBD',
                hideAdd: true,
                backups: false,
            },
            esxi: {
                name: 'ESXi',
                ipanel: 'ESXIInputPanel',
                faIcon: 'cloud-download',
                backups: false,
            },
        },

        sdnvnetSchema: {
            vnet: {
                name: 'vnet',
                faIcon: 'folder',
            },
        },

        sdnzoneSchema: {
            zone: {
                name: 'zone',
                hideAdd: true,
            },
            simple: {
                name: 'Simple',
                ipanel: 'SimpleInputPanel',
                faIcon: 'th',
            },
            vlan: {
                name: 'VLAN',
                ipanel: 'VlanInputPanel',
                faIcon: 'th',
            },
            qinq: {
                name: 'QinQ',
                ipanel: 'QinQInputPanel',
                faIcon: 'th',
            },
            vxlan: {
                name: 'VXLAN',
                ipanel: 'VxlanInputPanel',
                faIcon: 'th',
            },
            evpn: {
                name: 'EVPN',
                ipanel: 'EvpnInputPanel',
                faIcon: 'th',
            },
        },

        sdncontrollerSchema: {
            controller: {
                name: 'controller',
                hideAdd: true,
            },
            evpn: {
                name: 'evpn',
                ipanel: 'EvpnInputPanel',
                faIcon: 'crosshairs',
            },
            bgp: {
                name: 'bgp',
                ipanel: 'BgpInputPanel',
                faIcon: 'crosshairs',
            },
            isis: {
                name: 'isis',
                ipanel: 'IsisInputPanel',
                faIcon: 'crosshairs',
            },
        },

        sdnipamSchema: {
            ipam: {
                name: 'ipam',
                hideAdd: true,
            },
            pve: {
                name: 'PVE',
                ipanel: 'PVEIpamInputPanel',
                faIcon: 'th',
                hideAdd: true,
            },
            netbox: {
                name: 'Netbox',
                ipanel: 'NetboxInputPanel',
                faIcon: 'th',
            },
            phpipam: {
                name: 'PhpIpam',
                ipanel: 'PhpIpamInputPanel',
                faIcon: 'th',
            },
        },

        sdndnsSchema: {
            dns: {
                name: 'dns',
                hideAdd: true,
            },
            powerdns: {
                name: 'powerdns',
                ipanel: 'PowerdnsInputPanel',
                faIcon: 'th',
            },
        },

        format_sdnvnet_type: function (value, md, record) {
            var schema = PVE.Utils.sdnvnetSchema[value];
            if (schema) {
                return schema.name;
            }
            return Proxmox.Utils.unknownText;
        },

        format_sdnzone_type: function (value, md, record) {
            var schema = PVE.Utils.sdnzoneSchema[value];
            if (schema) {
                return schema.name;
            }
            return Proxmox.Utils.unknownText;
        },

        format_sdncontroller_type: function (value, md, record) {
            var schema = PVE.Utils.sdncontrollerSchema[value];
            if (schema) {
                return schema.name;
            }
            return Proxmox.Utils.unknownText;
        },

        format_sdnipam_type: function (value, md, record) {
            var schema = PVE.Utils.sdnipamSchema[value];
            if (schema) {
                return schema.name;
            }
            return Proxmox.Utils.unknownText;
        },

        format_sdndns_type: function (value, md, record) {
            var schema = PVE.Utils.sdndnsSchema[value];
            if (schema) {
                return schema.name;
            }
            return Proxmox.Utils.unknownText;
        },

        format_storage_type: function (value, md, record) {
            if (value === 'rbd') {
                value = !record || record.get('monhost') ? 'rbd' : 'pveceph';
            } else if (value === 'cephfs') {
                value = !record || record.get('monhost') ? 'cephfs' : 'pvecephfs';
            }

            let schema = PVE.Utils.storageSchema[value];
            return schema?.name ?? value;
        },

        format_ha: function (value) {
            var text = Proxmox.Utils.noneText;

            if (value.managed) {
                text = value.state || Proxmox.Utils.noneText;

                text += ', ' + Proxmox.Utils.groupText + ': ';
                text += value.group || Proxmox.Utils.noneText;
            }

            return text;
        },

        format_content_types: function (value) {
            return value
                .split(',')
                .sort()
                .map(function (ct) {
                    return PVE.Utils.contentTypes[ct] || ct;
                })
                .join(', ');
        },

        render_storage_content: function (value, metaData, record) {
            let data = record.data;
            let result;
            if (Ext.isNumber(data.channel) && Ext.isNumber(data.id) && Ext.isNumber(data.lun)) {
                result =
                    'CH ' +
                    Ext.String.leftPad(data.channel, 2, '0') +
                    ' ID ' +
                    data.id +
                    ' LUN ' +
                    data.lun;
            } else if (data.content === 'import') {
                if (data.volid.match(/^.*?:import\//)) {
                    // dir-based storages
                    result = data.volid.replace(/^.*?:import\//, '');
                } else {
                    // esxi storage
                    result = data.volid.replace(/^.*?:/, '');
                }
            } else {
                result = data.volid.replace(/^.*?:(.*?\/)?/, '');
            }
            return Ext.String.htmlEncode(result);
        },

        render_serverity: function (value) {
            return PVE.Utils.log_severity_hash[value] || value;
        },

        calculate_hostcpu: function (data) {
            if (!(data.uptime && Ext.isNumeric(data.cpu))) {
                return -1;
            }

            if (data.type !== 'qemu' && data.type !== 'lxc') {
                return -1;
            }

            let node = PVE.data.ResourceStore.getNodeById(data.node);
            if (!Ext.isDefined(node) || node === null) {
                return -1;
            }
            var maxcpu = node.data.maxcpu || 1;

            if (!Ext.isNumeric(maxcpu) && maxcpu >= 1) {
                return -1;
            }

            return (data.cpu / maxcpu) * data.maxcpu;
        },

        render_hostcpu: function (value, metaData, record, rowIndex, colIndex, store) {
            if (!(record.data.uptime && Ext.isNumeric(record.data.cpu))) {
                return '';
            }

            if (record.data.type !== 'qemu' && record.data.type !== 'lxc') {
                return '';
            }

            let node = PVE.data.ResourceStore.getNodeById(record.data.node);
            if (!Ext.isDefined(node) || node === null) {
                return '';
            }
            var maxcpu = node.data.maxcpu || 1;

            if (!Ext.isNumeric(maxcpu) || maxcpu < 1) {
                return '';
            }

            var per = (record.data.cpu / maxcpu) * record.data.maxcpu * 100;
            const cpu_label = maxcpu > 1 ? 'CPUs' : 'CPU';

            return `${per.toFixed(1)}% of ${maxcpu} ${cpu_label}`;
        },

        render_bandwidth: function (value) {
            if (!Ext.isNumeric(value)) {
                return '';
            }

            return Proxmox.Utils.format_size(value) + '/s';
        },

        render_timestamp_human_readable: function (value) {
            return Ext.Date.format(new Date(value * 1000), 'l d F Y H:i:s');
        },

        // render a timestamp or pending
        render_next_event: function (value) {
            if (!value) {
                return '-';
            }
            let now = new Date(),
                next = new Date(value * 1000);
            if (next < now) {
                return gettext('pending');
            }
            return Proxmox.Utils.render_timestamp(value);
        },

        calculate_mem_usage: function (data) {
            if (!Ext.isNumeric(data.mem) || data.maxmem === 0 || data.uptime < 1) {
                return -1;
            }

            return data.mem / data.maxmem;
        },

        calculate_hostmem_usage: function (data) {
            if (data.type !== 'qemu' && data.type !== 'lxc') {
                return -1;
            }

            let node = PVE.data.ResourceStore.getNodeById(data.node);

            if (!Ext.isDefined(node) || node === null) {
                return -1;
            }
            var maxmem = node.data.maxmem || 0;

            if (!Ext.isNumeric(data.mem) || maxmem === 0 || data.uptime < 1) {
                return -1;
            }

            return data.mem / maxmem;
        },

        render_mem_usage_percent: function (value, metaData, record, rowIndex, colIndex, store) {
            if (!Ext.isNumeric(value) || value === -1) {
                return '';
            }
            if (value > 1) {
                // we got no percentage but bytes
                let mem = value;
                let maxmem = record.data.maxmem;
                if (!record.data.uptime || maxmem === 0 || !Ext.isNumeric(mem)) {
                    return '';
                }

                return ((mem * 100) / maxmem).toFixed(1) + ' %';
            }
            return (value * 100).toFixed(1) + ' %';
        },

        render_hostmem_usage_percent: function (
            value,
            metaData,
            record,
            rowIndex,
            colIndex,
            store,
        ) {
            if (!Ext.isNumeric(record.data.mem) || value === -1) {
                return '';
            }

            if (record.data.type !== 'qemu' && record.data.type !== 'lxc') {
                return '';
            }

            let node = PVE.data.ResourceStore.getNodeById(record.data.node);
            var maxmem = node.data.maxmem || 0;

            if (record.data.mem > 1) {
                // we got no percentage but bytes
                let mem = record.data.mem;
                if (!record.data.uptime || maxmem === 0 || !Ext.isNumeric(mem)) {
                    return '';
                }

                return ((mem * 100) / maxmem).toFixed(1) + ' %';
            }
            return (value * 100).toFixed(1) + ' %';
        },

        render_mem_usage: function (value, metaData, record, rowIndex, colIndex, store) {
            var mem = value;
            var maxmem = record.data.maxmem;

            if (!record.data.uptime) {
                return '';
            }

            if (!(Ext.isNumeric(mem) && maxmem)) {
                return '';
            }

            return Proxmox.Utils.render_size(value);
        },

        calculate_disk_usage: function (data) {
            if (
                !Ext.isNumeric(data.disk) ||
                ((data.type === 'qemu' || data.type === 'lxc') && data.uptime === 0) ||
                data.maxdisk === 0
            ) {
                return -1;
            }

            return data.disk / data.maxdisk;
        },

        render_disk_usage_percent: function (value, metaData, record, rowIndex, colIndex, store) {
            if (!Ext.isNumeric(value) || value === -1) {
                return '';
            }

            return (value * 100).toFixed(1) + ' %';
        },

        render_disk_usage: function (value, metaData, record, rowIndex, colIndex, store) {
            var disk = value;
            var maxdisk = record.data.maxdisk;
            var type = record.data.type;

            if (
                !Ext.isNumeric(disk) ||
                maxdisk === 0 ||
                ((type === 'qemu' || type === 'lxc') && record.data.uptime === 0)
            ) {
                return '';
            }

            return Proxmox.Utils.render_size(value);
        },

        get_object_icon_class: function (type, record) {
            var status = '';
            var objType = type;

            if (type === 'type') {
                // for folder view
                objType = record.groupbyid;
            } else if (record.template) {
                // templates
                objType = 'template';
                status = type;
            } else if (type === 'storage' && record.content === 'import') {
                return 'fa fa-cloud-download';
            } else {
                // everything else
                status = record.status + ' ha-' + record.hastate;
            }

            if (record.lock) {
                status += ' locked lock-' + record.lock;
            }

            var defaults = PVE.tree.ResourceTree.typeDefaults[objType];
            if (defaults && defaults.iconCls) {
                return defaults.iconCls + ' ' + status;
            }

            return '';
        },

        render_resource_type: function (value, metaData, record, rowIndex, colIndex, store) {
            var cls = PVE.Utils.get_object_icon_class(value, record.data);

            var fa = '<i class="fa-fw x-grid-icon-custom ' + cls + '"></i> ';
            return fa + value;
        },

        render_support_level: function (value, metaData, record) {
            return PVE.Utils.support_level_hash[value] || '-';
        },

        render_upid: function (value, metaData, record) {
            var type = record.data.type;
            var id = record.data.id;

            return Ext.htmlEncode(Proxmox.Utils.format_task_description(type, id));
        },

        render_optional_url: function (value) {
            if (value && value.match(/^https?:\/\//)) {
                return '<a target="_blank" href="' + value + '">' + value + '</a>';
            }
            return value;
        },

        render_san: function (value) {
            var names = [];
            if (Ext.isArray(value)) {
                value.forEach(function (val) {
                    if (!Ext.isNumber(val)) {
                        names.push(val);
                    }
                });
                return names.join('<br>');
            }
            return value;
        },

        render_full_name: function (firstname, metaData, record) {
            var first = firstname || '';
            var last = record.data.lastname || '';
            return Ext.htmlEncode(first + ' ' + last);
        },

        // expecting the following format:
        // [v2:10.10.10.1:6802/2008,v1:10.10.10.1:6803/2008]
        render_ceph_osd_addr: function (value) {
            value = value.trim();
            if (value.startsWith('[') && value.endsWith(']')) {
                value = value.slice(1, -1); // remove []
            }
            value = value.replaceAll(',', '\n'); // split IPs in lines
            let retVal = '';
            for (const i of value.matchAll(/^(v[0-9]):(.*):([0-9]*)\/([0-9]*)$/gm)) {
                retVal += `${i[1]}: ${i[2]}:${i[3]}<br>`;
            }
            return retVal.length < 1 ? value : retVal;
        },

        windowHostname: function () {
            return window.location.hostname.replace(
                Proxmox.Utils.IP6_bracket_match,
                function (m, addr, offset, original) {
                    return addr;
                },
            );
        },

        openDefaultConsoleWindow: function (consoles, consoleType, vmid, nodename, vmname, cmd) {
            var dv = PVE.Utils.defaultViewer(consoles, consoleType);
            PVE.Utils.openConsoleWindow(dv, consoleType, vmid, nodename, vmname, cmd);
        },

        openConsoleWindow: function (viewer, consoleType, vmid, nodename, vmname, cmd) {
            if (vmid === undefined && (consoleType === 'kvm' || consoleType === 'lxc')) {
                throw 'missing vmid';
            }
            if (!nodename) {
                throw 'no nodename specified';
            }

            if (viewer === 'html5') {
                PVE.Utils.openVNCViewer(consoleType, vmid, nodename, vmname, cmd);
            } else if (viewer === 'xtermjs') {
                Proxmox.Utils.openXtermJsViewer(consoleType, vmid, nodename, vmname, cmd);
            } else if (viewer === 'vv') {
                let url = '/nodes/' + nodename + '/spiceshell';
                let params = {
                    proxy: PVE.Utils.windowHostname(),
                };
                if (consoleType === 'kvm') {
                    url = '/nodes/' + nodename + '/qemu/' + vmid.toString() + '/spiceproxy';
                } else if (consoleType === 'lxc') {
                    url = '/nodes/' + nodename + '/lxc/' + vmid.toString() + '/spiceproxy';
                } else if (consoleType === 'upgrade') {
                    params.cmd = 'upgrade';
                } else if (consoleType === 'cmd') {
                    params.cmd = cmd;
                } else if (consoleType !== 'shell') {
                    throw `unknown spice viewer type '${consoleType}'`;
                }
                PVE.Utils.openSpiceViewer(url, params);
            } else {
                throw `unknown viewer type '${viewer}'`;
            }
        },

        defaultViewer: function (consoles, type) {
            var allowSpice, allowXtermjs;

            if (consoles === true) {
                allowSpice = true;
                allowXtermjs = true;
            } else if (typeof consoles === 'object') {
                allowSpice = consoles.spice;
                allowXtermjs = !!consoles.xtermjs;
            }
            let dv = PVE.UIOptions.options.console || (type === 'kvm' ? 'vv' : 'xtermjs');
            if (dv === 'vv' && !allowSpice) {
                dv = allowXtermjs ? 'xtermjs' : 'html5';
            } else if (dv === 'xtermjs' && !allowXtermjs) {
                dv = allowSpice ? 'vv' : 'html5';
            }

            return dv;
        },

        openVNCViewer: function (vmtype, vmid, nodename, vmname, cmd) {
            let scaling = 'off';
            if (Proxmox.Utils.toolkit !== 'touch') {
                let sp = Ext.state.Manager.getProvider();
                scaling = sp.get('novnc-scaling', 'off');
            }
            var url = Ext.Object.toQueryString({
                console: vmtype, // kvm, lxc, upgrade or shell
                novnc: 1,
                vmid: vmid,
                vmname: vmname,
                node: nodename,
                resize: scaling,
                cmd: cmd,
            });
            var nw = window.open('?' + url, '_blank', 'innerWidth=745,innerheight=427');
            if (nw) {
                nw.focus();
            }
        },

        openSpiceViewer: function (url, params) {
            var downloadWithName = function (uri, name) {
                var link = Ext.DomHelper.append(document.body, {
                    tag: 'a',
                    href: uri,
                    css: 'display:none;visibility:hidden;height:0px;',
                });

                // Note: we need to tell Android, AppleWebKit and Chrome
                // the correct file name extension
                // but we do not set 'download' tag for other environments, because
                // It can have strange side effects (additional user prompt on firefox)
                if (navigator.userAgent.match(/Android|AppleWebKit|Chrome/i)) {
                    link.download = name;
                }

                if (link.fireEvent) {
                    link.fireEvent('onclick');
                } else {
                    let evt = document.createEvent('MouseEvents');
                    evt.initMouseEvent(
                        'click',
                        true,
                        true,
                        window,
                        1,
                        0,
                        0,
                        0,
                        0,
                        false,
                        false,
                        false,
                        false,
                        0,
                        null,
                    );
                    link.dispatchEvent(evt);
                }
            };

            Proxmox.Utils.API2Request({
                url: url,
                params: params,
                method: 'POST',
                failure: function (response, opts) {
                    Ext.Msg.alert('Error', response.htmlStatus);
                },
                success: function (response, opts) {
                    let cfg = response.result.data;
                    let raw = Object.entries(cfg).reduce(
                        (acc, [k, v]) => acc + `${k}=${v}\n`,
                        '[virt-viewer]\n',
                    );
                    let spiceDownload =
                        'data:application/x-virt-viewer;charset=UTF-8,' + encodeURIComponent(raw);
                    downloadWithName(spiceDownload, 'pve-spice.vv');
                },
            });
        },

        openTreeConsole: function (tree, record, item, index, e) {
            e.stopEvent();
            let nodename = record.data.node;
            let vmid = record.data.vmid;
            let vmname = record.data.name;
            if (record.data.type === 'qemu' && !record.data.template) {
                Proxmox.Utils.API2Request({
                    url: `/nodes/${nodename}/qemu/${vmid}/status/current`,
                    failure: (response) => Ext.Msg.alert('Error', response.htmlStatus),
                    success: function (response, opts) {
                        let conf = response.result.data;
                        let consoles = {
                            spice: !!conf.spice,
                            xtermjs: !!conf.serial,
                        };
                        PVE.Utils.openDefaultConsoleWindow(consoles, 'kvm', vmid, nodename, vmname);
                    },
                });
            } else if (record.data.type === 'lxc' && !record.data.template) {
                PVE.Utils.openDefaultConsoleWindow(true, 'lxc', vmid, nodename, vmname);
            }
        },

        // test automation helper
        call_menu_handler: function (menu, text) {
            let item = menu.query('menuitem').find((el) => el.text === text);
            if (item && item.handler) {
                item.handler();
            }
        },

        createCmdMenu: function (v, record, item, index, event) {
            event.stopEvent();
            if (!(v instanceof Ext.tree.View)) {
                v.select(record);
            }
            let menu;
            let type = record.data.type;

            if (record.data.template) {
                if (type === 'qemu' || type === 'lxc') {
                    menu = Ext.create('PVE.menu.TemplateMenu', {
                        pveSelNode: record,
                    });
                }
            } else if (type === 'qemu' || type === 'lxc' || type === 'node') {
                menu = Ext.create('PVE.' + type + '.CmdMenu', {
                    pveSelNode: record,
                    nodename: record.data.node,
                });
            } else {
                return undefined;
            }

            menu.showAt(event.getXY());
            return menu;
        },

        // helper for deleting field which are set to there default values
        delete_if_default: function (values, fieldname, default_val, create) {
            if (values[fieldname] === '' || values[fieldname] === default_val) {
                if (!create) {
                    if (values.delete) {
                        if (Ext.isArray(values.delete)) {
                            values.delete.push(fieldname);
                        } else {
                            values.delete += ',' + fieldname;
                        }
                    } else {
                        values.delete = fieldname;
                    }
                }

                delete values[fieldname];
            }
        },

        loadSSHKeyFromFile: function (file, callback) {
            // ssh-keygen produces ~ 740 bytes for a 4096 bit RSA key,  current max is 16 kbit, so assume:
            // 740 * 8 for max. 32kbit (5920 bytes), round upwards to 8192 bytes, leaves lots of comment space
            PVE.Utils.loadFile(file, callback, 8192);
        },

        loadFile: function (file, callback, maxSize) {
            maxSize = maxSize || 32 * 1024;
            if (file.size > maxSize) {
                Ext.Msg.alert(
                    gettext('Error'),
                    `${gettext('Invalid file size')}: ${file.size} > ${maxSize}`,
                );
                return;
            }
            let reader = new FileReader();
            reader.onload = (evt) => callback(evt.target.result);
            reader.readAsText(file);
        },

        loadTextFromFile: function (file, callback, maxBytes) {
            let maxSize = maxBytes || 8192;
            if (file.size > maxSize) {
                Ext.Msg.alert(gettext('Error'), gettext('Invalid file size: ') + file.size);
                return;
            }
            let reader = new FileReader();
            reader.onload = (evt) => callback(evt.target.result);
            reader.readAsText(file);
        },

        diskControllerMaxIDs: {
            ide: 4,
            sata: 6,
            scsi: 31,
            virtio: 16,
            unused: 256,
        },

        // types is either undefined (all busses), an array of busses, or a single bus
        forEachBus: function (types, func) {
            let busses = Object.keys(PVE.Utils.diskControllerMaxIDs);

            if (Ext.isArray(types)) {
                busses = types;
            } else if (Ext.isDefined(types)) {
                busses = [types];
            }

            // check if we only have valid busses
            for (let i = 0; i < busses.length; i++) {
                if (!PVE.Utils.diskControllerMaxIDs[busses[i]]) {
                    throw "invalid bus: '" + busses[i] + "'";
                }
            }

            for (let i = 0; i < busses.length; i++) {
                let count = PVE.Utils.diskControllerMaxIDs[busses[i]];
                for (let j = 0; j < count; j++) {
                    let cont = func(busses[i], j);
                    if (!cont && cont !== undefined) {
                        return;
                    }
                }
            }
        },

        lxc_mp_counts: {
            mp: 256,
            unused: 256,
        },

        forEachLxcMP: function (func, includeUnused) {
            for (let i = 0; i < PVE.Utils.lxc_mp_counts.mp; i++) {
                let cont = func('mp', i, `mp${i}`);
                if (!cont && cont !== undefined) {
                    return;
                }
            }

            if (!includeUnused) {
                return;
            }

            for (let i = 0; i < PVE.Utils.lxc_mp_counts.unused; i++) {
                let cont = func('unused', i, `unused${i}`);
                if (!cont && cont !== undefined) {
                    return;
                }
            }
        },

        lxc_dev_count: 256,

        forEachLxcDev: function (func) {
            for (let i = 0; i < PVE.Utils.lxc_dev_count; i++) {
                let cont = func(i, `dev${i}`);
                if (!cont && cont !== undefined) {
                    return;
                }
            }
        },

        hardware_counts: {
            net: 32,
            usb: 14,
            usb_old: 5,
            hostpci: 16,
            audio: 1,
            efidisk: 1,
            serial: 4,
            rng: 1,
            tpmstate: 1,
            virtiofs: 10,
        },

        // we can have usb6 and up only for specific machine/ostypes
        get_max_usb_count: function (ostype, machine) {
            if (!ostype) {
                return PVE.Utils.hardware_counts.usb_old;
            }

            let match = /-(\d+).(\d+)/.exec(machine ?? '');
            if (!match || PVE.Utils.qemu_min_version([match[1], match[2]], [7, 1])) {
                if (ostype === 'l26') {
                    return PVE.Utils.hardware_counts.usb;
                }
                let os_match = /^win(\d+)$/.exec(ostype);
                if (os_match && os_match[1] > 7) {
                    return PVE.Utils.hardware_counts.usb;
                }
            }

            return PVE.Utils.hardware_counts.usb_old;
        },

        // parameters are expected to be arrays, e.g. [7,1], [4,0,1]
        // returns true if toCheck is equal or greater than minVersion
        qemu_min_version: function (toCheck, minVersion) {
            let i;
            for (i = 0; i < toCheck.length && i < minVersion.length; i++) {
                if (toCheck[i] < minVersion[i]) {
                    return false;
                }
            }

            if (minVersion.length > toCheck.length) {
                for (; i < minVersion.length; i++) {
                    if (minVersion[i] !== 0) {
                        return false;
                    }
                }
            }

            return true;
        },

        cleanEmptyObjectKeys: function (obj) {
            for (const propName of Object.keys(obj)) {
                if (obj[propName] === null || obj[propName] === undefined) {
                    delete obj[propName];
                }
            }
        },

        acmedomain_count: 5,

        add_domain_to_acme: function (acme, domain) {
            if (acme.domains === undefined) {
                acme.domains = [domain];
            } else {
                acme.domains.push(domain);
                acme.domains = acme.domains.filter(
                    (value, index, self) => self.indexOf(value) === index,
                );
            }
            return acme;
        },

        remove_domain_from_acme: function (acme, domain) {
            if (acme.domains !== undefined) {
                acme.domains = acme.domains.filter(
                    (value, index, self) => self.indexOf(value) === index && value !== domain,
                );
            }
            return acme;
        },

        handleStoreErrorOrMask: function (view, store, regex, callback) {
            view.mon(store, 'load', function (proxy, response, success, operation) {
                if (success) {
                    Proxmox.Utils.setErrorMask(view, false);
                    return;
                }
                let msg;
                if (operation.error.statusText) {
                    if (operation.error.statusText.match(regex)) {
                        callback(view, operation.error);
                        return;
                    } else {
                        msg = operation.error.statusText + ' (' + operation.error.status + ')';
                    }
                } else {
                    msg = gettext('Connection error');
                }
                Proxmox.Utils.setErrorMask(view, Ext.htmlEncode(msg));
            });
        },

        showCephInstallOrMask: function (container, msg, nodename, callback) {
            if (msg.match(/not (installed|initialized)/i)) {
                if (Proxmox.UserName === 'root@pam') {
                    container.el.mask();
                    if (!container.down('pveCephInstallWindow')) {
                        let isInstalled = !!msg.match(/not initialized/i);
                        let win = Ext.create('PVE.ceph.Install', {
                            nodename: nodename,
                        });
                        win.getViewModel().set('isInstalled', isInstalled);
                        container.add(win);
                        win.on('close', () => {
                            container.el.unmask();
                        });
                        win.show();
                        callback(win);
                    }
                } else {
                    container.mask(
                        Ext.String.format(
                            gettext('{0} not installed.') +
                                ' ' +
                                gettext('Log in as root to install.'),
                            'Ceph',
                        ),
                        ['pve-static-mask'],
                    );
                }
                return true;
            } else {
                return false;
            }
        },

        monitor_ceph_installed: function (view, rstore, nodename, maskOwnerCt) {
            PVE.Utils.handleStoreErrorOrMask(
                view,
                rstore,
                /not (installed|initialized)/i,
                (_, error) => {
                    nodename = nodename || Proxmox.NodeName;
                    let maskTarget = maskOwnerCt ? view.ownerCt : view;
                    rstore.stopUpdate();
                    PVE.Utils.showCephInstallOrMask(
                        maskTarget,
                        error.statusText,
                        nodename,
                        (win) => {
                            view.mon(win, 'cephInstallWindowClosed', () => rstore.startUpdate());
                        },
                    );
                },
            );
        },

        propertyStringSet: function (target, source, name, value) {
            if (source) {
                if (value === undefined) {
                    target[name] = source;
                } else {
                    target[name] = value;
                }
            } else {
                delete target[name];
            }
        },

        forEachCorosyncLink: function (nodeinfo, cb) {
            let re = /(?:ring|link)(\d+)_addr/;
            Ext.iterate(nodeinfo, (prop, val) => {
                let match = re.exec(prop);
                if (match) {
                    cb(Number(match[1]), val);
                }
            });
        },

        cpu_vendor_map: {
            default: 'QEMU',
            AuthenticAMD: 'AMD',
            GenuineIntel: 'Intel',
        },

        cpu_vendor_order: {
            AMD: 1,
            Intel: 2,
            QEMU: 3,
            Host: 4,
            _default_: 5, // includes custom models
        },

        verify_ip64_address_list: function (value, with_suffix) {
            for (let addr of value.split(/[ ,;]+/)) {
                if (addr === '') {
                    continue;
                }

                if (with_suffix) {
                    let parts = addr.split('%');
                    addr = parts[0];

                    if (parts.length > 2) {
                        return false;
                    }

                    if (parts.length > 1 && !addr.startsWith('fe80:')) {
                        return false;
                    }
                }

                if (!Proxmox.Utils.IP64_match.test(addr)) {
                    return false;
                }
            }

            return true;
        },

        sortByPreviousUsage: function (vmconfig, controllerList) {
            if (!controllerList) {
                controllerList = ['ide', 'virtio', 'scsi', 'sata'];
            }
            let usedControllers = {};
            for (const type of Object.keys(PVE.Utils.diskControllerMaxIDs)) {
                usedControllers[type] = 0;
            }

            for (const property of Object.keys(vmconfig)) {
                if (
                    property.match(PVE.Utils.bus_match) &&
                    !vmconfig[property].match(/media=cdrom/)
                ) {
                    const foundController = property.match(PVE.Utils.bus_match)[1];
                    usedControllers[foundController]++;
                }
            }

            let sortPriority = PVE.qemu.OSDefaults.getDefaults(vmconfig.ostype).busPriority;

            let sortedList = Ext.clone(controllerList);
            sortedList.sort(function (a, b) {
                if (usedControllers[b] === usedControllers[a]) {
                    return sortPriority[b] - sortPriority[a];
                }
                return usedControllers[b] - usedControllers[a];
            });

            return sortedList;
        },

        nextFreeDisk: function (controllers, config) {
            for (const controller of controllers) {
                for (let i = 0; i < PVE.Utils.diskControllerMaxIDs[controller]; i++) {
                    let confid = controller + i.toString();
                    if (!Ext.isDefined(config[confid])) {
                        return {
                            controller,
                            id: i,
                            confid,
                        };
                    }
                }
            }

            return undefined;
        },

        nextFreeLxcMP: function (type, config) {
            for (let i = 0; i < PVE.Utils.lxc_mp_counts[type]; i++) {
                let confid = `${type}${i}`;
                if (!Ext.isDefined(config[confid])) {
                    return {
                        type,
                        id: i,
                        confid,
                    };
                }
            }

            return undefined;
        },

        escapeNotesTemplate: function (value) {
            let replace = {
                '\\': '\\\\',
                '\n': '\\n',
            };
            return value.replace(/(\\|[\n])/g, (match) => replace[match]);
        },

        unEscapeNotesTemplate: function (value) {
            let replace = {
                '\\\\': '\\',
                '\\n': '\n',
            };
            return value.replace(/(\\\\|\\n)/g, (match) => replace[match]);
        },

        notesTemplateVars: ['cluster', 'guestname', 'node', 'vmid'],

        renderTags: function (tagstext, overrides) {
            let text = '';
            if (tagstext) {
                let tags = (tagstext.split(/[,; ]/) || []).filter((t) => !!t);
                if (PVE.UIOptions.shouldSortTags()) {
                    tags = tags.sort((a, b) => {
                        let alc = a.toLowerCase();
                        let blc = b.toLowerCase();
                        return alc < blc ? -1 : blc < alc ? 1 : a.localeCompare(b);
                    });
                }
                text += ' ';
                tags.forEach((tag) => {
                    text += Proxmox.Utils.getTagElement(tag, overrides);
                });
            }
            return text;
        },

        tagCharRegex: /^[a-z0-9+_.-]+$/i,

        verificationStateOrder: {
            failed: 0,
            none: 1,
            ok: 2,
            __default__: 3,
        },

        isStandaloneNode: function () {
            return PVE.data.ResourceStore.getNodes().length < 2;
        },

        // main use case of this helper is the login window
        getUiLanguage: function () {
            let languageCookie = Ext.util.Cookies.get('PVELangCookie');
            if (languageCookie === 'kr') {
                // fix-up 'kr' being used for Korean by mistake FIXME: remove with PVE 9
                let dt = Ext.Date.add(new Date(), Ext.Date.YEAR, 10);
                languageCookie = 'ko';
                Ext.util.Cookies.set('PVELangCookie', languageCookie, dt);
            }
            return languageCookie || Proxmox.defaultLang || 'en';
        },

        getFormattedGuestIdentifier: function (vmid, guestName) {
            if (PVE.UIOptions.getTreeSortingValue('sort-field') === 'vmid') {
                return guestName ? `${vmid} (${guestName})` : vmid;
            } else {
                return guestName ? `${guestName} (${vmid})` : vmid;
            }
        },

        formatGuestTaskConfirmation: function (taskType, vmid, guestName) {
            let description = Proxmox.Utils.format_task_description(
                taskType,
                this.getFormattedGuestIdentifier(vmid, guestName),
            );
            return Ext.htmlEncode(description);
        },
    },

    singleton: true,
    constructor: function () {
        var me = this;
        Ext.apply(me, me.utilities);

        Proxmox.Utils.override_task_descriptions({
            acmedeactivate: ['ACME Account', gettext('Deactivate')],
            acmenewcert: ['SRV', gettext('Order Certificate')],
            acmerefresh: ['ACME Account', gettext('Refresh')],
            acmeregister: ['ACME Account', gettext('Register')],
            acmerenew: ['SRV', gettext('Renew Certificate')],
            acmerevoke: ['SRV', gettext('Revoke Certificate')],
            acmeupdate: ['ACME Account', gettext('Update')],
            'auth-realm-sync': [gettext('Realm'), gettext('Sync')],
            'auth-realm-sync-test': [gettext('Realm'), gettext('Sync Preview')],
            cephcreatemds: ['Ceph Metadata Server', gettext('Create')],
            cephcreatemgr: ['Ceph Manager', gettext('Create')],
            cephcreatemon: ['Ceph Monitor', gettext('Create')],
            cephcreateosd: ['Ceph OSD', gettext('Create')],
            cephcreatepool: ['Ceph Pool', gettext('Create')],
            cephdestroymds: ['Ceph Metadata Server', gettext('Destroy')],
            cephdestroymgr: ['Ceph Manager', gettext('Destroy')],
            cephdestroymon: ['Ceph Monitor', gettext('Destroy')],
            cephdestroyosd: ['Ceph OSD', gettext('Destroy')],
            cephdestroypool: ['Ceph Pool', gettext('Destroy')],
            cephdestroyfs: ['CephFS', gettext('Destroy')],
            cephfscreate: ['CephFS', gettext('Create')],
            cephsetpool: ['Ceph Pool', gettext('Edit')],
            cephsetflags: ['', gettext('Change global Ceph flags')],
            clustercreate: ['', gettext('Create Cluster')],
            clusterjoin: ['', gettext('Join Cluster')],
            dircreate: [gettext('Directory Storage'), gettext('Create')],
            dirremove: [gettext('Directory'), gettext('Remove')],
            download: [gettext('File'), gettext('Download')],
            hamigrate: ['HA', gettext('Migrate')],
            hashutdown: ['HA', gettext('Shutdown')],
            hastart: ['HA', gettext('Start')],
            hastop: ['HA', gettext('Stop')],
            imgcopy: ['', gettext('Copy data')],
            imgdel: ['', gettext('Erase data')],
            lvmcreate: [gettext('LVM Storage'), gettext('Create')],
            lvmremove: ['Volume Group', gettext('Remove')],
            lvmthincreate: [gettext('LVM-Thin Storage'), gettext('Create')],
            lvmthinremove: ['Thinpool', gettext('Remove')],
            migrateall: ['', gettext('Bulk migrate VMs and Containers')],
            move_volume: ['CT', gettext('Move Volume')],
            'pbs-download': ['VM/CT', gettext('File Restore Download')],
            pull_file: ['CT', gettext('Pull file')],
            push_file: ['CT', gettext('Push file')],
            qmclone: ['VM', gettext('Clone')],
            qmconfig: ['VM', gettext('Configure')],
            qmcreate: ['VM', gettext('Create')],
            qmdelsnapshot: ['VM', gettext('Delete Snapshot')],
            qmdestroy: ['VM', gettext('Destroy')],
            qmigrate: ['VM', gettext('Migrate')],
            qmmove: ['VM', gettext('Move disk')],
            qmpause: ['VM', gettext('Pause')],
            qmreboot: ['VM', gettext('Reboot')],
            qmreset: ['VM', gettext('Reset')],
            qmrestore: ['VM', gettext('Restore')],
            qmresume: ['VM', gettext('Resume')],
            qmrollback: ['VM', gettext('Rollback')],
            qmshutdown: ['VM', gettext('Shutdown')],
            qmsnapshot: ['VM', gettext('Snapshot')],
            qmstart: ['VM', gettext('Start')],
            qmstop: ['VM', gettext('Stop')],
            qmsuspend: ['VM', gettext('Hibernate')],
            qmtemplate: ['VM', gettext('Convert to template')],
            resize: ['VM/CT', gettext('Resize')],
            reloadnetworkall: ['', gettext('Reload network configuration on all nodes')],
            spiceproxy: ['VM/CT', gettext('Console') + ' (Spice)'],
            spiceshell: ['', gettext('Shell') + ' (Spice)'],
            startall: ['', gettext('Bulk start VMs and Containers')],
            stopall: ['', gettext('Bulk shutdown VMs and Containers')],
            suspendall: ['', gettext('Suspend all VMs')],
            unknownimgdel: ['', gettext('Destroy image from unknown guest')],
            wipedisk: ['Device', gettext('Wipe Disk')],
            vncproxy: ['VM/CT', gettext('Console')],
            vncshell: ['', gettext('Shell')],
            vzclone: ['CT', gettext('Clone')],
            vzcreate: ['CT', gettext('Create')],
            vzdelsnapshot: ['CT', gettext('Delete Snapshot')],
            vzdestroy: ['CT', gettext('Destroy')],
            vzdump: (type, id) =>
                id ? `VM/CT ${id} - ${gettext('Backup')}` : gettext('Backup Job'),
            vzmigrate: ['CT', gettext('Migrate')],
            vzmount: ['CT', gettext('Mount')],
            vzreboot: ['CT', gettext('Reboot')],
            vzrestore: ['CT', gettext('Restore')],
            vzresume: ['CT', gettext('Resume')],
            vzrollback: ['CT', gettext('Rollback')],
            vzshutdown: ['CT', gettext('Shutdown')],
            vzsnapshot: ['CT', gettext('Snapshot')],
            vzstart: ['CT', gettext('Start')],
            vzstop: ['CT', gettext('Stop')],
            vzsuspend: ['CT', gettext('Suspend')],
            vztemplate: ['CT', gettext('Convert to template')],
            vzumount: ['CT', gettext('Unmount')],
            zfscreate: [gettext('ZFS Storage'), gettext('Create')],
            zfsremove: ['ZFS Pool', gettext('Remove')],
        });

        Proxmox.Utils.overrideNotificationFieldName({
            'job-id': gettext('Job ID'),
        });

        Proxmox.Utils.overrideNotificationFieldValue({
            'package-updates': gettext('Package updates are available'),
            vzdump: gettext('Backup notifications'),
            replication: gettext('Replication job notifications'),
            fencing: gettext('Node fencing notifications'),
        });
    },
});
Ext.define('PVE.UIOptions', {
    singleton: true,

    options: {
        'allowed-tags': [],
    },

    update: function () {
        Proxmox.Utils.API2Request({
            url: '/cluster/options',
            method: 'GET',
            success: function (response) {
                for (const option of ['allowed-tags', 'console', 'tag-style']) {
                    PVE.UIOptions.options[option] = response?.result?.data?.[option];
                }

                PVE.UIOptions.updateTagList(PVE.UIOptions.options['allowed-tags']);
                PVE.UIOptions.updateTagSettings(PVE.UIOptions.options['tag-style']);
                PVE.UIOptions.fireUIConfigChanged();
            },
        });
    },

    tagList: [],

    updateTagList: function (tags) {
        PVE.UIOptions.tagList = [...new Set([...tags])].sort();
    },

    parseTagOverrides: function (overrides) {
        let colors = {};
        (overrides || '').split(';').forEach((color) => {
            if (!color) {
                return;
            }
            let [tag, color_hex, font_hex] = color.split(':');
            let r = parseInt(color_hex.slice(0, 2), 16);
            let g = parseInt(color_hex.slice(2, 4), 16);
            let b = parseInt(color_hex.slice(4, 6), 16);
            colors[tag] = [r, g, b];
            if (font_hex) {
                colors[tag].push(parseInt(font_hex.slice(0, 2), 16));
                colors[tag].push(parseInt(font_hex.slice(2, 4), 16));
                colors[tag].push(parseInt(font_hex.slice(4, 6), 16));
            }
        });
        return colors;
    },

    tagOverrides: {},

    updateTagOverrides: function (colors) {
        let sp = Ext.state.Manager.getProvider();
        let color_state = sp.get('colors', '');
        let browser_colors = PVE.UIOptions.parseTagOverrides(color_state);
        PVE.UIOptions.tagOverrides = Ext.apply({}, browser_colors, colors);
    },

    updateTagSettings: function (style) {
        let overrides = style?.['color-map'];
        PVE.UIOptions.updateTagOverrides(PVE.UIOptions.parseTagOverrides(overrides ?? ''));

        let shape = style?.shape ?? 'circle';
        if (shape === '__default__') {
            style = 'circle';
        }

        Ext.ComponentQuery.query('pveResourceTree')[0].setUserCls(`proxmox-tags-${shape}`);
    },

    tagTreeStyles: {
        __default__: `${Proxmox.Utils.defaultText} (${gettext('Circle')})`,
        full: gettext('Full'),
        circle: gettext('Circle'),
        dense: gettext('Dense'),
        none: Proxmox.Utils.NoneText,
    },

    tagOrderOptions: {
        __default__: `${Proxmox.Utils.defaultText} (${gettext('Alphabetical')})`,
        config: gettext('Configuration'),
        alphabetical: gettext('Alphabetical'),
    },

    shouldSortTags: function () {
        return !(PVE.UIOptions.options['tag-style']?.ordering === 'config');
    },

    getTreeSortingValue: function (key) {
        let localStorage = Ext.state.Manager.getProvider();
        let browserValues = localStorage.get('pve-tree-sorting');
        let defaults = {
            'sort-field': 'vmid',
            'group-templates': true,
            'group-guest-types': true,
        };

        return browserValues?.[key] ?? defaults[key];
    },

    fireUIConfigChanged: function () {
        PVE.data.ResourceStore.refresh();
        Ext.GlobalEvents.fireEvent('loadedUiOptions');
    },
});
// ExtJS related things

Proxmox.Utils.toolkit = 'extjs';

// custom PVE specific VTypes
Ext.apply(Ext.form.field.VTypes, {
    QemuStartDate: function (v) {
        return /^(now|\d{4}-\d{1,2}-\d{1,2}(T\d{1,2}:\d{1,2}:\d{1,2})?)$/.test(v);
    },
    QemuStartDateText: gettext('Format') + ': "now" or "2006-06-17T16:01:21" or "2006-06-17"',
    IP64AddressList: (v) => PVE.Utils.verify_ip64_address_list(v, false),
    IP64AddressWithSuffixList: (v) => PVE.Utils.verify_ip64_address_list(v, true),
    IP64AddressListText: gettext('Example') + ': 192.168.1.1,192.168.1.2',
    IP64AddressListMask: /[A-Fa-f0-9,:.; ]/,
    PciIdText: gettext('Example') + ': 0x8086',
    PciId: (v) => /^0x[0-9a-fA-F]{4}$/.test(v),
});

Ext.define('PVE.form.field.Display', {
    override: 'Ext.form.field.Display',

    setSubmitValue: function (value) {
        // do nothing, this is only to allow generalized  bindings for the:
        // `me.isCreate ? 'textfield' : 'displayfield'` cases we have.
    },
});
Ext.define('PVE.noVncConsole', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.pveNoVncConsole',

    nodename: undefined,
    vmid: undefined,
    cmd: undefined,

    consoleType: undefined, // lxc, kvm, shell, cmd
    xtermjs: false,

    layout: 'fit',
    border: false,

    initComponent: function () {
        var me = this;

        if (!me.nodename) {
            throw 'no node name specified';
        }

        if (!me.consoleType) {
            throw 'no console type specified';
        }

        if (!me.vmid && me.consoleType !== 'shell' && me.consoleType !== 'cmd') {
            throw 'no VM ID specified';
        }

        // always use same iframe, to avoid running several noVnc clients
        // at same time (to avoid performance problems)
        var box = Ext.create('Ext.ux.IFrame', { itemid: 'vncconsole' });

        var type = me.xtermjs ? 'xtermjs' : 'novnc';
        Ext.apply(me, {
            items: box,
            listeners: {
                activate: function () {
                    let sp = Ext.state.Manager.getProvider();
                    if (Ext.isFunction(me.beforeLoad)) {
                        me.beforeLoad();
                    }
                    let queryDict = {
                        console: me.consoleType, // kvm, lxc, upgrade or shell
                        vmid: me.vmid,
                        node: me.nodename,
                        cmd: me.cmd,
                        'cmd-opts': me.cmdOpts,
                        resize: sp.get('novnc-scaling', 'scale'),
                    };
                    queryDict[type] = 1;
                    PVE.Utils.cleanEmptyObjectKeys(queryDict);
                    var url = '/?' + Ext.Object.toQueryString(queryDict);
                    box.load(url);
                },
            },
        });

        me.callParent();

        me.on('afterrender', function () {
            me.focus();
        });
    },

    reload: function () {
        // reload IFrame content to forcibly reconnect VNC/xterm.js to VM
        var box = this.down('[itemid=vncconsole]');
        box.getWin().location.reload();
    },
});
Ext.define('PVE.button.ConsoleButton', {
    extend: 'Ext.button.Split',
    alias: 'widget.pveConsoleButton',

    consoleType: 'shell', // one of 'shell', 'kvm', 'lxc', 'upgrade', 'cmd'

    cmd: undefined,

    consoleName: undefined,

    iconCls: 'fa fa-terminal',

    enableSpice: true,
    enableXtermjs: true,

    nodename: undefined,

    vmid: 0,

    text: gettext('Console'),

    setEnableSpice: function (enable) {
        var me = this;

        me.enableSpice = enable;
        me.down('#spicemenu').setDisabled(!enable);
    },

    setEnableXtermJS: function (enable) {
        var me = this;

        me.enableXtermjs = enable;
        me.down('#xtermjs').setDisabled(!enable);
    },

    handler: function () {
        // main, general, handler
        let me = this;
        PVE.Utils.openDefaultConsoleWindow(
            {
                spice: me.enableSpice,
                xtermjs: me.enableXtermjs,
            },
            me.consoleType,
            me.vmid,
            me.nodename,
            me.consoleName,
            me.cmd,
        );
    },

    openConsole: function (types) {
        // used by split-menu buttons
        let me = this;
        PVE.Utils.openConsoleWindow(
            types,
            me.consoleType,
            me.vmid,
            me.nodename,
            me.consoleName,
            me.cmd,
        );
    },

    menu: [
        {
            xtype: 'menuitem',
            text: 'noVNC',
            iconCls: 'pve-itype-icon-novnc',
            type: 'html5',
            handler: function (button) {
                let view = this.up('button');
                view.openConsole(button.type);
            },
        },
        {
            xterm: 'menuitem',
            itemId: 'spicemenu',
            text: 'SPICE',
            type: 'vv',
            iconCls: 'pve-itype-icon-virt-viewer',
            handler: function (button) {
                let view = this.up('button');
                view.openConsole(button.type);
            },
        },
        {
            text: 'xterm.js',
            itemId: 'xtermjs',
            iconCls: 'pve-itype-icon-xtermjs',
            type: 'xtermjs',
            handler: function (button) {
                let view = this.up('button');
                view.openConsole(button.type);
            },
        },
    ],

    initComponent: function () {
        let me = this;

        if (!me.nodename) {
            throw 'no node name specified';
        }

        me.callParent();
    },
});
Ext.define('PVE.button.PendingRevert', {
    extend: 'Proxmox.button.Button',
    alias: 'widget.pvePendingRevertButton',

    text: gettext('Revert'),
    disabled: true,
    config: {
        pendingGrid: null,
        apiurl: undefined,
    },

    handler: function () {
        if (!this.pendingGrid) {
            this.pendingGrid = this.up('proxmoxPendingObjectGrid');
            if (!this.pendingGrid) {
                throw 'revert button requires a pendingGrid';
            }
        }
        let view = this.pendingGrid;

        let rec = view.getSelectionModel().getSelection()[0];
        if (!rec) {
            return;
        }

        let rowdef = view.rows[rec.data.key] || {};
        let keys = rowdef.multiKey || [rec.data.key];

        Proxmox.Utils.API2Request({
            url: this.apiurl || view.editorConfig.url,
            waitMsgTarget: view,
            selModel: view.getSelectionModel(),
            method: 'PUT',
            params: {
                revert: keys.join(','),
            },
            callback: () => view.reload(),
            failure: (response) => Ext.Msg.alert('Error', response.htmlStatus),
        });
    },
});
/* Button features:
 * - observe selection changes to enable/disable the button using enableFn()
 * - pop up confirmation dialog using confirmMsg()
 *
 *   does this for the button and every menu item
 */
Ext.define('PVE.button.Split', {
    extend: 'Ext.button.Split',
    alias: 'widget.pveSplitButton',

    // the selection model to observe
    selModel: undefined,

    // if 'false' handler will not be called (button disabled)
    enableFn: function (record) {
        // do nothing
    },

    // function(record) or text
    confirmMsg: false,

    // take special care in confirm box (select no as default).
    dangerous: false,

    handlerWrapper: function (button, event) {
        var me = this;
        var rec, msg;
        if (me.selModel) {
            rec = me.selModel.getSelection()[0];
            if (!rec || me.enableFn(rec) === false) {
                return;
            }
        }

        if (me.confirmMsg) {
            msg = me.confirmMsg;
            // confirMsg can be boolean or function
            if (Ext.isFunction(me.confirmMsg)) {
                msg = me.confirmMsg(rec);
            }
            Ext.MessageBox.defaultButton = me.dangerous ? 2 : 1;
            Ext.Msg.show({
                title: gettext('Confirm'),
                icon: me.dangerous ? Ext.Msg.WARNING : Ext.Msg.QUESTION,
                msg: msg,
                buttons: Ext.Msg.YESNO,
                callback: function (btn) {
                    if (btn !== 'yes') {
                        return;
                    }
                    me.realHandler(button, event, rec);
                },
            });
        } else {
            me.realHandler(button, event, rec);
        }
    },

    initComponent: function () {
        var me = this;

        if (me.handler) {
            me.realHandler = me.handler;
            me.handler = me.handlerWrapper;
        }

        if (me.menu && me.menu.items) {
            me.menu.items.forEach(function (item) {
                if (item.handler) {
                    item.realHandler = item.handler;
                    item.handler = me.handlerWrapper;
                }

                if (item.selModel) {
                    me.mon(item.selModel, 'selectionchange', function () {
                        var rec = item.selModel.getSelection()[0];
                        if (!rec || item.enableFn(rec) === false) {
                            item.setDisabled(true);
                        } else {
                            item.setDisabled(false);
                        }
                    });
                }
            });
        }

        me.callParent();

        if (me.selModel) {
            me.mon(me.selModel, 'selectionchange', function () {
                var rec = me.selModel.getSelection()[0];
                if (!rec || me.enableFn(rec) === false) {
                    me.setDisabled(true);
                } else {
                    me.setDisabled(false);
                }
            });
        }
    },
});
Ext.define('PVE.controller.StorageEdit', {
    extend: 'Ext.app.ViewController',
    alias: 'controller.storageEdit',
    control: {
        'field[name=content]': {
            change: function (field, value) {
                const hasImages = Ext.Array.contains(value, 'images');
                const prealloc = field.up('form').getForm().findField('preallocation');
                if (prealloc) {
                    prealloc.setDisabled(!hasImages);
                }

                var hasBackups = Ext.Array.contains(value, 'backup');
                var maxfiles = this.lookupReference('maxfiles');
                if (!maxfiles) {
                    return;
                }

                if (!hasBackups) {
                    // clear values which will never be submitted
                    maxfiles.reset();
                }
                maxfiles.setDisabled(!hasBackups);
            },
        },
    },
});
Ext.define('PVE.data.PermPathStore', {
    extend: 'Ext.data.Store',
    alias: 'store.pvePermPath',
    fields: ['value'],
    autoLoad: false,
    data: [
        { value: '/' },
        { value: '/access' },
        { value: '/access/groups' },
        { value: '/access/realm' },
        { value: '/mapping' },
        { value: '/mapping/hwrng' },
        { value: '/mapping/notifications' },
        { value: '/mapping/pci' },
        { value: '/mapping/usb' },
        { value: '/nodes' },
        { value: '/pool' },
        { value: '/sdn/zones' },
        { value: '/storage' },
        { value: '/vms' },
    ],

    constructor: function (config) {
        var me = this;

        config = config || {};

        me.callParent([config]);

        let donePaths = {};
        me.suspendEvents();
        PVE.data.ResourceStore.each(function (record) {
            let path;
            switch (record.get('type')) {
                case 'node':
                    path = '/nodes/' + record.get('text');
                    break;
                case 'qemu':
                    path = '/vms/' + record.get('vmid');
                    break;
                case 'lxc':
                    path = '/vms/' + record.get('vmid');
                    break;
                case 'sdn':
                    path = '/sdn/zones/' + record.get('sdn');
                    break;
                case 'storage':
                    path = '/storage/' + record.get('storage');
                    break;
                case 'pool':
                    path = '/pool/' + record.get('pool');
                    break;
            }
            if (path !== undefined && !donePaths[path]) {
                me.add({ value: path });
                donePaths[path] = 1;
            }
        });
        me.resumeEvents();

        me.fireEvent('refresh', me);
        me.fireEvent('datachanged', me);

        me.sort({
            property: 'value',
            direction: 'ASC',
        });
    },
});
Ext.define('PVE.data.ResourceStore', {
    extend: 'Proxmox.data.UpdateStore',
    singleton: true,

    nodeCache: {},

    findVMID: function (vmid) {
        let me = this;
        return me.findExact('vmid', parseInt(vmid, 10)) >= 0;
    },

    // returns the cached data from all nodes
    getNodes: function () {
        let me = this;

        let nodes = [];
        me.each(function (record) {
            if (record.get('type') === 'node') {
                nodes.push(record.getData());
            }
        });

        return nodes;
    },

    getNodeById: function (id) {
        let me = this;

        if (!me.nodeCache[id]) {
            let idx = me.findExact('id', `node/${id}`);
            me.nodeCache[id] = me.getAt(idx);
        }

        return me.nodeCache[id];
    },

    clearCache: function () {
        let me = this;
        me.nodeCache = {};
    },

    storageIsShared: function (storage_path) {
        let me = this;

        let index = me.findExact('id', storage_path);
        if (index >= 0) {
            return me.getAt(index).data.shared;
        } else {
            return undefined;
        }
    },

    guestNode: function (vmid) {
        let me = this;

        let index = me.findExact('vmid', parseInt(vmid, 10));

        return me.getAt(index).data.node;
    },

    guestName: function (vmid) {
        let me = this;
        let index = me.findExact('vmid', parseInt(vmid, 10));
        if (index < 0) {
            return '-';
        }
        let rec = me.getAt(index).data;
        if ('name' in rec) {
            return rec.name;
        }
        return '';
    },

    refresh: function () {
        let me = this;
        // can only refresh if we're loaded at least once and are not currently loading
        if (!me.isLoading() && me.isLoaded()) {
            let records = (me.getData().getSource() || me.getData()).getRange();
            me.fireEvent('load', me, records);
        }
    },

    constructor: function (config) {
        let me = this;

        config = config || {};

        let field_defaults = {
            type: {
                header: gettext('Type'),
                type: 'string',
                renderer: PVE.Utils.render_resource_type,
                sortable: true,
                hideable: false,
                width: 100,
            },
            id: {
                header: 'ID',
                type: 'string',
                hidden: true,
                sortable: true,
                width: 80,
            },
            running: {
                header: gettext('Online'),
                type: 'boolean',
                renderer: Proxmox.Utils.format_boolean,
                hidden: true,
                convert: function (value, record) {
                    var info = record.data;
                    return Ext.isNumeric(info.uptime) && info.uptime > 0;
                },
            },
            text: {
                header: gettext('Description'),
                type: 'string',
                sortable: true,
                width: 200,
                convert: function (value, record) {
                    if (value) {
                        return value;
                    }

                    let info = record.data,
                        text;
                    if (Ext.isNumeric(info.vmid) && info.vmid > 0) {
                        text = String(info.vmid);
                        if (info.name) {
                            text += ' (' + info.name + ')';
                        }
                    } else {
                        // node, pool, storage
                        text = info[info.type] || info.id;
                        if (info.node && info.type !== 'node') {
                            text += ' (' + info.node + ')';
                        }
                    }

                    return text;
                },
            },
            vmid: {
                header: 'VMID',
                type: 'integer',
                hidden: true,
                sortable: true,
                width: 80,
            },
            name: {
                header: gettext('Name'),
                hidden: true,
                sortable: true,
                type: 'string',
            },
            disk: {
                header: gettext('Disk usage'),
                type: 'integer',
                renderer: PVE.Utils.render_disk_usage,
                sortable: true,
                width: 100,
                hidden: true,
            },
            diskuse: {
                header: gettext('Disk usage') + ' %',
                type: 'number',
                sortable: true,
                renderer: PVE.Utils.render_disk_usage_percent,
                width: 100,
                calculate: PVE.Utils.calculate_disk_usage,
                sortType: 'asFloat',
            },
            maxdisk: {
                header: gettext('Disk size'),
                type: 'integer',
                renderer: Proxmox.Utils.render_size,
                sortable: true,
                hidden: true,
                width: 100,
            },
            mem: {
                header: gettext('Memory usage'),
                type: 'integer',
                renderer: PVE.Utils.render_mem_usage,
                sortable: true,
                hidden: true,
                width: 100,
            },
            memuse: {
                header: gettext('Memory usage') + ' %',
                type: 'number',
                renderer: PVE.Utils.render_mem_usage_percent,
                calculate: PVE.Utils.calculate_mem_usage,
                sortType: 'asFloat',
                sortable: true,
                width: 100,
            },
            maxmem: {
                header: gettext('Memory size'),
                type: 'integer',
                renderer: Proxmox.Utils.render_size,
                hidden: true,
                sortable: true,
                width: 100,
            },
            cpu: {
                header: gettext('CPU usage'),
                type: 'float',
                renderer: Proxmox.Utils.render_cpu,
                sortable: true,
                width: 100,
            },
            maxcpu: {
                header: gettext('maxcpu'),
                type: 'integer',
                hidden: true,
                sortable: true,
                width: 60,
            },
            diskread: {
                header: gettext('Total Disk Read'),
                type: 'integer',
                hidden: true,
                sortable: true,
                renderer: Proxmox.Utils.format_size,
                width: 100,
            },
            diskwrite: {
                header: gettext('Total Disk Write'),
                type: 'integer',
                hidden: true,
                sortable: true,
                renderer: Proxmox.Utils.format_size,
                width: 100,
            },
            netin: {
                header: gettext('Total NetIn'),
                type: 'integer',
                hidden: true,
                sortable: true,
                renderer: Proxmox.Utils.format_size,
                width: 100,
            },
            netout: {
                header: gettext('Total NetOut'),
                type: 'integer',
                hidden: true,
                sortable: true,
                renderer: Proxmox.Utils.format_size,
                width: 100,
            },
            template: {
                header: gettext('Template'),
                type: 'integer',
                hidden: true,
                sortable: true,
                width: 60,
            },
            uptime: {
                header: gettext('Uptime'),
                type: 'integer',
                renderer: Proxmox.Utils.render_uptime,
                sortable: true,
                width: 110,
            },
            node: {
                header: gettext('Node'),
                type: 'string',
                hidden: true,
                sortable: true,
                width: 110,
            },
            storage: {
                header: gettext('Storage'),
                type: 'string',
                hidden: true,
                sortable: true,
                width: 110,
            },
            pool: {
                header: gettext('Pool'),
                type: 'string',
                hidden: true,
                sortable: true,
                width: 110,
            },
            hastate: {
                header: gettext('HA State'),
                type: 'string',
                defaultValue: 'unmanaged',
                hidden: true,
                sortable: true,
            },
            status: {
                header: gettext('Status'),
                type: 'string',
                hidden: true,
                sortable: true,
                width: 110,
            },
            lock: {
                header: gettext('Lock'),
                type: 'string',
                hidden: true,
                sortable: true,
                width: 110,
            },
            hostcpu: {
                header: gettext('Host CPU usage'),
                type: 'float',
                renderer: PVE.Utils.render_hostcpu,
                calculate: PVE.Utils.calculate_hostcpu,
                sortType: 'asFloat',
                sortable: true,
                width: 100,
            },
            hostmemuse: {
                header: gettext('Host Memory usage') + ' %',
                type: 'number',
                renderer: PVE.Utils.render_hostmem_usage_percent,
                calculate: PVE.Utils.calculate_hostmem_usage,
                sortType: 'asFloat',
                sortable: true,
                width: 100,
            },
            tags: {
                header: gettext('Tags'),
                renderer: (value) => PVE.Utils.renderTags(value, PVE.UIOptions.tagOverrides),
                type: 'string',
                sortable: true,
                flex: 1,
            },
            // note: flex only last column to keep info closer together
        };

        let fields = [];
        let fieldNames = [];
        Ext.Object.each(field_defaults, function (key, value) {
            var field = { name: key, type: value.type };
            if (Ext.isDefined(value.convert)) {
                field.convert = value.convert;
            }

            if (Ext.isDefined(value.calculate)) {
                field.calculate = value.calculate;
            }

            if (Ext.isDefined(value.defaultValue)) {
                field.defaultValue = value.defaultValue;
            }

            fields.push(field);
            fieldNames.push(key);
        });

        Ext.define('PVEResources', {
            extend: 'Ext.data.Model',
            fields: fields,
            proxy: {
                type: 'proxmox',
                url: '/api2/json/cluster/resources',
            },
        });

        Ext.define('PVETree', {
            extend: 'Ext.data.Model',
            fields: fields,
            proxy: { type: 'memory' },
        });

        Ext.apply(config, {
            storeid: 'PVEResources',
            model: 'PVEResources',
            defaultColumns: function () {
                let res = [];
                Ext.Object.each(field_defaults, function (field, info) {
                    let fieldInfo = Ext.apply({ dataIndex: field }, info);
                    res.push(fieldInfo);
                });
                return res;
            },
            fieldNames: fieldNames,
        });

        me.callParent([config]);

        me.on('beforeload', me.clearCache, me);
    },
});
Ext.define('pve-rrd-node', {
    extend: 'Ext.data.Model',
    fields: [
        {
            name: 'cpu',
            // percentage
            convert: function (value) {
                return value * 100;
            },
        },
        {
            name: 'iowait',
            // percentage
            convert: function (value) {
                return value * 100;
            },
        },
        'loadavg',
        'maxcpu',
        'memtotal',
        'memused',
        'netin',
        'netout',
        'roottotal',
        'rootused',
        'swaptotal',
        'swapused',
        { type: 'date', dateFormat: 'timestamp', name: 'time' },
    ],
});

Ext.define('pve-rrd-guest', {
    extend: 'Ext.data.Model',
    fields: [
        {
            name: 'cpu',
            // percentage
            convert: function (value) {
                return value * 100;
            },
        },
        'maxcpu',
        'netin',
        'netout',
        'mem',
        'maxmem',
        'disk',
        'maxdisk',
        'diskread',
        'diskwrite',
        { type: 'date', dateFormat: 'timestamp', name: 'time' },
    ],
});

Ext.define('pve-rrd-storage', {
    extend: 'Ext.data.Model',
    fields: ['used', 'total', { type: 'date', dateFormat: 'timestamp', name: 'time' }],
});
// This is a container intended to show a field on the first column and one on the second column.
// One can set a ratio for the field sizes.
//
// Works around a limitation of our input panel column1/2 handling that entries are not vertically
// aligned when one of them has wrapping text (like it happens sometimes with such longer
// descriptions)
Ext.define('PVE.container.TwoColumnContainer', {
    extend: 'Ext.container.Container',
    alias: 'widget.pveTwoColumnContainer',

    layout: {
        type: 'hbox',
        align: 'begin',
    },

    // The default ratio of the start widget. It an be an integer or a floating point number
    startFlex: 1,

    // The default ratio of the end widget. It an be an integer or a floating point number
    endFlex: 1,

    // the padding between the two columns
    columnPadding: 20,

    // the config of the first widget
    startColumn: undefined,

    // the config of the second widget
    endColumn: undefined,

    // same as fields in a panel
    padding: '0 0 5 0',

    initComponent: function () {
        let me = this;

        if (!me.startColumn) {
            throw 'no start widget configured';
        }
        if (!me.endColumn) {
            throw 'no end widget configured';
        }

        Ext.apply(me, {
            items: [
                Ext.applyIf({ flex: me.startFlex }, me.startColumn),
                {
                    xtype: 'box',
                    width: me.columnPadding,
                },
                Ext.applyIf({ flex: me.endFlex }, me.endColumn),
            ],
        });

        me.callParent();
    },
});
Ext.define('pve-acme-challenges', {
    extend: 'Ext.data.Model',
    fields: ['id', 'type', 'schema'],
    proxy: {
        type: 'proxmox',
        url: '/api2/json/cluster/acme/challenge-schema',
    },
    idProperty: 'id',
});

Ext.define('PVE.form.ACMEApiSelector', {
    extend: 'Ext.form.field.ComboBox',
    alias: 'widget.pveACMEApiSelector',

    fieldLabel: gettext('DNS API'),
    displayField: 'name',
    valueField: 'id',

    store: {
        model: 'pve-acme-challenges',
        autoLoad: true,
    },

    triggerAction: 'all',
    queryMode: 'local',
    allowBlank: false,
    editable: true,
    forceSelection: true,
    anyMatch: true,
    selectOnFocus: true,

    getSchema: function () {
        let me = this;
        let val = me.getValue();
        if (val) {
            let record = me.getStore().findRecord('id', val, 0, false, true, true);
            if (record) {
                return record.data.schema;
            }
        }
        return {};
    },
});
Ext.define('PVE.form.ACMEAccountSelector', {
    extend: 'Ext.form.field.ComboBox',
    alias: 'widget.pveACMEAccountSelector',

    displayField: 'name',
    valueField: 'name',

    store: {
        model: 'pve-acme-accounts',
        autoLoad: true,
    },

    triggerAction: 'all',
    queryMode: 'local',
    allowBlank: false,
    editable: false,
    forceSelection: true,

    isEmpty: function () {
        return this.getStore().getData().length === 0;
    },
});
Ext.define('PVE.form.ACMEPluginSelector', {
    extend: 'Ext.form.field.ComboBox',
    alias: 'widget.pveACMEPluginSelector',

    fieldLabel: gettext('Plugin'),
    displayField: 'plugin',
    valueField: 'plugin',

    store: {
        model: 'pve-acme-plugins',
        autoLoad: true,
        filters: (item) => item.data.type === 'dns',
    },

    triggerAction: 'all',
    queryMode: 'local',
    allowBlank: false,
    editable: false,
});
Ext.define('PVE.form.AgentFeatureSelector', {
    extend: 'Proxmox.panel.InputPanel',
    alias: ['widget.pveAgentFeatureSelector'],

    viewModel: {},

    items: [
        {
            xtype: 'proxmoxcheckbox',
            boxLabel: Ext.String.format(gettext('Use {0}'), 'QEMU Guest Agent'),
            name: 'enabled',
            reference: 'enabled',
            uncheckedValue: 0,
        },
        {
            xtype: 'proxmoxcheckbox',
            boxLabel: gettext('Run guest-trim after a disk move or VM migration'),
            name: 'fstrim_cloned_disks',
            bind: {
                disabled: '{!enabled.checked}',
            },
            disabled: true,
        },
        {
            xtype: 'proxmoxcheckbox',
            boxLabel: gettext('Freeze/thaw guest filesystems on backup for consistency'),
            name: 'freeze-fs-on-backup',
            reference: 'freeze_fs_on_backup',
            bind: {
                disabled: '{!enabled.checked}',
            },
            disabled: true,
            uncheckedValue: '0',
            defaultValue: '1',
        },
        {
            xtype: 'displayfield',
            userCls: 'pmx-hint',
            value: gettext(
                'Freeze/thaw for guest filesystems disabled. This can lead to inconsistent disk backups.',
            ),
            bind: {
                hidden: '{freeze_fs_on_backup.checked}',
            },
        },
        {
            xtype: 'displayfield',
            userCls: 'pmx-hint',
            value: gettext('Make sure the QEMU Guest Agent is installed in the VM'),
            bind: {
                hidden: '{!enabled.checked}',
            },
        },
    ],

    advancedItems: [
        {
            xtype: 'proxmoxKVComboBox',
            name: 'type',
            value: '__default__',
            deleteEmpty: false,
            fieldLabel: 'Type',
            comboItems: [
                ['__default__', Proxmox.Utils.defaultText + ' (VirtIO)'],
                ['virtio', 'VirtIO'],
                ['isa', 'ISA'],
            ],
        },
    ],

    onGetValues: function (values) {
        if (PVE.Parser.parseBoolean(values['freeze-fs-on-backup'])) {
            delete values['freeze-fs-on-backup'];
        }

        const agentstr = PVE.Parser.printPropertyString(values, 'enabled');
        return { agent: agentstr };
    },

    setValues: function (values) {
        let res = PVE.Parser.parsePropertyString(values.agent, 'enabled');
        if (!Ext.isDefined(res['freeze-fs-on-backup'])) {
            res['freeze-fs-on-backup'] = 1;
        }

        this.callParent([res]);
    },
});
Ext.define('PVE.form.BackupCompressionSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.pveBackupCompressionSelector'],
    comboItems: [
        ['0', Proxmox.Utils.noneText],
        ['lzo', 'LZO (' + gettext('fast') + ')'],
        ['gzip', 'GZIP (' + gettext('good') + ')'],
        ['zstd', 'ZSTD (' + gettext('fast and good') + ')'],
    ],
});
Ext.define('PVE.form.BackupModeSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.pveBackupModeSelector'],
    comboItems: [
        ['snapshot', gettext('Snapshot')],
        ['suspend', gettext('Suspend')],
        ['stop', gettext('Stop')],
    ],
});
Ext.define('PVE.form.SizeField', {
    extend: 'Ext.form.FieldContainer',
    alias: 'widget.pveSizeField',

    mixins: ['Proxmox.Mixin.CBind'],

    viewModel: {
        data: {
            unit: 'MiB',
            unitPostfix: '',
        },
        formulas: {
            unitlabel: (get) => get('unit') + get('unitPostfix'),
        },
    },

    emptyText: '',

    layout: 'hbox',
    defaults: {
        hideLabel: true,
    },

    units: {
        B: 1,
        KiB: 1024,
        MiB: 1024 * 1024,
        GiB: 1024 * 1024 * 1024,
        TiB: 1024 * 1024 * 1024 * 1024,
        KB: 1000,
        MB: 1000 * 1000,
        GB: 1000 * 1000 * 1000,
        TB: 1000 * 1000 * 1000 * 1000,
    },

    // display unit (TODO: make (optionally) selectable)
    unit: 'MiB',
    unitPostfix: '',

    // use this if the backend saves values in a unit other than bytes, e.g.,
    // for KiB set it to 'KiB'
    backendUnit: undefined,

    // allow setting 0 and using it as a submit value
    allowZero: false,

    emptyValue: null,

    items: [
        {
            xtype: 'numberfield',
            cbind: {
                name: '{name}',
                emptyText: '{emptyText}',
                allowZero: '{allowZero}',
                emptyValue: '{emptyValue}',
            },
            minValue: 0,
            step: 1,
            submitLocaleSeparator: false,
            fieldStyle: 'text-align: right',
            flex: 1,
            enableKeyEvents: true,
            setValue: function (v) {
                if (!this._transformed && v !== null) {
                    let fieldContainer = this.up('fieldcontainer');
                    let vm = fieldContainer.getViewModel();
                    let unit = vm.get('unit');

                    v /= fieldContainer.units[unit];
                    v *= fieldContainer.backendFactor;

                    this._transformed = true;
                }

                if (Number(v) === 0 && !this.allowZero) {
                    v = undefined;
                }

                return Ext.form.field.Text.prototype.setValue.call(this, v);
            },
            getSubmitValue: function () {
                let v = this.processRawValue(this.getRawValue());
                v = v.replace(this.decimalSeparator, '.');

                if (v === undefined || v === '') {
                    return this.emptyValue;
                }

                if (Number(v) === 0) {
                    return this.allowZero ? 0 : null;
                }

                let fieldContainer = this.up('fieldcontainer');
                let vm = fieldContainer.getViewModel();
                let unit = vm.get('unit');

                v = parseFloat(v) * fieldContainer.units[unit];
                v /= fieldContainer.backendFactor;

                return String(Math.floor(v));
            },
            listeners: {
                // our setValue gets only called if we have a value, avoid
                // transformation of the first user-entered value
                keydown: function () {
                    this._transformed = true;
                },
            },
        },
        {
            xtype: 'displayfield',
            name: 'unit',
            submitValue: false,
            padding: '0 0 0 10',
            bind: {
                value: '{unitlabel}',
            },
            listeners: {
                change: (f, v) => {
                    f.originalValue = v;
                },
            },
            width: 40,
        },
    ],

    initComponent: function () {
        let me = this;

        me.unit = me.unit || 'MiB';
        if (!(me.unit in me.units)) {
            throw 'unknown unit: ' + me.unit;
        }

        me.backendFactor = 1;
        if (me.backendUnit !== undefined) {
            if (!(me.unit in me.units)) {
                throw 'unknown backend unit: ' + me.backendUnit;
            }
            me.backendFactor = me.units[me.backendUnit];
        }

        me.callParent(arguments);

        me.getViewModel().set('unit', me.unit);
        me.getViewModel().set('unitPostfix', me.unitPostfix);
    },
});

Ext.define('PVE.form.BandwidthField', {
    extend: 'PVE.form.SizeField',
    alias: 'widget.pveBandwidthField',

    unitPostfix: '/s',
});
Ext.define('PVE.form.BridgeSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: ['widget.PVE.form.BridgeSelector'],

    bridgeType: 'any_bridge', // bridge, OVSBridge or any_bridge

    store: {
        fields: ['iface', 'active', 'type'],
        filterOnLoad: true,
        sorters: [
            {
                property: 'iface',
                direction: 'ASC',
            },
        ],
    },
    valueField: 'iface',
    displayField: 'iface',
    listConfig: {
        columns: [
            {
                header: gettext('Bridge'),
                dataIndex: 'iface',
                hideable: false,
                width: 100,
            },
            {
                header: gettext('Active'),
                width: 60,
                dataIndex: 'active',
                renderer: Proxmox.Utils.format_boolean,
            },
            {
                header: gettext('Comment'),
                dataIndex: 'comments',
                renderer: Ext.String.htmlEncode,
                flex: 1,
            },
        ],
    },

    setNodename: function (nodename) {
        var me = this;

        if (!nodename || me.nodename === nodename) {
            return;
        }

        me.nodename = nodename;

        me.store.setProxy({
            type: 'proxmox',
            url: '/api2/json/nodes/' + me.nodename + '/network?type=' + me.bridgeType,
        });

        me.store.load();
    },

    initComponent: function () {
        var me = this;

        var nodename = me.nodename;
        me.nodename = undefined;

        me.callParent();

        me.setNodename(nodename);
    },
});
Ext.define('PVE.form.BusTypeSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: 'widget.pveBusSelector',

    withVirtIO: true,
    withUnused: false,

    initComponent: function () {
        var me = this;

        me.comboItems = [
            ['ide', 'IDE'],
            ['sata', 'SATA'],
        ];

        if (me.withVirtIO) {
            me.comboItems.push(['virtio', 'VirtIO Block']);
        }

        me.comboItems.push(['scsi', 'SCSI']);

        if (me.withUnused) {
            me.comboItems.push(['unused', 'Unused']);
        }

        me.callParent();
    },
});
Ext.define('PVE.data.CPUModel', {
    extend: 'Ext.data.Model',
    fields: [{ name: 'name' }, { name: 'vendor' }, { name: 'custom' }, { name: 'displayname' }],
});

Ext.define('PVE.form.CPUModelSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: ['widget.CPUModelSelector'],

    valueField: 'name',
    displayField: 'displayname',

    emptyText: Proxmox.Utils.defaultText + ' (kvm64)',
    allowBlank: true,

    editable: true,
    anyMatch: true,
    forceSelection: true,
    autoSelect: false,

    deleteEmpty: true,

    listConfig: {
        columns: [
            {
                header: gettext('Model'),
                dataIndex: 'displayname',
                hideable: false,
                sortable: true,
                flex: 3,
            },
            {
                header: gettext('Vendor'),
                dataIndex: 'vendor',
                hideable: false,
                sortable: true,
                flex: 2,
            },
        ],
        width: 360,
    },

    store: {
        autoLoad: true,
        model: 'PVE.data.CPUModel',
        proxy: {
            type: 'proxmox',
            url: '/api2/json/nodes/localhost/capabilities/qemu/cpu',
        },
        sorters: [
            {
                sorterFn: function (recordA, recordB) {
                    let a = recordA.data;
                    let b = recordB.data;

                    let vendorOrder = PVE.Utils.cpu_vendor_order;
                    let orderA = vendorOrder[a.vendor] || vendorOrder._default_;
                    let orderB = vendorOrder[b.vendor] || vendorOrder._default_;

                    if (orderA > orderB) {
                        return 1;
                    } else if (orderA < orderB) {
                        return -1;
                    }

                    // Within same vendor, sort alphabetically
                    return a.name.localeCompare(b.name);
                },
                direction: 'ASC',
            },
        ],
        listeners: {
            load: function (store, records, success) {
                if (success) {
                    records.forEach((rec) => {
                        rec.data.displayname = rec.data.name.replace(/^custom-/, '');

                        let vendor = rec.data.vendor;

                        if (rec.data.name === 'host') {
                            vendor = 'Host';
                        }

                        // We receive vendor names as given to QEMU as CPUID
                        vendor = PVE.Utils.cpu_vendor_map[vendor] || vendor;

                        if (rec.data.custom) {
                            vendor = gettext('Custom') + ` (${vendor})`;
                        }

                        rec.data.vendor = vendor;
                    });

                    store.sort();
                }
            },
        },
    },
});
Ext.define('PVE.form.CacheTypeSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.CacheTypeSelector'],
    comboItems: [
        ['__default__', Proxmox.Utils.defaultText + ' (' + gettext('No cache') + ')'],
        ['directsync', 'Direct sync'],
        ['writethrough', 'Write through'],
        ['writeback', 'Write back'],
        ['unsafe', 'Write back (' + gettext('unsafe') + ')'],
        ['none', gettext('No cache')],
    ],
});
Ext.define('PVE.form.CalendarEvent', {
    extend: 'Ext.form.field.ComboBox',
    xtype: 'pveCalendarEvent',

    editable: true,
    emptyText: gettext('Editable'), // FIXME: better way to convey that to confused users?

    valueField: 'value',
    queryMode: 'local',

    matchFieldWidth: false,
    listConfig: {
        maxWidth: 450,
    },

    store: {
        field: ['value', 'text'],
        data: [
            { value: '*/30', text: Ext.String.format(gettext('Every {0} minutes'), 30) },
            { value: '*/2:00', text: gettext('Every two hours') },
            { value: '21:00', text: gettext('Every day') + ' 21:00' },
            { value: '2,22:30', text: gettext('Every day') + ' 02:30, 22:30' },
            { value: 'mon..fri 00:00', text: gettext('Monday to Friday') + ' 00:00' },
            {
                value: 'mon..fri */1:00',
                text: gettext('Monday to Friday') + ': ' + gettext('hourly'),
            },
            {
                value: 'mon..fri 7..18:00/15',
                text:
                    gettext('Monday to Friday') +
                    ', ' +
                    Ext.String.format(gettext('{0} to {1}'), '07:00', '18:45') +
                    ': ' +
                    Ext.String.format(gettext('Every {0} minutes'), 15),
            },
            { value: 'sun 01:00', text: gettext('Sunday') + ' 01:00' },
            { value: 'monthly', text: gettext('Every first day of the Month') + ' 00:00' },
            { value: 'sat *-1..7 15:00', text: gettext('First Saturday each month') + ' 15:00' },
            { value: 'yearly', text: gettext('First day of the year') + ' 00:00' },
        ],
    },

    tpl: [
        '<ul class="x-list-plain"><tpl for=".">',
        '<li role="option" class="x-boundlist-item">{text}</li>',
        '</tpl></ul>',
    ],

    displayTpl: ['<tpl for=".">', '{value}', '</tpl>'],
});
Ext.define('PVE.form.CephPoolSelector', {
    extend: 'Ext.form.field.ComboBox',
    alias: 'widget.pveCephPoolSelector',

    allowBlank: false,
    valueField: 'pool_name',
    displayField: 'pool_name',
    listConfig: {
        itemTpl: '{pool_name:htmlEncode}',
    },
    editable: false,
    queryMode: 'local',

    initComponent: function () {
        var me = this;

        if (!me.nodename) {
            throw 'no nodename given';
        }

        let onlyRBDPools = ({ data }) =>
            !data?.application_metadata || !!data?.application_metadata?.rbd;

        var store = Ext.create('Ext.data.Store', {
            fields: ['name'],
            sorters: 'name',
            filters: [onlyRBDPools],
            proxy: {
                type: 'proxmox',
                url: '/api2/json/nodes/' + me.nodename + '/ceph/pool',
            },
        });

        Ext.apply(me, {
            store: store,
        });

        me.callParent();

        store.load({
            callback: function (rec, op, success) {
                let filteredRec = rec.filter(onlyRBDPools);

                if (success && filteredRec.length > 0) {
                    me.select(filteredRec[0]);
                }
            },
        });
    },
});
Ext.define('PVE.form.CephFSSelector', {
    extend: 'Ext.form.field.ComboBox',
    alias: 'widget.pveCephFSSelector',

    allowBlank: false,
    valueField: 'name',
    displayField: 'name',
    editable: false,
    queryMode: 'local',

    initComponent: function () {
        var me = this;

        if (!me.nodename) {
            throw 'no nodename given';
        }

        var store = Ext.create('Ext.data.Store', {
            fields: ['name'],
            sorters: 'name',
            proxy: {
                type: 'proxmox',
                url: '/api2/json/nodes/' + me.nodename + '/ceph/fs',
            },
        });

        Ext.apply(me, {
            store: store,
        });

        me.callParent();

        store.load({
            callback: function (rec, op, success) {
                if (success && rec.length > 0) {
                    me.select(rec[0]);
                }
            },
        });
    },
});
Ext.define('PVE.form.ComboBoxSetStoreNode', {
    extend: 'Proxmox.form.ComboGrid',
    config: {
        apiBaseUrl: '/api2/json/nodes/',
        apiSuffix: '',
    },

    showNodeSelector: false,

    setNodeName: function (value) {
        let me = this;
        value ||= Proxmox.NodeName;

        me.getStore().getProxy().setUrl(`${me.apiBaseUrl}${value}${me.apiSuffix}`);
        me.clearValue();
    },

    nodeChange: function (_field, value) {
        let me = this;
        // disable autoSelect if there is already a selection or we have the picker open
        if (me.getValue() || me.isExpanded) {
            let autoSelect = me.autoSelect;
            me.autoSelect = false;
            me.store.on(
                'afterload',
                function () {
                    me.autoSelect = autoSelect;
                },
                { single: true },
            );
        }
        me.setNodeName(value);
        me.fireEvent('nodechanged', value);
    },

    tbarMouseDown: function () {
        this.topBarMousePress = true;
    },

    tbarMouseUp: function () {
        let me = this;
        delete this.topBarMousePress;
        if (me.focusLeft) {
            me.focus();
            delete me.focusLeft;
        }
    },

    // conditionally prevent the focusLeave handler to continue, preventing collapsing of the picker
    onFocusLeave: function () {
        let me = this;
        me.focusLeft = true;
        if (!me.topBarMousePress) {
            me.callParent(arguments);
        }

        return undefined;
    },

    initComponent: function () {
        let me = this;

        if (me.showNodeSelector && !PVE.Utils.isStandaloneNode()) {
            me.errorHeight = 140;
            Ext.apply(me.listConfig ?? {}, {
                tbar: {
                    xtype: 'toolbar',
                    minHeight: 40,
                    listeners: {
                        mousedown: me.tbarMouseDown,
                        mouseup: me.tbarMouseUp,
                        element: 'el',
                        scope: me,
                    },
                    items: [
                        {
                            xtype: 'pveStorageScanNodeSelector',
                            autoSelect: false,
                            fieldLabel: gettext('Node to scan'),
                            listeners: {
                                change: (field, value) => me.nodeChange(field, value),
                            },
                        },
                    ],
                },
                emptyText: me.listConfig?.emptyText ?? gettext('Nothing found'),
            });
        }

        me.callParent();
    },
});
Ext.define('PVE.form.ContentTypeSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.pveContentTypeSelector'],

    cts: undefined,

    initComponent: function () {
        var me = this;

        me.comboItems = [];

        if (me.cts === undefined) {
            me.cts = ['images', 'iso', 'vztmpl', 'backup', 'rootdir', 'snippets', 'import'];
        }

        Ext.Array.each(me.cts, function (ct) {
            me.comboItems.push([ct, PVE.Utils.format_content_types(ct)]);
        });

        me.callParent();
    },
});
Ext.define('PVE.form.ControllerSelector', {
    extend: 'Ext.form.FieldContainer',
    alias: 'widget.pveControllerSelector',

    withVirtIO: true,
    withUnused: false,

    vmconfig: {}, // used to check for existing devices

    setToFree: function (controllers, busField, deviceIDField) {
        let me = this;
        let freeId = PVE.Utils.nextFreeDisk(controllers, me.vmconfig);

        if (freeId !== undefined) {
            busField?.setValue(freeId.controller);
            deviceIDField.setValue(freeId.id);
        }
    },

    updateVMConfig: function (vmconfig) {
        let me = this;
        me.vmconfig = Ext.apply({}, vmconfig);

        me.down('field[name=deviceid]').validate();
    },

    setVMConfig: function (vmconfig, autoSelect) {
        let me = this;

        me.vmconfig = Ext.apply({}, vmconfig);

        let bussel = me.down('field[name=controller]');
        let deviceid = me.down('field[name=deviceid]');

        let clist;
        if (autoSelect === 'cdrom') {
            if (!Ext.isDefined(me.vmconfig.ide2)) {
                bussel.setValue('ide');
                deviceid.setValue(2);
                return;
            }
            clist = ['ide', 'scsi', 'sata'];
        } else {
            // in most cases we want to add a disk to the same controller we previously used
            clist = PVE.Utils.sortByPreviousUsage(me.vmconfig);
        }

        me.setToFree(clist, bussel, deviceid);

        deviceid.validate();
    },

    getConfId: function () {
        let me = this;
        let controller = me.getComponent('controller').getValue() || 'ide';
        let id = me.getComponent('deviceid').getValue() || 0;

        return `${controller}${id}`;
    },

    initComponent: function () {
        let me = this;

        Ext.apply(me, {
            fieldLabel: gettext('Bus/Device'),
            layout: 'hbox',
            defaults: {
                hideLabel: true,
            },
            items: [
                {
                    xtype: 'pveBusSelector',
                    name: 'controller',
                    itemId: 'controller',
                    value: PVE.qemu.OSDefaults.generic.busType,
                    withVirtIO: me.withVirtIO,
                    withUnused: me.withUnused,
                    allowBlank: false,
                    flex: 2,
                    listeners: {
                        change: function (t, value) {
                            if (!value) {
                                return;
                            }
                            let field = me.down('field[name=deviceid]');
                            me.setToFree([value], undefined, field);
                            field.setMaxValue(PVE.Utils.diskControllerMaxIDs[value] - 1);
                            field.validate();
                        },
                    },
                },
                {
                    xtype: 'proxmoxintegerfield',
                    name: 'deviceid',
                    itemId: 'deviceid',
                    minValue: 0,
                    maxValue: PVE.Utils.diskControllerMaxIDs.ide - 1,
                    value: '0',
                    flex: 1,
                    allowBlank: false,
                    validator: function (value) {
                        if (!me.rendered) {
                            return undefined;
                        }
                        let controller = me.down('field[name=controller]').getValue();
                        let confid = controller + value;
                        if (Ext.isDefined(me.vmconfig[confid])) {
                            return 'This device is already in use.';
                        }
                        return true;
                    },
                },
            ],
        });

        me.callParent();

        if (me.selectFree) {
            me.setVMConfig(me.vmconfig);
        }
    },
});
Ext.define('PVE.form.DayOfWeekSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.pveDayOfWeekSelector'],
    comboItems: [],
    initComponent: function () {
        var me = this;
        me.comboItems = [
            ['mon', Ext.util.Format.htmlDecode(Ext.Date.dayNames[1])],
            ['tue', Ext.util.Format.htmlDecode(Ext.Date.dayNames[2])],
            ['wed', Ext.util.Format.htmlDecode(Ext.Date.dayNames[3])],
            ['thu', Ext.util.Format.htmlDecode(Ext.Date.dayNames[4])],
            ['fri', Ext.util.Format.htmlDecode(Ext.Date.dayNames[5])],
            ['sat', Ext.util.Format.htmlDecode(Ext.Date.dayNames[6])],
            ['sun', Ext.util.Format.htmlDecode(Ext.Date.dayNames[0])],
        ];
        this.callParent();
    },
});
Ext.define('PVE.form.DirMapSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: 'widget.pveDirMapSelector',

    store: {
        fields: ['name', 'path'],
        filterOnLoad: true,
        sorters: [
            {
                property: 'id',
                direction: 'ASC',
            },
        ],
    },

    allowBlank: false,
    autoSelect: false,
    displayField: 'id',
    valueField: 'id',

    listConfig: {
        columns: [
            {
                header: gettext('Directory ID'),
                dataIndex: 'id',
                flex: 1,
            },
            {
                header: gettext('Comment'),
                dataIndex: 'description',
                flex: 1,
            },
        ],
    },

    setNodename: function (nodename) {
        var me = this;

        if (!nodename || me.nodename === nodename) {
            return;
        }

        me.nodename = nodename;

        me.store.setProxy({
            type: 'proxmox',
            url: `/api2/json/cluster/mapping/dir?check-node=${nodename}`,
        });

        me.store.load();
    },

    initComponent: function () {
        var me = this;

        var nodename = me.nodename;
        me.nodename = undefined;

        me.callParent();

        me.setNodename(nodename);
    },
});
Ext.define('PVE.form.DiskFormatSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: 'widget.pveDiskFormatSelector',
    comboItems: [
        ['raw', gettext('Raw disk image') + ' (raw)'],
        ['qcow2', gettext('QEMU image format') + ' (qcow2)'],
        ['vmdk', gettext('VMware image format') + ' (vmdk)'],
    ],
});
Ext.define('PVE.form.DiskStorageSelector', {
    extend: 'Ext.container.Container',
    alias: 'widget.pveDiskStorageSelector',

    layout: 'fit',
    defaults: {
        margin: '0 0 5 0',
    },

    // the fieldLabel for the storageselector
    storageLabel: gettext('Storage'),

    // the content to show (e.g., images or rootdir)
    storageContent: undefined,

    // if true, selects the first available storage
    autoSelect: false,

    allowBlank: false,
    emptyText: '',

    // hides the selection field
    // this is always hidden on creation,
    // and only shown when the storage needs a selection and
    // hideSelection is not true
    hideSelection: undefined,

    // hides the size field (e.g, for the efi disk dialog)
    hideSize: false,

    // hides the format field (e.g. for TPM state)
    hideFormat: false,

    // sets the initial size value
    // string because else we get a type confusion
    defaultSize: '32',

    changeStorage: function (f, value) {
        var me = this;
        var formatsel = me.getComponent('diskformat');
        var hdfilesel = me.getComponent('hdimage');
        var hdsizesel = me.getComponent('disksize');

        // initial store load, and reset/deletion of the storage
        if (!value) {
            hdfilesel.setDisabled(true);
            hdfilesel.setVisible(false);

            formatsel.setDisabled(true);
            return;
        }

        var rec = f.store.getById(value);
        // if the storage is not defined, or valid,
        // we cannot know what to enable/disable
        if (!rec) {
            return;
        }

        let validFormats = {};
        let selectFormat = 'raw';
        if (rec.data.format) {
            validFormats = rec.data.format[0]; // 0 is the formats, 1 the default in the backend
            delete validFormats.subvol; // we never need subvol in the gui
            if (validFormats.qcow2) {
                selectFormat = 'qcow2';
            } else if (validFormats.raw) {
                selectFormat = 'raw';
            } else {
                selectFormat = rec.data.format[1];
            }
        }

        var select = !!rec.data.select_existing && !me.hideSelection;

        formatsel.setDisabled(me.hideFormat || Ext.Object.getSize(validFormats) <= 1);
        formatsel.setValue(selectFormat);

        hdfilesel.setDisabled(!select);
        hdfilesel.setVisible(select);
        if (select) {
            hdfilesel.setStorage(value);
        }

        hdsizesel.setDisabled(select || me.hideSize);
        hdsizesel.setVisible(!select && !me.hideSize);
    },

    setNodename: function (nodename) {
        var me = this;
        var hdstorage = me.getComponent('hdstorage');
        var hdfilesel = me.getComponent('hdimage');

        hdstorage.setNodename(nodename);
        hdfilesel.setNodename(nodename);
    },

    setDisabled: function (value) {
        var me = this;
        var hdstorage = me.getComponent('hdstorage');

        // reset on disable
        if (value) {
            hdstorage.setValue();
        }
        hdstorage.setDisabled(value);

        // disabling does not always fire this event and we do not need
        // the value of the validity
        hdstorage.fireEvent('validitychange');
    },

    initComponent: function () {
        var me = this;

        me.items = [
            {
                xtype: 'pveStorageSelector',
                itemId: 'hdstorage',
                name: 'hdstorage',
                fieldLabel: me.storageLabel,
                nodename: me.nodename,
                storageContent: me.storageContent,
                disabled: me.disabled,
                autoSelect: me.autoSelect,
                allowBlank: me.allowBlank,
                emptyText: me.emptyText,
                listeners: {
                    change: {
                        fn: me.changeStorage,
                        scope: me,
                    },
                },
            },
            {
                xtype: 'pveFileSelector',
                name: 'hdimage',
                itemId: 'hdimage',
                fieldLabel: gettext('Disk image'),
                nodename: me.nodename,
                disabled: true,
                hidden: true,
            },
            {
                xtype: 'numberfield',
                itemId: 'disksize',
                name: 'disksize',
                fieldLabel: `${gettext('Disk size')} (${gettext('GiB')})`,
                hidden: me.hideSize,
                disabled: me.hideSize,
                minValue: 0.001,
                maxValue: 128 * 1024,
                decimalPrecision: 3,
                value: me.defaultSize,
                allowBlank: false,
            },
            {
                xtype: 'pveDiskFormatSelector',
                itemId: 'diskformat',
                name: 'diskformat',
                fieldLabel: gettext('Format'),
                nodename: me.nodename,
                disabled: true,
                hidden: me.hideFormat || me.storageContent === 'rootdir',
                value: 'qcow2',
                allowBlank: false,
            },
        ];

        // use it to disable the children but not ourself
        me.disabled = false;

        me.callParent();
    },
});
Ext.define('PVE.form.FileSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: 'widget.pveFileSelector',

    editable: true,
    anyMatch: true,
    forceSelection: true,

    listeners: {
        afterrender: function () {
            var me = this;
            if (!me.disabled) {
                me.setStorage(me.storage, me.nodename);
            }
        },
    },

    setStorage: function (storage, nodename) {
        var me = this;

        var change = false;
        if (storage && me.storage !== storage) {
            me.storage = storage;
            change = true;
        }

        if (nodename && me.nodename !== nodename) {
            me.nodename = nodename;
            change = true;
        }

        if (!(me.storage && me.nodename && change)) {
            return;
        }

        var url = '/api2/json/nodes/' + me.nodename + '/storage/' + me.storage + '/content';
        if (me.storageContent) {
            url += '?content=' + me.storageContent;
        }

        me.store.setProxy({
            type: 'proxmox',
            url: url,
        });

        if (Ext.isFunction(me.filter)) {
            me.store.clearFilter();
            me.store.addFilter([me.filter]);
        } else {
            me.store.clearFilter();
        }

        me.store.removeAll();
        me.store.load();
    },

    setNodename: function (nodename) {
        this.setStorage(undefined, nodename);
    },

    store: {
        model: 'pve-storage-content',
    },

    allowBlank: false,
    autoSelect: false,
    valueField: 'volid',
    displayField: 'text',

    // An optional filter function
    filter: undefined,

    listConfig: {
        width: 600,
        columns: [
            {
                header: gettext('Name'),
                dataIndex: 'text',
                hideable: false,
                flex: 1,
            },
            {
                header: gettext('Format'),
                width: 60,
                dataIndex: 'format',
            },
            {
                header: gettext('Size'),
                width: 100,
                dataIndex: 'size',
                renderer: Proxmox.Utils.format_size,
            },
        ],
    },
});
Ext.define('PVE.form.FirewallPolicySelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.pveFirewallPolicySelector'],
    comboItems: [
        ['ACCEPT', 'ACCEPT'],
        ['REJECT', 'REJECT'],
        ['DROP', 'DROP'],
    ],
});
/*
 *  This is a global search field it loads the /cluster/resources on focus and displays the
 *  result in a floating grid. Filtering and sorting is done in the customFilter function
 *
 *  Accepts key up/down and enter for input, and it opens to CTRL+SHIFT+F and CTRL+SPACE
 */
Ext.define('PVE.form.GlobalSearchField', {
    extend: 'Ext.form.field.Text',
    alias: 'widget.pveGlobalSearchField',

    emptyText: gettext('Search'),
    enableKeyEvents: true,
    selectOnFocus: true,
    padding: '0 5 0 5',

    grid: {
        xtype: 'gridpanel',
        userCls: 'proxmox-tags-full',
        focusOnToFront: false,
        floating: true,
        emptyText: Proxmox.Utils.noneText,
        width: 600,
        height: 400,
        scrollable: {
            xtype: 'scroller',
            y: true,
            x: true,
        },
        store: {
            model: 'PVEResources',
            proxy: {
                type: 'proxmox',
                url: '/api2/extjs/cluster/resources',
            },
        },
        plugins: {
            ptype: 'bufferedrenderer',
            trailingBufferZone: 20,
            leadingBufferZone: 20,
        },

        hideMe: function () {
            var me = this;
            if (typeof me.ctxMenu !== 'undefined' && me.ctxMenu.isVisible()) {
                return;
            }
            me.hasFocus = false;
            if (!me.textfield.hasFocus) {
                me.hide();
            }
        },

        setFocus: function () {
            var me = this;
            me.hasFocus = true;
        },

        listeners: {
            rowclick: function (grid, record) {
                var me = this;
                me.textfield.selectAndHide(record.id);
            },
            itemcontextmenu: function (v, record, item, index, event) {
                var me = this;
                me.ctxMenu = PVE.Utils.createCmdMenu(v, record, item, index, event);
            },
            focusleave: 'hideMe',
            focusenter: 'setFocus',
        },

        columns: [
            {
                text: gettext('Type'),
                dataIndex: 'type',
                width: 100,
                renderer: PVE.Utils.render_resource_type,
            },
            {
                text: gettext('Description'),
                flex: 1,
                dataIndex: 'text',
                renderer: function (value, mD, rec) {
                    let overrides = PVE.UIOptions.tagOverrides;
                    let tags = PVE.Utils.renderTags(rec.data.tags, overrides);
                    return `${value}${tags}`;
                },
            },
            {
                text: gettext('Node'),
                dataIndex: 'node',
            },
            {
                text: gettext('Pool'),
                dataIndex: 'pool',
            },
        ],
    },

    customFilter: function (item) {
        let me = this;

        if (me.filterVal === '') {
            item.data.relevance = 0;
            return true;
        }
        // different types have different fields to search, e.g., a node will never have a pool
        const fieldMap = {
            pool: ['type', 'pool', 'text'],
            node: ['type', 'node', 'text'],
            storage: ['type', 'pool', 'node', 'storage'],
            default: ['name', 'type', 'node', 'pool', 'vmid'],
        };
        let fields = fieldMap[item.data.type] || fieldMap.default;
        let fieldArr = fields.map((field) => item.data[field]?.toString().toLowerCase());
        if (item.data.tags) {
            let tags = item.data.tags.split(/[;, ]/);
            fieldArr.push(...tags);
        }

        let filterWords = me.filterVal.split(/\s+/);

        // all text is case insensitive and each split-out word is searched for separately.
        // a row gets 1 point for every partial match, and and additional point for every exact match
        let match = 0;
        for (let fieldValue of fieldArr) {
            if (fieldValue === undefined || fieldValue === '') {
                continue;
            }
            for (let filterWord of filterWords) {
                if (fieldValue.indexOf(filterWord) !== -1) {
                    match++; // partial match
                    if (fieldValue === filterWord) {
                        match++; // exact match is worth more
                    }
                }
            }
        }
        item.data.relevance = match; // set the row's virtual 'relevance' value for ordering
        return match > 0;
    },

    updateFilter: function (field, newValue, oldValue) {
        let me = this;
        // parse input and filter store, show grid
        me.grid.store.filterVal = newValue.toLowerCase().trim();
        me.grid.store.clearFilter(true);
        me.grid.store.filterBy(me.customFilter);
        me.grid.getSelectionModel().select(0);
    },

    selectAndHide: function (id) {
        var me = this;
        me.tree.selectById(id);
        me.grid.hide();
        me.setValue('');
        me.blur();
    },

    onKey: function (field, e) {
        var me = this;
        var key = e.getKey();

        switch (key) {
            case Ext.event.Event.ENTER:
                // go to first entry if there is one
                if (me.grid.store.getCount() > 0) {
                    me.selectAndHide(me.grid.getSelection()[0].data.id);
                }
                break;
            case Ext.event.Event.UP:
                me.grid.getSelectionModel().selectPrevious();
                break;
            case Ext.event.Event.DOWN:
                me.grid.getSelectionModel().selectNext();
                break;
            case Ext.event.Event.ESC:
                me.grid.hide();
                me.blur();
                break;
        }
    },

    loadValues: function (field) {
        let me = this;
        me.hasFocus = true;
        me.grid.textfield = me;
        me.grid.store.load();
        me.grid.showBy(me, 'tl-bl');
    },

    hideGrid: function () {
        let me = this;
        me.hasFocus = false;
        if (!me.grid.hasFocus) {
            me.grid.hide();
        }
    },

    listeners: {
        change: {
            fn: 'updateFilter',
            buffer: 250,
        },
        specialkey: 'onKey',
        focusenter: 'loadValues',
        focusleave: {
            fn: 'hideGrid',
            delay: 100,
        },
    },

    toggleFocus: function () {
        let me = this;
        if (!me.hasFocus) {
            me.focus();
        } else {
            me.blur();
        }
    },

    initComponent: function () {
        let me = this;

        if (!me.tree) {
            throw 'no tree given';
        }

        me.grid = Ext.create(me.grid);

        me.callParent();

        // bind CTRL + SHIFT + F and CTRL + SPACE to open/close the search
        me.keymap = new Ext.KeyMap({
            target: Ext.get(document),
            binding: [
                {
                    key: 'F',
                    ctrl: true,
                    shift: true,
                    fn: me.toggleFocus,
                    scope: me,
                },
                {
                    key: ' ',
                    ctrl: true,
                    fn: me.toggleFocus,
                    scope: me,
                },
            ],
        });

        // always select first item and sort by relevance after load
        me.mon(me.grid.store, 'load', function () {
            me.grid.getSelectionModel().select(0);
            me.grid.store.sort({
                property: 'relevance',
                direction: 'DESC',
            });
        });
    },
});
Ext.define('pve-groups', {
    extend: 'Ext.data.Model',
    fields: ['groupid', 'comment', 'users'],
    proxy: {
        type: 'proxmox',
        url: '/api2/json/access/groups',
    },
    idProperty: 'groupid',
});

Ext.define('PVE.form.GroupSelector', {
    extend: 'Proxmox.form.ComboGrid',
    xtype: 'pveGroupSelector',

    editable: true,
    anyMatch: true,
    forceSelection: true,

    allowBlank: false,
    autoSelect: false,
    valueField: 'groupid',
    displayField: 'groupid',
    listConfig: {
        columns: [
            {
                header: gettext('Group'),
                sortable: true,
                dataIndex: 'groupid',
                flex: 1,
            },
            {
                header: gettext('Comment'),
                sortable: false,
                dataIndex: 'comment',
                renderer: Ext.String.htmlEncode,
                flex: 1,
            },
            {
                header: gettext('Users'),
                sortable: false,
                dataIndex: 'users',
                renderer: Ext.String.htmlEncode,
                flex: 1,
            },
        ],
    },

    initComponent: function () {
        var me = this;

        var store = new Ext.data.Store({
            model: 'pve-groups',
            sorters: [
                {
                    property: 'groupid',
                },
            ],
        });

        Ext.apply(me, {
            store: store,
        });

        me.callParent();

        store.load();
    },
});
Ext.define('PVE.form.GuestIDSelector', {
    extend: 'Ext.form.field.Number',
    alias: 'widget.pveGuestIDSelector',

    allowBlank: false,

    minValue: 100,

    maxValue: 999999999,

    validateExists: undefined,

    loadNextFreeID: false,

    guestType: undefined,

    validator: function (value) {
        var me = this;

        if (!Ext.isNumeric(value) || value < me.minValue || value > me.maxValue) {
            // check is done by ExtJS
            return true;
        }

        if (me.validateExists === true && !me.exists) {
            return me.unknownID;
        }

        if (me.validateExists === false && me.exists) {
            return me.inUseID;
        }

        return true;
    },

    initComponent: function () {
        var me = this;
        var label = '{0} ID';
        var unknownID = gettext('This {0} ID does not exist');
        var inUseID = gettext('This {0} ID is already in use');
        var type = 'CT/VM';

        if (me.guestType === 'lxc') {
            type = 'CT';
        } else if (me.guestType === 'qemu') {
            type = 'VM';
        }

        me.label = Ext.String.format(label, type);
        me.unknownID = Ext.String.format(unknownID, type);
        me.inUseID = Ext.String.format(inUseID, type);

        Ext.apply(me, {
            fieldLabel: me.label,
            listeners: {
                change: function (field, newValue, oldValue) {
                    if (!Ext.isDefined(me.validateExists)) {
                        return;
                    }
                    Proxmox.Utils.API2Request({
                        params: { vmid: newValue },
                        url: '/cluster/nextid',
                        method: 'GET',
                        success: function (response, opts) {
                            me.exists = false;
                            me.validate();
                        },
                        failure: function (response, opts) {
                            me.exists = true;
                            me.validate();
                        },
                    });
                },
            },
        });

        me.callParent();

        if (me.loadNextFreeID) {
            Proxmox.Utils.API2Request({
                url: '/cluster/nextid',
                method: 'GET',
                success: function (response, opts) {
                    me.setRawValue(response.result.data);
                },
            });
        }
    },
});
Ext.define('PVE.form.hashAlgorithmSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.pveHashAlgorithmSelector'],
    config: {
        deleteEmpty: false,
    },
    comboItems: [
        ['__default__', 'None'],
        ['md5', 'MD5'],
        ['sha1', 'SHA-1'],
        ['sha224', 'SHA-224'],
        ['sha256', 'SHA-256'],
        ['sha384', 'SHA-384'],
        ['sha512', 'SHA-512'],
    ],
});
Ext.define('PVE.form.HotplugFeatureSelector', {
    extend: 'Ext.form.CheckboxGroup',
    alias: 'widget.pveHotplugFeatureSelector',

    columns: 1,
    vertical: true,

    defaults: {
        name: 'hotplugCbGroup',
        submitValue: false,
    },
    items: [
        {
            boxLabel: gettext('Disk'),
            inputValue: 'disk',
            checked: true,
        },
        {
            boxLabel: gettext('Network'),
            inputValue: 'network',
            checked: true,
        },
        {
            boxLabel: 'USB',
            inputValue: 'usb',
            checked: true,
        },
        {
            boxLabel: gettext('Memory'),
            inputValue: 'memory',
        },
        {
            boxLabel: gettext('CPU'),
            inputValue: 'cpu',
        },
    ],

    setValue: function (value) {
        var me = this;
        var newVal = [];
        if (value === '1') {
            newVal = ['disk', 'network', 'usb'];
        } else if (value !== '0') {
            newVal = value.split(',');
        }
        me.callParent([{ hotplugCbGroup: newVal }]);
    },

    // override framework function to
    // assemble the hotplug value
    getSubmitData: function () {
        var me = this,
            boxes = me.getBoxes(),
            data = [];
        Ext.Array.forEach(boxes, function (box) {
            if (box.getValue()) {
                data.push(box.inputValue);
            }
        });

        /* because above is hotplug an array */
        if (data.length === 0) {
            return { hotplug: '0' };
        } else {
            return { hotplug: data.join(',') };
        }
    },
});
Ext.define('PVE.form.IPProtocolSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: ['widget.pveIPProtocolSelector'],
    valueField: 'p',
    displayField: 'p',
    listConfig: {
        columns: [
            {
                header: gettext('Protocol'),
                dataIndex: 'p',
                hideable: false,
                sortable: false,
                width: 100,
            },
            {
                header: gettext('Number'),
                dataIndex: 'n',
                hideable: false,
                sortable: false,
                width: 50,
            },
            {
                header: gettext('Description'),
                dataIndex: 'd',
                hideable: false,
                sortable: false,
                flex: 1,
            },
        ],
    },
    store: {
        fields: ['p', 'd', 'n'],
        data: [
            { p: 'tcp', n: 6, d: 'Transmission Control Protocol' },
            { p: 'udp', n: 17, d: 'User Datagram Protocol' },
            { p: 'icmp', n: 1, d: 'Internet Control Message Protocol' },
            { p: 'igmp', n: 2, d: 'Internet Group Management' },
            { p: 'ggp', n: 3, d: 'gateway-gateway protocol' },
            { p: 'ipencap', n: 4, d: 'IP encapsulated in IP' },
            { p: 'st', n: 5, d: 'ST datagram mode' },
            { p: 'egp', n: 8, d: 'exterior gateway protocol' },
            { p: 'igp', n: 9, d: 'any private interior gateway (Cisco)' },
            { p: 'pup', n: 12, d: 'PARC universal packet protocol' },
            { p: 'hmp', n: 20, d: 'host monitoring protocol' },
            { p: 'xns-idp', n: 22, d: 'Xerox NS IDP' },
            { p: 'rdp', n: 27, d: '"reliable datagram" protocol' },
            { p: 'iso-tp4', n: 29, d: 'ISO Transport Protocol class 4 [RFC905]' },
            { p: 'dccp', n: 33, d: 'Datagram Congestion Control Prot. [RFC4340]' },
            { p: 'xtp', n: 36, d: 'Xpress Transfer Protocol' },
            { p: 'ddp', n: 37, d: 'Datagram Delivery Protocol' },
            { p: 'idpr-cmtp', n: 38, d: 'IDPR Control Message Transport' },
            { p: 'ipv6', n: 41, d: 'Internet Protocol, version 6' },
            { p: 'ipv6-route', n: 43, d: 'Routing Header for IPv6' },
            { p: 'ipv6-frag', n: 44, d: 'Fragment Header for IPv6' },
            { p: 'idrp', n: 45, d: 'Inter-Domain Routing Protocol' },
            { p: 'rsvp', n: 46, d: 'Reservation Protocol' },
            { p: 'gre', n: 47, d: 'General Routing Encapsulation' },
            { p: 'esp', n: 50, d: 'Encap Security Payload [RFC2406]' },
            { p: 'ah', n: 51, d: 'Authentication Header [RFC2402]' },
            { p: 'skip', n: 57, d: 'SKIP' },
            { p: 'ipv6-icmp', n: 58, d: 'ICMP for IPv6' },
            { p: 'ipv6-nonxt', n: 59, d: 'No Next Header for IPv6' },
            { p: 'ipv6-opts', n: 60, d: 'Destination Options for IPv6' },
            { p: 'vmtp', n: 81, d: 'Versatile Message Transport' },
            { p: 'eigrp', n: 88, d: 'Enhanced Interior Routing Protocol (Cisco)' },
            { p: 'ospf', n: 89, d: 'Open Shortest Path First IGP' },
            { p: 'ax.25', n: 93, d: 'AX.25 frames' },
            { p: 'ipip', n: 94, d: 'IP-within-IP Encapsulation Protocol' },
            { p: 'etherip', n: 97, d: 'Ethernet-within-IP Encapsulation [RFC3378]' },
            { p: 'encap', n: 98, d: 'Yet Another IP encapsulation [RFC1241]' },
            { p: 'pim', n: 103, d: 'Protocol Independent Multicast' },
            { p: 'ipcomp', n: 108, d: 'IP Payload Compression Protocol' },
            { p: 'vrrp', n: 112, d: 'Virtual Router Redundancy Protocol [RFC5798]' },
            { p: 'l2tp', n: 115, d: 'Layer Two Tunneling Protocol [RFC2661]' },
            { p: 'isis', n: 124, d: 'IS-IS over IPv4' },
            { p: 'sctp', n: 132, d: 'Stream Control Transmission Protocol' },
            { p: 'fc', n: 133, d: 'Fibre Channel' },
            { p: 'mobility-header', n: 135, d: 'Mobility Support for IPv6 [RFC3775]' },
            { p: 'udplite', n: 136, d: 'UDP-Lite [RFC3828]' },
            { p: 'mpls-in-ip', n: 137, d: 'MPLS-in-IP [RFC4023]' },
            { p: 'hip', n: 139, d: 'Host Identity Protocol' },
            { p: 'shim6', n: 140, d: 'Shim6 Protocol [RFC5533]' },
            { p: 'wesp', n: 141, d: 'Wrapped Encapsulating Security Payload' },
            { p: 'rohc', n: 142, d: 'Robust Header Compression' },
        ],
    },
});
Ext.define('PVE.form.IPRefSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: ['widget.pveIPRefSelector'],

    base_url: undefined,

    preferredValue: '', // hack: else Form sets dirty flag?

    ref_type: undefined, // undefined = any [undefined, 'ipset' or 'alias']

    valueField: 'scopedref',
    displayField: 'ref',
    notFoundIsValid: true,

    initComponent: function () {
        var me = this;

        if (!me.base_url) {
            throw 'no base_url specified';
        }

        var url = '/api2/json' + me.base_url;
        if (me.ref_type) {
            url += '?type=' + me.ref_type;
        }

        var store = Ext.create('Ext.data.Store', {
            autoLoad: true,
            fields: [
                'type',
                'name',
                'ref',
                'comment',
                'scope',
                {
                    name: 'scopedref',
                    calculate: function (v) {
                        if (v.type === 'alias') {
                            return `${v.scope}/${v.name}`;
                        } else if (v.type === 'ipset') {
                            return `+${v.scope}/${v.name}`;
                        } else {
                            return v.ref;
                        }
                    },
                },
            ],
            idProperty: 'ref',
            proxy: {
                type: 'proxmox',
                url: url,
            },
            sorters: {
                property: 'ref',
                direction: 'ASC',
            },
        });

        var columns = [];

        if (!me.ref_type) {
            columns.push({
                header: gettext('Type'),
                dataIndex: 'type',
                hideable: false,
                width: 60,
            });
        }

        let scopes = {
            dc: gettext('Datacenter'),
            guest: gettext('Guest'),
            sdn: gettext('SDN'),
        };

        columns.push(
            {
                header: gettext('Name'),
                dataIndex: 'ref',
                hideable: false,
                width: 140,
            },
            {
                header: gettext('Scope'),
                dataIndex: 'scope',
                hideable: false,
                width: 140,
                renderer: function (value) {
                    return scopes[value] ?? 'unknown scope';
                },
            },
            {
                header: gettext('Comment'),
                dataIndex: 'comment',
                renderer: Ext.String.htmlEncode,
                minWidth: 60,
                flex: 1,
            },
        );

        Ext.apply(me, {
            store: store,
            listConfig: {
                columns: columns,
                width: 500,
            },
        });

        me.on('beforequery', function (queryPlan) {
            return !(queryPlan.query === null || queryPlan.query.match(/^\d/));
        });

        me.callParent();
    },
});
Ext.define('PVE.form.MDevSelector', {
    extend: 'Proxmox.form.ComboGrid',
    xtype: 'pveMDevSelector',

    store: {
        fields: ['type', 'available', 'description'],
        filterOnLoad: true,
        sorters: [
            {
                property: 'type',
                direction: 'ASC',
            },
        ],
    },
    autoSelect: false,
    valueField: 'type',
    displayField: 'type',
    listConfig: {
        width: 550,
        columns: [
            {
                header: gettext('Type'),
                dataIndex: 'type',
                renderer: function (value, md, rec) {
                    if (rec.data.name !== undefined) {
                        return `${rec.data.name} (${value})`;
                    }
                    return value;
                },
                flex: 1,
            },
            {
                header: gettext('Avail'),
                dataIndex: 'available',
                width: 60,
            },
            {
                header: gettext('Description'),
                dataIndex: 'description',
                flex: 1,
                cellWrap: true,
                renderer: function (value) {
                    if (!value) {
                        return '';
                    }

                    return value.split('\n').join('<br>');
                },
            },
        ],
    },

    setPciIdOrMapping: function (pciIdOrMapping, force) {
        var me = this;

        if (!force && (!pciIdOrMapping || me.pciIdOrMapping === pciIdOrMapping)) {
            return;
        }

        me.pciIdOrMapping = pciIdOrMapping;
        me.updateProxy();
    },

    setNodename: function (nodename) {
        var me = this;

        if (!nodename || me.nodename === nodename) {
            return;
        }

        me.nodename = nodename;
        me.updateProxy();
    },

    updateProxy: function () {
        var me = this;
        me.store.setProxy({
            type: 'proxmox',
            url: `/api2/json/nodes/${me.nodename}/hardware/pci/${me.pciIdOrMapping}/mdev`,
        });
        me.store.load();
    },

    initComponent: function () {
        var me = this;

        if (!me.nodename) {
            throw 'no node name specified';
        }

        me.callParent();

        if (me.pciIdOrMapping) {
            me.setPciIdOrMapping(me.pciIdOrMapping, true);
        }
    },
});
Ext.define('PVE.form.MemoryField', {
    extend: 'Ext.form.field.Number',
    alias: 'widget.pveMemoryField',

    allowBlank: false,

    hotplug: false,

    minValue: 32,

    maxValue: 4178944,

    step: 32,

    value: '512', // qm backend default

    allowDecimals: false,

    allowExponential: false,

    computeUpDown: function (value) {
        var me = this;

        if (!me.hotplug) {
            return { up: value + me.step, down: value - me.step };
        }

        var dimm_size = 512;
        var prev_dimm_size = 0;
        var min_size = 1024;
        var current_size = min_size;
        var value_up = min_size;
        var value_down = min_size;
        var value_start = min_size;

        var i, j;
        for (j = 0; j < 9; j++) {
            for (i = 0; i < 32; i++) {
                if (value >= current_size && value < current_size + dimm_size) {
                    value_start = current_size;
                    value_up = current_size + dimm_size;
                    value_down = current_size - (i === 0 ? prev_dimm_size : dimm_size);
                }
                current_size += dimm_size;
            }
            prev_dimm_size = dimm_size;
            dimm_size = dimm_size * 2;
        }

        return { up: value_up, down: value_down, start: value_start };
    },

    onSpinUp: function () {
        var me = this;
        if (!me.readOnly) {
            let res = me.computeUpDown(me.getValue());
            me.setValue(Ext.Number.constrain(res.up, me.minValue, me.maxValue));
        }
    },

    onSpinDown: function () {
        var me = this;
        if (!me.readOnly) {
            let res = me.computeUpDown(me.getValue());
            me.setValue(Ext.Number.constrain(res.down, me.minValue, me.maxValue));
        }
    },

    initComponent: function () {
        var me = this;

        if (me.hotplug) {
            me.minValue = 1024;

            me.on('blur', function (field) {
                var value = me.getValue();
                var res = me.computeUpDown(value);
                if (value === res.start || value === res.up || value === res.down) {
                    return;
                }
                field.setValue(res.up);
            });
        }

        me.callParent();
    },
});
Ext.define('PVE.form.MultiPCISelector', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.pveMultiPCISelector',

    emptyText: gettext('No Devices found'),

    mixins: {
        field: 'Ext.form.field.Field',
    },

    // will be called after loading finished
    onLoadCallBack: Ext.emptyFn,

    getValue: function () {
        let me = this;
        return me.value ?? [];
    },

    getSubmitData: function () {
        let me = this;
        let res = {};
        res[me.name] = me.getValue();
        return res;
    },

    setValue: function (value) {
        let me = this;

        value ??= [];

        me.updateSelectedDevices(value);

        return me.mixins.field.setValue.call(me, value);
    },

    getErrors: function () {
        let me = this;

        let errorCls = ['x-form-trigger-wrap-default', 'x-form-trigger-wrap-invalid'];

        if (me.getValue().length < 1) {
            let error = gettext('Must choose at least one device');
            me.addCls(errorCls);
            me.getActionEl()?.dom.setAttribute('data-errorqtip', error);

            return [error];
        }

        me.removeCls(errorCls);
        me.getActionEl()?.dom.setAttribute('data-errorqtip', '');

        return [];
    },

    viewConfig: {
        getRowClass: function (record) {
            if (record.data.disabled === true) {
                return 'x-item-disabled';
            }
            return '';
        },
    },

    updateSelectedDevices: function (value = []) {
        let me = this;

        let recs = [];
        let store = me.getStore();

        for (const map of value) {
            let parsed = PVE.Parser.parsePropertyString(map);
            if (parsed.node !== me.nodename) {
                continue;
            }

            let rec = store.getById(parsed.path);
            if (rec) {
                recs.push(rec);
            }
        }

        me.suspendEvent('change');
        me.setSelection();
        me.setSelection(recs);
        me.resumeEvent('change');
    },

    setNodename: function (nodename) {
        let me = this;

        if (!nodename || me.nodename === nodename) {
            return;
        }

        me.nodename = nodename;

        me.getStore().setProxy({
            type: 'proxmox',
            url: '/api2/json/nodes/' + me.nodename + '/hardware/pci?pci-class-blacklist=',
        });

        me.setSelection();

        me.getStore().load({
            callback: (recs, op, success) => me.addSlotRecords(recs, op, success),
        });
    },

    setMdev: function (mdev) {
        let me = this;
        if (mdev) {
            me.getStore().addFilter({
                id: 'mdev-filter',
                property: 'mdev',
                value: '1',
                operator: '=',
            });
        } else {
            me.getStore().removeFilter('mdev-filter');
        }
        me.setSelection();
    },

    // adds the virtual 'slot' records (e.g. '0000:01:00') to the store
    addSlotRecords: function (records, _op, success) {
        let me = this;
        if (!success) {
            return;
        }

        let slots = {};
        records.forEach((rec) => {
            let slotname = rec.data.id.slice(0, -2); // remove function
            if (slots[slotname] !== undefined) {
                slots[slotname].count++;
                rec.set('slot', slots[slotname]);
                return;
            }
            slots[slotname] = {
                count: 1,
            };

            rec.set('slot', slots[slotname]);

            if (rec.data.id.endsWith('.0')) {
                slots[slotname].device = rec.data;
            }
        });

        let store = me.getStore();

        for (const [slot, { count, device }] of Object.entries(slots)) {
            if (count === 1) {
                continue;
            }
            store.add(
                Ext.apply(
                    {},
                    {
                        id: slot,
                        mdev: undefined,
                        device_name: gettext('Pass through all functions as one device'),
                    },
                    device,
                ),
            );
        }

        me.updateSelectedDevices(me.value);
    },

    selectionChange: function (_grid, selection) {
        let me = this;

        let ids = {};
        selection
            .filter((rec) => rec.data.id.indexOf('.') === -1)
            .forEach((rec) => {
                ids[rec.data.id] = true;
            });

        let to_disable = [];

        me.getStore().each((rec) => {
            let id = rec.data.id;
            rec.set('disabled', false);
            if (id.indexOf('.') === -1) {
                return;
            }
            let slot = id.slice(0, -2); // remove function

            if (ids[slot]) {
                to_disable.push(rec);
                rec.set('disabled', true);
            }
        });

        me.suspendEvent('selectionchange');
        me.getSelectionModel().deselect(to_disable);
        me.resumeEvent('selectionchange');

        me.value = me.getSelection().map((rec) => {
            let res = {
                path: rec.data.id,
                node: me.nodename,
                id: `${rec.data.vendor}:${rec.data.device}`.replace(/0x/g, ''),
                'subsystem-id': `${rec.data.subsystem_vendor}:${rec.data.subsystem_device}`.replace(
                    /0x/g,
                    '',
                ),
            };

            if (rec.data.iommugroup !== -1) {
                res.iommugroup = rec.data.iommugroup;
            }

            return PVE.Parser.printPropertyString(res);
        });
        me.checkChange();
    },

    selModel: {
        type: 'checkboxmodel',
        mode: 'SIMPLE',
    },

    columns: [
        {
            header: 'ID',
            dataIndex: 'id',
            renderer: function (value, _md, rec) {
                if (value.match(/\.[0-9a-f]/i) && rec.data.slot?.count > 1) {
                    return `&emsp;${value}`;
                }
                return value;
            },
            width: 150,
        },
        {
            header: gettext('IOMMU Group'),
            dataIndex: 'iommugroup',
            renderer: (v, _md, rec) => (rec.data.slot === rec.data.id ? '' : v === -1 ? '-' : v),
            width: 50,
        },
        {
            header: gettext('Vendor'),
            dataIndex: 'vendor_name',
            flex: 3,
        },
        {
            header: gettext('Device'),
            dataIndex: 'device_name',
            flex: 6,
        },
        {
            header: gettext('Mediated Devices'),
            dataIndex: 'mdev',
            flex: 1,
            renderer: function (val) {
                return Proxmox.Utils.format_boolean(!!val);
            },
        },
    ],

    listeners: {
        selectionchange: function () {
            this.selectionChange(...arguments);
        },
    },

    store: {
        fields: [
            'id',
            'vendor_name',
            'device_name',
            'vendor',
            'device',
            'iommugroup',
            'mdev',
            'subsystem_vendor',
            'subsystem_device',
            'disabled',
            {
                name: 'subsystem-vendor',
                calculate: function (data) {
                    return data.subsystem_vendor;
                },
            },
            {
                name: 'subsystem-device',
                calculate: function (data) {
                    return data.subsystem_device;
                },
            },
        ],
        sorters: [
            {
                property: 'id',
                direction: 'ASC',
            },
        ],
    },

    initComponent: function () {
        let me = this;

        let nodename = me.nodename;
        me.nodename = undefined;

        me.callParent();

        me.mon(me.getStore(), 'load', me.onLoadCallBack);

        Proxmox.Utils.monStoreErrors(me, me.getStore(), true);

        me.setNodename(nodename);

        me.initField();
    },
});
Ext.define('PVE.form.NetworkCardSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: 'widget.pveNetworkCardSelector',
    comboItems: [
        ['e1000', 'Intel E1000'],
        ['e1000e', 'Intel E1000E'],
        ['virtio', 'VirtIO (' + gettext('paravirtualized') + ')'],
        ['rtl8139', 'Realtek RTL8139'],
        ['vmxnet3', 'VMware vmxnet3'],
    ],
});
Ext.define('PVE.form.NodeSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: ['widget.pveNodeSelector'],

    // invalidate nodes which are offline
    onlineValidator: false,

    selectCurNode: false,

    // do not allow those nodes (array)
    disallowedNodes: undefined,

    // only allow those nodes (array)
    allowedNodes: undefined,

    valueField: 'node',
    displayField: 'node',
    store: {
        fields: ['node', 'cpu', 'maxcpu', 'mem', 'maxmem', 'uptime'],
        proxy: {
            type: 'proxmox',
            url: '/api2/json/nodes',
        },
        sorters: [
            {
                property: 'node',
                direction: 'ASC',
            },
            {
                property: 'mem',
                direction: 'DESC',
            },
        ],
    },

    listConfig: {
        columns: [
            {
                header: gettext('Node'),
                dataIndex: 'node',
                sortable: true,
                hideable: false,
                flex: 1,
            },
            {
                header: gettext('Memory usage') + ' %',
                renderer: PVE.Utils.render_mem_usage_percent,
                sortable: true,
                width: 100,
                dataIndex: 'mem',
            },
            {
                header: gettext('CPU usage'),
                renderer: Proxmox.Utils.render_cpu,
                sortable: true,
                width: 100,
                dataIndex: 'cpu',
            },
        ],
    },

    validator: function (value) {
        let me = this;
        if (!me.onlineValidator || (me.allowBlank && !value)) {
            return true;
        }

        let offline = [],
            notAllowed = [];
        Ext.Array.each(value.split(/\s*,\s*/), function (node) {
            let rec = me.store.findRecord(me.valueField, node, 0, false, true, true);
            if (!(rec && rec.data) || rec.data.status !== 'online') {
                offline.push(node);
            } else if (me.allowedNodes && !Ext.Array.contains(me.allowedNodes, node)) {
                notAllowed.push(node);
            }
        });

        if (value && notAllowed.length !== 0) {
            return 'Node ' + notAllowed.join(', ') + ' is not allowed for this action!';
        }
        if (value && offline.length !== 0) {
            return 'Node ' + offline.join(', ') + ' seems to be offline!';
        }
        return true;
    },

    initComponent: function () {
        var me = this;

        if (me.selectCurNode && PVE.curSelectedNode && PVE.curSelectedNode.data.node) {
            me.preferredValue = PVE.curSelectedNode.data.node;
        }

        me.callParent();
        me.getStore().load();

        me.getStore().addFilter(
            new Ext.util.Filter({
                // filter out disallowed nodes
                filterFn: (item) =>
                    !(me.disallowedNodes && me.disallowedNodes.includes(item.data.node)),
            }),
        );

        me.mon(me.getStore(), 'load', () => me.isValid());
    },
});
Ext.define('PVE.form.NotificationModeSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.pveNotificationModeSelector'],
    comboItems: [
        ['notification-target', gettext('Target')],
        ['mailto', gettext('E-Mail')],
    ],
});
Ext.define('PVE.form.NotificationTargetSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: ['widget.pveNotificationTargetSelector'],

    // set default value to empty array, else it inits it with
    // null and after the store load it is an empty array,
    // triggering dirtychange
    value: [],
    valueField: 'name',
    displayField: 'name',
    deleteEmpty: true,
    skipEmptyText: true,

    store: {
        fields: ['name', 'type', 'comment'],
        proxy: {
            type: 'proxmox',
            url: '/api2/json/cluster/notifications/targets',
        },
        sorters: [
            {
                property: 'name',
                direction: 'ASC',
            },
        ],
        autoLoad: true,
    },

    listConfig: {
        columns: [
            {
                header: gettext('Target'),
                dataIndex: 'name',
                sortable: true,
                hideable: false,
                flex: 1,
            },
            {
                header: gettext('Type'),
                dataIndex: 'type',
                sortable: true,
                hideable: false,
                flex: 1,
            },
            {
                header: gettext('Comment'),
                dataIndex: 'comment',
                sortable: true,
                hideable: false,
                flex: 2,
            },
        ],
    },
});
Ext.define('PVE.form.EmailNotificationSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.pveEmailNotificationSelector'],
    comboItems: [
        ['always', gettext('Always')],
        ['failure', gettext('On failure only')],
    ],
});
Ext.define('PVE.form.PCISelector', {
    extend: 'Proxmox.form.ComboGrid',
    xtype: 'pvePCISelector',

    store: {
        fields: ['id', 'vendor_name', 'device_name', 'vendor', 'device', 'iommugroup', 'mdev'],
        filterOnLoad: true,
        sorters: [
            {
                property: 'id',
                direction: 'ASC',
            },
        ],
    },

    autoSelect: false,
    valueField: 'id',
    displayField: 'id',

    // can contain a load callback for the store
    // useful to determine the state of the IOMMU
    onLoadCallBack: undefined,

    listConfig: {
        minHeight: 80,
        width: 800,
        columns: [
            {
                header: 'ID',
                dataIndex: 'id',
                width: 100,
            },
            {
                header: gettext('IOMMU Group'),
                dataIndex: 'iommugroup',
                renderer: (v) => (v === -1 ? '-' : v),
                width: 75,
            },
            {
                header: gettext('Vendor'),
                dataIndex: 'vendor_name',
                flex: 2,
            },
            {
                header: gettext('Device'),
                dataIndex: 'device_name',
                flex: 6,
            },
            {
                header: gettext('Mediated Devices'),
                dataIndex: 'mdev',
                flex: 1,
                renderer: function (val) {
                    return Proxmox.Utils.format_boolean(!!val);
                },
            },
        ],
    },

    setNodename: function (nodename) {
        var me = this;

        if (!nodename || me.nodename === nodename) {
            return;
        }

        me.nodename = nodename;

        me.store.setProxy({
            type: 'proxmox',
            url: '/api2/json/nodes/' + me.nodename + '/hardware/pci',
        });

        me.store.load();
    },

    initComponent: function () {
        var me = this;

        var nodename = me.nodename;
        me.nodename = undefined;

        me.callParent();

        if (me.onLoadCallBack !== undefined) {
            me.mon(me.getStore(), 'load', me.onLoadCallBack);
        }

        me.setNodename(nodename);
    },
});
Ext.define('pve-mapped-pci-model', {
    extend: 'Ext.data.Model',

    fields: ['id', 'path', 'vendor', 'device', 'iommugroup', 'mdev', 'description', 'map'],
    idProperty: 'id',
});

Ext.define('PVE.form.PCIMapSelector', {
    extend: 'Proxmox.form.ComboGrid',
    xtype: 'pvePCIMapSelector',

    store: {
        model: 'pve-mapped-pci-model',
        filterOnLoad: true,
        sorters: [
            {
                property: 'id',
                direction: 'ASC',
            },
        ],
    },

    autoSelect: false,
    valueField: 'id',
    displayField: 'id',

    // can contain a load callback for the store
    // useful to determine the state of the IOMMU
    onLoadCallBack: undefined,

    listConfig: {
        width: 800,
        columns: [
            {
                header: gettext('ID'),
                dataIndex: 'id',
                flex: 1,
            },
            {
                header: gettext('Description'),
                dataIndex: 'description',
                flex: 1,
                renderer: Ext.String.htmlEncode,
            },
            {
                header: gettext('Status'),
                dataIndex: 'checks',
                renderer: function (value) {
                    let _me = this;

                    if (!Ext.isArray(value) || !value?.length) {
                        return `<i class="fa fa-check-circle good"></i> ${gettext('Mapping matches host data')}`;
                    }

                    let checks = [];

                    value.forEach((check) => {
                        let iconCls;
                        switch (check?.severity) {
                            case 'warning':
                                iconCls = 'fa-exclamation-circle warning';
                                break;
                            case 'error':
                                iconCls = 'fa-times-circle critical';
                                break;
                        }

                        let message = check?.message;
                        let icon = `<i class="fa ${iconCls}"></i>`;
                        if (iconCls !== undefined) {
                            checks.push(`${icon} ${message}`);
                        }
                    });

                    return checks.join('<br>');
                },
                flex: 3,
            },
        ],
    },

    setNodename: function (nodename) {
        var me = this;

        if (!nodename || me.nodename === nodename) {
            return;
        }

        me.nodename = nodename;

        me.store.setProxy({
            type: 'proxmox',
            url: `/api2/json/cluster/mapping/pci?check-node=${nodename}`,
        });

        me.store.load();
    },

    initComponent: function () {
        var me = this;

        var nodename = me.nodename;
        me.nodename = undefined;

        me.callParent();

        if (me.onLoadCallBack !== undefined) {
            me.mon(me.getStore(), 'load', me.onLoadCallBack);
        }

        me.setNodename(nodename);
    },
});
Ext.define('PVE.form.PermPathSelector', {
    extend: 'Ext.form.field.ComboBox',
    xtype: 'pvePermPathSelector',

    valueField: 'value',
    displayField: 'value',
    typeAhead: true,
    queryMode: 'local',
    width: 380,

    store: {
        type: 'pvePermPath',
    },
});
Ext.define(
    'PVE.form.PoolSelector',
    {
        extend: 'Proxmox.form.ComboGrid',
        alias: ['widget.pvePoolSelector'],

        allowBlank: false,
        valueField: 'poolid',
        displayField: 'poolid',

        initComponent: function () {
            var me = this;

            var store = new Ext.data.Store({
                model: 'pve-pools',
                sorters: 'poolid',
            });

            Ext.apply(me, {
                store: store,
                autoSelect: false,
                listConfig: {
                    columns: [
                        {
                            header: gettext('Pool'),
                            sortable: true,
                            dataIndex: 'poolid',
                            flex: 1,
                        },
                        {
                            header: gettext('Comment'),
                            sortable: false,
                            dataIndex: 'comment',
                            renderer: Ext.String.htmlEncode,
                            flex: 1,
                        },
                    ],
                },
            });

            me.callParent();

            store.load();
        },
    },
    function () {
        Ext.define('pve-pools', {
            extend: 'Ext.data.Model',
            fields: ['poolid', 'comment'],
            proxy: {
                type: 'proxmox',
                url: '/api2/json/pools',
            },
            idProperty: 'poolid',
        });
    },
);
Ext.define('PVE.form.preallocationSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.pvePreallocationSelector'],
    comboItems: [
        ['__default__', Proxmox.Utils.defaultText],
        ['off', 'Off'],
        ['metadata', 'Metadata'],
        ['falloc', 'Full (posix_fallocate)'],
        ['full', 'Full'],
    ],
});
Ext.define('PVE.form.PrivilegesSelector', {
    extend: 'Proxmox.form.KVComboBox',
    xtype: 'pvePrivilegesSelector',

    multiSelect: true,

    initComponent: function () {
        let me = this;

        me.callParent();

        Proxmox.Utils.API2Request({
            url: '/access/roles/Administrator',
            method: 'GET',
            success: function (response, options) {
                let data = Object.keys(response.result.data).map((key) => [key, key]);

                me.store.setData(data);

                me.store.sort({
                    property: 'key',
                    direction: 'ASC',
                });
            },
            failure: (response, opts) => Ext.Msg.alert(gettext('Error'), response.htmlStatus),
        });
    },
});
Ext.define('PVE.form.QemuBiosSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.pveQemuBiosSelector'],

    initComponent: function () {
        var me = this;

        me.comboItems = [
            ['__default__', PVE.Utils.render_qemu_bios('')],
            ['seabios', PVE.Utils.render_qemu_bios('seabios')],
            ['ovmf', PVE.Utils.render_qemu_bios('ovmf')],
        ];

        me.callParent();
    },
});
Ext.define(
    'PVE.form.SDNControllerSelector',
    {
        extend: 'Proxmox.form.ComboGrid',
        alias: ['widget.pveSDNControllerSelector'],

        allowBlank: false,
        valueField: 'controller',
        displayField: 'controller',

        initComponent: function () {
            var me = this;

            var store = new Ext.data.Store({
                model: 'pve-sdn-controller',
                sorters: {
                    property: 'controller',
                    direction: 'ASC',
                },
            });

            Ext.apply(me, {
                store: store,
                autoSelect: false,
                listConfig: {
                    columns: [
                        {
                            header: gettext('Controller'),
                            sortable: true,
                            dataIndex: 'controller',
                            flex: 1,
                        },
                    ],
                },
            });

            me.callParent();

            store.load();
        },
    },
    function () {
        Ext.define('pve-sdn-controller', {
            extend: 'Ext.data.Model',
            fields: ['controller'],
            proxy: {
                type: 'proxmox',
                url: '/api2/json/cluster/sdn/controllers',
            },
            idProperty: 'controller',
        });
    },
);
Ext.define(
    'PVE.form.SDNZoneSelector',
    {
        extend: 'Proxmox.form.ComboGrid',
        alias: ['widget.pveSDNZoneSelector'],

        allowBlank: false,
        valueField: 'zone',
        displayField: 'zone',

        initComponent: function () {
            var me = this;

            var store = new Ext.data.Store({
                model: 'pve-sdn-zone',
                sorters: {
                    property: 'zone',
                    direction: 'ASC',
                },
            });

            Ext.apply(me, {
                store: store,
                autoSelect: false,
                listConfig: {
                    columns: [
                        {
                            header: gettext('Zone'),
                            sortable: true,
                            dataIndex: 'zone',
                            flex: 1,
                        },
                    ],
                },
            });

            me.callParent();

            store.load();
        },
    },
    function () {
        Ext.define('pve-sdn-zone', {
            extend: 'Ext.data.Model',
            fields: ['zone', 'type'],
            proxy: {
                type: 'proxmox',
                url: '/api2/json/cluster/sdn/zones',
            },
            idProperty: 'zone',
        });
    },
);
Ext.define(
    'PVE.form.SDNVnetSelector',
    {
        extend: 'Proxmox.form.ComboGrid',
        alias: ['widget.pveSDNVnetSelector'],

        allowBlank: false,
        valueField: 'vnet',
        displayField: 'vnet',

        initComponent: function () {
            var me = this;

            var store = new Ext.data.Store({
                model: 'pve-sdn-vnet',
                sorters: {
                    property: 'vnet',
                    direction: 'ASC',
                },
            });

            Ext.apply(me, {
                store: store,
                autoSelect: false,
                listConfig: {
                    columns: [
                        {
                            header: gettext('VNet'),
                            sortable: true,
                            dataIndex: 'vnet',
                            flex: 1,
                        },
                        {
                            header: gettext('Alias'),
                            flex: 1,
                            dataIndex: 'alias',
                        },
                        {
                            header: gettext('Tag'),
                            flex: 1,
                            dataIndex: 'tag',
                        },
                    ],
                },
            });

            me.callParent();

            store.load();
        },
    },
    function () {
        Ext.define('pve-sdn-vnet', {
            extend: 'Ext.data.Model',
            fields: ['alias', 'tag', 'type', 'vnet', 'zone'],
            proxy: {
                type: 'proxmox',
                url: '/api2/json/cluster/sdn/vnets',
            },
            idProperty: 'vnet',
        });
    },
);
Ext.define(
    'PVE.form.SDNIpamSelector',
    {
        extend: 'Proxmox.form.ComboGrid',
        alias: ['widget.pveSDNIpamSelector'],

        allowBlank: false,
        valueField: 'ipam',
        displayField: 'ipam',

        initComponent: function () {
            var me = this;

            var store = new Ext.data.Store({
                model: 'pve-sdn-ipam',
                sorters: {
                    property: 'ipam',
                    direction: 'ASC',
                },
            });

            Ext.apply(me, {
                store: store,
                autoSelect: false,
                listConfig: {
                    columns: [
                        {
                            header: gettext('Ipam'),
                            sortable: true,
                            dataIndex: 'ipam',
                            flex: 1,
                        },
                    ],
                },
            });

            me.callParent();

            store.load();
        },
    },
    function () {
        Ext.define('pve-sdn-ipam', {
            extend: 'Ext.data.Model',
            fields: ['ipam'],
            proxy: {
                type: 'proxmox',
                url: '/api2/json/cluster/sdn/ipams',
            },
            idProperty: 'ipam',
        });
    },
);
Ext.define(
    'PVE.form.SDNDnsSelector',
    {
        extend: 'Proxmox.form.ComboGrid',
        alias: ['widget.pveSDNDnsSelector'],

        allowBlank: false,
        valueField: 'dns',
        displayField: 'dns',

        initComponent: function () {
            var me = this;

            var store = new Ext.data.Store({
                model: 'pve-sdn-dns',
                sorters: {
                    property: 'dns',
                    direction: 'ASC',
                },
            });

            Ext.apply(me, {
                store: store,
                autoSelect: false,
                listConfig: {
                    columns: [
                        {
                            header: gettext('dns'),
                            sortable: true,
                            dataIndex: 'dns',
                            flex: 1,
                        },
                    ],
                },
            });

            me.callParent();

            store.load();
        },
    },
    function () {
        Ext.define('pve-sdn-dns', {
            extend: 'Ext.data.Model',
            fields: ['dns'],
            proxy: {
                type: 'proxmox',
                url: '/api2/json/cluster/sdn/dns',
            },
            idProperty: 'dns',
        });
    },
);
Ext.define('PVE.form.ScsiHwSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.pveScsiHwSelector'],
    comboItems: [
        ['__default__', PVE.Utils.render_scsihw('')],
        ['lsi', PVE.Utils.render_scsihw('lsi')],
        ['lsi53c810', PVE.Utils.render_scsihw('lsi53c810')],
        ['megasas', PVE.Utils.render_scsihw('megasas')],
        ['virtio-scsi-pci', PVE.Utils.render_scsihw('virtio-scsi-pci')],
        ['virtio-scsi-single', PVE.Utils.render_scsihw('virtio-scsi-single')],
        ['pvscsi', PVE.Utils.render_scsihw('pvscsi')],
    ],
});
Ext.define('PVE.form.SecurityGroupsSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: ['widget.pveSecurityGroupsSelector'],

    valueField: 'group',
    displayField: 'group',
    initComponent: function () {
        var me = this;

        var store = Ext.create('Ext.data.Store', {
            autoLoad: true,
            fields: ['group', 'comment'],
            idProperty: 'group',
            proxy: {
                type: 'proxmox',
                url: '/api2/json/cluster/firewall/groups',
            },
            sorters: {
                property: 'group',
                direction: 'ASC',
            },
        });

        Ext.apply(me, {
            store: store,
            listConfig: {
                columns: [
                    {
                        header: gettext('Security Group'),
                        dataIndex: 'group',
                        hideable: false,
                        width: 100,
                    },
                    {
                        header: gettext('Comment'),
                        dataIndex: 'comment',
                        renderer: function (value, metaData) {
                            let comment = Ext.String.htmlEncode(value) || '';
                            if (comment.length * 12 > metaData.column.cellWidth) {
                                let qtip = Ext.htmlEncode(comment);
                                comment = `<span data-qtip="${qtip}">${comment}</span>`;
                            }
                            return comment;
                        },
                        flex: 1,
                    },
                ],
            },
        });

        me.callParent();
    },
});
Ext.define('PVE.form.SnapshotSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: ['widget.PVE.form.SnapshotSelector'],

    valueField: 'name',
    displayField: 'name',

    loadStore: function (nodename, vmid) {
        var me = this;

        if (!nodename) {
            return;
        }

        me.nodename = nodename;

        if (!vmid) {
            return;
        }

        me.vmid = vmid;

        me.store.setProxy({
            type: 'proxmox',
            url:
                '/api2/json/nodes/' +
                me.nodename +
                '/' +
                me.guestType +
                '/' +
                me.vmid +
                '/snapshot',
        });

        me.store.load();
    },

    initComponent: function () {
        var me = this;

        if (!me.nodename) {
            throw 'no node name specified';
        }

        if (!me.vmid) {
            throw 'no VM ID specified';
        }

        if (!me.guestType) {
            throw 'no guest type specified';
        }

        var store = Ext.create('Ext.data.Store', {
            fields: ['name'],
            filterOnLoad: true,
        });

        Ext.apply(me, {
            store: store,
            listConfig: {
                columns: [
                    {
                        header: gettext('Snapshot'),
                        dataIndex: 'name',
                        hideable: false,
                        flex: 1,
                    },
                ],
            },
        });

        me.callParent();

        me.loadStore(me.nodename, me.vmid);
    },
});
Ext.define('PVE.form.SpiceEnhancementSelector', {
    extend: 'Proxmox.panel.InputPanel',
    alias: 'widget.pveSpiceEnhancementSelector',

    viewModel: {},

    items: [
        {
            xtype: 'proxmoxcheckbox',
            itemId: 'foldersharing',
            name: 'foldersharing',
            reference: 'foldersharing',
            fieldLabel: 'Folder Sharing',
            uncheckedValue: 0,
        },
        {
            xtype: 'proxmoxKVComboBox',
            itemId: 'videostreaming',
            name: 'videostreaming',
            value: 'off',
            fieldLabel: 'Video Streaming',
            comboItems: [
                ['off', 'off'],
                ['all', 'all'],
                ['filter', 'filter'],
            ],
        },
        {
            xtype: 'displayfield',
            itemId: 'spicehint',
            userCls: 'pmx-hint',
            value: gettext(
                'To use these features set the display to SPICE in the hardware settings of the VM.',
            ),
            hidden: true,
        },
        {
            xtype: 'displayfield',
            itemId: 'spicefolderhint',
            userCls: 'pmx-hint',
            value: gettext('Make sure the SPICE WebDav daemon is installed in the VM.'),
            bind: {
                hidden: '{!foldersharing.checked}',
            },
        },
    ],

    onGetValues: function (values) {
        var ret = {};

        if (values.videostreaming !== 'off') {
            ret.videostreaming = values.videostreaming;
        }
        if (values.foldersharing) {
            ret.foldersharing = 1;
        }
        if (Ext.Object.isEmpty(ret)) {
            return { delete: 'spice_enhancements' };
        }
        var enhancements = PVE.Parser.printPropertyString(ret);
        return { spice_enhancements: enhancements };
    },

    setValues: function (values) {
        var vga = PVE.Parser.parsePropertyString(values.vga, 'type');
        if (!/^qxl\d?$/.test(vga.type)) {
            this.down('#spicehint').setVisible(true);
        }
        if (values.spice_enhancements) {
            let enhancements = PVE.Parser.parsePropertyString(values.spice_enhancements);
            enhancements.foldersharing = PVE.Parser.parseBoolean(enhancements.foldersharing, 0);
            this.callParent([enhancements]);
        }
    },
});
Ext.define('PVE.form.StorageScanNodeSelector', {
    extend: 'PVE.form.NodeSelector',
    xtype: 'pveStorageScanNodeSelector',

    name: 'storageScanNode',
    itemId: 'pveStorageScanNodeSelector',
    fieldLabel: gettext('Scan node'),
    allowBlank: true,
    disallowedNodes: undefined,
    autoSelect: false,
    submitValue: false,
    value: null,
    autoEl: {
        tag: 'div',
        'data-qtip': gettext('Scan for available storages on the selected node'),
    },
    triggers: {
        clear: {
            handler: function () {
                let me = this;
                me.setValue(null);
            },
        },
    },

    emptyText: Proxmox.NodeName,

    setValue: function (value) {
        let me = this;
        me.callParent([value]);
        me.triggers.clear.setVisible(!!value);
    },
});
Ext.define(
    'PVE.form.StorageSelector',
    {
        extend: 'Proxmox.form.ComboGrid',
        alias: 'widget.pveStorageSelector',
        mixins: ['Proxmox.Mixin.CBind'],

        cbindData: {
            clusterView: false,
        },

        allowBlank: false,
        valueField: 'storage',
        displayField: 'storage',
        listConfig: {
            cbind: {
                clusterView: '{clusterView}',
            },
            width: 450,
            columns: [
                {
                    header: gettext('Name'),
                    dataIndex: 'storage',
                    hideable: false,
                    flex: 1,
                },
                {
                    header: gettext('Type'),
                    width: 75,
                    dataIndex: 'type',
                },
                {
                    header: gettext('Avail'),
                    width: 90,
                    dataIndex: 'avail',
                    renderer: Proxmox.Utils.format_size,
                    cbind: {
                        hidden: '{clusterView}',
                    },
                },
                {
                    header: gettext('Capacity'),
                    width: 90,
                    dataIndex: 'total',
                    renderer: Proxmox.Utils.format_size,
                    cbind: {
                        hidden: '{clusterView}',
                    },
                },
                {
                    header: gettext('Nodes'),
                    width: 120,
                    dataIndex: 'nodes',
                    renderer: (value) => (value ? value : '-- ' + gettext('All') + ' --'),
                    cbind: {
                        hidden: '{!clusterView}',
                    },
                },
                {
                    header: gettext('Shared'),
                    width: 70,
                    dataIndex: 'shared',
                    renderer: Proxmox.Utils.format_boolean,
                    cbind: {
                        hidden: '{!clusterView}',
                    },
                },
            ],
        },

        reloadStorageList: function () {
            let me = this;

            if (me.clusterView) {
                me.getStore().setProxy({
                    type: 'proxmox',
                    url: `/api2/json/storage`,
                });

                // filter here, back-end does not support it currently
                let filters = [(storage) => !storage.data.disable];

                if (me.storageContent) {
                    filters.push((storage) =>
                        storage.data.content.split(',').includes(me.storageContent),
                    );
                }

                if (me.nodename) {
                    filters.push(
                        (storage) =>
                            !storage.data.nodes || storage.data.nodes.includes(me.nodename),
                    );
                }

                me.getStore().clearFilter();
                me.getStore().setFilters(filters);
            } else {
                if (!me.nodename) {
                    return;
                }

                let params = {
                    format: 1,
                };
                if (me.storageContent) {
                    params.content = me.storageContent;
                }
                if (me.targetNode) {
                    params.target = me.targetNode;
                    params.enabled = 1; // skip disabled storages
                }
                me.store.setProxy({
                    type: 'proxmox',
                    url: `/api2/json/nodes/${me.nodename}/storage`,
                    extraParams: params,
                });
            }

            me.store.load(() => me.validate());
        },

        setTargetNode: function (targetNode) {
            var me = this;

            if (!targetNode || me.targetNode === targetNode) {
                return;
            }

            if (me.clusterView) {
                throw 'setting targetNode with clusterView is not implemented';
            }

            me.targetNode = targetNode;

            me.reloadStorageList();
        },

        setNodename: function (nodename) {
            var me = this;

            nodename = nodename || '';

            if (me.nodename === nodename) {
                return;
            }

            me.nodename = nodename;

            me.reloadStorageList();
        },

        initComponent: function () {
            var me = this;

            let nodename = me.nodename;
            me.nodename = undefined;

            var store = Ext.create('Ext.data.Store', {
                model: 'pve-storage-status',
                sorters: {
                    property: 'storage',
                    direction: 'ASC',
                },
            });

            Ext.apply(me, {
                store: store,
            });

            me.callParent();

            me.setNodename(nodename);
        },
    },
    function () {
        Ext.define('pve-storage-status', {
            extend: 'Ext.data.Model',
            fields: ['storage', 'active', 'type', 'avail', 'total', 'nodes', 'shared'],
            idProperty: 'storage',
        });
    },
);
Ext.define('PVE.form.TFASelector', {
    extend: 'Ext.container.Container',
    xtype: 'pveTFASelector',
    mixins: ['Proxmox.Mixin.CBind'],

    deleteEmpty: true,

    viewModel: {
        data: {
            type: '__default__',
            step: null,
            digits: null,
            id: null,
            key: null,
            url: null,
        },

        formulas: {
            isOath: (get) => get('type') === 'oath',
            isYubico: (get) => get('type') === 'yubico',
            tfavalue: {
                get: function (get) {
                    let val = {
                        type: get('type'),
                    };
                    if (get('isOath')) {
                        let step = get('step');
                        let digits = get('digits');
                        if (step) {
                            val.step = step;
                        }
                        if (digits) {
                            val.digits = digits;
                        }
                    } else if (get('isYubico')) {
                        let id = get('id');
                        let key = get('key');
                        let url = get('url');
                        val.id = id;
                        val.key = key;
                        if (url) {
                            val.url = url;
                        }
                    } else if (val.type === '__default__') {
                        return '';
                    }

                    return PVE.Parser.printPropertyString(val);
                },
                set: function (value) {
                    let val = PVE.Parser.parseTfaConfig(value);
                    this.set(val);
                    this.notify();
                    // we need to reset the original values, so that
                    // we can reliably track the state of the form
                    let form = this.getView().up('form');
                    if (form.trackResetOnLoad) {
                        let fields = this.getView().query('field[name!="tfa"]');
                        fields.forEach((field) => field.resetOriginalValue());
                    }
                },
            },
        },
    },

    items: [
        {
            xtype: 'proxmoxtextfield',
            name: 'tfa',
            hidden: true,
            submitValue: true,
            cbind: {
                deleteEmpty: '{deleteEmpty}',
            },
            bind: {
                value: '{tfavalue}',
            },
        },
        {
            xtype: 'proxmoxKVComboBox',
            value: '__default__',
            deleteEmpty: false,
            submitValue: false,
            fieldLabel: gettext('Require TFA'),
            comboItems: [
                ['__default__', Proxmox.Utils.noneText],
                ['oath', 'OATH/TOTP'],
                ['yubico', 'Yubico'],
            ],
            bind: {
                value: '{type}',
            },
        },
        {
            xtype: 'proxmoxintegerfield',
            hidden: true,
            minValue: 10,
            submitValue: false,
            emptyText: Proxmox.Utils.defaultText + ' (30)',
            fieldLabel: gettext('Time Step'),
            bind: {
                value: '{step}',
                hidden: '{!isOath}',
                disabled: '{!isOath}',
            },
        },
        {
            xtype: 'proxmoxintegerfield',
            hidden: true,
            submitValue: false,
            fieldLabel: gettext('Secret Length'),
            minValue: 6,
            maxValue: 8,
            emptyText: Proxmox.Utils.defaultText + ' (6)',
            bind: {
                value: '{digits}',
                hidden: '{!isOath}',
                disabled: '{!isOath}',
            },
        },
        {
            xtype: 'textfield',
            hidden: true,
            submitValue: false,
            allowBlank: false,
            fieldLabel: 'Yubico API Id',
            bind: {
                value: '{id}',
                hidden: '{!isYubico}',
                disabled: '{!isYubico}',
            },
        },
        {
            xtype: 'textfield',
            hidden: true,
            submitValue: false,
            allowBlank: false,
            fieldLabel: 'Yubico API Key',
            bind: {
                value: '{key}',
                hidden: '{!isYubico}',
                disabled: '{!isYubico}',
            },
        },
        {
            xtype: 'textfield',
            hidden: true,
            submitValue: false,
            fieldLabel: 'Yubico URL',
            bind: {
                value: '{url}',
                hidden: '{!isYubico}',
                disabled: '{!isYubico}',
            },
        },
    ],
});
Ext.define(
    'PVE.form.TokenSelector',
    {
        extend: 'Proxmox.form.ComboGrid',
        alias: ['widget.pveTokenSelector'],

        allowBlank: false,
        autoSelect: false,
        displayField: 'id',

        editable: true,
        anyMatch: true,
        forceSelection: true,

        store: {
            model: 'pve-tokens',
            autoLoad: true,
            proxy: {
                type: 'proxmox',
                url: 'api2/json/access/users',
                extraParams: { full: 1 },
            },
            sorters: 'id',
            listeners: {
                load: function (store, records, success) {
                    let tokens = [];
                    for (const { data: user } of records) {
                        if (!user.tokens || user.tokens.length === 0) {
                            continue;
                        }
                        for (const token of user.tokens) {
                            tokens.push({
                                id: `${user.userid}!${token.tokenid}`,
                                comment: token.comment,
                            });
                        }
                    }
                    store.loadData(tokens);
                },
            },
        },

        listConfig: {
            columns: [
                {
                    header: gettext('API Token'),
                    sortable: true,
                    dataIndex: 'id',
                    renderer: Ext.String.htmlEncode,
                    flex: 1,
                },
                {
                    header: gettext('Comment'),
                    sortable: false,
                    dataIndex: 'comment',
                    renderer: Ext.String.htmlEncode,
                    flex: 1,
                },
            ],
        },
    },
    function () {
        Ext.define('pve-tokens', {
            extend: 'Ext.data.Model',
            fields: [
                'id',
                'userid',
                'tokenid',
                'comment',
                { type: 'boolean', name: 'privsep' },
                { type: 'date', dateFormat: 'timestamp', name: 'expire' },
            ],
            idProperty: 'id',
        });
    },
);
Ext.define(
    'PVE.form.USBSelector',
    {
        extend: 'Proxmox.form.ComboGrid',
        alias: ['widget.pveUSBSelector'],

        allowBlank: false,
        autoSelect: false,
        anyMatch: true,
        displayField: 'product_and_id',
        valueField: 'usbid',
        editable: true,

        validator: function (value) {
            var me = this;
            if (!value) {
                return true; // handled later by allowEmpty in the getErrors call chain
            }
            value = me.getValue(); // as the valueField is not the displayfield
            if (me.type === 'device') {
                return /^[a-f0-9]{4}:[a-f0-9]{4}$/i.test(value);
            } else if (me.type === 'port') {
                return /^[0-9]+-[0-9]+(\.[0-9]+)*$/.test(value);
            }
            return gettext('Invalid Value');
        },

        setNodename: function (nodename) {
            var me = this;

            if (!nodename || me.nodename === nodename) {
                return;
            }

            me.nodename = nodename;

            me.store.setProxy({
                type: 'proxmox',
                url: `/api2/json/nodes/${me.nodename}/hardware/usb`,
            });

            me.store.load();
        },

        initComponent: function () {
            var me = this;

            if (me.pveSelNode) {
                me.nodename = me.pveSelNode.data.node;
            }

            var nodename = me.nodename;
            me.nodename = undefined;

            if (me.type !== 'device' && me.type !== 'port') {
                throw 'no valid type specified';
            }

            let store = new Ext.data.Store({
                model: `pve-usb-${me.type}`,
                filters: [
                    ({ data }) => !!data.usbpath && !!data.prodid && String(data.class) !== '9',
                ],
            });
            let emptyText = '';
            if (me.type === 'device') {
                emptyText = gettext('Passthrough a specific device');
            } else {
                emptyText = gettext('Passthrough a full port');
            }

            Ext.apply(me, {
                store: store,
                emptyText: emptyText,
                listConfig: {
                    minHeight: 80,
                    width: 520,
                    columns: [
                        {
                            header: me.type === 'device' ? gettext('Device') : gettext('Port'),
                            sortable: true,
                            dataIndex: 'usbid',
                            width: 80,
                        },
                        {
                            header: gettext('Manufacturer'),
                            sortable: true,
                            dataIndex: 'manufacturer',
                            width: 150,
                        },
                        {
                            header: gettext('Product'),
                            sortable: true,
                            dataIndex: 'product',
                            flex: 1,
                        },
                        {
                            header: gettext('Speed'),
                            width: 75,
                            sortable: true,
                            dataIndex: 'speed',
                            renderer: function (value) {
                                let speed2Class = {
                                    10000: 'USB 3.1',
                                    5000: 'USB 3.0',
                                    480: 'USB 2.0',
                                    12: 'USB 1.x',
                                    1.5: 'USB 1.x',
                                };
                                return speed2Class[value] || value + ' Mbps';
                            },
                        },
                    ],
                },
            });

            me.callParent();

            me.setNodename(nodename);
        },
    },
    function () {
        Ext.define('pve-usb-device', {
            extend: 'Ext.data.Model',
            fields: [
                {
                    name: 'usbid',
                    convert: function (val, data) {
                        if (val) {
                            return val;
                        }
                        return data.get('vendid') + ':' + data.get('prodid');
                    },
                },
                'speed',
                'product',
                'manufacturer',
                'vendid',
                'prodid',
                'usbpath',
                { name: 'port', type: 'number' },
                { name: 'level', type: 'number' },
                { name: 'class', type: 'number' },
                { name: 'devnum', type: 'number' },
                { name: 'busnum', type: 'number' },
                {
                    name: 'product_and_id',
                    type: 'string',
                    convert: (v, rec) => {
                        let res = rec.data.product || gettext('Unknown');
                        res += ' (' + rec.data.usbid + ')';
                        return res;
                    },
                },
            ],
        });

        Ext.define('pve-usb-port', {
            extend: 'Ext.data.Model',
            fields: [
                {
                    name: 'usbid',
                    convert: function (val, data) {
                        if (val) {
                            return val;
                        }
                        return data.get('busnum') + '-' + data.get('usbpath');
                    },
                },
                'speed',
                'product',
                'manufacturer',
                'vendid',
                'prodid',
                'usbpath',
                { name: 'port', type: 'number' },
                { name: 'level', type: 'number' },
                { name: 'class', type: 'number' },
                { name: 'devnum', type: 'number' },
                { name: 'busnum', type: 'number' },
                {
                    name: 'product_and_id',
                    type: 'string',
                    convert: (v, rec) => {
                        let res = rec.data.product || gettext('Unplugged');
                        res += ' (' + rec.data.usbid + ')';
                        return res;
                    },
                },
            ],
        });
    },
);
Ext.define('PVE.form.USBMapSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: 'widget.pveUSBMapSelector',

    store: {
        fields: ['name', 'vendor', 'device', 'path'],
        filterOnLoad: true,
        sorters: [
            {
                property: 'name',
                direction: 'ASC',
            },
        ],
    },

    allowBlank: false,
    autoSelect: false,
    displayField: 'id',
    valueField: 'id',

    listConfig: {
        width: 800,
        columns: [
            {
                header: gettext('Name'),
                dataIndex: 'id',
                flex: 1,
            },
            {
                header: gettext('Status'),
                dataIndex: 'errors',
                flex: 2,
                renderer: function (value) {
                    let _me = this;

                    if (!Ext.isArray(value) || !value?.length) {
                        return `<i class="fa fa-check-circle good"></i> ${gettext('Mapping matches host data')}`;
                    }

                    let errors = [];

                    value.forEach((error) => {
                        let iconCls;
                        switch (error?.severity) {
                            case 'warning':
                                iconCls = 'fa-exclamation-circle warning';
                                break;
                            case 'error':
                                iconCls = 'fa-times-circle critical';
                                break;
                        }

                        let message = error?.message;
                        let icon = `<i class="fa ${iconCls}"></i>`;
                        if (iconCls !== undefined) {
                            errors.push(`${icon} ${message}`);
                        }
                    });

                    return errors.join('<br>');
                },
            },
            {
                header: gettext('Comment'),
                dataIndex: 'description',
                flex: 1,
                renderer: Ext.String.htmlEncode,
            },
        ],
    },

    setNodename: function (nodename) {
        var me = this;

        if (!nodename || me.nodename === nodename) {
            return;
        }

        me.nodename = nodename;

        me.store.setProxy({
            type: 'proxmox',
            url: `/api2/json/cluster/mapping/usb?check-node=${nodename}`,
        });

        me.store.load();
    },

    initComponent: function () {
        var me = this;

        var nodename = me.nodename;
        me.nodename = undefined;

        me.callParent();

        me.setNodename(nodename);
    },
});
Ext.define('pmx-users', {
    extend: 'Ext.data.Model',
    fields: [
        'userid',
        'firstname',
        'lastname',
        'email',
        'comment',
        { type: 'boolean', name: 'enable' },
        { type: 'date', dateFormat: 'timestamp', name: 'expire' },
    ],
    proxy: {
        type: 'proxmox',
        url: '/api2/json/access/users?full=1',
    },
    idProperty: 'userid',
});
Ext.define('PVE.form.VlanField', {
    extend: 'Ext.form.field.Number',
    alias: ['widget.pveVlanField'],

    deleteEmpty: false,

    emptyText: gettext('no VLAN'),

    fieldLabel: gettext('VLAN Tag'),

    allowBlank: true,

    getSubmitData: function () {
        var me = this,
            data = null,
            val;
        if (!me.disabled && me.submitValue) {
            val = me.getSubmitValue();
            if (val) {
                data = {};
                data[me.getName()] = val;
            } else if (me.deleteEmpty) {
                data = {};
                data.delete = me.getName();
            }
        }
        return data;
    },

    initComponent: function () {
        var me = this;

        Ext.apply(me, {
            minValue: 1,
            maxValue: 4094,
        });

        me.callParent();
    },
});
Ext.define('PVE.form.VMCPUFlagSelector', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.vmcpuflagselector',

    mixins: {
        field: 'Ext.form.field.Field',
    },

    disableSelection: true,
    columnLines: false,
    selectable: false,
    hideHeaders: true,

    scrollable: 'y',
    height: 200,

    unkownFlags: [],

    store: {
        type: 'store',
        fields: ['flag', { name: 'state', defaultValue: '=' }, 'desc'],
        data: [
            // FIXME: let qemu-server host this and autogenerate or get from API call??
            {
                flag: 'md-clear',
                desc: 'Required to let the guest OS know if MDS is mitigated correctly',
            },
            {
                flag: 'pcid',
                desc: 'Meltdown fix cost reduction on Westmere, Sandy-, and IvyBridge Intel CPUs',
            },
            { flag: 'spec-ctrl', desc: 'Allows improved Spectre mitigation with Intel CPUs' },
            { flag: 'ssbd', desc: 'Protection for "Speculative Store Bypass" for Intel models' },
            { flag: 'ibpb', desc: 'Allows improved Spectre mitigation with AMD CPUs' },
            {
                flag: 'virt-ssbd',
                desc: 'Basis for "Speculative Store Bypass" protection for AMD models',
            },
            {
                flag: 'amd-ssbd',
                desc: 'Improves Spectre mitigation performance with AMD CPUs, best used with "virt-ssbd"',
            },
            {
                flag: 'amd-no-ssb',
                desc: 'Notifies guest OS that host is not vulnerable for Spectre on AMD CPUs',
            },
            {
                flag: 'pdpe1gb',
                desc: 'Allow guest OS to use 1GB size pages, if host HW supports it',
            },
            {
                flag: 'hv-tlbflush',
                desc: 'Improve performance in overcommitted Windows guests. May lead to guest bluescreens on old CPUs.',
            },
            {
                flag: 'hv-evmcs',
                desc: 'Improve performance for nested virtualization. Only supported on Intel CPUs.',
            },
            { flag: 'aes', desc: 'Activate AES instruction set for HW acceleration.' },
        ],
        listeners: {
            update: function () {
                this.commitChanges();
            },
        },
    },

    getValue: function () {
        var me = this;
        var store = me.getStore();
        var flags = '';

        // ExtJS does not has a nice getAllRecords interface for stores :/
        store.queryBy(Ext.returnTrue).each(function (rec) {
            var s = rec.get('state');
            if (s && s !== '=') {
                let f = rec.get('flag');
                if (flags === '') {
                    flags = s + f;
                } else {
                    flags += ';' + s + f;
                }
            }
        });

        flags += me.unkownFlags.join(';');

        return flags;
    },

    setValue: function (value) {
        var me = this;
        var store = me.getStore();

        me.value = value || '';

        me.unkownFlags = [];

        me.getStore()
            .queryBy(Ext.returnTrue)
            .each(function (rec) {
                rec.set('state', '=');
            });

        var flags = value ? value.split(';') : [];
        flags.forEach(function (flag) {
            var sign = flag.substr(0, 1);
            flag = flag.substr(1);

            var rec = store.findRecord('flag', flag, 0, false, true, true);
            if (rec !== null) {
                rec.set('state', sign);
            } else {
                me.unkownFlags.push(flag);
            }
        });
        store.reload();

        var res = me.mixins.field.setValue.call(me, value);

        return res;
    },
    columns: [
        {
            dataIndex: 'state',
            renderer: function (v) {
                switch (v) {
                    case '=':
                        return 'Default';
                    case '-':
                        return 'Off';
                    case '+':
                        return 'On';
                    default:
                        return 'Unknown';
                }
            },
            width: 65,
        },
        {
            xtype: 'widgetcolumn',
            dataIndex: 'state',
            width: 95,
            onWidgetAttach: function (column, widget, record) {
                var val = record.get('state') || '=';
                widget.down('[inputValue=' + val + ']').setValue(true);
                // TODO: disable if selected CPU model and flag are incompatible
            },
            widget: {
                xtype: 'radiogroup',
                hideLabel: true,
                layout: 'hbox',
                validateOnChange: false,
                value: '=',
                listeners: {
                    change: function (f, value) {
                        var v = Object.values(value)[0];
                        f.getWidgetRecord().set('state', v);

                        var view = this.up('grid');
                        view.dirty = view.getValue() !== view.originalValue;
                        view.checkDirty();
                        //view.checkChange();
                    },
                },
                items: [
                    {
                        boxLabel: '-',
                        boxLabelAlign: 'before',
                        inputValue: '-',
                        isFormField: false,
                    },
                    {
                        checked: true,
                        inputValue: '=',
                        isFormField: false,
                    },
                    {
                        boxLabel: '+',
                        inputValue: '+',
                        isFormField: false,
                    },
                ],
            },
        },
        {
            dataIndex: 'flag',
            width: 100,
        },
        {
            dataIndex: 'desc',
            cellWrap: true,
            flex: 1,
        },
    ],

    initComponent: function () {
        var me = this;

        // static class store, thus gets not recreated, so ensure defaults are set!
        me.getStore().data.forEach(function (v) {
            v.state = '=';
        });

        me.value = me.originalValue = '';

        me.callParent(arguments);
    },
});
/* filter is a javascript builtin, but extjs calls it also filter */
Ext.define('PVE.form.VMSelector', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.vmselector',

    mixins: {
        field: 'Ext.form.field.Field',
    },

    allowBlank: true,
    selectAll: false,
    isFormField: true,

    plugins: 'gridfilters',

    store: {
        model: 'PVEResources',
        sorters: 'vmid',
    },

    userCls: 'proxmox-tags-circle',

    columnsDeclaration: [
        {
            header: 'ID',
            dataIndex: 'vmid',
            width: 80,
            filter: {
                type: 'number',
            },
        },
        {
            header: gettext('Node'),
            dataIndex: 'node',
        },
        {
            header: gettext('Status'),
            dataIndex: 'status',
            filter: {
                type: 'list',
            },
        },
        {
            header: gettext('Name'),
            dataIndex: 'name',
            flex: 1,
            filter: {
                type: 'string',
            },
        },
        {
            header: gettext('Pool'),
            dataIndex: 'pool',
            filter: {
                type: 'list',
            },
        },
        {
            header: gettext('Type'),
            dataIndex: 'type',
            width: 120,
            renderer: function (value) {
                if (value === 'qemu') {
                    return gettext('Virtual Machine');
                } else if (value === 'lxc') {
                    return gettext('LXC Container');
                }

                return '';
            },
            filter: {
                type: 'list',
                store: {
                    data: [
                        { id: 'qemu', text: gettext('Virtual Machine') },
                        { id: 'lxc', text: gettext('LXC Container') },
                    ],
                    un: function () {
                        // Due to EXTJS-18711. we have to do a static list via a store but to avoid
                        // creating an object, we have to have an empty pseudo un function
                    },
                },
            },
        },
        {
            header: gettext('Tags'),
            dataIndex: 'tags',
            renderer: (tags) => PVE.Utils.renderTags(tags, PVE.UIOptions.tagOverrides),
            flex: 1,
        },
        {
            header: 'HA ' + gettext('Status'),
            dataIndex: 'hastate',
            flex: 1,
            filter: {
                type: 'list',
            },
        },
    ],

    // should be a list of 'dataIndex' values, if 'undefined' all declared columns will be included
    columnSelection: undefined,

    selModel: {
        selType: 'checkboxmodel',
        mode: 'SIMPLE',
    },

    checkChangeEvents: ['selectionchange', 'change'],

    listeners: {
        selectionchange: function () {
            // to trigger validity and error checks
            this.checkChange();
        },
    },

    getValue: function () {
        var me = this;
        if (me.savedValue !== undefined) {
            return me.savedValue;
        }
        var sm = me.getSelectionModel();
        var selection = sm.getSelection();
        var values = [];
        var store = me.getStore();
        selection.forEach(function (item) {
            // only add if not filtered
            if (store.findExact('vmid', item.data.vmid) !== -1) {
                values.push(item.data.vmid);
            }
        });
        return values;
    },

    setValueSelection: function (value) {
        let me = this;

        let store = me.getStore();
        let notFound = [];
        let selection = value
            .map((item) => {
                let found = store.findRecord('vmid', item, 0, false, true, true);
                if (!found) {
                    if (Ext.isNumeric(item)) {
                        notFound.push(item);
                    } else {
                        console.warn(`invalid item in vm selection: ${item}`);
                    }
                }
                return found;
            })
            .filter((r) => r);

        for (const vmid of notFound) {
            let rec = store.add({
                vmid,
                node: 'unknown',
            });
            selection.push(rec[0]);
        }

        let sm = me.getSelectionModel();
        if (selection.length) {
            sm.select(selection);
        } else {
            sm.deselectAll();
        }
        // to correctly trigger invalid class
        me.getErrors();
    },

    setValue: function (value) {
        let me = this;
        value ??= [];
        if (!Ext.isArray(value)) {
            value = value.split(',').filter((v) => v !== '');
        }

        let store = me.getStore();
        if (!store.isLoaded()) {
            me.savedValue = value;
            store.on(
                'load',
                function () {
                    me.setValueSelection(value);
                    delete me.savedValue;
                },
                { single: true },
            );
        } else {
            me.setValueSelection(value);
        }
        return me.mixins.field.setValue.call(me, value);
    },

    getErrors: function (value) {
        let me = this;
        if (!me.isDisabled() && me.allowBlank === false && me.getValue().length === 0) {
            me.addBodyCls(['x-form-trigger-wrap-default', 'x-form-trigger-wrap-invalid']);
            return [gettext('No VM selected')];
        }

        me.removeBodyCls(['x-form-trigger-wrap-default', 'x-form-trigger-wrap-invalid']);
        return [];
    },

    setDisabled: function (disabled) {
        let me = this;
        let res = me.callParent([disabled]);
        me.getErrors();
        return res;
    },

    initComponent: function () {
        let me = this;

        let columns = me.columnsDeclaration
            .filter((column) =>
                me.columnSelection ? me.columnSelection.indexOf(column.dataIndex) !== -1 : true,
            )
            .map((x) => x);

        me.columns = columns;

        me.callParent();

        me.getStore().load({ params: { type: 'vm' } });

        if (me.nodename) {
            me.getStore().addFilter({
                property: 'node',
                exactMatch: true,
                value: me.nodename,
            });
        }

        // only show the relevant guests by default
        if (me.action) {
            let statusfilter = '';
            switch (me.action) {
                case 'startall':
                    statusfilter = 'stopped';
                    break;
                case 'stopall':
                    statusfilter = 'running';
                    break;
            }
            if (statusfilter !== '') {
                me.getStore().addFilter([
                    {
                        property: 'template',
                        value: 0,
                    },
                    {
                        id: 'x-gridfilter-status',
                        operator: 'in',
                        property: 'status',
                        value: [statusfilter],
                    },
                ]);
            }
        }

        if (me.selectAll) {
            me.mon(me.getStore(), 'load', function () {
                me.getSelectionModel().selectAll(false);
            });
        }
    },
});

Ext.define('PVE.form.VMComboSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: 'widget.vmComboSelector',

    valueField: 'vmid',
    displayField: 'vmid',

    autoSelect: false,
    editable: true,
    anyMatch: true,
    forceSelection: true,

    store: {
        model: 'PVEResources',
        autoLoad: true,
        sorters: 'vmid',
        filters: [
            {
                property: 'type',
                value: /lxc|qemu/,
            },
        ],
    },

    listConfig: {
        width: 600,
        plugins: 'gridfilters',
        columns: [
            {
                header: 'ID',
                dataIndex: 'vmid',
                width: 80,
                filter: {
                    type: 'number',
                },
            },
            {
                header: gettext('Name'),
                dataIndex: 'name',
                flex: 1,
                filter: {
                    type: 'string',
                },
            },
            {
                header: gettext('Node'),
                dataIndex: 'node',
            },
            {
                header: gettext('Status'),
                dataIndex: 'status',
                filter: {
                    type: 'list',
                },
            },
            {
                header: gettext('Pool'),
                dataIndex: 'pool',
                hidden: true,
                filter: {
                    type: 'list',
                },
            },
            {
                header: gettext('Type'),
                dataIndex: 'type',
                width: 120,
                renderer: function (value) {
                    if (value === 'qemu') {
                        return gettext('Virtual Machine');
                    } else if (value === 'lxc') {
                        return gettext('LXC Container');
                    }

                    return '';
                },
                filter: {
                    type: 'list',
                    store: {
                        data: [
                            { id: 'qemu', text: gettext('Virtual Machine') },
                            { id: 'lxc', text: gettext('LXC Container') },
                        ],
                        un: function () {
                            /* due to EXTJS-18711 */
                        },
                    },
                },
            },
            {
                header: 'HA ' + gettext('Status'),
                dataIndex: 'hastate',
                hidden: true,
                flex: 1,
                filter: {
                    type: 'list',
                },
            },
        ],
    },
});
Ext.define('PVE.form.VNCKeyboardSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.VNCKeyboardSelector'],
    comboItems: Object.entries(PVE.Utils.kvm_keymaps),
});
/*
 * Top left combobox, used to select a view of the underneath RessourceTree
 */
Ext.define('PVE.form.ViewSelector', {
    extend: 'Ext.form.field.ComboBox',
    alias: ['widget.pveViewSelector'],

    editable: false,
    allowBlank: false,
    forceSelection: true,
    autoSelect: false,
    valueField: 'key',
    displayField: 'value',
    hideLabel: true,
    queryMode: 'local',

    initComponent: function () {
        let me = this;

        let default_views = {
            server: {
                text: gettext('Server View'),
                groups: ['node'],
            },
            folder: {
                text: gettext('Folder View'),
                groups: ['type'],
            },
            pool: {
                text: gettext('Pool View'),
                groups: ['pool'],
                // Pool View only lists VMs and Containers
                getFilterFn:
                    () =>
                    ({ data }) =>
                        data.type === 'qemu' || data.type === 'lxc' || data.type === 'pool',
            },
            tags: {
                text: gettext('Tag View'),
                groups: ['tag'],
                getFilterFn:
                    () =>
                    ({ data }) =>
                        ['qemu', 'lxc', 'node', 'storage'].indexOf(data.type) !== -1,
                groupRenderer: function (info) {
                    let tag = PVE.Utils.renderTags(info.tag, PVE.UIOptions.tagOverrides);
                    return `<span class="proxmox-tags-full">${tag}</span>`;
                },
                itemMap: function (item) {
                    let tags = (item.data.tags ?? '').split(/[;, ]/);
                    if (tags.length === 1 && tags[0] === '') {
                        return item;
                    }
                    let items = [];
                    for (const tag of tags) {
                        let id = `${item.data.id}-${tag}`;
                        let info = Ext.apply({ leaf: true }, item.data);
                        info.tag = tag;
                        info.realId = info.id;
                        info.id = id;
                        items.push(Ext.create('Ext.data.TreeModel', info));
                    }
                    return items;
                },
                attrMoveChecks: {
                    tag: (newitem, olditem) => newitem.data.tags !== olditem.data.tags,
                },
            },
        };
        let groupdef = Object.entries(default_views).map(([name, config]) => [name, config.text]);

        let store = Ext.create('Ext.data.Store', {
            model: 'KeyValue',
            proxy: {
                type: 'memory',
                reader: 'array',
            },
            data: groupdef,
            autoload: true,
        });

        Ext.apply(me, {
            store: store,
            value: groupdef[0][0],
            getViewFilter: function () {
                let view = me.getValue();
                return Ext.apply({ id: view }, default_views[view] || default_views.server);
            },
            getState: function () {
                return { value: me.getValue() };
            },
            applyState: function (state, doSelect) {
                let view = me.getValue();
                if (state && state.value && view !== state.value) {
                    let record = store.findRecord('key', state.value, 0, false, true, true);
                    if (record) {
                        me.setValue(state.value, true);
                        if (doSelect) {
                            me.fireEvent('select', me, [record]);
                        }
                    }
                }
            },
            stateEvents: ['select'],
            stateful: true,
            stateId: 'pveview',
            id: 'view',
        });

        me.callParent();

        let statechange = function (sp, key, value) {
            if (key === me.id) {
                me.applyState(value, true);
            }
        };
        let sp = Ext.state.Manager.getProvider();
        me.mon(sp, 'statechange', statechange, me);
    },
});
Ext.define('PVE.form.iScsiProviderSelector', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.pveiScsiProviderSelector'],
    comboItems: [
        ['comstar', 'Comstar'],
        ['istgt', 'istgt'],
        ['iet', 'IET'],
        ['LIO', 'LIO'],
    ],
});
Ext.define('PVE.form.ColorPicker', {
    extend: 'Ext.form.FieldContainer',
    alias: 'widget.pveColorPicker',

    defaultBindProperty: 'value',

    config: {
        value: null,
    },

    height: 24,

    layout: {
        type: 'hbox',
        align: 'stretch',
    },

    getValue: function () {
        return this.realvalue.slice(1);
    },

    setValue: function (value) {
        let me = this;
        me.setColor(value);
        if (value && value.length === 6) {
            me.picker.value = value[0] !== '#' ? `#${value}` : value;
        }
    },

    setColor: function (value) {
        let me = this;
        let oldValue = me.realvalue;
        me.realvalue = value;
        let color = value.length === 6 ? `#${value}` : undefined;
        me.down('#picker').setStyle('background-color', color);
        me.down('#text').setValue(value ?? '');
        me.fireEvent('change', me, me.realvalue, oldValue);
    },

    initComponent: function () {
        let me = this;
        me.picker = document.createElement('input');
        me.picker.type = 'color';
        me.picker.style = `opacity: 0; border: 0px; width: 100%; height: ${me.height}px`;
        me.picker.value = `${me.value}`;

        me.items = [
            {
                xtype: 'textfield',
                itemId: 'text',
                minLength: !me.allowBlank ? 6 : undefined,
                maxLength: 6,
                enforceMaxLength: true,
                allowBlank: me.allowBlank,
                emptyText: me.allowBlank ? gettext('Automatic') : undefined,
                maskRe: /[a-f0-9]/i,
                regex: /^[a-f0-9]{6}$/i,
                flex: 1,
                listeners: {
                    change: function (field, value) {
                        me.setValue(value);
                    },
                },
            },
            {
                xtype: 'box',
                style: {
                    'margin-left': '1px',
                    border: '1px solid #cfcfcf',
                },
                itemId: 'picker',
                width: 24,
                contentEl: me.picker,
            },
        ];

        me.callParent();
        me.picker.oninput = function () {
            me.setColor(me.picker.value.slice(1));
        };
    },
});

Ext.define('PVE.form.TagColorGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.pveTagColorGrid',

    mixins: ['Ext.form.field.Field'],

    allowBlank: true,
    selectAll: false,
    isFormField: true,
    deleteEmpty: false,
    selModel: 'checkboxmodel',

    config: {
        deleteEmpty: false,
    },

    emptyText: gettext('No Overrides'),
    viewConfig: {
        deferEmptyText: false,
    },

    setValue: function (value) {
        let me = this;
        let colors;
        if (Ext.isObject(value)) {
            colors = value.colors;
        } else {
            colors = value;
        }
        if (!colors) {
            me.getStore().removeAll();
            me.checkChange();
            return me;
        }
        let entries = (colors.split(';') || []).map((entry) => {
            let [tag, bg, fg] = entry.split(':');
            fg = fg || '';
            return {
                tag,
                color: bg,
                text: fg,
            };
        });
        me.getStore().setData(entries);
        me.checkChange();
        return me;
    },

    getValue: function () {
        let me = this;
        let values = [];
        me.getStore().each((rec) => {
            if (rec.data.tag) {
                let val = `${rec.data.tag}:${rec.data.color}`;
                if (rec.data.text) {
                    val += `:${rec.data.text}`;
                }
                values.push(val);
            }
        });
        return values.join(';');
    },

    getErrors: function (value) {
        let me = this;
        let emptyTag = false;
        let notValidColor = false;
        let colorRegex = new RegExp(/^[0-9a-f]{6}$/i);
        me.getStore().each((rec) => {
            if (!rec.data.tag) {
                emptyTag = true;
            }
            if (!rec.data.color?.match(colorRegex)) {
                notValidColor = true;
            }
            if (rec.data.text && !rec.data.text?.match(colorRegex)) {
                notValidColor = true;
            }
        });
        let errors = [];
        if (emptyTag) {
            errors.push(gettext('Tag must not be empty.'));
        }
        if (notValidColor) {
            errors.push(gettext('Not a valid color.'));
        }
        return errors;
    },

    // override framework function to implement deleteEmpty behaviour
    getSubmitData: function () {
        let me = this,
            data = null,
            val;
        if (!me.disabled && me.submitValue) {
            val = me.getValue();
            if (val !== null && val !== '') {
                data = {};
                data[me.getName()] = val;
            } else if (me.getDeleteEmpty()) {
                data = {};
                data.delete = me.getName();
            }
        }
        return data;
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        addLine: function () {
            let me = this;
            me.getView().getStore().add({
                tag: '',
                color: '',
                text: '',
            });
        },

        removeSelection: function () {
            let me = this;
            let view = me.getView();
            let selection = view.getSelection();
            if (selection === undefined) {
                return;
            }

            selection.forEach((sel) => {
                view.getStore().remove(sel);
            });
            view.checkChange();
        },

        tagChange: function (field, newValue, oldValue) {
            let me = this;
            let rec = field.getWidgetRecord();
            if (!rec) {
                return;
            }
            if (newValue && newValue !== oldValue) {
                let newrgb = Proxmox.Utils.stringToRGB(newValue);
                let newvalue = Proxmox.Utils.rgbToHex(newrgb);
                if (!rec.get('color')) {
                    rec.set('color', newvalue);
                } else if (oldValue) {
                    let oldrgb = Proxmox.Utils.stringToRGB(oldValue);
                    let oldvalue = Proxmox.Utils.rgbToHex(oldrgb);
                    if (rec.get('color') === oldvalue) {
                        rec.set('color', newvalue);
                    }
                }
            }
            me.fieldChange(field, newValue, oldValue);
        },

        backgroundChange: function (field, newValue, oldValue) {
            let me = this;
            let rec = field.getWidgetRecord();
            if (!rec) {
                return;
            }
            if (newValue && newValue !== oldValue) {
                let newrgb = Proxmox.Utils.hexToRGB(newValue);
                let newcls = Proxmox.Utils.getTextContrastClass(newrgb);
                let hexvalue = newcls === 'dark' ? '000000' : 'FFFFFF';
                if (!rec.get('text')) {
                    rec.set('text', hexvalue);
                } else if (oldValue) {
                    let oldrgb = Proxmox.Utils.hexToRGB(oldValue);
                    let oldcls = Proxmox.Utils.getTextContrastClass(oldrgb);
                    let oldvalue = oldcls === 'dark' ? '000000' : 'FFFFFF';
                    if (rec.get('text') === oldvalue) {
                        rec.set('text', hexvalue);
                    }
                }
            }
            me.fieldChange(field, newValue, oldValue);
        },

        fieldChange: function (field, newValue, oldValue) {
            let me = this;
            let view = me.getView();
            let rec = field.getWidgetRecord();
            if (!rec) {
                return;
            }
            let column = field.getWidgetColumn();
            rec.set(column.dataIndex, newValue);
            view.checkChange();
        },
    },

    tbar: [
        {
            text: gettext('Add'),
            handler: 'addLine',
        },
        {
            xtype: 'proxmoxButton',
            text: gettext('Remove'),
            handler: 'removeSelection',
            disabled: true,
        },
    ],

    columns: [
        {
            header: 'Tag',
            dataIndex: 'tag',
            xtype: 'widgetcolumn',
            onWidgetAttach: function (col, widget, rec) {
                widget.getStore().setData(PVE.UIOptions.tagList.map((v) => ({ tag: v })));
            },
            widget: {
                xtype: 'combobox',
                isFormField: false,
                maskRe: PVE.Utils.tagCharRegex,
                allowBlank: false,
                queryMode: 'local',
                displayField: 'tag',
                valueField: 'tag',
                store: {},
                listeners: {
                    change: 'tagChange',
                },
            },
            flex: 1,
        },
        {
            header: gettext('Background'),
            xtype: 'widgetcolumn',
            flex: 1,
            dataIndex: 'color',
            widget: {
                xtype: 'pveColorPicker',
                isFormField: false,
                listeners: {
                    change: 'backgroundChange',
                },
            },
        },
        {
            header: gettext('Text'),
            xtype: 'widgetcolumn',
            flex: 1,
            dataIndex: 'text',
            widget: {
                xtype: 'pveColorPicker',
                allowBlank: true,
                isFormField: false,
                listeners: {
                    change: 'fieldChange',
                },
            },
        },
    ],

    store: {
        listeners: {
            update: function () {
                this.commitChanges();
            },
        },
    },

    initComponent: function () {
        let me = this;
        me.callParent();
        me.initField();
    },
});
Ext.define('PVE.form.ListField', {
    extend: 'Ext.container.Container',
    alias: 'widget.pveListField',

    mixins: ['Ext.form.field.Field'],

    // override for column header
    fieldTitle: gettext('Item'),

    // will be applied to the textfields
    maskRe: undefined,

    allowBlank: true,
    selectAll: false,
    isFormField: true,
    deleteEmpty: false,
    config: {
        deleteEmpty: false,
    },

    setValue: function (list) {
        let me = this;
        list = Ext.isArray(list) ? list : (list ?? '').split(';').filter((t) => t !== '');

        let store = me.lookup('grid').getStore();
        if (list.length > 0) {
            store.setData(list.map((item) => ({ item })));
        } else {
            store.removeAll();
        }
        me.checkChange();
        return me;
    },

    getValue: function () {
        let me = this;
        let values = [];
        me.lookup('grid')
            .getStore()
            .each((rec) => {
                if (rec.data.item) {
                    values.push(rec.data.item);
                }
            });
        return values.join(';');
    },

    getErrors: function (value) {
        let me = this;
        let empty = false;
        me.lookup('grid')
            .getStore()
            .each((rec) => {
                if (!rec.data.item) {
                    empty = true;
                }
            });
        if (empty) {
            return [gettext('Tag must not be empty.')];
        }
        return [];
    },

    // override framework function to implement deleteEmpty behaviour
    getSubmitData: function () {
        let me = this,
            data = null,
            val;
        if (!me.disabled && me.submitValue) {
            val = me.getValue();
            if (val !== null && val !== '') {
                data = {};
                data[me.getName()] = val;
            } else if (me.getDeleteEmpty()) {
                data = {};
                data.delete = me.getName();
            }
        }
        return data;
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        addLine: function () {
            let me = this;
            me.lookup('grid').getStore().add({
                item: '',
            });
        },

        removeSelection: function (field) {
            let me = this;
            let view = me.getView();
            let grid = me.lookup('grid');

            let record = field.getWidgetRecord();
            if (record === undefined) {
                // this is sometimes called before a record/column is initialized
                return;
            }

            grid.getStore().remove(record);
            view.checkChange();
            view.validate();
        },

        itemChange: function (field, newValue) {
            let rec = field.getWidgetRecord();
            if (!rec) {
                return;
            }
            let column = field.getWidgetColumn();
            rec.set(column.dataIndex, newValue);
            let list = field.up('pveListField');
            list.checkChange();
            list.validate();
        },

        control: {
            'grid button': {
                click: 'removeSelection',
            },
        },
    },

    items: [
        {
            xtype: 'grid',
            reference: 'grid',

            viewConfig: {
                deferEmptyText: false,
            },

            store: {
                listeners: {
                    update: function () {
                        this.commitChanges();
                    },
                },
            },
        },
        {
            xtype: 'button',
            text: gettext('Add'),
            iconCls: 'fa fa-plus-circle',
            handler: 'addLine',
            margin: '5 0 0 0',
        },
    ],

    initComponent: function () {
        let me = this;

        for (const [key, value] of Object.entries(me.gridConfig ?? {})) {
            me.items[0][key] = value;
        }

        me.items[0].columns = [
            {
                header: me.fieldTtitle,
                dataIndex: 'item',
                xtype: 'widgetcolumn',
                widget: {
                    xtype: 'textfield',
                    isFormField: false,
                    maskRe: me.maskRe,
                    allowBlank: false,
                    queryMode: 'local',
                    listeners: {
                        change: 'itemChange',
                    },
                },
                flex: 1,
            },
            {
                xtype: 'widgetcolumn',
                width: 40,
                widget: {
                    xtype: 'button',
                    iconCls: 'fa fa-trash-o',
                },
            },
        ];

        me.callParent();
        me.initField();
    },
});
Ext.define('Proxmox.form.Tag', {
    extend: 'Ext.Component',
    alias: 'widget.pveTag',

    mode: 'editable',

    tag: '',
    cls: 'pve-edit-tag',

    tpl: [
        '<i class="handle fa fa-bars"></i>',
        '<span>{tag}</span>',
        '<i class="action fa fa-minus-square"></i>',
    ],

    focusable: true,
    getFocusEl: function () {
        return Ext.get(this.tagEl());
    },

    onFocus: function () {
        this.selectText();
    },

    // contains tags not to show in the picker and not allowing to set
    filter: [],

    updateFilter: function (tags) {
        this.filter = tags;
    },

    onClick: function (event) {
        let me = this;
        if (event.target.tagName === 'I' && !event.target.classList.contains('handle')) {
            if (me.mode === 'editable') {
                me.destroy();
                return;
            }
        } else if (event.target.tagName !== 'SPAN' || me.mode !== 'editable') {
            return;
        }
        me.selectText();
    },

    selectText: function (collapseToEnd) {
        let me = this;
        let tagEl = me.tagEl();
        tagEl.contentEditable = true;
        let range = document.createRange();
        range.selectNodeContents(tagEl);
        if (collapseToEnd) {
            range.collapse(false);
        }
        let sel = window.getSelection();
        sel.removeAllRanges();
        sel.addRange(range);

        me.showPicker();
    },

    showPicker: function () {
        let me = this;
        if (!me.picker) {
            me.picker = Ext.widget({
                xtype: 'boundlist',
                minWidth: 70,
                scrollable: true,
                floating: true,
                hidden: true,
                userCls: 'proxmox-tags-full',
                displayField: 'tag',
                itemTpl: [
                    '{[Proxmox.Utils.getTagElement(values.tag, PVE.UIOptions.tagOverrides)]}',
                ],
                store: [],
                listeners: {
                    select: function (picker, rec) {
                        me.tagEl().innerHTML = rec.data.tag;
                        me.setTag(rec.data.tag, true);
                        me.selectText(true);
                        me.setColor(rec.data.tag);
                        me.picker.hide();
                    },
                },
            });
        }
        me.picker.getStore()?.clearFilter();
        let taglist = PVE.UIOptions.tagList
            .filter((v) => !me.filter.includes(v))
            .map((v) => ({ tag: v }));
        if (taglist.length < 1) {
            return;
        }
        me.picker.getStore().setData(taglist);
        me.picker.showBy(me, 'tl-bl');
        me.picker.setMaxHeight(200);
    },

    setMode: function (mode) {
        let me = this;
        let tagEl = me.tagEl();
        if (tagEl) {
            tagEl.contentEditable = mode === 'editable';
        }
        me.removeCls(me.mode);
        me.addCls(mode);
        me.mode = mode;
        if (me.mode !== 'editable') {
            me.picker?.hide();
        }
    },

    onKeyPress: function (event) {
        let me = this;
        let key = event.browserEvent.key;
        switch (key) {
            case 'Enter':
            case 'Escape':
                me.fireEvent('keypress', key);
                break;
            case 'ArrowLeft':
            case 'ArrowRight':
            case 'Backspace':
            case 'Delete':
                return;
            default:
                if (key.match(PVE.Utils.tagCharRegex)) {
                    return;
                }
                me.setTag(me.tagEl().innerHTML);
        }
        event.browserEvent.preventDefault();
        event.browserEvent.stopPropagation();
    },

    // for pasting text
    beforeInput: function (event) {
        let me = this;
        me.updateLayout();
        let tag = event.event.data ?? event.event.dataTransfer?.getData('text/plain');
        if (!tag) {
            return;
        }
        if (tag.match(PVE.Utils.tagCharRegex) === null) {
            event.event.preventDefault();
            event.event.stopPropagation();
        }
    },

    onInput: function (event) {
        let me = this;
        me.picker.getStore().filter({
            property: 'tag',
            value: me.tagEl().innerHTML,
            anyMatch: true,
        });
        me.setTag(me.tagEl().innerHTML);
    },

    lostFocus: function (list, event) {
        let me = this;
        me.picker?.hide();
        window.getSelection().removeAllRanges();
    },

    setColor: function (tag) {
        let me = this;
        let rgb = PVE.UIOptions.tagOverrides[tag] ?? Proxmox.Utils.stringToRGB(tag);

        let cls = Proxmox.Utils.getTextContrastClass(rgb);
        let color = Proxmox.Utils.rgbToCss(rgb);
        me.setUserCls(`proxmox-tag-${cls}`);
        me.setStyle('background-color', color);
        if (rgb.length > 3) {
            let fgcolor = Proxmox.Utils.rgbToCss([rgb[3], rgb[4], rgb[5]]);

            me.setStyle('color', fgcolor);
        } else {
            me.setStyle('color');
        }
    },

    setTag: function (tag) {
        let me = this;
        let oldtag = me.tag;
        me.tag = tag;

        clearTimeout(me.colorTimeout);
        me.colorTimeout = setTimeout(() => me.setColor(tag), 200);

        me.updateLayout();
        if (oldtag !== tag) {
            me.fireEvent('change', me, tag, oldtag);
        }
    },

    tagEl: function () {
        return this.el?.dom?.getElementsByTagName('span')?.[0];
    },

    listeners: {
        click: 'onClick',
        focusleave: 'lostFocus',
        keydown: 'onKeyPress',
        beforeInput: 'beforeInput',
        input: 'onInput',
        element: 'el',
        scope: 'this',
    },

    initComponent: function () {
        let me = this;

        me.data = {
            tag: me.tag,
        };

        me.setTag(me.tag);
        me.setColor(me.tag);
        me.setMode(me.mode ?? 'normal');
        me.callParent();
    },

    destroy: function () {
        let me = this;
        if (me.picker) {
            Ext.destroy(me.picker);
        }
        clearTimeout(me.colorTimeout);
        me.callParent();
    },
});
Ext.define('PVE.panel.TagEditContainer', {
    extend: 'Ext.container.Container',
    alias: 'widget.pveTagEditContainer',

    layout: {
        type: 'hbox',
        align: 'middle',
    },

    // set to false to hide the 'no tags' field and the edit button
    canEdit: true,
    editOnly: false,

    controller: {
        xclass: 'Ext.app.ViewController',

        loadTags: function (tagstring = '', force = false) {
            let me = this;
            let view = me.getView();

            if (me.oldTags === tagstring && !force) {
                return;
            }

            view.suspendLayout = true;
            me.forEachTag((tag) => {
                view.remove(tag);
            });
            me.getViewModel().set('tagCount', 0);
            let newtags = tagstring.split(/[;, ]/).filter((t) => !!t) || [];
            newtags.forEach((tag) => {
                me.addTag(tag);
            });
            view.suspendLayout = false;
            view.updateLayout();
            if (!force) {
                me.oldTags = tagstring;
            }
            me.tagsChanged();
        },

        onRender: function (v) {
            let me = this;
            let view = me.getView();
            view.toggleCls('hide-handles', PVE.UIOptions.shouldSortTags());

            view.dragzone = Ext.create('Ext.dd.DragZone', v.getEl(), {
                getDragData: function (e) {
                    let source = e.getTarget('.handle');
                    if (!source) {
                        return undefined;
                    }
                    let sourceId = source.parentNode.id;
                    let cmp = Ext.getCmp(sourceId);
                    let ddel = document.createElement('div');
                    ddel.classList.add('proxmox-tags-full');
                    ddel.innerHTML = Proxmox.Utils.getTagElement(
                        cmp.tag,
                        PVE.UIOptions.tagOverrides,
                    );
                    let repairXY = Ext.fly(source).getXY();
                    cmp.setDisabled(true);
                    ddel.id = Ext.id();
                    return {
                        ddel,
                        repairXY,
                        sourceId,
                    };
                },
                onMouseUp: function (target, e, id) {
                    let cmp = Ext.getCmp(this.dragData.sourceId);
                    if (cmp && !cmp.isDestroyed) {
                        cmp.setDisabled(false);
                    }
                },
                getRepairXY: function () {
                    return this.dragData.repairXY;
                },
                beforeInvalidDrop: function (target, e, id) {
                    let cmp = Ext.getCmp(this.dragData.sourceId);
                    if (cmp && !cmp.isDestroyed) {
                        cmp.setDisabled(false);
                    }
                },
            });
            view.dropzone = Ext.create('Ext.dd.DropZone', v.getEl(), {
                getTargetFromEvent: function (e) {
                    return e.getTarget('.proxmox-tag-dark,.proxmox-tag-light');
                },
                getIndicator: function () {
                    if (!view.indicator) {
                        view.indicator = Ext.create('Ext.Component', {
                            floating: true,
                            html: '<i class="fa fa-long-arrow-up"></i>',
                            hidden: true,
                            shadow: false,
                        });
                    }
                    return view.indicator;
                },
                onContainerOver: function () {
                    this.getIndicator().setVisible(false);
                },
                notifyOut: function () {
                    this.getIndicator().setVisible(false);
                },
                onNodeOver: function (target, dd, e, data) {
                    let indicator = this.getIndicator();
                    indicator.setVisible(true);
                    indicator.alignTo(Ext.getCmp(target.id), 't50-bl', [-1, -2]);
                    return this.dropAllowed;
                },
                onNodeDrop: function (target, dd, e, data) {
                    this.getIndicator().setVisible(false);
                    let sourceCmp = Ext.getCmp(data.sourceId);
                    if (!sourceCmp) {
                        return;
                    }
                    sourceCmp.setDisabled(false);
                    let targetCmp = Ext.getCmp(target.id);
                    view.remove(sourceCmp, { destroy: false });
                    view.insert(view.items.indexOf(targetCmp), sourceCmp);
                    me.tagsChanged();
                },
            });
        },

        forEachTag: function (func) {
            let me = this;
            let view = me.getView();
            view.items.each((field) => {
                if (field.getXType() === 'pveTag') {
                    func(field);
                }
                return true;
            });
        },

        toggleEdit: function (cancel) {
            let me = this;
            let vm = me.getViewModel();
            let view = me.getView();
            let editMode = !vm.get('editMode');
            vm.set('editMode', editMode);

            // get a current tag list for editing
            if (editMode) {
                PVE.UIOptions.update();
            }

            me.forEachTag((tag) => {
                tag.setMode(editMode ? 'editable' : 'normal');
            });

            if (!vm.get('editMode')) {
                let tags = [];
                if (cancel) {
                    me.loadTags(me.oldTags, true);
                } else {
                    let toRemove = [];
                    me.forEachTag((cmp) => {
                        if (cmp.isVisible() && cmp.tag) {
                            tags.push(cmp.tag);
                        } else {
                            toRemove.push(cmp);
                        }
                    });
                    toRemove.forEach((cmp) => view.remove(cmp));
                    tags = tags.join(',');
                    if (me.oldTags !== tags) {
                        me.oldTags = tags;
                        me.loadTags(tags, true);
                        me.getView().fireEvent('change', tags);
                    }
                }
            }
            me.getView().updateLayout();
        },

        tagsChanged: function () {
            let me = this;
            let tags = [];
            me.forEachTag((cmp) => {
                if (cmp.tag) {
                    tags.push(cmp.tag);
                }
            });
            me.getViewModel().set('isDirty', me.oldTags !== tags.join(','));
            me.forEachTag((cmp) => {
                cmp.updateFilter(tags);
            });
        },

        addTag: function (tag, isNew) {
            let me = this;
            let view = me.getView();
            let vm = me.getViewModel();
            let index = view.items.length - 5;
            if (PVE.UIOptions.shouldSortTags() && !isNew) {
                index = view.items.findIndexBy((tagField) => {
                    if (tagField.reference === 'noTagsField') {
                        return false;
                    }
                    if (tagField.xtype !== 'pveTag') {
                        return true;
                    }
                    let a = tagField.tag.toLowerCase();
                    let b = tag.toLowerCase();
                    return a > b ? true : a < b ? false : tagField.tag.localeCompare(tag) > 0;
                }, 1);
            }
            let tagField = view.insert(index, {
                xtype: 'pveTag',
                tag,
                mode: vm.get('editMode') ? 'editable' : 'normal',
                listeners: {
                    change: 'tagsChanged',
                    destroy: function () {
                        vm.set('tagCount', vm.get('tagCount') - 1);
                        me.tagsChanged();
                    },
                    keypress: function (key) {
                        if (vm.get('hideFinishButtons')) {
                            return;
                        }
                        if (key === 'Enter') {
                            me.editClick();
                        } else if (key === 'Escape') {
                            me.cancelClick();
                        }
                    },
                },
            });

            if (isNew) {
                me.tagsChanged();
                tagField.selectText();
            }

            vm.set('tagCount', vm.get('tagCount') + 1);
        },

        addTagClick: function (event) {
            let me = this;
            me.lookup('noTagsField').setVisible(false);
            me.addTag('', true);
        },

        cancelClick: function () {
            this.toggleEdit(true);
        },

        editClick: function () {
            this.toggleEdit(false);
        },

        init: function (view) {
            let me = this;
            if (view.tags) {
                me.loadTags(view.tags);
            }
            me.getViewModel().set('canEdit', view.canEdit);
            me.getViewModel().set('editOnly', view.editOnly);

            me.mon(Ext.GlobalEvents, 'loadedUiOptions', () => {
                let vm = me.getViewModel();
                view.toggleCls('hide-handles', PVE.UIOptions.shouldSortTags());
                me.loadTags(me.oldTags, !vm.get('editMode')); // refresh tag colors and order
            });

            if (view.editOnly) {
                me.toggleEdit();
            }
        },
    },

    getTags: function () {
        let me = this;
        let controller = me.getController();
        let tags = [];
        controller.forEachTag((cmp) => {
            if (cmp.tag.length) {
                tags.push(cmp.tag);
            }
        });

        return tags;
    },

    viewModel: {
        data: {
            tagCount: 0,
            editMode: false,
            canEdit: true,
            isDirty: false,
            editOnly: true,
        },

        formulas: {
            hideNoTags: function (get) {
                return get('tagCount') !== 0 || !get('canEdit');
            },
            hideEditBtn: function (get) {
                return get('editMode') || !get('canEdit');
            },
            hideFinishButtons: function (get) {
                return !get('editMode') || get('editOnly');
            },
        },
    },

    loadTags: function () {
        return this.getController().loadTags(...arguments);
    },

    items: [
        {
            xtype: 'box',
            reference: 'noTagsField',
            bind: {
                hidden: '{hideNoTags}',
            },
            html: gettext('No Tags'),
            style: {
                opacity: 0.5,
            },
        },
        {
            xtype: 'button',
            iconCls: 'fa fa-plus',
            tooltip: gettext('Add Tag'),
            bind: {
                hidden: '{!editMode}',
            },
            hidden: true,
            margin: '0 8 0 5',
            ui: 'default-toolbar',
            handler: 'addTagClick',
        },
        {
            xtype: 'tbseparator',
            ui: 'horizontal',
            bind: {
                hidden: '{hideFinishButtons}',
            },
            hidden: true,
        },
        {
            xtype: 'button',
            iconCls: 'fa fa-times',
            tooltip: gettext('Cancel Edit'),
            bind: {
                hidden: '{hideFinishButtons}',
            },
            hidden: true,
            margin: '0 5 0 0',
            ui: 'default-toolbar',
            handler: 'cancelClick',
        },
        {
            xtype: 'button',
            iconCls: 'fa fa-check',
            tooltip: gettext('Finish Edit'),
            bind: {
                hidden: '{hideFinishButtons}',
                disabled: '{!isDirty}',
            },
            hidden: true,
            handler: 'editClick',
        },
        {
            xtype: 'box',
            cls: 'pve-tag-inline-button',
            html: `<i data-qtip="${gettext('Edit Tags')}" class="fa fa-pencil"></i>`,
            bind: {
                hidden: '{hideEditBtn}',
            },
            listeners: {
                click: 'editClick',
                element: 'el',
            },
        },
    ],

    listeners: {
        render: 'onRender',
    },

    destroy: function () {
        let me = this;
        Ext.destroy(me.dragzone);
        Ext.destroy(me.dropzone);
        Ext.destroy(me.indicator);
        me.callParent();
    },
});
// mostly copied from ExtJS FileButton, but added 'multiple' at the relevant
// places so we have a file picker where one can select multiple files
// changes are marked with an 'pmx:' comment
Ext.define('PVE.form.MultiFileButton', {
    extend: 'Ext.form.field.FileButton',
    alias: 'widget.pveMultiFileButton',

    afterTpl: [
        '<input id="{id}-fileInputEl" data-ref="fileInputEl" class="{childElCls} {inputCls}" ',
        'type="file" size="1" name="{inputName}" unselectable="on" multiple ', // pmx: added multiple
        '<tpl if="accept != null">accept="{accept}"</tpl>',
        '<tpl if="tabIndex != null">tabindex="{tabIndex}"</tpl>',
        '>',
    ],

    createFileInput: function (isTemporary) {
        var me = this,
            fileInputEl,
            listeners;

        fileInputEl = me.fileInputEl = me.el.createChild(
            {
                name: me.inputName || me.id,
                multiple: true, // pmx: added multiple option
                id: !isTemporary ? me.id + '-fileInputEl' : undefined,
                cls: me.inputCls + (me.getInherited().rtl ? ' ' + Ext.baseCSSPrefix + 'rtl' : ''),
                tag: 'input',
                type: 'file',
                size: 1,
                unselectable: 'on',
            },
            me.afterInputGuard,
        ); // Nothing special happens outside of IE/Edge

        // This is our focusEl
        fileInputEl.dom.setAttribute('data-componentid', me.id);

        if (me.tabIndex !== null) {
            me.setTabIndex(me.tabIndex);
        }

        if (me.accept) {
            fileInputEl.dom.setAttribute('accept', me.accept);
        }

        // We place focus and blur listeners on fileInputEl to activate Button's
        // focus and blur style treatment
        listeners = {
            scope: me,
            change: me.fireChange,
            mousedown: me.handlePrompt,
            keydown: me.handlePrompt,
            focus: me.onFileFocus,
            blur: me.onFileBlur,
        };

        if (me.useTabGuards) {
            listeners.keydown = me.onFileInputKeydown;
        }

        fileInputEl.on(listeners);
    },
});
Ext.define('PVE.form.TagFieldSet', {
    extend: 'Ext.form.FieldSet',
    alias: 'widget.pveTagFieldSet',
    mixins: ['Ext.form.field.Field'],

    title: gettext('Tags'),
    padding: '0 5 5 5',

    getValue: function () {
        let me = this;
        let tags = me
            .down('pveTagEditContainer')
            .getTags()
            .filter((t) => t !== '');
        return tags.join(';');
    },

    setValue: function (value) {
        let me = this;
        value ??= [];
        if (!Ext.isArray(value)) {
            value = value.split(/[;, ]/).filter((t) => t !== '');
        }
        me.down('pveTagEditContainer').loadTags(value.join(';'));
    },

    getErrors: function (value) {
        value ??= [];
        if (!Ext.isArray(value)) {
            value = value.split(/[;, ]/).filter((t) => t !== '');
        }
        if (value.some((t) => !t.match(PVE.Utils.tagCharRegex))) {
            return [gettext('Tags contain invalid characters.')];
        }
        return [];
    },

    getSubmitData: function () {
        let me = this;
        let value = me.getValue();
        if (me.disabled || !me.submitValue || value === '') {
            return null;
        }
        let data = {};
        data[me.getName()] = value;
        return data;
    },

    layout: 'fit',

    items: [
        {
            xtype: 'pveTagEditContainer',
            userCls: 'proxmox-tags-full proxmox-tag-fieldset',
            editOnly: true,
            allowBlank: true,
            layout: 'column',
            scrollable: true,
        },
    ],

    initComponent: function () {
        let me = this;
        me.callParent();
        me.initField();
    },
});
Ext.define('PVE.form.IsoSelector', {
    extend: 'Ext.container.Container',
    alias: 'widget.pveIsoSelector',
    mixins: ['Ext.form.field.Field', 'Proxmox.Mixin.CBind'],

    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    nodename: undefined,
    insideWizard: false,
    labelWidth: undefined,
    labelAlign: 'right',

    cbindData: function () {
        let me = this;
        return {
            nodename: me.nodename,
            insideWizard: me.insideWizard,
        };
    },

    getValue: function () {
        return this.lookup('file').getValue();
    },

    setValue: function (value) {
        let me = this;
        if (!value) {
            me.lookup('file').reset();
            return;
        }
        var match = value.match(/^([^:]+):/);
        if (match) {
            me.lookup('storage').setValue(match[1]);
            me.lookup('file').setValue(value);
        }
    },

    getErrors: function () {
        let me = this;
        me.lookup('storage').validate();
        let file = me.lookup('file');
        file.validate();
        let value = file.getValue();
        if (!value || !value.length) {
            return ['']; // for validation
        }
        return [];
    },

    setNodename: function (nodename) {
        let me = this;
        me.lookup('storage').setNodename(nodename);
        me.lookup('file').setStorage(undefined, nodename);
    },

    setDisabled: function (disabled) {
        let me = this;
        me.lookup('storage').setDisabled(disabled);
        me.lookup('file').setDisabled(disabled);
        return me.callParent([disabled]);
    },

    referenceHolder: true,

    items: [
        {
            xtype: 'pveStorageSelector',
            reference: 'storage',
            isFormField: false,
            fieldLabel: gettext('Storage'),
            storageContent: 'iso',
            allowBlank: false,
            cbind: {
                nodename: '{nodename}',
                autoSelect: '{insideWizard}',
                insideWizard: '{insideWizard}',
                disabled: '{disabled}',
                labelWidth: '{labelWidth}',
                labelAlign: '{labelAlign}',
            },
            listeners: {
                change: function (f, value) {
                    let me = this;
                    let selector = me.up('pveIsoSelector');
                    selector.lookup('file').setStorage(value);
                    selector.checkChange();
                },
            },
        },
        {
            xtype: 'pveFileSelector',
            reference: 'file',
            isFormField: false,
            storageContent: 'iso',
            fieldLabel: gettext('ISO image'),
            labelAlign: 'right',
            cbind: {
                nodename: '{nodename}',
                disabled: '{disabled}',
                labelWidth: '{labelWidth}',
                labelAlign: '{labelAlign}',
            },
            allowBlank: false,
            listeners: {
                change: function () {
                    this.up('pveIsoSelector').checkChange();
                },
            },
        },
    ],
});
Ext.define('PVE.grid.BackupView', {
    extend: 'Ext.grid.GridPanel',

    alias: ['widget.pveBackupView'],

    onlineHelp: 'chapter_vzdump',

    stateful: true,
    stateId: 'grid-guest-backup',

    initComponent: function () {
        var me = this;

        var nodename = me.pveSelNode.data.node;
        if (!nodename) {
            throw 'no node name specified';
        }

        var vmid = me.pveSelNode.data.vmid;
        if (!vmid) {
            throw 'no VM ID specified';
        }

        var vmtype = me.pveSelNode.data.type;
        if (!vmtype) {
            throw 'no VM type specified';
        }

        var vmtypeFilter;
        if (vmtype === 'lxc' || vmtype === 'openvz') {
            vmtypeFilter = function (item) {
                return PVE.Utils.volume_is_lxc_backup(item.data);
            };
        } else if (vmtype === 'qemu') {
            vmtypeFilter = function (item) {
                return PVE.Utils.volume_is_qemu_backup(item.data);
            };
        } else {
            throw "unsupported VM type '" + vmtype + "'";
        }

        let vmname = me.pveSelNode.data.name;

        var searchFilter = {
            property: 'volid',
            value: '',
            anyMatch: true,
            caseSensitive: false,
        };

        var vmidFilter = {
            property: 'vmid',
            value: vmid,
            exactMatch: true,
        };

        me.store = Ext.create('Ext.data.Store', {
            model: 'pve-storage-content',
            sorters: [
                {
                    property: 'vmid',
                    direction: 'ASC',
                },
                {
                    property: 'vdate',
                    direction: 'DESC',
                },
            ],
            filters: [vmtypeFilter, searchFilter, vmidFilter],
        });

        let updateFilter = function () {
            me.store.filter([vmtypeFilter, searchFilter, vmidFilter]);
        };

        const reload = Ext.Function.createBuffered((options) => {
            if (me.store) {
                me.store.load(options);
            }
        }, 100);

        let isPBS = false;
        var setStorage = function (storage) {
            var url = '/api2/json/nodes/' + nodename + '/storage/' + storage + '/content';
            url += '?content=backup';

            me.store.setProxy({
                type: 'proxmox',
                url: url,
            });

            Proxmox.Utils.monStoreErrors(me.view, me.store, true);

            reload();
        };

        let file_restore_btn;

        var storagesel = Ext.create('PVE.form.StorageSelector', {
            nodename: nodename,
            fieldLabel: gettext('Storage'),
            labelAlign: 'right',
            storageContent: 'backup',
            allowBlank: false,
            listeners: {
                change: function (f, value) {
                    let storage = f.getStore().findRecord('storage', value, 0, false, true, true);
                    if (storage) {
                        isPBS = storage.data.type === 'pbs';
                        me.getColumns().forEach((column) => {
                            let id = column.dataIndex;
                            if (id === 'verification' || id === 'encrypted') {
                                column.setHidden(!isPBS);
                            }
                        });
                    } else {
                        isPBS = false;
                    }
                    setStorage(value);
                    if (file_restore_btn) {
                        file_restore_btn.setHidden(!isPBS);
                    }
                },
            },
        });

        var storagefilter = Ext.create('Ext.form.field.Text', {
            fieldLabel: gettext('Search'),
            labelWidth: 50,
            labelAlign: 'right',
            enableKeyEvents: true,
            value: searchFilter.value,
            listeners: {
                buffer: 500,
                keyup: function (field) {
                    me.store.clearFilter(true);
                    searchFilter.value = field.getValue();
                    updateFilter();
                },
            },
        });

        var vmidfilterCB = Ext.create('Ext.form.field.Checkbox', {
            boxLabel: gettext('Filter VMID'),
            value: '1',
            listeners: {
                change: function (cb, value) {
                    vmidFilter.value = value ? vmid : '';
                    vmidFilter.exactMatch = !!value;
                    updateFilter();
                },
            },
        });

        var sm = Ext.create('Ext.selection.RowModel', {});

        var backup_btn = Ext.create('Ext.button.Button', {
            text: gettext('Backup now'),
            handler: function () {
                var win = Ext.create('PVE.window.Backup', {
                    nodename: nodename,
                    vmid: vmid,
                    vmtype: vmtype,
                    vmname: vmname,
                    storage: storagesel.getValue(),
                    listeners: {
                        close: function () {
                            reload();
                        },
                    },
                });
                win.show();
            },
        });

        var restore_btn = Ext.create('Proxmox.button.Button', {
            text: gettext('Restore'),
            disabled: true,
            selModel: sm,
            enableFn: function (rec) {
                return !!rec;
            },
            handler: function (b, e, rec) {
                let win = Ext.create('PVE.window.Restore', {
                    nodename: nodename,
                    vmid: vmid,
                    vmname: vmname,
                    volid: rec.data.volid,
                    volidText: PVE.Utils.render_storage_content(rec.data.volid, {}, rec),
                    vmtype: vmtype,
                    isPBS: isPBS,
                });
                win.show();
                win.on('destroy', reload);
            },
        });

        let delete_btn = Ext.create('Proxmox.button.StdRemoveButton', {
            selModel: sm,
            dangerous: true,
            delay: 5,
            enableFn: (rec) => !rec?.data?.protected,
            confirmMsg: ({ data }) => {
                let msg = Ext.String.format(
                    gettext('Are you sure you want to remove entry {0}'),
                    `'${data.volid}'`,
                );
                return msg + ' ' + gettext('This will permanently erase all data.');
            },
            getUrl: ({ data }) =>
                `/nodes/${nodename}/storage/${storagesel.getValue()}/content/${data.volid}`,
            callback: () => reload(),
        });

        let config_btn = Ext.create('Proxmox.button.Button', {
            text: gettext('Show Configuration'),
            disabled: true,
            selModel: sm,
            enableFn: (rec) => !!rec,
            handler: function (b, e, rec) {
                let storage = storagesel.getValue();
                if (!storage) {
                    return;
                }
                Ext.create('PVE.window.BackupConfig', {
                    volume: rec.data.volid,
                    pveSelNode: me.pveSelNode,
                    autoShow: true,
                });
            },
        });

        // declared above so that the storage selector can change this buttons hidden state
        file_restore_btn = Ext.create('Proxmox.button.Button', {
            text: gettext('File Restore'),
            disabled: true,
            selModel: sm,
            enableFn: (rec) => !!rec && isPBS,
            hidden: !isPBS,
            handler: function (b, e, rec) {
                let storage = storagesel.getValue();
                let isVMArchive = PVE.Utils.volume_is_qemu_backup(rec.data.volid, rec.data.format);
                Ext.create('Proxmox.window.FileBrowser', {
                    title: gettext('File Restore') + ' - ' + rec.data.text,
                    listURL: `/api2/json/nodes/localhost/storage/${storage}/file-restore/list`,
                    downloadURL: `/api2/json/nodes/localhost/storage/${storage}/file-restore/download`,
                    extraParams: {
                        volume: rec.data.volid,
                    },
                    archive: isVMArchive ? 'all' : undefined,
                    autoShow: true,
                });
            },
        });

        Ext.apply(me, {
            selModel: sm,
            tbar: {
                overflowHandler: 'scroller',
                items: [
                    backup_btn,
                    '-',
                    restore_btn,
                    file_restore_btn,
                    config_btn,
                    {
                        xtype: 'proxmoxButton',
                        text: gettext('Edit Notes'),
                        disabled: true,
                        handler: function () {
                            let volid = sm.getSelection()[0].data.volid;
                            var storage = storagesel.getValue();
                            Ext.create('Proxmox.window.Edit', {
                                autoLoad: true,
                                width: 600,
                                height: 400,
                                resizable: true,
                                title: gettext('Notes'),
                                url: `/api2/extjs/nodes/${nodename}/storage/${storage}/content/${volid}`,
                                layout: 'fit',
                                items: [
                                    {
                                        xtype: 'textarea',
                                        layout: 'fit',
                                        name: 'notes',
                                        height: '100%',
                                    },
                                ],
                                listeners: {
                                    destroy: () => reload(),
                                },
                            }).show();
                        },
                    },
                    {
                        xtype: 'proxmoxButton',
                        text: gettext('Change Protection'),
                        disabled: true,
                        handler: function (button, event, record) {
                            let volid = record.data.volid,
                                storage = storagesel.getValue();
                            let url = `/api2/extjs/nodes/${nodename}/storage/${storage}/content/${volid}`;
                            Proxmox.Utils.API2Request({
                                url: url,
                                method: 'PUT',
                                waitMsgTarget: me,
                                params: {
                                    protected: record.data.protected ? 0 : 1,
                                },
                                failure: (response) => Ext.Msg.alert('Error', response.htmlStatus),
                                success: () => {
                                    reload({
                                        callback: () =>
                                            sm.fireEvent('selectionchange', sm, [record]),
                                    });
                                },
                            });
                        },
                    },
                    '-',
                    delete_btn,
                    '->',
                    storagesel,
                    '-',
                    vmidfilterCB,
                    storagefilter,
                ],
            },
            columns: [
                {
                    header: gettext('Name'),
                    flex: 2,
                    sortable: true,
                    renderer: PVE.Utils.render_storage_content,
                    dataIndex: 'volid',
                },
                {
                    header: gettext('Notes'),
                    dataIndex: 'notes',
                    flex: 1,
                    renderer: Ext.htmlEncode,
                },
                {
                    header: `<i class="fa fa-shield"></i>`,
                    tooltip: gettext('Protected'),
                    width: 30,
                    renderer: (v) =>
                        v ? `<i data-qtip="${gettext('Protected')}" class="fa fa-shield"></i>` : '',
                    sorter: (a, b) => (b.data.protected || 0) - (a.data.protected || 0),
                    dataIndex: 'protected',
                },
                {
                    header: gettext('Date'),
                    width: 150,
                    dataIndex: 'vdate',
                },
                {
                    header: gettext('Format'),
                    width: 100,
                    dataIndex: 'format',
                },
                {
                    header: gettext('Size'),
                    width: 100,
                    renderer: Proxmox.Utils.format_size,
                    dataIndex: 'size',
                },
                {
                    header: 'VMID',
                    dataIndex: 'vmid',
                    hidden: true,
                },
                {
                    header: gettext('Encrypted'),
                    dataIndex: 'encrypted',
                    renderer: PVE.Utils.render_backup_encryption,
                },
                {
                    header: gettext('Verify State'),
                    dataIndex: 'verification',
                    renderer: PVE.Utils.render_backup_verification,
                },
            ],
        });

        me.callParent();
    },
});
Ext.define('PVE.FirewallAliasEdit', {
    extend: 'Proxmox.window.Edit',

    base_url: undefined,

    alias_name: undefined,

    width: 400,

    initComponent: function () {
        let me = this;

        me.isCreate = me.alias_name === undefined;

        if (me.isCreate) {
            me.url = '/api2/extjs' + me.base_url;
            me.method = 'POST';
        } else {
            me.url = '/api2/extjs' + me.base_url + '/' + me.alias_name;
            me.method = 'PUT';
        }

        let ipanel = Ext.create('Proxmox.panel.InputPanel', {
            isCreate: me.isCreate,
            items: [
                {
                    xtype: 'textfield',
                    name: me.isCreate ? 'name' : 'rename',
                    fieldLabel: gettext('Name'),
                    allowBlank: false,
                },
                {
                    xtype: 'textfield',
                    name: 'cidr',
                    fieldLabel: gettext('IP/CIDR'),
                    allowBlank: false,
                },
                {
                    xtype: 'textfield',
                    name: 'comment',
                    fieldLabel: gettext('Comment'),
                },
            ],
        });

        Ext.apply(me, {
            subject: gettext('Alias'),
            isAdd: true,
            items: [ipanel],
        });

        me.callParent();

        if (!me.isCreate) {
            me.load({
                success: function (response, options) {
                    let values = response.result.data;
                    values.rename = values.name;
                    ipanel.setValues(values);
                },
            });
        }
    },
});

Ext.define('pve-fw-aliases', {
    extend: 'Ext.data.Model',

    fields: ['name', 'cidr', 'comment', 'digest'],
    idProperty: 'name',
});

Ext.define('PVE.FirewallAliases', {
    extend: 'Ext.grid.Panel',
    alias: ['widget.pveFirewallAliases'],

    onlineHelp: 'pve_firewall_ip_aliases',

    stateful: true,
    stateId: 'grid-firewall-aliases',

    base_url: undefined,

    title: gettext('Alias'),

    initComponent: function () {
        let me = this;

        if (!me.base_url) {
            throw 'missing base_url configuration';
        }

        let store = new Ext.data.Store({
            model: 'pve-fw-aliases',
            proxy: {
                type: 'proxmox',
                url: '/api2/json' + me.base_url,
            },
            sorters: {
                property: 'name',
                direction: 'ASC',
            },
        });

        let sm = Ext.create('Ext.selection.RowModel', {});

        let caps = Ext.state.Manager.get('GuiCap');
        let canEdit =
            !!caps.vms['VM.Config.Network'] ||
            !!caps.dc['Sys.Modify'] ||
            !!caps.nodes['Sys.Modify'];

        let reload = function () {
            let oldrec = sm.getSelection()[0];
            store.load(function (records, operation, success) {
                if (oldrec) {
                    let rec = store.findRecord('name', oldrec.data.name, 0, false, true, true);
                    if (rec) {
                        sm.select(rec);
                    }
                }
            });
        };

        let run_editor = function () {
            let rec = me.getSelectionModel().getSelection()[0];
            if (!rec || !canEdit) {
                return;
            }
            let win = Ext.create('PVE.FirewallAliasEdit', {
                base_url: me.base_url,
                alias_name: rec.data.name,
            });
            win.show();
            win.on('destroy', reload);
        };

        me.editBtn = new Proxmox.button.Button({
            text: gettext('Edit'),
            disabled: true,
            selModel: sm,
            enableFn: (rec) => canEdit,
            handler: run_editor,
        });

        me.addBtn = Ext.create('Ext.Button', {
            text: gettext('Add'),
            disabled:
                !caps.vms['VM.Config.Network'] &&
                !caps.dc['Sys.Modify'] &&
                !caps.nodes['Sys.Modify'],
            handler: function () {
                var win = Ext.create('PVE.FirewallAliasEdit', {
                    base_url: me.base_url,
                });
                win.on('destroy', reload);
                win.show();
            },
        });

        me.removeBtn = Ext.create('Proxmox.button.StdRemoveButton', {
            disabled: true,
            selModel: sm,
            enableFn: (rec) =>
                !!caps.vms['VM.Config.Network'] ||
                !!caps.dc['Sys.Modify'] ||
                !!caps.nodes['Sys.Modify'],
            baseurl: me.base_url + '/',
            callback: reload,
        });

        Ext.apply(me, {
            store: store,
            tbar: [me.addBtn, me.removeBtn, me.editBtn],
            selModel: sm,
            columns: [
                {
                    header: gettext('Name'),
                    dataIndex: 'name',
                    flex: 1,
                },
                {
                    header: gettext('IP/CIDR'),
                    dataIndex: 'cidr',
                    flex: 1,
                },
                {
                    header: gettext('Comment'),
                    dataIndex: 'comment',
                    renderer: Ext.String.htmlEncode,
                    flex: 3,
                },
            ],
            listeners: {
                itemdblclick: run_editor,
            },
        });

        me.callParent();
        me.on('activate', reload);
    },
});
Ext.define('PVE.FirewallOptions', {
    extend: 'Proxmox.grid.ObjectGrid',
    alias: ['widget.pveFirewallOptions'],

    fwtype: undefined, // 'dc', 'node', 'vm' or 'vnet'

    base_url: undefined,

    initComponent: function () {
        var me = this;

        if (!['dc', 'node', 'vm', 'vnet'].includes(me.fwtype)) {
            throw 'unknown firewall option type';
        }

        if (me.fwtype === 'node') {
            me.cwidth1 = 250;
        }

        let caps = Ext.state.Manager.get('GuiCap');
        let canEdit =
            caps.vms['VM.Config.Network'] || caps.dc['Sys.Modify'] || caps.nodes['Sys.Modify'];

        me.rows = {};

        var add_boolean_row = function (name, text, defaultValue) {
            me.add_boolean_row(name, text, { defaultValue: defaultValue });
        };
        var add_integer_row = function (name, text, minValue, labelWidth) {
            me.add_integer_row(name, text, {
                minValue: minValue,
                deleteEmpty: true,
                labelWidth: labelWidth,
                renderer: function (value) {
                    if (value === undefined) {
                        return Proxmox.Utils.defaultText;
                    }

                    return value;
                },
            });
        };

        var add_log_row = function (name, labelWidth) {
            me.rows[name] = {
                header: name,
                required: true,
                defaultValue: 'nolog',
                editor: {
                    xtype: 'proxmoxWindowEdit',
                    subject: name,
                    fieldDefaults: { labelWidth: labelWidth || 100 },
                    items: {
                        xtype: 'pveFirewallLogLevels',
                        name: name,
                        fieldLabel: name,
                    },
                },
            };
        };

        if (me.fwtype === 'node') {
            me.rows.enable = {
                required: true,
                defaultValue: 1,
                header: gettext('Firewall'),
                renderer: Proxmox.Utils.format_boolean,
                editor: {
                    xtype: 'pveFirewallEnableEdit',
                    defaultValue: 1,
                },
            };
            add_boolean_row('nosmurfs', gettext('SMURFS filter'), 1);
            add_boolean_row('tcpflags', gettext('TCP flags filter'), 0);
            add_boolean_row('ndp', 'NDP', 1);
            add_integer_row('nf_conntrack_max', 'nf_conntrack_max', 32768, 120);
            add_integer_row(
                'nf_conntrack_tcp_timeout_established',
                'nf_conntrack_tcp_timeout_established',
                7875,
                250,
            );
            add_log_row('log_level_in');
            add_log_row('log_level_out');
            add_log_row('log_level_forward');
            add_log_row('tcp_flags_log_level', 120);
            add_log_row('smurf_log_level');
            add_boolean_row('nftables', gettext('nftables (tech preview)'), 0);
        } else if (me.fwtype === 'vm') {
            me.rows.enable = {
                required: true,
                defaultValue: 0,
                header: gettext('Firewall'),
                renderer: Proxmox.Utils.format_boolean,
                editor: {
                    xtype: 'pveFirewallEnableEdit',
                    defaultValue: 0,
                },
            };
            add_boolean_row('dhcp', 'DHCP', 1);
            add_boolean_row('ndp', 'NDP', 1);
            add_boolean_row('radv', gettext('Router Advertisement'), 0);
            add_boolean_row('macfilter', gettext('MAC filter'), 1);
            add_boolean_row('ipfilter', gettext('IP filter'), 0);
            add_log_row('log_level_in');
            add_log_row('log_level_out');
        } else if (me.fwtype === 'dc') {
            add_boolean_row('enable', gettext('Firewall'), 0);
            add_boolean_row('ebtables', 'ebtables', 1);
            me.rows.log_ratelimit = {
                header: gettext('Log rate limit'),
                required: true,
                defaultValue: gettext('Default') + ' (enable=1,rate1/second,burst=5)',
                editor: {
                    xtype: 'pveFirewallLograteEdit',
                    defaultValue: 'enable=1',
                },
            };
        } else if (me.fwtype === 'vnet') {
            add_boolean_row('enable', gettext('Firewall'), 0);
            add_log_row('log_level_forward');
        }

        if (me.fwtype === 'dc' || me.fwtype === 'vm') {
            me.rows.policy_in = {
                header: gettext('Input Policy'),
                required: true,
                defaultValue: 'DROP',
                editor: {
                    xtype: 'proxmoxWindowEdit',
                    subject: gettext('Input Policy'),
                    items: {
                        xtype: 'pveFirewallPolicySelector',
                        name: 'policy_in',
                        value: 'DROP',
                        fieldLabel: gettext('Input Policy'),
                    },
                },
            };

            me.rows.policy_out = {
                header: gettext('Output Policy'),
                required: true,
                defaultValue: 'ACCEPT',
                editor: {
                    xtype: 'proxmoxWindowEdit',
                    subject: gettext('Output Policy'),
                    items: {
                        xtype: 'pveFirewallPolicySelector',
                        name: 'policy_out',
                        value: 'ACCEPT',
                        fieldLabel: gettext('Output Policy'),
                    },
                },
            };
        }

        if (me.fwtype === 'vnet' || me.fwtype === 'dc') {
            me.rows.policy_forward = {
                header: gettext('Forward Policy'),
                required: true,
                defaultValue: 'ACCEPT',
                editor: {
                    xtype: 'proxmoxWindowEdit',
                    subject: gettext('Forward Policy'),
                    items: {
                        xtype: 'pveFirewallPolicySelector',
                        name: 'policy_forward',
                        value: 'ACCEPT',
                        fieldLabel: gettext('Forward Policy'),
                        comboItems: [
                            ['ACCEPT', 'ACCEPT'],
                            ['DROP', 'DROP'],
                        ],
                    },
                },
            };
        }

        var edit_btn = new Ext.Button({
            text: gettext('Edit'),
            disabled: true,
            handler: function () {
                me.run_editor();
            },
        });

        var set_button_status = function () {
            var sm = me.getSelectionModel();
            var rec = sm.getSelection()[0];

            if (!rec) {
                edit_btn.disable();
                return;
            }
            var rowdef = me.rows[rec.data.key];
            if (canEdit) {
                edit_btn.setDisabled(!rowdef.editor);
            }
        };

        Ext.apply(me, {
            tbar: [edit_btn],
            listeners: {
                itemdblclick: () => {
                    if (canEdit) {
                        me.run_editor();
                    }
                },
                selectionchange: set_button_status,
            },
        });

        if (me.base_url) {
            me.applyUrl(me.base_url);
        } else {
            me.rstore = Ext.create('Proxmox.data.ObjectStore', {
                interval: me.interval,
                extraParams: me.extraParams,
                rows: me.rows,
            });
        }

        me.callParent();

        me.on('activate', me.rstore.startUpdate);
        me.on('destroy', me.rstore.stopUpdate);
        me.on('deactivate', me.rstore.stopUpdate);
    },
    applyUrl: function (url) {
        let me = this;

        Ext.apply(me, {
            url: '/api2/json' + url,
            editorConfig: {
                url: '/api2/extjs/' + url,
            },
        });
    },
    setBaseUrl: function (url) {
        let me = this;

        me.base_url = url;

        me.applyUrl(url);

        me.rstore.getProxy().setConfig('url', `/api2/extjs/${url}`);
        me.rstore.reload();
    },
});

Ext.define('PVE.FirewallLogLevels', {
    extend: 'Proxmox.form.KVComboBox',
    alias: ['widget.pveFirewallLogLevels'],

    name: 'log',
    fieldLabel: gettext('Log level'),
    value: 'nolog',
    comboItems: [
        ['nolog', 'nolog'],
        ['emerg', 'emerg'],
        ['alert', 'alert'],
        ['crit', 'crit'],
        ['err', 'err'],
        ['warning', 'warning'],
        ['notice', 'notice'],
        ['info', 'info'],
        ['debug', 'debug'],
    ],
});
Ext.define('PVE.form.FWMacroSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: 'widget.pveFWMacroSelector',

    allowBlank: true,
    autoSelect: false,
    valueField: 'macro',
    displayField: 'macro',

    listConfig: {
        columns: [
            {
                header: gettext('Macro'),
                dataIndex: 'macro',
                hideable: false,
                width: 100,
            },
            {
                header: gettext('Description'),
                renderer: Ext.String.htmlEncode,
                flex: 1,
                dataIndex: 'descr',
            },
        ],
    },
    initComponent: function () {
        var me = this;

        var store = Ext.create('Ext.data.Store', {
            autoLoad: true,
            fields: ['macro', 'descr'],
            idProperty: 'macro',
            proxy: {
                type: 'proxmox',
                url: '/api2/json/cluster/firewall/macros',
            },
            sorters: {
                property: 'macro',
                direction: 'ASC',
            },
        });

        Ext.apply(me, {
            store: store,
        });

        me.callParent();
    },
});

Ext.define('PVE.form.ICMPTypeSelector', {
    extend: 'Proxmox.form.ComboGrid',
    alias: 'widget.pveICMPTypeSelector',

    allowBlank: true,
    autoSelect: false,
    valueField: 'name',
    displayField: 'name',

    listConfig: {
        columns: [
            {
                header: gettext('Type'),
                dataIndex: 'type',
                hideable: false,
                sortable: false,
                width: 50,
            },
            {
                header: gettext('Name'),
                dataIndex: 'name',
                hideable: false,
                sortable: false,
                flex: 1,
            },
        ],
    },
    setName: function (value) {
        this.name = value;
    },
});

let ICMP_TYPE_NAMES_STORE = Ext.create('Ext.data.Store', {
    field: ['type', 'name'],
    data: [
        { type: 'any', name: 'any' },
        { type: '0', name: 'echo-reply' },
        { type: '3', name: 'destination-unreachable' },
        { type: '3/0', name: 'network-unreachable' },
        { type: '3/1', name: 'host-unreachable' },
        { type: '3/2', name: 'protocol-unreachable' },
        { type: '3/3', name: 'port-unreachable' },
        { type: '3/4', name: 'fragmentation-needed' },
        { type: '3/5', name: 'source-route-failed' },
        { type: '3/6', name: 'network-unknown' },
        { type: '3/7', name: 'host-unknown' },
        { type: '3/9', name: 'network-prohibited' },
        { type: '3/10', name: 'host-prohibited' },
        { type: '3/11', name: 'TOS-network-unreachable' },
        { type: '3/12', name: 'TOS-host-unreachable' },
        { type: '3/13', name: 'communication-prohibited' },
        { type: '3/14', name: 'host-precedence-violation' },
        { type: '3/15', name: 'precedence-cutoff' },
        { type: '4', name: 'source-quench' },
        { type: '5', name: 'redirect' },
        { type: '5/0', name: 'network-redirect' },
        { type: '5/1', name: 'host-redirect' },
        { type: '5/2', name: 'TOS-network-redirect' },
        { type: '5/3', name: 'TOS-host-redirect' },
        { type: '8', name: 'echo-request' },
        { type: '9', name: 'router-advertisement' },
        { type: '10', name: 'router-solicitation' },
        { type: '11', name: 'time-exceeded' },
        { type: '11/0', name: 'ttl-zero-during-transit' },
        { type: '11/1', name: 'ttl-zero-during-reassembly' },
        { type: '12', name: 'parameter-problem' },
        { type: '12/0', name: 'ip-header-bad' },
        { type: '12/1', name: 'required-option-missing' },
        { type: '13', name: 'timestamp-request' },
        { type: '14', name: 'timestamp-reply' },
        { type: '17', name: 'address-mask-request' },
        { type: '18', name: 'address-mask-reply' },
    ],
});
let ICMPV6_TYPE_NAMES_STORE = Ext.create('Ext.data.Store', {
    field: ['type', 'name'],
    data: [
        { type: '1', name: 'destination-unreachable' },
        { type: '1/0', name: 'no-route' },
        { type: '1/1', name: 'communication-prohibited' },
        { type: '1/2', name: 'beyond-scope' },
        { type: '1/3', name: 'address-unreachable' },
        { type: '1/4', name: 'port-unreachable' },
        { type: '1/5', name: 'failed-policy' },
        { type: '1/6', name: 'reject-route' },
        { type: '2', name: 'packet-too-big' },
        { type: '3', name: 'time-exceeded' },
        { type: '3/0', name: 'ttl-zero-during-transit' },
        { type: '3/1', name: 'ttl-zero-during-reassembly' },
        { type: '4', name: 'parameter-problem' },
        { type: '4/0', name: 'bad-header' },
        { type: '4/1', name: 'unknown-header-type' },
        { type: '4/2', name: 'unknown-option' },
        { type: '128', name: 'echo-request' },
        { type: '129', name: 'echo-reply' },
        { type: '133', name: 'router-solicitation' },
        { type: '134', name: 'router-advertisement' },
        { type: '135', name: 'neighbour-solicitation' },
        { type: '136', name: 'neighbour-advertisement' },
        { type: '137', name: 'redirect' },
    ],
});

let DEFAULT_ALLOWED_DIRECTIONS = ['in', 'out'];

let ALLOWED_DIRECTIONS = {
    dc: ['in', 'out', 'forward'],
    node: ['in', 'out', 'forward'],
    group: ['in', 'out', 'forward'],
    vm: ['in', 'out'],
    vnet: ['forward'],
};

let DEFAULT_ALLOWED_ACTIONS = ['ACCEPT', 'REJECT', 'DROP'];

let ALLOWED_ACTIONS = {
    in: ['ACCEPT', 'REJECT', 'DROP'],
    out: ['ACCEPT', 'REJECT', 'DROP'],
    forward: ['ACCEPT', 'DROP'],
};

Ext.define('PVE.FirewallRulePanel', {
    extend: 'Proxmox.panel.InputPanel',

    allow_iface: false,

    list_refs_url: undefined,

    firewall_type: undefined,
    action_selector: undefined,
    forward_warning: undefined,

    onGetValues: function (values) {
        var _me = this;

        // hack: editable ComboGrid returns nothing when empty, so we need to set ''
        // Also, disabled text fields return nothing, so we need to set ''

        Ext.Array.each(
            ['source', 'dest', 'macro', 'proto', 'sport', 'dport', 'icmp-type', 'log'],
            function (key) {
                if (values[key] === undefined) {
                    values[key] = '';
                }
            },
        );

        delete values.modified_marker;

        return values;
    },

    setValidActions: function (type) {
        let me = this;

        let allowed_actions = ALLOWED_ACTIONS[type] ?? DEFAULT_ALLOWED_ACTIONS;
        me.action_selector.setComboItems(allowed_actions.map((action) => [action, action]));
    },

    setForwardWarning: function (type) {
        let me = this;
        me.forward_warning.setHidden(type !== 'forward');
    },

    onSetValues: function (values) {
        let me = this;

        if (values.type) {
            me.setValidActions(values.type);
            me.setForwardWarning(values.type);
        }

        return values;
    },

    initComponent: function () {
        var me = this;

        if (!me.list_refs_url) {
            throw 'no list_refs_url specified';
        }

        let allowed_directions = ALLOWED_DIRECTIONS[me.firewall_type] ?? DEFAULT_ALLOWED_DIRECTIONS;

        me.action_selector = Ext.create('Proxmox.form.KVComboBox', {
            xtype: 'proxmoxKVComboBox',
            name: 'action',
            value: 'ACCEPT',
            comboItems: DEFAULT_ALLOWED_ACTIONS.map((action) => [action, action]),
            fieldLabel: gettext('Action'),
            allowBlank: false,
        });

        me.forward_warning = Ext.create('Proxmox.form.field.DisplayEdit', {
            userCls: 'pmx-hint',
            value: gettext(
                'Forward rules only take effect when the nftables firewall is activated in the host options',
            ),
            hidden: true,
        });

        me.column1 = [
            {
                // hack: we use this field to mark the form 'dirty' when the
                // record has errors- so that the user can safe the unmodified
                // form again.
                xtype: 'hiddenfield',
                name: 'modified_marker',
                value: '',
            },
            {
                xtype: 'proxmoxKVComboBox',
                name: 'type',
                value: allowed_directions[0],
                comboItems: allowed_directions.map((dir) => [dir, dir]),
                fieldLabel: gettext('Direction'),
                allowBlank: false,
                listeners: {
                    change: function (f, value) {
                        me.setValidActions(value);
                        me.setForwardWarning(value);
                    },
                },
            },
            me.action_selector,
        ];

        if (me.allow_iface) {
            me.column1.push({
                xtype: 'proxmoxtextfield',
                name: 'iface',
                deleteEmpty: !me.isCreate,
                value: '',
                fieldLabel: gettext('Interface'),
            });
        } else {
            me.column1.push({
                xtype: 'displayfield',
                fieldLabel: '',
                value: '',
            });
        }

        me.column1.push(
            {
                xtype: 'displayfield',
                fieldLabel: '',
                height: 7,
                value: '',
            },
            {
                xtype: 'pveIPRefSelector',
                name: 'source',
                autoSelect: false,
                editable: true,
                base_url: me.list_refs_url,
                fieldLabel: gettext('Source'),
                maxLength: 512,
                maxLengthText: gettext('Too long, consider using IP sets.'),
            },
            {
                xtype: 'pveIPRefSelector',
                name: 'dest',
                autoSelect: false,
                editable: true,
                base_url: me.list_refs_url,
                fieldLabel: gettext('Destination'),
                maxLength: 512,
                maxLengthText: gettext('Too long, consider using IP sets.'),
            },
        );

        me.column2 = [
            {
                xtype: 'proxmoxcheckbox',
                name: 'enable',
                checked: false,
                uncheckedValue: 0,
                fieldLabel: gettext('Enable'),
            },
            {
                xtype: 'pveFWMacroSelector',
                name: 'macro',
                fieldLabel: gettext('Macro'),
                editable: true,
                allowBlank: true,
                listeners: {
                    change: function (f, value) {
                        if (value === null) {
                            me.down('field[name=proto]').setDisabled(false);
                            me.down('field[name=sport]').setDisabled(false);
                            me.down('field[name=dport]').setDisabled(false);
                        } else {
                            me.down('field[name=proto]').setDisabled(true);
                            me.down('field[name=proto]').setValue('');
                            me.down('field[name=sport]').setDisabled(true);
                            me.down('field[name=sport]').setValue('');
                            me.down('field[name=dport]').setDisabled(true);
                            me.down('field[name=dport]').setValue('');
                        }
                    },
                },
            },
            {
                xtype: 'pveIPProtocolSelector',
                name: 'proto',
                autoSelect: false,
                editable: true,
                value: '',
                fieldLabel: gettext('Protocol'),
                listeners: {
                    change: function (f, value) {
                        if (value === 'icmp' || value === 'icmpv6' || value === 'ipv6-icmp') {
                            me.down('field[name=dport]').setHidden(true);
                            me.down('field[name=dport]').setDisabled(true);
                            if (value === 'icmp') {
                                me.down('#icmpv4-type').setHidden(false);
                                me.down('#icmpv4-type').setDisabled(false);
                                me.down('#icmpv6-type').setHidden(true);
                                me.down('#icmpv6-type').setDisabled(true);
                            } else {
                                me.down('#icmpv6-type').setHidden(false);
                                me.down('#icmpv6-type').setDisabled(false);
                                me.down('#icmpv4-type').setHidden(true);
                                me.down('#icmpv4-type').setDisabled(true);
                            }
                        } else {
                            me.down('#icmpv4-type').setHidden(true);
                            me.down('#icmpv4-type').setDisabled(true);
                            me.down('#icmpv6-type').setHidden(true);
                            me.down('#icmpv6-type').setDisabled(true);
                            me.down('field[name=dport]').setHidden(false);
                            me.down('field[name=dport]').setDisabled(false);
                        }
                    },
                },
            },
            {
                xtype: 'displayfield',
                fieldLabel: '',
                height: 7,
                value: '',
            },
            {
                xtype: 'textfield',
                name: 'sport',
                value: '',
                fieldLabel: gettext('Source port'),
            },
            {
                xtype: 'textfield',
                name: 'dport',
                value: '',
                fieldLabel: gettext('Dest. port'),
            },
            {
                xtype: 'pveICMPTypeSelector',
                name: 'icmp-type',
                id: 'icmpv4-type',
                autoSelect: false,
                editable: true,
                hidden: true,
                disabled: true,
                value: '',
                fieldLabel: gettext('ICMP type'),
                store: ICMP_TYPE_NAMES_STORE,
            },
            {
                xtype: 'pveICMPTypeSelector',
                name: 'icmp-type',
                id: 'icmpv6-type',
                autoSelect: false,
                editable: true,
                hidden: true,
                disabled: true,
                value: '',
                fieldLabel: gettext('ICMP type'),
                store: ICMPV6_TYPE_NAMES_STORE,
            },
        ];

        me.advancedColumn1 = [
            {
                xtype: 'pveFirewallLogLevels',
            },
        ];

        me.columnB = [
            {
                xtype: 'textfield',
                name: 'comment',
                value: '',
                fieldLabel: gettext('Comment'),
            },
            me.forward_warning,
        ];

        me.callParent();

        if (me.isCreate) {
            // on create we never change the values, so we need to trigger this
            // manually
            me.setValidActions(me.getValues().type);
            me.setForwardWarning(me.getValues().type);
        }
    },
});

Ext.define('PVE.FirewallRuleEdit', {
    extend: 'Proxmox.window.Edit',

    base_url: undefined,
    list_refs_url: undefined,

    allow_iface: false,

    firewall_type: undefined,

    initComponent: function () {
        var me = this;

        if (!me.base_url) {
            throw 'no base_url specified';
        }
        if (!me.list_refs_url) {
            throw 'no list_refs_url specified';
        }

        me.isCreate = me.rule_pos === undefined;

        if (me.isCreate) {
            me.url = '/api2/extjs' + me.base_url;
            me.method = 'POST';
        } else {
            me.url = '/api2/extjs' + me.base_url + '/' + me.rule_pos.toString();
            me.method = 'PUT';
        }

        var ipanel = Ext.create('PVE.FirewallRulePanel', {
            isCreate: me.isCreate,
            list_refs_url: me.list_refs_url,
            allow_iface: me.allow_iface,
            rule_pos: me.rule_pos,
            firewall_type: me.firewall_type,
        });

        Ext.apply(me, {
            subject: gettext('Rule'),
            isAdd: true,
            items: [ipanel],
        });

        me.callParent();

        if (!me.isCreate) {
            me.load({
                success: function (response, options) {
                    var values = response.result.data;
                    ipanel.setValues(values);
                    // set icmp-type again after protocol has been set
                    if (values['icmp-type'] !== undefined) {
                        ipanel.setValues({ 'icmp-type': values['icmp-type'] });
                    }
                    if (values.errors) {
                        let field = me.query('[isFormField][name=modified_marker]')[0];
                        field.setValue(1);
                        Ext.Function.defer(function () {
                            var form = ipanel.up('form').getForm();
                            form.markInvalid(values.errors);
                        }, 100);
                    }
                },
            });
        } else if (me.rec) {
            ipanel.setValues(me.rec.data);
        }
    },
});

Ext.define('PVE.FirewallGroupRuleEdit', {
    extend: 'Proxmox.window.Edit',

    base_url: undefined,

    allow_iface: false,

    initComponent: function () {
        var me = this;

        me.isCreate = me.rule_pos === undefined;

        if (me.isCreate) {
            me.url = '/api2/extjs' + me.base_url;
            me.method = 'POST';
        } else {
            me.url = '/api2/extjs' + me.base_url + '/' + me.rule_pos.toString();
            me.method = 'PUT';
        }

        var column1 = [
            {
                xtype: 'hiddenfield',
                name: 'type',
                value: 'group',
            },
            {
                xtype: 'pveSecurityGroupsSelector',
                name: 'action',
                value: '',
                fieldLabel: gettext('Security Group'),
                allowBlank: false,
            },
        ];

        if (me.allow_iface) {
            column1.push({
                xtype: 'proxmoxtextfield',
                name: 'iface',
                deleteEmpty: !me.isCreate,
                value: '',
                fieldLabel: gettext('Interface'),
            });
        }

        var ipanel = Ext.create('Proxmox.panel.InputPanel', {
            isCreate: me.isCreate,
            column1: column1,
            column2: [
                {
                    xtype: 'proxmoxcheckbox',
                    name: 'enable',
                    checked: false,
                    uncheckedValue: 0,
                    fieldLabel: gettext('Enable'),
                },
            ],
            columnB: [
                {
                    xtype: 'textfield',
                    name: 'comment',
                    value: '',
                    fieldLabel: gettext('Comment'),
                },
            ],
        });

        Ext.apply(me, {
            subject: gettext('Rule'),
            isAdd: true,
            items: [ipanel],
        });

        me.callParent();

        if (!me.isCreate) {
            me.load({
                success: function (response, options) {
                    var values = response.result.data;
                    ipanel.setValues(values);
                },
            });
        }
    },
});

Ext.define(
    'PVE.FirewallRules',
    {
        extend: 'Ext.grid.Panel',
        alias: 'widget.pveFirewallRules',

        onlineHelp: 'chapter_pve_firewall',
        emptyText: gettext('No firewall rule configured here.'),

        stateful: true,
        stateId: 'grid-firewall-rules',

        base_url: undefined,
        list_refs_url: undefined,

        addBtn: undefined,
        removeBtn: undefined,
        editBtn: undefined,
        groupBtn: undefined,

        tbar_prefix: undefined,

        allow_groups: true,
        allow_iface: false,

        firewall_type: undefined,

        setBaseUrl: function (url) {
            var me = this;

            me.base_url = url;

            if (url === undefined) {
                me.addBtn.setDisabled(true);
                if (me.groupBtn) {
                    me.groupBtn.setDisabled(true);
                }
                me.store.removeAll();
            } else {
                if (me.canEdit) {
                    me.addBtn.setDisabled(false);
                    if (me.groupBtn) {
                        me.groupBtn.setDisabled(false);
                    }
                }
                me.removeBtn.baseurl = url + '/';

                me.store.setProxy({
                    type: 'proxmox',
                    url: '/api2/json' + url,
                });

                me.store.load();
            }
        },

        moveRule: function (from, to) {
            var me = this;

            if (!me.base_url) {
                return;
            }

            Proxmox.Utils.API2Request({
                url: me.base_url + '/' + from,
                method: 'PUT',
                params: { moveto: to },
                waitMsgTarget: me,
                failure: function (response, options) {
                    Ext.Msg.alert(gettext('Error'), response.htmlStatus);
                },
                callback: function () {
                    me.store.load();
                },
            });
        },

        updateRule: function (rule) {
            var me = this;

            if (!me.base_url) {
                return;
            }

            rule.enable = rule.enable ? 1 : 0;

            var pos = rule.pos;
            delete rule.pos;
            delete rule.errors;

            Proxmox.Utils.API2Request({
                url: me.base_url + '/' + pos.toString(),
                method: 'PUT',
                params: rule,
                waitMsgTarget: me,
                failure: function (response, options) {
                    Ext.Msg.alert(gettext('Error'), response.htmlStatus);
                },
                callback: function () {
                    me.store.load();
                },
            });
        },

        initComponent: function () {
            var me = this;

            if (!me.list_refs_url) {
                throw 'no list_refs_url specified';
            }

            var store = Ext.create('Ext.data.Store', {
                model: 'pve-fw-rule',
            });

            var reload = function () {
                store.load();
            };

            var sm = Ext.create('Ext.selection.RowModel', {});

            me.caps = Ext.state.Manager.get('GuiCap');
            me.canEdit =
                !!me.caps.vms['VM.Config.Network'] ||
                !!me.caps.dc['Sys.Modify'] ||
                !!me.caps.nodes['Sys.Modify'];

            var run_editor = function () {
                var rec = sm.getSelection()[0];
                if (!rec || !me.canEdit) {
                    return;
                }
                var type = rec.data.type;

                var editor;
                if (type === 'in' || type === 'out' || type === 'forward') {
                    editor = 'PVE.FirewallRuleEdit';
                } else if (type === 'group') {
                    editor = 'PVE.FirewallGroupRuleEdit';
                } else {
                    return;
                }

                var win = Ext.create(editor, {
                    firewall_type: me.firewall_type,
                    digest: rec.data.digest,
                    allow_iface: me.allow_iface,
                    base_url: me.base_url,
                    list_refs_url: me.list_refs_url,
                    rule_pos: rec.data.pos,
                });

                win.show();
                win.on('destroy', reload);
            };

            me.editBtn = Ext.create('Proxmox.button.Button', {
                text: gettext('Edit'),
                disabled: true,
                enableFn: (rec) => me.canEdit,
                selModel: sm,
                handler: run_editor,
            });

            me.addBtn = Ext.create('Ext.Button', {
                text: gettext('Add'),
                disabled: true,
                handler: function () {
                    var win = Ext.create('PVE.FirewallRuleEdit', {
                        firewall_type: me.firewall_type,
                        allow_iface: me.allow_iface,
                        base_url: me.base_url,
                        list_refs_url: me.list_refs_url,
                    });
                    win.on('destroy', reload);
                    win.show();
                },
            });

            var run_copy_editor = function () {
                let rec = sm.getSelection()[0];
                if (!rec) {
                    return;
                }
                let type = rec.data.type;
                if (!(type === 'in' || type === 'out' || type === 'forward')) {
                    return;
                }

                let win = Ext.create('PVE.FirewallRuleEdit', {
                    firewall_type: me.firewall_type,
                    allow_iface: me.allow_iface,
                    base_url: me.base_url,
                    list_refs_url: me.list_refs_url,
                    rec: rec,
                });
                win.show();
                win.on('destroy', reload);
            };

            me.copyBtn = Ext.create('Proxmox.button.Button', {
                text: gettext('Copy'),
                selModel: sm,
                enableFn: ({ data }) =>
                    (data.type === 'in' || data.type === 'out' || data.type === 'forward') &&
                    me.canEdit,
                disabled: true,
                handler: run_copy_editor,
            });

            if (me.allow_groups) {
                me.groupBtn = Ext.create('Ext.Button', {
                    text: gettext('Insert') + ': ' + gettext('Security Group'),
                    disabled: true,
                    handler: function () {
                        var win = Ext.create('PVE.FirewallGroupRuleEdit', {
                            allow_iface: me.allow_iface,
                            base_url: me.base_url,
                        });
                        win.on('destroy', reload);
                        win.show();
                    },
                });
            }

            me.removeBtn = Ext.create('Proxmox.button.StdRemoveButton', {
                enableFn: (rec) => me.canEdit,
                selModel: sm,
                baseurl: me.base_url + '/',
                confirmMsg: false,
                getRecordName: function (rec) {
                    var rule = rec.data;
                    return rule.pos.toString() + '?digest=' + encodeURIComponent(rule.digest);
                },
                callback: function () {
                    me.store.load();
                },
            });

            let tbar = me.tbar_prefix ? [me.tbar_prefix] : [];
            tbar.push(me.addBtn, me.copyBtn);
            if (me.groupBtn) {
                tbar.push(me.groupBtn);
            }
            tbar.push(me.removeBtn, me.editBtn);

            let render_errors = function (name, value, metaData, record) {
                let errors = record.data.errors;
                if (errors && errors[name]) {
                    metaData.tdCls = 'proxmox-invalid-row';
                    let html = Ext.htmlEncode(`<p>${Ext.htmlEncode(errors[name])}`);
                    metaData.tdAttr =
                        'data-qwidth=600 data-qtitle="ERROR" data-qtip="' + html + '"';
                }
                return Ext.htmlEncode(value);
            };

            let columns = [
                {
                    // similar to xtype: 'rownumberer',
                    dataIndex: 'pos',
                    resizable: false,
                    minWidth: 65,
                    maxWidth: 83,
                    flex: 1,
                    sortable: false,
                    hideable: false,
                    menuDisabled: true,
                    renderer: function (value, metaData, record, rowIdx, colIdx) {
                        metaData.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
                        let dragHandle =
                            "<i class='pve-grid-fa fa fa-fw fa-reorder cursor-move'></i>";
                        if (value >= 0) {
                            return dragHandle + value;
                        }
                        return dragHandle;
                    },
                },
                {
                    xtype: 'checkcolumn',
                    header: gettext('On'),
                    dataIndex: 'enable',
                    listeners: {
                        checkchange: function (column, recordIndex, checked) {
                            var record = me.getStore().getData().items[recordIndex];
                            record.commit();
                            var data = {};
                            Ext.Array.forEach(record.getFields(), function (field) {
                                data[field.name] = record.get(field.name);
                            });
                            if (!me.allow_iface || !data.iface) {
                                delete data.iface;
                            }
                            me.updateRule(data);
                        },
                    },
                    width: 40,
                },
                {
                    header: gettext('Type'),
                    dataIndex: 'type',
                    renderer: function (value, metaData, record) {
                        return render_errors('type', value, metaData, record);
                    },
                    minWidth: 60,
                    maxWidth: 80,
                    flex: 2,
                },
                {
                    header: gettext('Action'),
                    dataIndex: 'action',
                    renderer: function (value, metaData, record) {
                        return render_errors('action', value, metaData, record);
                    },
                    minWidth: 80,
                    maxWidth: 200,
                    flex: 2,
                },
                {
                    header: gettext('Macro'),
                    dataIndex: 'macro',
                    renderer: function (value, metaData, record) {
                        return render_errors('macro', value, metaData, record);
                    },
                    minWidth: 80,
                    flex: 2,
                },
            ];

            if (me.allow_iface) {
                columns.push({
                    header: gettext('Interface'),
                    dataIndex: 'iface',
                    renderer: function (value, metaData, record) {
                        return render_errors('iface', value, metaData, record);
                    },
                    minWidth: 80,
                    flex: 2,
                });
            }

            columns.push(
                {
                    header: gettext('Protocol'),
                    dataIndex: 'proto',
                    renderer: function (value, metaData, record) {
                        return render_errors('proto', value, metaData, record);
                    },
                    width: 75,
                },
                {
                    header: gettext('Source'),
                    dataIndex: 'source',
                    renderer: function (value, metaData, record) {
                        return render_errors('source', value, metaData, record);
                    },
                    minWidth: 100,
                    flex: 2,
                },
                {
                    header: gettext('S.Port'),
                    dataIndex: 'sport',
                    renderer: function (value, metaData, record) {
                        return render_errors('sport', value, metaData, record);
                    },
                    width: 75,
                },
                {
                    header: gettext('Destination'),
                    dataIndex: 'dest',
                    renderer: function (value, metaData, record) {
                        return render_errors('dest', value, metaData, record);
                    },
                    minWidth: 100,
                    flex: 2,
                },
                {
                    header: gettext('D.Port'),
                    dataIndex: 'dport',
                    renderer: function (value, metaData, record) {
                        return render_errors('dport', value, metaData, record);
                    },
                    width: 75,
                },
                {
                    header: gettext('Log level'),
                    dataIndex: 'log',
                    renderer: function (value, metaData, record) {
                        return render_errors('log', value, metaData, record);
                    },
                    width: 100,
                },
                {
                    header: gettext('Comment'),
                    dataIndex: 'comment',
                    flex: 10,
                    minWidth: 75,
                    renderer: function (value, metaData, record) {
                        let comment = render_errors('comment', value, metaData, record) || '';
                        if (comment.length * 12 > metaData.column.cellWidth) {
                            comment = `<span data-qtip="${Ext.htmlEncode(comment)}">${comment}</span>`;
                        }
                        return comment;
                    },
                },
            );

            Ext.apply(me, {
                store: store,
                selModel: sm,
                tbar: tbar,
                viewConfig: {
                    plugins: [
                        {
                            ptype: 'gridviewdragdrop',
                            dragGroup: 'FWRuleDDGroup',
                            dropGroup: 'FWRuleDDGroup',
                        },
                    ],
                    listeners: {
                        beforedrop: function (node, data, dropRec, dropPosition) {
                            if (!dropRec) {
                                return false; // empty view
                            }
                            let moveto = dropRec.get('pos');
                            if (dropPosition === 'after') {
                                moveto++;
                            }
                            let pos = data.records[0].get('pos');
                            me.moveRule(pos, moveto);
                            return 0;
                        },
                        itemdblclick: run_editor,
                    },
                },
                sortableColumns: false,
                columns: columns,
            });

            me.callParent();

            if (me.base_url) {
                me.setBaseUrl(me.base_url); // load
            }
        },
    },
    function () {
        Ext.define('pve-fw-rule', {
            extend: 'Ext.data.Model',
            fields: [
                { name: 'enable', type: 'boolean' },
                'type',
                'action',
                'macro',
                'source',
                'dest',
                'proto',
                'iface',
                'dport',
                'sport',
                'comment',
                'pos',
                'digest',
                'errors',
            ],
            idProperty: 'pos',
        });
    },
);
Ext.define('PVE.pool.AddVM', {
    extend: 'Proxmox.window.Edit',

    width: 640,
    height: 480,
    isAdd: true,
    isCreate: true,

    extraRequestParams: {
        'allow-move': 1,
    },

    initComponent: function () {
        var me = this;

        if (!me.pool) {
            throw 'no pool specified';
        }

        me.url = '/pools/';
        me.method = 'PUT';
        me.extraRequestParams.poolid = me.pool;

        var vmsField = Ext.create('Ext.form.field.Text', {
            name: 'vms',
            hidden: true,
            allowBlank: false,
        });

        var vmStore = Ext.create('Ext.data.Store', {
            model: 'PVEResources',
            sorters: [
                {
                    property: 'vmid',
                    direction: 'ASC',
                },
            ],
            filters: [
                function (item) {
                    return (
                        (item.data.type === 'lxc' || item.data.type === 'qemu') &&
                        item.data.pool !== me.pool
                    );
                },
            ],
        });

        var vmGrid = Ext.create('widget.grid', {
            store: vmStore,
            border: true,
            height: 360,
            scrollable: true,
            selModel: {
                selType: 'checkboxmodel',
                mode: 'SIMPLE',
                listeners: {
                    selectionchange: function (model, selected, opts) {
                        var selectedVms = [];
                        selected.forEach(function (vm) {
                            selectedVms.push(vm.data.vmid);
                        });
                        vmsField.setValue(selectedVms);
                    },
                },
            },
            columns: [
                {
                    header: 'ID',
                    dataIndex: 'vmid',
                    width: 60,
                },
                {
                    header: gettext('Node'),
                    dataIndex: 'node',
                },
                {
                    header: gettext('Current Pool'),
                    dataIndex: 'pool',
                },
                {
                    header: gettext('Status'),
                    dataIndex: 'uptime',
                    renderer: (v) => (v ? Proxmox.Utils.runningText : Proxmox.Utils.stoppedText),
                },
                {
                    header: gettext('Name'),
                    dataIndex: 'name',
                    flex: 1,
                },
                {
                    header: gettext('Type'),
                    dataIndex: 'type',
                },
            ],
        });

        Ext.apply(me, {
            subject: gettext('Virtual Machine'),
            items: [
                vmsField,
                vmGrid,
                {
                    xtype: 'displayfield',
                    userCls: 'pmx-hint',
                    value: gettext(
                        'Selected guests who are already part of a pool will be removed from it first.',
                    ),
                },
            ],
        });

        me.callParent();
        vmStore.load();
    },
});

Ext.define('PVE.pool.AddStorage', {
    extend: 'Proxmox.window.Edit',

    initComponent: function () {
        var me = this;

        if (!me.pool) {
            throw 'no pool specified';
        }

        me.isCreate = true;
        me.isAdd = true;
        me.url = '/pools/';
        me.method = 'PUT';
        me.extraRequestParams.poolid = me.pool;

        Ext.apply(me, {
            subject: gettext('Storage'),
            width: 350,
            items: [
                {
                    xtype: 'pveStorageSelector',
                    name: 'storage',
                    nodename: 'localhost',
                    autoSelect: false,
                    value: '',
                    fieldLabel: gettext('Storage'),
                },
            ],
        });

        me.callParent();
    },
});

Ext.define('PVE.grid.PoolMembers', {
    extend: 'Ext.grid.GridPanel',
    alias: ['widget.pvePoolMembers'],

    stateful: true,
    stateId: 'grid-pool-members',

    initComponent: function () {
        var me = this;

        if (!me.pool) {
            throw 'no pool specified';
        }

        me.rstore = Ext.create('Proxmox.data.UpdateStore', {
            interval: 10000,
            model: 'PVEResources',
            proxy: {
                type: 'proxmox',
                root: 'data[0].members',
                url: `/api2/json/pools/?poolid=${me.pool}`,
            },
            autoStart: true,
        });

        let store = Ext.create('Proxmox.data.DiffStore', {
            rstore: me.rstore,
            sorters: [
                {
                    property: 'type',
                    direction: 'ASC',
                },
            ],
        });

        var coldef = PVE.data.ResourceStore.defaultColumns().filter(
            (c) => c.dataIndex !== 'tags' && c.dataIndex !== 'lock',
        );

        var reload = function () {
            store.load();
        };

        var sm = Ext.create('Ext.selection.RowModel', {});

        var remove_btn = new Proxmox.button.Button({
            text: gettext('Remove'),
            disabled: true,
            selModel: sm,
            confirmMsg: function (rec) {
                return Ext.String.format(
                    gettext('Are you sure you want to remove entry {0}'),
                    "'" + rec.data.id + "'",
                );
            },
            handler: function (btn, event, rec) {
                var params = { delete: 1, poolid: me.pool };
                if (rec.data.type === 'storage') {
                    params.storage = rec.data.storage;
                } else if (
                    rec.data.type === 'qemu' ||
                    rec.data.type === 'lxc' ||
                    rec.data.type === 'openvz'
                ) {
                    params.vms = rec.data.vmid;
                } else {
                    throw 'unknown resource type';
                }

                Proxmox.Utils.API2Request({
                    url: '/pools/',
                    method: 'PUT',
                    params: params,
                    waitMsgTarget: me,
                    callback: function () {
                        reload();
                    },
                    failure: function (response, opts) {
                        Ext.Msg.alert(gettext('Error'), response.htmlStatus);
                    },
                });
            },
        });

        Ext.apply(me, {
            store: store,
            selModel: sm,
            tbar: [
                {
                    text: gettext('Add'),
                    menu: new Ext.menu.Menu({
                        items: [
                            {
                                text: gettext('Virtual Machine'),
                                iconCls: 'pve-itype-icon-qemu',
                                handler: function () {
                                    var win = Ext.create('PVE.pool.AddVM', { pool: me.pool });
                                    win.on('destroy', reload);
                                    win.show();
                                },
                            },
                            {
                                text: gettext('Storage'),
                                iconCls: 'pve-itype-icon-storage',
                                handler: function () {
                                    var win = Ext.create('PVE.pool.AddStorage', { pool: me.pool });
                                    win.on('destroy', reload);
                                    win.show();
                                },
                            },
                        ],
                    }),
                },
                remove_btn,
            ],
            viewConfig: {
                stripeRows: true,
            },
            columns: coldef,
            listeners: {
                itemcontextmenu: PVE.Utils.createCmdMenu,
                itemdblclick: function (v, record) {
                    var ws = me.up('pveStdWorkspace');
                    ws.selectById(record.data.id);
                },
                activate: reload,
                destroy: () => me.rstore.stopUpdate(),
            },
        });

        me.callParent();
    },
});
Ext.define('PVE.window.ReplicaEdit', {
    extend: 'Proxmox.window.Edit',
    xtype: 'pveReplicaEdit',

    subject: gettext('Replication Job'),

    url: '/cluster/replication',
    method: 'POST',

    initComponent: function () {
        var me = this;

        var vmid = me.pveSelNode.data.vmid;
        var nodename = me.pveSelNode.data.node;

        var items = [];

        items.push({
            xtype: me.isCreate && !vmid ? 'pveGuestIDSelector' : 'displayfield',
            name: 'guest',
            fieldLabel: 'CT/VM ID',
            value: vmid || '',
        });

        items.push(
            {
                xtype: me.isCreate ? 'pveNodeSelector' : 'displayfield',
                name: 'target',
                disallowedNodes: [nodename],
                allowBlank: false,
                onlineValidator: true,
                fieldLabel: gettext('Target'),
            },
            {
                xtype: 'pveCalendarEvent',
                fieldLabel: gettext('Schedule'),
                emptyText: '*/15 - ' + Ext.String.format(gettext('Every {0} minutes'), 15),
                name: 'schedule',
            },
            {
                xtype: 'numberfield',
                fieldLabel: gettext('Rate limit') + ' (MB/s)',
                step: 1,
                minValue: 1,
                emptyText: gettext('unlimited'),
                name: 'rate',
            },
            {
                xtype: 'textfield',
                fieldLabel: gettext('Comment'),
                name: 'comment',
            },
            {
                xtype: 'proxmoxcheckbox',
                name: 'enabled',
                defaultValue: 'on',
                checked: true,
                fieldLabel: gettext('Enabled'),
            },
        );

        me.items = [
            {
                xtype: 'inputpanel',
                itemId: 'ipanel',
                onlineHelp: 'pvesr_schedule_time_format',

                onGetValues: function (values) {
                    let win = this.up('window');

                    values.disable = values.enabled ? 0 : 1;
                    delete values.enabled;

                    PVE.Utils.delete_if_default(values, 'rate', '', win.isCreate);
                    PVE.Utils.delete_if_default(values, 'disable', 0, win.isCreate);
                    PVE.Utils.delete_if_default(values, 'schedule', '*/15', win.isCreate);
                    PVE.Utils.delete_if_default(values, 'comment', '', win.isCreate);

                    if (win.isCreate) {
                        values.type = 'local';
                        let vm = vmid || values.guest;
                        let id = -1;
                        if (win.highestids[vm] !== undefined) {
                            id = win.highestids[vm];
                        }
                        id++;
                        values.id = vm + '-' + id.toString();
                        delete values.guest;
                    }
                    return values;
                },
                items: items,
            },
        ];

        me.callParent();

        if (me.isCreate) {
            me.load({
                success: function (response) {
                    var jobs = response.result.data;
                    var highestids = {};
                    Ext.Array.forEach(jobs, function (job) {
                        var match = /^([0-9]+)-([0-9]+)$/.exec(job.id);
                        if (match) {
                            let jobVMID = parseInt(match[1], 10);
                            let id = parseInt(match[2], 10);
                            if (highestids[jobVMID] === undefined || highestids[jobVMID] < id) {
                                highestids[jobVMID] = id;
                            }
                        }
                    });
                    me.highestids = highestids;
                },
            });
        } else {
            me.load({
                success: function (response, options) {
                    response.result.data.enabled = !response.result.data.disable;
                    me.setValues(response.result.data);
                    me.digest = response.result.data.digest;
                },
            });
        }
    },
});

/* callback is a function and string */
Ext.define(
    'PVE.grid.ReplicaView',
    {
        extend: 'Ext.grid.Panel',
        xtype: 'pveReplicaView',

        onlineHelp: 'chapter_pvesr',

        stateful: true,
        stateId: 'grid-pve-replication-status',

        controller: {
            xclass: 'Ext.app.ViewController',

            addJob: function (button, event, rec) {
                let me = this;
                let view = me.getView();
                Ext.create('PVE.window.ReplicaEdit', {
                    isCreate: true,
                    method: 'POST',
                    pveSelNode: view.pveSelNode,
                    listeners: {
                        destroy: () => me.reload(),
                    },
                    autoShow: true,
                });
            },

            editJob: function (button, event, { data }) {
                let me = this;
                let view = me.getView();
                Ext.create('PVE.window.ReplicaEdit', {
                    url: `/cluster/replication/${data.id}`,
                    method: 'PUT',
                    pveSelNode: view.pveSelNode,
                    listeners: {
                        destroy: () => me.reload(),
                    },
                    autoShow: true,
                });
            },

            scheduleJobNow: function (button, event, rec) {
                let me = this;
                let view = me.getView();
                Proxmox.Utils.API2Request({
                    url: `/api2/extjs/nodes/${view.nodename}/replication/${rec.data.id}/schedule_now`,
                    method: 'POST',
                    waitMsgTarget: view,
                    callback: () => me.reload(),
                    failure: (response, opts) =>
                        Ext.Msg.alert(gettext('Error'), response.htmlStatus),
                });
            },

            showLog: function (button, event, rec) {
                let me = this;
                let view = this.getView();

                let logView = Ext.create('Proxmox.panel.LogView', {
                    border: false,
                    url: `/api2/extjs/nodes/${view.nodename}/replication/${rec.data.id}/log`,
                });
                let task = Ext.TaskManager.newTask({
                    run: () => logView.requestUpdate(),
                    interval: 1000,
                });
                let win = Ext.create('Ext.window.Window', {
                    items: [logView],
                    layout: 'fit',
                    width: 800,
                    height: 400,
                    modal: true,
                    title: gettext('Replication Log'),
                    listeners: {
                        destroy: function () {
                            task.stop();
                            me.reload();
                        },
                    },
                });
                task.start();
                win.show();
            },

            reload: function () {
                this.getView().rstore.load();
            },

            dblClick: function (grid, record, item) {
                this.editJob(undefined, undefined, record);
            },

            // currently replication is for cluster only, so disable the whole component for non-cluster
            checkPrerequisites: function () {
                let view = this.getView();
                if (PVE.Utils.isStandaloneNode()) {
                    view.mask(gettext('Replication needs at least two nodes'), ['pve-static-mask']);
                }
            },

            control: {
                '#': {
                    itemdblclick: 'dblClick',
                    afterlayout: 'checkPrerequisites',
                },
            },
        },

        tbar: [
            {
                text: gettext('Add'),
                itemId: 'addButton',
                handler: 'addJob',
            },
            {
                xtype: 'proxmoxButton',
                text: gettext('Edit'),
                itemId: 'editButton',
                handler: 'editJob',
                disabled: true,
            },
            {
                xtype: 'proxmoxStdRemoveButton',
                itemId: 'removeButton',
                baseurl: '/api2/extjs/cluster/replication/',
                dangerous: true,
                callback: 'reload',
            },
            {
                xtype: 'proxmoxButton',
                text: gettext('Log'),
                itemId: 'logButton',
                handler: 'showLog',
                disabled: true,
            },
            {
                xtype: 'proxmoxButton',
                text: gettext('Schedule now'),
                itemId: 'scheduleNowButton',
                handler: 'scheduleJobNow',
                disabled: true,
            },
        ],

        initComponent: function () {
            var me = this;
            var mode = '';
            var url = '/cluster/replication';

            me.nodename = me.pveSelNode.data.node;
            me.vmid = me.pveSelNode.data.vmid;

            me.columns = [
                {
                    header: gettext('Enabled'),
                    width: 80,
                    dataIndex: 'enabled',
                    align: 'center',
                    renderer: Proxmox.Utils.renderEnabledIcon,
                    sortable: true,
                },
                {
                    text: 'ID',
                    dataIndex: 'id',
                    width: 60,
                    hidden: true,
                },
                {
                    text: gettext('Guest'),
                    dataIndex: 'guest',
                    width: 75,
                },
                {
                    text: gettext('Job'),
                    dataIndex: 'jobnum',
                    width: 60,
                },
                {
                    text: gettext('Target'),
                    dataIndex: 'target',
                },
            ];

            if (!me.nodename) {
                mode = 'dc';
                me.stateId = 'grid-pve-replication-dc';
            } else if (!me.vmid) {
                mode = 'node';
                url = `/nodes/${me.nodename}/replication`;
            } else {
                mode = 'vm';
                url = `/nodes/${me.nodename}/replication?guest=${me.vmid}`;
            }

            if (mode !== 'dc') {
                me.columns.push(
                    {
                        text: gettext('Status'),
                        dataIndex: 'state',
                        minWidth: 160,
                        flex: 1,
                        renderer: function (value, metadata, record) {
                            if (record.data.pid) {
                                metadata.tdCls = 'x-grid-row-loading';
                                return '';
                            }

                            let icons = [],
                                states = [];

                            if (record.data.remove_job) {
                                icons.push(
                                    '<i class="fa fa-ban warning" title="' +
                                        gettext('Removal Scheduled') +
                                        '"></i>',
                                );
                                states.push(gettext('Removal Scheduled'));
                            }
                            if (record.data.error) {
                                icons.push(
                                    '<i class="fa fa-times critical" title="' +
                                        gettext('Error') +
                                        '"></i>',
                                );
                                states.push(record.data.error);
                            }
                            if (icons.length === 0) {
                                icons.push('<i class="fa fa-check good"></i>');
                                states.push(gettext('OK'));
                            }

                            return icons.join(',') + ' ' + states.join(',');
                        },
                    },
                    {
                        text: gettext('Last Sync'),
                        dataIndex: 'last_sync',
                        width: 150,
                        renderer: function (value, metadata, record) {
                            if (!value) {
                                return '-';
                            }
                            if (record.data.pid) {
                                return gettext('syncing');
                            }
                            return Proxmox.Utils.render_timestamp(value);
                        },
                    },
                    {
                        text: gettext('Duration'),
                        dataIndex: 'duration',
                        width: 60,
                        renderer: Proxmox.Utils.render_duration,
                    },
                    {
                        text: gettext('Next Sync'),
                        dataIndex: 'next_sync',
                        width: 150,
                        renderer: function (value) {
                            if (!value) {
                                return '-';
                            }

                            let now = new Date(),
                                next = new Date(value * 1000);
                            if (next < now) {
                                return gettext('pending');
                            }
                            return Proxmox.Utils.render_timestamp(value);
                        },
                    },
                );
            }

            me.columns.push(
                {
                    text: gettext('Schedule'),
                    width: 75,
                    dataIndex: 'schedule',
                },
                {
                    text: gettext('Rate limit'),
                    dataIndex: 'rate',
                    renderer: function (value) {
                        if (!value) {
                            return gettext('unlimited');
                        }

                        return value.toString() + ' MB/s';
                    },
                    hidden: true,
                },
                {
                    text: gettext('Comment'),
                    dataIndex: 'comment',
                    renderer: Ext.htmlEncode,
                },
            );

            me.rstore = Ext.create('Proxmox.data.UpdateStore', {
                storeid: 'pve-replica-' + me.nodename + me.vmid,
                model: mode === 'dc' ? 'pve-replication' : 'pve-replication-state',
                interval: 3000,
                proxy: {
                    type: 'proxmox',
                    url: '/api2/json' + url,
                },
            });

            me.store = Ext.create('Proxmox.data.DiffStore', {
                rstore: me.rstore,
                sorters: [
                    {
                        property: 'guest',
                    },
                    {
                        property: 'jobnum',
                    },
                ],
            });

            me.callParent();

            // we cannot access the log and scheduleNow button
            // in the datacenter, because
            // we do not know where/if the jobs runs
            if (mode === 'dc') {
                me.down('#logButton').setHidden(true);
                me.down('#scheduleNowButton').setHidden(true);
            }

            // if we set the warning mask, we do not want to load
            // or set the mask on store errors
            if (PVE.Utils.isStandaloneNode()) {
                return;
            }

            Proxmox.Utils.monStoreErrors(me, me.rstore);

            me.on('destroy', me.rstore.stopUpdate);
            me.rstore.startUpdate();
        },
    },
    function () {
        Ext.define('pve-replication', {
            extend: 'Ext.data.Model',
            fields: [
                'id',
                'target',
                'comment',
                'rate',
                'type',
                { name: 'guest', type: 'integer' },
                { name: 'jobnum', type: 'integer' },
                { name: 'schedule', defaultValue: '*/15' },
                { name: 'disable', defaultValue: '' },
                {
                    name: 'enabled',
                    calculate: function (data) {
                        return !data.disable;
                    },
                },
            ],
        });

        Ext.define('pve-replication-state', {
            extend: 'pve-replication',
            fields: [
                'last_sync',
                'next_sync',
                'error',
                'duration',
                'state',
                'fail_count',
                'remove_job',
                'pid',
            ],
        });
    },
);
Ext.define('PVE.grid.ResourceGrid', {
    extend: 'Ext.grid.GridPanel',
    alias: ['widget.pveResourceGrid'],

    border: false,
    defaultSorter: {
        property: 'type',
        direction: 'ASC',
    },
    userCls: 'proxmox-tags-full',
    initComponent: function () {
        let me = this;

        let rstore = PVE.data.ResourceStore;

        let store = Ext.create('Ext.data.Store', {
            model: 'PVEResources',
            sorters: me.defaultSorter,
            proxy: {
                type: 'memory',
            },
        });

        let textfilter = '';
        let textfilterMatch = function (item) {
            for (const field of ['name', 'storage', 'node', 'type', 'text']) {
                let v = item.data[field];
                if (v && v.toLowerCase().indexOf(textfilter) >= 0) {
                    return true;
                }
            }
            return false;
        };

        let updateGrid = function () {
            var filterfn = me.viewFilter ? me.viewFilter.filterfn : null;

            store.suspendEvents();

            let nodeidx = {};
            let gather_child_nodes;
            gather_child_nodes = function (node) {
                if (!node || !node.childNodes) {
                    return;
                }
                for (let child of node.childNodes) {
                    let orgNode = rstore.data.get(child.data.realId ?? child.data.id);
                    if (orgNode) {
                        if (
                            (!filterfn || filterfn(child)) &&
                            (!textfilter || textfilterMatch(child))
                        ) {
                            nodeidx[child.data.id] = orgNode;
                        }
                    }
                    gather_child_nodes(child);
                }
            };
            gather_child_nodes(me.pveSelNode);

            // remove vanished items
            let rmlist = [];
            store.each((olditem) => {
                if (!nodeidx[olditem.data.id]) {
                    rmlist.push(olditem);
                }
            });
            if (rmlist.length) {
                store.remove(rmlist);
            }

            // add new items
            let addlist = [];
            for (const [_key, item] of Object.entries(nodeidx)) {
                // getById() use find(), which is slow (ExtJS4 DP5)
                let olditem = store.data.get(item.data.id);
                if (!olditem) {
                    addlist.push(item);
                    continue;
                }
                let changes = false;
                for (let field of PVE.data.ResourceStore.fieldNames) {
                    if (field !== 'id' && item.data[field] !== olditem.data[field]) {
                        changes = true;
                        olditem.beginEdit();
                        olditem.set(field, item.data[field]);
                    }
                }
                if (changes) {
                    olditem.endEdit(true);
                    olditem.commit(true);
                }
            }
            if (addlist.length) {
                store.add(addlist);
            }
            store.sort();
            store.resumeEvents();
            store.fireEvent('refresh', store);
        };

        Ext.apply(me, {
            store: store,
            stateful: true,
            stateId: 'grid-resource',
            tbar: [
                '->',
                gettext('Search') + ':',
                ' ',
                {
                    xtype: 'textfield',
                    width: 200,
                    value: textfilter,
                    enableKeyEvents: true,
                    listeners: {
                        buffer: 500,
                        keyup: function (field, e) {
                            textfilter = field.getValue().toLowerCase();
                            updateGrid();
                        },
                    },
                },
            ],
            viewConfig: {
                stripeRows: true,
            },
            listeners: {
                itemcontextmenu: PVE.Utils.createCmdMenu,
                itemdblclick: function (v, record) {
                    var ws = me.up('pveStdWorkspace');
                    ws.selectById(record.data.id);
                },
                afterrender: function () {
                    updateGrid();
                },
            },
            columns: rstore.defaultColumns(),
        });
        me.callParent();
        me.mon(rstore, 'load', () => updateGrid());
    },
});
/*
 * Base class for all the multitab config panels
 *
 * How to use this:
 *
 * You create a subclass of this, and then define your wanted tabs
 * as items like this:
 *
 * items: [{
 *  title: "myTitle",
 *  xytpe: "somextype",
 *  iconCls: 'fa fa-icon',
 *  groups: ['somegroup'],
 *  expandedOnInit: true,
 *  itemId: 'someId'
 * }]
 *
 * this has to be in the declarative syntax, else we
 * cannot save them for later
 * (so no Ext.create or Ext.apply of an item in the subclass)
 *
 * the groups array expects the itemids of the items
 * which are the parents, which have to come before they
 * are used
 *
 * if you want following the tree:
 *
 * Option1
 * Option2
 *   -> SubOption1
 *	-> SubSubOption1
 *
 * the suboption1 group array has to look like this:
 * groups: ['itemid-of-option2']
 *
 * and of subsuboption1:
 * groups: ['itemid-of-option2', 'itemid-of-suboption1']
 *
 * setting the expandedOnInit determines if the item/group is expanded
 * initially (false by default)
 */
Ext.define('PVE.panel.Config', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.pvePanelConfig',

    showSearch: true, // add a resource grid with a search button as first tab
    viewFilter: undefined, // a filter to pass to that resource grid

    tbarSpacing: true, // if true, adds a spacer after the title in tbar

    dockedItems: [
        {
            // this is needed for the overflow handler
            xtype: 'toolbar',
            overflowHandler: 'scroller',
            dock: 'left',
            style: {
                padding: 0,
                margin: 0,
            },
            cls: 'pve-toolbar-bg',
            items: {
                xtype: 'treelist',
                itemId: 'menu',
                ui: 'pve-nav',
                expanderOnly: true,
                expanderFirst: false,
                animation: false,
                singleExpand: false,
                listeners: {
                    selectionchange: function (treeList, selection) {
                        if (!selection) {
                            return;
                        }
                        let view = this.up('panel');
                        view.suspendLayout = true;
                        view.activateCard(selection.data.id);
                        view.suspendLayout = false;
                        view.updateLayout();
                    },
                    itemclick: function (treelist, info) {
                        var olditem = treelist.getSelection();
                        var newitem = info.node;

                        // when clicking on the expand arrow, we don't select items, but still want the original behaviour
                        if (info.select === false) {
                            return;
                        }

                        // click on a different, open item then leave it open, else toggle the clicked item
                        if (olditem.data.id !== newitem.data.id && newitem.data.expanded === true) {
                            info.toggle = false;
                        } else {
                            info.toggle = true;
                        }
                    },
                },
            },
        },
        {
            xtype: 'toolbar',
            itemId: 'toolbar',
            dock: 'top',
            height: 36,
            overflowHandler: 'scroller',
        },
    ],

    firstItem: '',
    layout: 'card',
    border: 0,

    // used for automated test
    selectById: function (cardid) {
        var me = this;

        var root = me.store.getRoot();
        var selection = root.findChild('id', cardid, true);

        if (selection) {
            selection.expand();
            let menu = me.down('#menu');
            menu.setSelection(selection);
            return cardid;
        }
        return '';
    },

    activateCard: function (cardid) {
        var me = this;
        if (me.savedItems[cardid]) {
            let curcard = me.getLayout().getActiveItem();
            let newcard = me.add(me.savedItems[cardid]);
            me.helpButton.setOnlineHelp(newcard.onlineHelp || me.onlineHelp);
            if (curcard) {
                me.setActiveItem(cardid);
                me.remove(curcard, true);

                // trigger state change

                let ncard = cardid;
                // Note: '' is alias for first tab.
                // First tab can be 'search' or something else
                if (cardid === me.firstItem) {
                    ncard = '';
                }
                if (me.hstateid) {
                    me.sp.set(me.hstateid, { value: ncard });
                }
            }
        }
    },

    initComponent: function () {
        var me = this;

        var stateid = me.hstateid;

        me.sp = Ext.state.Manager.getProvider();

        var activeTab; // leaving this undefined means items[0] will be the default tab

        if (stateid) {
            let state = me.sp.get(stateid);
            if (state && state.value) {
                // if this tab does not exist, it chooses the first
                activeTab = state.value;
            }
        }

        // get title
        var title = me.title || me.pveSelNode.data.text;
        me.title = undefined;

        // create toolbar
        var tbar = me.tbar || [];
        me.tbar = undefined;

        if (!me.onlineHelp) {
            // use the onlineHelp property indirection to enforce checking reference validity
            let typeToOnlineHelp = {
                'type/lxc': { onlineHelp: 'chapter_pct' },
                'type/node': { onlineHelp: 'chapter_system_administration' },
                'type/pool': { onlineHelp: 'pveum_pools' },
                'type/qemu': { onlineHelp: 'chapter_virtual_machines' },
                'type/sdn': { onlineHelp: 'chapter_pvesdn' },
                'type/storage': { onlineHelp: 'chapter_storage' },
            };
            me.onlineHelp = typeToOnlineHelp[me.pveSelNode.data.id]?.onlineHelp;
        }

        if (me.tbarSpacing) {
            tbar.unshift('->');
        }
        tbar.unshift({
            xtype: 'tbtext',
            text: title,
            baseCls: 'x-panel-header-text',
        });

        me.helpButton = Ext.create('Proxmox.button.Help', {
            hidden: false,
            listenToGlobalEvent: false,
            onlineHelp: me.onlineHelp || undefined,
        });

        tbar.push(me.helpButton);

        me.dockedItems[1].items = tbar;

        // include search tab
        me.items = me.items || [];
        if (me.showSearch) {
            me.items.unshift({
                xtype: 'pveResourceGrid',
                itemId: 'search',
                title: gettext('Search'),
                iconCls: 'fa fa-search',
                pveSelNode: me.pveSelNode,
            });
        }

        me.savedItems = {};
        if (me.items[0]) {
            me.firstItem = me.items[0].itemId;
        }

        me.store = Ext.create('Ext.data.TreeStore', {
            root: {
                expanded: true,
            },
        });
        var root = me.store.getRoot();
        me.insertNodes(me.items);

        delete me.items;
        me.defaults = me.defaults || {};
        Ext.apply(me.defaults, {
            pveSelNode: me.pveSelNode,
            viewFilter: me.viewFilter,
            workspace: me.workspace,
            border: 0,
        });

        me.callParent();

        var menu = me.down('#menu');
        var selection = root.findChild('id', activeTab, true) || root.firstChild;
        var node = selection;
        while (node !== root) {
            node.expand();
            node = node.parentNode;
        }
        menu.setStore(me.store);
        menu.setSelection(selection);

        // on a state change,
        // select the new item
        var statechange = function (sp, key, state) {
            // it the state change is for this panel
            if (stateid && key === stateid && state) {
                // get active item
                let acard = me.getLayout().getActiveItem().itemId;
                // get the itemid of the new value
                let ncard = state.value || me.firstItem;
                if (ncard && acard !== ncard) {
                    // select the chosen item
                    menu.setSelection(root.findChild('id', ncard, true) || root.firstChild);
                }
            }
        };

        if (stateid) {
            me.mon(me.sp, 'statechange', statechange);
        }
    },

    insertNodes: function (items) {
        var me = this;
        var root = me.store.getRoot();

        items.forEach(function (item) {
            var treeitem = Ext.create('Ext.data.TreeModel', {
                id: item.itemId,
                text: item.title,
                iconCls: item.iconCls,
                leaf: true,
                expanded: item.expandedOnInit,
            });
            item.header = false;
            if (me.savedItems[item.itemId] !== undefined) {
                throw 'itemId already exists, please use another';
            }
            me.savedItems[item.itemId] = item;

            var group;
            var curnode = root;

            // get/create the group items
            while (Ext.isArray(item.groups) && item.groups.length > 0) {
                group = item.groups.shift();

                let child = curnode.findChild('id', group);
                if (child === null) {
                    // did not find the group item
                    // so add it where we are
                    break;
                }
                curnode = child;
            }

            // insert the item

            // lets see if it already exists
            var node = curnode.findChild('id', item.itemId);

            if (node === null) {
                curnode.appendChild(treeitem);
            } else {
                // should not happen!
                throw 'id already exists';
            }
        });
    },
});
/*
 * Input panel for advanced backup options intended to be used as part of an edit/create window.
 */
Ext.define('PVE.panel.BackupAdvancedOptions', {
    extend: 'Proxmox.panel.InputPanel',
    xtype: 'pveBackupAdvancedOptionsPanel',
    mixins: ['Proxmox.Mixin.CBind'],

    cbindData: function () {
        let me = this;
        me.isCreate = !!me.isCreate;
        return {};
    },

    viewModel: {
        data: {},
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        toggleFleecing: function (cb, value) {
            let me = this;
            me.lookup('fleecingStorage').setDisabled(!value);
        },

        control: {
            'proxmoxcheckbox[reference=fleecingEnabled]': {
                change: 'toggleFleecing',
            },
        },
    },

    onGetValues: function (formValues) {
        let me = this;
        if (me.needMask) {
            // isMasked() may not yet be true if not rendered once
            return {};
        }

        if (!formValues.id && me.isCreate) {
            formValues.id = 'backup-' + Ext.data.identifier.Uuid.Global.generate().slice(0, 13);
        }

        let options = {};

        if (!me.isCreate) {
            options.delete = []; // to avoid having to check this all the time
        }
        const deletePropertyOnEdit = me.isCreate
            ? () => {
                  /* no-op on create */
              }
            : (key) => options.delete.push(key);

        let fleecing = {},
            fleecingOptions = ['fleecing-enabled', 'fleecing-storage'];
        let performance = {},
            performanceOptions = ['max-workers', 'pbs-entries-max'];

        for (const [key, value] of Object.entries(formValues)) {
            if (performanceOptions.includes(key)) {
                performance[key] = value;
                // deleteEmpty is not currently implemented for pveBandwidthField
            } else if (key === 'bwlimit' && value === '') {
                deletePropertyOnEdit('bwlimit');
            } else if (key === 'delete') {
                if (Array.isArray(value)) {
                    value
                        .filter((opt) => !performanceOptions.includes(opt))
                        .forEach((opt) => deletePropertyOnEdit(opt));
                } else if (!performanceOptions.includes(formValues.delete)) {
                    deletePropertyOnEdit(value);
                }
            } else if (fleecingOptions.includes(key)) {
                let fleecingKey = key.slice('fleecing-'.length);
                fleecing[fleecingKey] = value;
            } else {
                options[key] = value;
            }
        }

        if (Object.keys(performance).length > 0) {
            options.performance = PVE.Parser.printPropertyString(performance);
        } else {
            deletePropertyOnEdit('performance');
        }

        if (Object.keys(fleecing).length > 0) {
            options.fleecing = PVE.Parser.printPropertyString(fleecing);
        } else {
            deletePropertyOnEdit('fleecing');
        }

        if (me.isCreate) {
            delete options.delete;
        }

        return options;
    },

    onSetValues: function (values) {
        if (values.fleecing) {
            for (const [key, value] of Object.entries(values.fleecing)) {
                values[`fleecing-${key}`] = value;
            }
            delete values.fleecing;
        }
        if (values['pbs-change-detection-mode'] === '__default__') {
            delete values['pbs-change-detection-mode'];
        }
        return values;
    },

    updateCompression: function (value, disabled) {
        this.lookup('zstdThreadCount').setDisabled(disabled || value !== 'zstd');
    },

    items: [
        {
            xtype: 'pveTwoColumnContainer',
            startColumn: {
                xtype: 'pmxDisplayEditField',
                vtype: 'ConfigId',
                fieldLabel: gettext('Job ID'),
                emptyText: gettext('Autogenerate'),
                name: 'id',
                allowBlank: true,
                cbind: {
                    editable: '{isCreate}',
                },
            },
            endFlex: 2,
            endColumn: {
                xtype: 'displayfield',
                value: gettext('Can be used in notification matchers to match this job.'),
            },
        },
        {
            xtype: 'pveTwoColumnContainer',
            startColumn: {
                xtype: 'pveBandwidthField',
                name: 'bwlimit',
                fieldLabel: gettext('Bandwidth Limit'),
                emptyText: gettext('Fallback'),
                backendUnit: 'KiB',
                allowZero: true,
                emptyValue: '',
                autoEl: {
                    tag: 'div',
                    'data-qtip': Ext.String.format(gettext('Use {0} for unlimited'), 0),
                },
            },
            endFlex: 2,
            endColumn: {
                xtype: 'displayfield',
                value: `${gettext('Limit I/O bandwidth.')} ${Ext.String.format(gettext('Schema default: {0}'), 0)}`,
            },
        },
        {
            xtype: 'pveTwoColumnContainer',
            startColumn: {
                xtype: 'proxmoxintegerfield',
                name: 'zstd',
                reference: 'zstdThreadCount',
                fieldLabel: gettext('Zstd Threads'),
                fieldStyle: 'text-align: right',
                emptyText: gettext('Fallback'),
                minValue: 0,
                cbind: {
                    deleteEmpty: '{!isCreate}',
                },
                autoEl: {
                    tag: 'div',
                    'data-qtip': gettext('With 0, half of the available cores are used'),
                },
            },
            endFlex: 2,
            endColumn: {
                xtype: 'displayfield',
                value: `${gettext('Threads used for zstd compression (non-PBS).')} ${Ext.String.format(gettext('Schema default: {0}'), 1)}`,
            },
        },
        {
            xtype: 'pveTwoColumnContainer',
            startColumn: {
                xtype: 'proxmoxintegerfield',
                name: 'max-workers',
                minValue: 1,
                maxValue: 256,
                fieldLabel: gettext('IO-Workers'),
                fieldStyle: 'text-align: right',
                emptyText: gettext('Fallback'),
                cbind: {
                    deleteEmpty: '{!isCreate}',
                },
            },
            endFlex: 2,
            endColumn: {
                xtype: 'displayfield',
                value: `${gettext('I/O workers in the QEMU process (VMs only).')} ${Ext.String.format(gettext('Schema default: {0}'), 16)}`,
            },
        },
        {
            xtype: 'pveTwoColumnContainer',
            startColumn: {
                xtype: 'proxmoxcheckbox',
                name: 'fleecing-enabled',
                reference: 'fleecingEnabled',
                fieldLabel: gettext('Fleecing'),
                uncheckedValue: 0,
                value: 0,
            },
            endFlex: 2,
            endColumn: {
                xtype: 'displayfield',
                value: gettext(
                    'Backup write cache that can reduce IO pressure inside guests (VMs only).',
                ),
            },
        },
        {
            xtype: 'pveTwoColumnContainer',
            startColumn: {
                xtype: 'pveStorageSelector',
                name: 'fleecing-storage',
                fieldLabel: gettext('Fleecing Storage'),
                reference: 'fleecingStorage',
                clusterView: true,
                storageContent: 'images',
                allowBlank: false,
                disabled: true,
            },
            endFlex: 2,
            endColumn: {
                xtype: 'displayfield',
                value: gettext(
                    'Prefer a fast and local storage, ideally with support for discard and thin-provisioning or sparse files.',
                ),
            },
        },
        {
            // It's part of the 'performance' property string, so have a field to preserve the
            // value, but don't expose it. It's a rather niche setting and difficult to
            // convey/understand what it does.
            xtype: 'proxmoxintegerfield',
            name: 'pbs-entries-max',
            hidden: true,
            fieldLabel: 'TODO',
            fieldStyle: 'text-align: right',
            emptyText: 'TODO',
            cbind: {
                deleteEmpty: '{!isCreate}',
            },
        },
        {
            xtype: 'pveTwoColumnContainer',
            startColumn: {
                xtype: 'proxmoxcheckbox',
                fieldLabel: gettext('Repeat missed'),
                name: 'repeat-missed',
                uncheckedValue: 0,
                defaultValue: 0,
                cbind: {
                    deleteDefaultValue: '{!isCreate}',
                },
            },
            endFlex: 2,
            endColumn: {
                xtype: 'displayfield',
                value: gettext(
                    "Run jobs as soon as possible if they couldn't start on schedule, for example, due to the node being offline.",
                ),
            },
        },
        {
            xtype: 'pveTwoColumnContainer',
            startColumn: {
                xtype: 'proxmoxKVComboBox',
                fieldLabel: gettext('PBS change detection mode'),
                name: 'pbs-change-detection-mode',
                deleteEmpty: true,
                value: '__default__',
                comboItems: [
                    ['__default__', 'Default'],
                    ['data', 'Data'],
                    ['metadata', 'Metadata'],
                ],
            },
            endFlex: 2,
            endColumn: {
                xtype: 'displayfield',
                value: gettext(
                    'Mode to detect file changes and switch archive encoding format for container backups.',
                ),
            },
        },
        {
            xtype: 'component',
            padding: '5 1',
            html: `<span class="pmx-hint">${gettext('Note')}</span>: ${gettext(
                "The node-specific 'vzdump.conf' or, if this is not set, the default from the config schema is used to determine fallback values.",
            )}`,
        },
    ],
});
/*
 * Input panel for prune settings with a keep-all option intended to be used as
 * part of an edit/create window.
 */
Ext.define('PVE.panel.BackupJobPrune', {
    extend: 'Proxmox.panel.PruneInputPanel',
    xtype: 'pveBackupJobPrunePanel',
    mixins: ['Proxmox.Mixin.CBind'],

    onlineHelp: 'vzdump_retention',

    onGetValues: function (formValues) {
        if (this.needMask) {
            // isMasked() may not yet be true if not rendered once
            return {};
        } else if (this.isCreate && !this.rendered) {
            return this.keepAllDefaultForCreate ? { 'prune-backups': 'keep-all=1' } : {};
        }

        let options = { delete: [] };

        if ('max-protected-backups' in formValues) {
            options['max-protected-backups'] = formValues['max-protected-backups'];
        } else if (this.hasMaxProtected) {
            options.delete.push('max-protected-backups');
        }

        delete formValues['max-protected-backups'];
        delete formValues.delete;

        let retention = PVE.Parser.printPropertyString(formValues);
        if (retention === '') {
            options.delete.push('prune-backups');
        } else {
            options['prune-backups'] = retention;
        }

        if (!this.isCreate) {
            // always delete old 'maxfiles' on edit, we map it to keep-last on window load
            options.delete.push('maxfiles');
        } else {
            delete options.delete;
        }

        return options;
    },

    updateComponents: function () {
        let me = this;

        let keepAll = me.down('proxmoxcheckbox[name=keep-all]').getValue();
        let anyValue = false;
        me.query('pmxPruneKeepField').forEach((field) => {
            anyValue = anyValue || field.getValue() !== null;
            field.setDisabled(keepAll);
        });
        me.down('component[name=no-keeps-hint]').setHidden(anyValue || keepAll);
    },

    listeners: {
        afterrender: function (panel) {
            if (panel.needMask) {
                panel.down('component[name=no-keeps-hint]').setHtml('');
                panel.mask(gettext('Backup content type not available for this storage.'));
            } else if (panel.isCreate && panel.keepAllDefaultForCreate) {
                panel.down('proxmoxcheckbox[name=keep-all]').setValue(true);
            }
            panel.down('component[name=pbs-hint]').setHidden(!panel.showPBSHint);

            let maxProtected = panel.down('proxmoxintegerfield[name=max-protected-backups]');
            maxProtected.setDisabled(!panel.hasMaxProtected);
            maxProtected.setHidden(!panel.hasMaxProtected);

            panel.query('pmxPruneKeepField').forEach((field) => {
                field.on('change', panel.updateComponents, panel);
            });
            panel.updateComponents();
        },
    },

    columnT: {
        xtype: 'proxmoxcheckbox',
        name: 'keep-all',
        boxLabel: gettext('Keep all backups'),
        listeners: {
            change: function (field, newValue) {
                let panel = field.up('pveBackupJobPrunePanel');
                panel.updateComponents();
            },
        },
    },

    columnB: [
        {
            xtype: 'component',
            userCls: 'pmx-hint',
            name: 'no-keeps-hint',
            hidden: true,
            padding: '5 1',
            cbind: {
                html: '{fallbackHintHtml}',
            },
        },
        {
            xtype: 'component',
            userCls: 'pmx-hint',
            name: 'pbs-hint',
            hidden: true,
            padding: '5 1',
            html: gettext(
                "It's preferred to configure backup retention directly on the Proxmox Backup Server.",
            ),
        },
        {
            xtype: 'proxmoxintegerfield',
            name: 'max-protected-backups',
            fieldLabel: gettext('Maximum Protected'),
            minValue: -1,
            hidden: true,
            disabled: true,
            emptyText: 'unlimited with Datastore.Allocate privilege, 5 otherwise',
            deleteEmpty: true,
            autoEl: {
                tag: 'div',
                'data-qtip': Ext.String.format(gettext('Use {0} for unlimited'), -1),
            },
        },
    ],
});
Ext.define('PVE.widget.HealthWidget', {
    extend: 'Ext.Component',
    alias: 'widget.pveHealthWidget',

    data: {
        iconCls: PVE.Utils.get_health_icon(undefined, true),
        text: '',
        title: '',
    },

    style: {
        'text-align': 'center',
    },

    tpl: ['<h3>{title}</h3>', '<i class="fa fa-5x {iconCls}"></i>', '<br /><br/>', '{text}'],

    updateHealth: function (data) {
        var me = this;
        me.update(Ext.apply(me.data, data));
    },

    initComponent: function () {
        var me = this;

        if (me.title) {
            me.config.data.title = me.title;
        }

        me.callParent();
    },
});
Ext.define('pve-fw-ipsets', {
    extend: 'Ext.data.Model',
    fields: ['name', 'comment', 'digest'],
    idProperty: 'name',
});

Ext.define('PVE.IPSetList', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.pveIPSetList',

    stateful: true,
    stateId: 'grid-firewall-ipsetlist',

    ipset_panel: undefined,

    base_url: undefined,

    addBtn: undefined,
    removeBtn: undefined,
    editBtn: undefined,

    initComponent: function () {
        var me = this;

        if (typeof me.ipset_panel === 'undefined') {
            throw 'no rule panel specified';
        }

        if (typeof me.ipset_panel === 'undefined') {
            throw 'no base_url specified';
        }

        var store = new Ext.data.Store({
            model: 'pve-fw-ipsets',
            proxy: {
                type: 'proxmox',
                url: '/api2/json' + me.base_url,
            },
            sorters: {
                property: 'name',
                direction: 'ASC',
            },
        });

        var caps = Ext.state.Manager.get('GuiCap');
        let canEdit =
            !!caps.vms['VM.Config.Network'] ||
            !!caps.dc['Sys.Modify'] ||
            !!caps.nodes['Sys.Modify'];

        var sm = Ext.create('Ext.selection.RowModel', {});

        var reload = function () {
            var oldrec = sm.getSelection()[0];
            store.load(function (records, operation, success) {
                if (oldrec) {
                    let rec = store.findRecord('name', oldrec.data.name, 0, false, true, true);
                    if (rec) {
                        sm.select(rec);
                    }
                }
            });
        };

        var run_editor = function () {
            var rec = sm.getSelection()[0];
            if (!rec || !canEdit) {
                return;
            }
            var win = Ext.create('Proxmox.window.Edit', {
                subject: "IPSet '" + rec.data.name + "'",
                url: me.base_url,
                method: 'POST',
                digest: rec.data.digest,
                items: [
                    {
                        xtype: 'hiddenfield',
                        name: 'rename',
                        value: rec.data.name,
                    },
                    {
                        xtype: 'textfield',
                        name: 'name',
                        value: rec.data.name,
                        fieldLabel: gettext('Name'),
                        allowBlank: false,
                    },
                    {
                        xtype: 'textfield',
                        name: 'comment',
                        value: rec.data.comment,
                        fieldLabel: gettext('Comment'),
                    },
                ],
            });
            win.show();
            win.on('destroy', reload);
        };

        me.editBtn = new Proxmox.button.Button({
            text: gettext('Edit'),
            disabled: true,
            enableFn: (rec) => canEdit,
            selModel: sm,
            handler: run_editor,
        });

        me.addBtn = new Proxmox.button.Button({
            text: gettext('Create'),
            handler: function () {
                sm.deselectAll();
                var win = Ext.create('Proxmox.window.Edit', {
                    subject: 'IPSet',
                    url: me.base_url,
                    method: 'POST',
                    items: [
                        {
                            xtype: 'textfield',
                            name: 'name',
                            value: '',
                            fieldLabel: gettext('Name'),
                            allowBlank: false,
                        },
                        {
                            xtype: 'textfield',
                            name: 'comment',
                            value: '',
                            fieldLabel: gettext('Comment'),
                        },
                    ],
                });
                win.show();
                win.on('destroy', reload);
            },
        });

        me.removeBtn = Ext.create('Proxmox.button.StdRemoveButton', {
            enableFn: (rec) => canEdit,
            selModel: sm,
            baseurl: me.base_url + '/',
            callback: reload,
        });

        Ext.apply(me, {
            store: store,
            tbar: ['<b>IPSet:</b>', me.addBtn, me.removeBtn, me.editBtn],
            selModel: sm,
            columns: [
                {
                    header: 'IPSet',
                    dataIndex: 'name',
                    minWidth: 150,
                    flex: 1,
                },
                {
                    header: gettext('Comment'),
                    dataIndex: 'comment',
                    renderer: Ext.String.htmlEncode,
                    flex: 4,
                },
            ],
            listeners: {
                itemdblclick: run_editor,
                select: function (_, rec) {
                    var url = me.base_url + '/' + rec.data.name;
                    me.ipset_panel.setBaseUrl(url);
                },
                deselect: function () {
                    me.ipset_panel.setBaseUrl(undefined);
                },
                show: reload,
            },
        });

        if (!canEdit) {
            me.addBtn.setDisabled(true);
        }

        me.callParent();

        store.load();
    },
});

Ext.define('PVE.IPSetCidrEdit', {
    extend: 'Proxmox.window.Edit',

    cidr: undefined,

    initComponent: function () {
        var me = this;

        me.isCreate = me.cidr === undefined;

        if (me.isCreate) {
            me.url = '/api2/extjs' + me.base_url;
            me.method = 'POST';
        } else {
            me.url = '/api2/extjs' + me.base_url + '/' + me.cidr;
            me.method = 'PUT';
        }

        var column1 = [];

        if (me.isCreate) {
            if (!me.list_refs_url) {
                throw 'no alias_base_url specified';
            }

            column1.push({
                xtype: 'pveIPRefSelector',
                name: 'cidr',
                ref_type: 'alias',
                autoSelect: false,
                editable: true,
                base_url: me.list_refs_url,
                allowBlank: false,
                fieldLabel: gettext('IP/CIDR'),
            });
        } else {
            column1.push({
                xtype: 'displayfield',
                name: 'cidr',
                value: '',
                fieldLabel: gettext('IP/CIDR'),
            });
        }

        var ipanel = Ext.create('Proxmox.panel.InputPanel', {
            isCreate: me.isCreate,
            column1: column1,
            column2: [
                {
                    xtype: 'proxmoxcheckbox',
                    name: 'nomatch',
                    checked: false,
                    uncheckedValue: 0,
                    fieldLabel: 'nomatch',
                },
            ],
            columnB: [
                {
                    xtype: 'textfield',
                    name: 'comment',
                    value: '',
                    fieldLabel: gettext('Comment'),
                },
            ],
        });

        Ext.apply(me, {
            subject: gettext('IP/CIDR'),
            items: [ipanel],
        });

        me.callParent();

        if (!me.isCreate) {
            me.load({
                success: function (response, options) {
                    var values = response.result.data;
                    ipanel.setValues(values);
                },
            });
        }
    },
});

Ext.define(
    'PVE.IPSetGrid',
    {
        extend: 'Ext.grid.Panel',
        alias: 'widget.pveIPSetGrid',

        stateful: true,
        stateId: 'grid-firewall-ipsets',

        base_url: undefined,
        list_refs_url: undefined,

        addBtn: undefined,
        removeBtn: undefined,
        editBtn: undefined,

        setBaseUrl: function (url) {
            var me = this;

            me.base_url = url;

            if (url === undefined) {
                me.addBtn.setDisabled(true);
                me.store.removeAll();
            } else {
                if (me.canEdit) {
                    me.addBtn.setDisabled(false);
                }
                me.removeBtn.baseurl = url + '/';
                me.store.setProxy({
                    type: 'proxmox',
                    url: '/api2/json' + url,
                });

                me.store.load();
            }
        },

        initComponent: function () {
            var me = this;

            if (!me.list_refs_url) {
                throw 'no1 list_refs_url specified';
            }

            var store = new Ext.data.Store({
                model: 'pve-ipset',
            });

            var reload = function () {
                store.load();
            };

            var sm = Ext.create('Ext.selection.RowModel', {});

            me.caps = Ext.state.Manager.get('GuiCap');
            me.canEdit =
                !!me.caps.vms['VM.Config.Network'] ||
                !!me.caps.dc['Sys.Modify'] ||
                !!me.caps.nodes['Sys.Modify'];

            var run_editor = function () {
                var rec = sm.getSelection()[0];
                if (!rec || !me.canEdit) {
                    return;
                }
                var win = Ext.create('PVE.IPSetCidrEdit', {
                    base_url: me.base_url,
                    cidr: rec.data.cidr,
                });
                win.show();
                win.on('destroy', reload);
            };

            me.editBtn = new Proxmox.button.Button({
                text: gettext('Edit'),
                disabled: true,
                enableFn: (rec) => me.canEdit,
                selModel: sm,
                handler: run_editor,
            });

            me.addBtn = new Proxmox.button.Button({
                text: gettext('Add'),
                disabled: true,
                enableFn: (rec) => me.canEdit,
                handler: function () {
                    if (!me.base_url) {
                        return;
                    }
                    var win = Ext.create('PVE.IPSetCidrEdit', {
                        base_url: me.base_url,
                        list_refs_url: me.list_refs_url,
                    });
                    win.show();
                    win.on('destroy', reload);
                },
            });

            me.removeBtn = Ext.create('Proxmox.button.StdRemoveButton', {
                disabled: true,
                enableFn: (rec) => me.canEdit,
                selModel: sm,
                baseurl: me.base_url + '/',
                callback: reload,
            });

            var render_errors = function (value, metaData, record) {
                var errors = record.data.errors;
                if (errors) {
                    let msg = errors.cidr || errors.nomatch;
                    if (msg) {
                        metaData.tdCls = 'proxmox-invalid-row';
                        let html = Ext.htmlEncode(`<p>${Ext.htmlEncode(msg)}</p>`);
                        metaData.tdAttr = `data-qwidth=600 data-qtitle="ERROR" data-qtip="${html}"`;
                    }
                }
                return Ext.htmlEncode(value);
            };

            Ext.apply(me, {
                tbar: ['<b>IP/CIDR:</b>', me.addBtn, me.removeBtn, me.editBtn],
                store: store,
                selModel: sm,
                listeners: {
                    itemdblclick: run_editor,
                },
                columns: [
                    {
                        xtype: 'rownumberer',
                        // cannot use width on instantiation as rownumberer hard-wires that in the
                        // constructor to avoid being overridden by applyDefaults
                        minWidth: 40,
                    },
                    {
                        header: gettext('IP/CIDR'),
                        dataIndex: 'cidr',
                        minWidth: 150,
                        flex: 1,
                        renderer: function (value, metaData, record) {
                            value = render_errors(value, metaData, record);
                            if (record.data.nomatch) {
                                return '<b>! </b>' + value;
                            }
                            return value;
                        },
                    },
                    {
                        header: gettext('Comment'),
                        dataIndex: 'comment',
                        flex: 3,
                        renderer: function (value) {
                            return Ext.util.Format.htmlEncode(value);
                        },
                    },
                ],
            });

            me.callParent();

            if (me.base_url) {
                me.setBaseUrl(me.base_url); // load
            }
        },
    },
    function () {
        Ext.define('pve-ipset', {
            extend: 'Ext.data.Model',
            fields: [{ name: 'nomatch', type: 'boolean' }, 'cidr', 'comment', 'errors'],
            idProperty: 'cidr',
        });
    },
);

Ext.define('PVE.IPSet', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.pveIPSet',

    title: 'IPSet',

    onlineHelp: 'pve_firewall_ip_sets',

    list_refs_url: undefined,

    initComponent: function () {
        var me = this;

        if (!me.list_refs_url) {
            throw 'no list_refs_url specified';
        }

        var ipset_panel = Ext.createWidget('pveIPSetGrid', {
            region: 'center',
            list_refs_url: me.list_refs_url,
            border: false,
        });

        var ipset_list = Ext.createWidget('pveIPSetList', {
            region: 'west',
            ipset_panel: ipset_panel,
            base_url: me.base_url,
            width: '50%',
            border: false,
            split: true,
        });

        Ext.apply(me, {
            layout: 'border',
            items: [ipset_list, ipset_panel],
            listeners: {
                show: function () {
                    ipset_list.fireEvent('show', ipset_list);
                },
            },
        });

        me.callParent();
    },
});
/*
 * This is a running chart widget you add time datapoints to it, and we only
 * show the last x of it used for ceph performance charts
 */
Ext.define('PVE.widget.RunningChart', {
    extend: 'Ext.container.Container',
    alias: 'widget.pveRunningChart',

    layout: {
        type: 'hbox',
        align: 'center',
    },
    items: [
        {
            width: 80,
            xtype: 'box',
            itemId: 'title',
            data: {
                title: '',
            },
            tpl: '<h3>{title}:</h3>',
        },
        {
            flex: 1,
            xtype: 'cartesian',
            height: '100%',
            itemId: 'chart',
            border: false,
            axes: [
                {
                    type: 'numeric',
                    position: 'left',
                    hidden: true,
                    minimum: 0,
                },
                {
                    type: 'numeric',
                    position: 'bottom',
                    hidden: true,
                },
            ],

            store: {
                trackRemoved: false,
                data: {},
            },

            sprites: [
                {
                    id: 'valueSprite',
                    type: 'text',
                    text: '0 B/s',
                    textAlign: 'end',
                    textBaseline: 'middle',
                    fontSize: 14,
                },
            ],

            series: [
                {
                    type: 'line',
                    xField: 'time',
                    yField: 'val',
                    fill: 'true',
                    colors: ['#cfcfcf'],
                    tooltip: {
                        trackMouse: true,
                        renderer: function (tooltip, record, ctx) {
                            if (!record || !record.data) {
                                return;
                            }
                            const view = this.getChart();
                            const date = new Date(record.data.time);
                            const value = view.up().renderer(record.data.val);
                            const line1 = `${view.up().title}: ${value}`;
                            const line2 = Ext.Date.format(date, 'H:i:s');
                            tooltip.setHtml(`${line1}<br />${line2}`);
                        },
                    },
                    style: {
                        lineWidth: 1.5,
                        opacity: 0.6,
                    },
                    marker: {
                        opacity: 0,
                        scaling: 0.01,
                        fx: {
                            duration: 200,
                            easing: 'easeOut',
                        },
                    },
                    highlightCfg: {
                        opacity: 1,
                        scaling: 1.5,
                    },
                },
            ],
        },
    ],

    // the renderer for the tooltip and last value, default just the value
    renderer: Ext.identityFn,

    // show the last x seconds default is 5 minutes
    timeFrame: 5 * 60,

    checkThemeColors: function () {
        let me = this;
        let rootStyle = getComputedStyle(document.documentElement);

        // get color
        let background = rootStyle.getPropertyValue('--pwt-panel-background').trim() || '#ffffff';
        let text = rootStyle.getPropertyValue('--pwt-text-color').trim() || '#000000';

        // set the colors
        me.chart.setBackground(background);
        me.chart.valuesprite.setAttributes({ fillStyle: text }, true);
        me.chart.redraw();
    },

    addDataPoint: function (value, time) {
        let view = this.chart;
        let panel = view.up();
        let now = new Date().getTime();
        let begin = new Date(now - 1000 * panel.timeFrame).getTime();

        view.store.add({
            time: time || now,
            val: value || 0,
        });

        // delete all old records when we have 20 times more datapoints
        // than seconds in our timeframe (so even a subsecond graph does
        // not trigger this often)
        //
        // records in the store do not take much space, but like this,
        // we prevent a memory leak when someone has the site open for a long time
        // with minimal graphical glitches
        if (view.store.count() > panel.timeFrame * 20) {
            let oldData = view.store.getData().createFiltered(function (item) {
                return item.data.time < begin;
            });

            view.store.remove(oldData.getRange());
        }

        view.timeaxis.setMinimum(begin);
        view.timeaxis.setMaximum(now);
        view.valuesprite.setText(panel.renderer(value || 0).toString());
        view.valuesprite.setAttributes(
            {
                x: view.getWidth() - 15,
                y: view.getHeight() / 2,
            },
            true,
        );
        view.redraw();
    },

    setTitle: function (title) {
        this.title = title;
        let titlebox = this.getComponent('title');
        titlebox.update({ title: title });
    },

    initComponent: function () {
        var me = this;
        me.callParent();

        if (me.title) {
            me.getComponent('title').update({ title: me.title });
        }
        me.chart = me.getComponent('chart');
        me.chart.timeaxis = me.chart.getAxes()[1];
        me.chart.valuesprite = me.chart.getSurface('chart').get('valueSprite');
        if (me.color) {
            me.chart.series[0].setStyle({
                fill: me.color,
                stroke: me.color,
            });
        }

        me.checkThemeColors();

        // switch colors on media query changes
        me.mediaQueryList = window.matchMedia('(prefers-color-scheme: dark)');
        me.themeListener = (e) => {
            me.checkThemeColors();
        };
        me.mediaQueryList.addEventListener('change', me.themeListener);
    },

    doDestroy: function () {
        let me = this;

        me.mediaQueryList.removeEventListener('change', me.themeListener);

        me.callParent();
    },
});
/*
 * This class describes the bottom panel
 */
Ext.define('PVE.panel.StatusPanel', {
    extend: 'Ext.tab.Panel',
    alias: 'widget.pveStatusPanel',

    //title: "Logs",
    //tabPosition: 'bottom',

    initComponent: function () {
        var me = this;

        var stateid = 'ltab';
        var sp = Ext.state.Manager.getProvider();

        var state = sp.get(stateid);
        if (state && state.value) {
            me.activeTab = state.value;
        }

        Ext.apply(me, {
            listeners: {
                tabchange: function () {
                    var atab = me.getActiveTab().itemId;
                    let tabstate = { value: atab };
                    sp.set(stateid, tabstate);
                },
            },
            items: [
                {
                    itemId: 'tasks',
                    title: gettext('Tasks'),
                    xtype: 'pveClusterTasks',
                },
                {
                    itemId: 'clog',
                    title: gettext('Cluster log'),
                    xtype: 'pveClusterLog',
                },
            ],
        });

        me.callParent();

        me.items.get(0).fireEvent('show', me.items.get(0));

        var statechange = function (_, key, newstate) {
            if (key === stateid) {
                let atab = me.getActiveTab().itemId;
                let ntab = newstate.value;
                if (newstate && ntab && atab !== ntab) {
                    me.setActiveTab(ntab);
                }
            }
        };

        sp.on('statechange', statechange);
        me.on('destroy', function () {
            sp.un('statechange', statechange);
        });
    },
});
Ext.define('PVE.panel.GuestStatusView', {
    extend: 'Proxmox.panel.StatusView',
    alias: 'widget.pveGuestStatusView',
    mixins: ['Proxmox.Mixin.CBind'],

    cbindData: function (initialConfig) {
        var me = this;
        return {
            isQemu: me.pveSelNode.data.type === 'qemu',
            isLxc: me.pveSelNode.data.type === 'lxc',
        };
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        init: function (view) {
            if (view.pveSelNode.data.type !== 'lxc') {
                return;
            }

            const nodename = view.pveSelNode.data.node;
            const vmid = view.pveSelNode.data.vmid;

            Proxmox.Utils.API2Request({
                url: `/api2/extjs/nodes/${nodename}/lxc/${vmid}/config`,
                waitMsgTargetView: view,
                method: 'GET',
                success: ({ result }) => {
                    view.down('#unprivileged').updateValue(
                        Proxmox.Utils.format_boolean(result.data.unprivileged),
                    );
                    view.ostype = Ext.htmlEncode(result.data.ostype);
                },
            });
        },
    },

    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    defaults: {
        xtype: 'pmxInfoWidget',
        padding: '2 25',
    },
    items: [
        {
            xtype: 'box',
            height: 20,
        },
        {
            itemId: 'status',
            title: gettext('Status'),
            iconCls: 'fa fa-info fa-fw',
            printBar: false,
            multiField: true,
            renderer: function (record) {
                var _me = this;
                var text = record.data.status;
                var qmpstatus = record.data.qmpstatus;
                if (qmpstatus && qmpstatus !== record.data.status) {
                    text += ' (' + qmpstatus + ')';
                }
                return text;
            },
        },
        {
            itemId: 'hamanaged',
            iconCls: 'fa fa-heartbeat fa-fw',
            title: gettext('HA State'),
            printBar: false,
            textField: 'ha',
            renderer: PVE.Utils.format_ha,
        },
        {
            itemId: 'node',
            iconCls: 'fa fa-building fa-fw',
            title: gettext('Node'),
            cbind: {
                text: '{pveSelNode.data.node}',
            },
            printBar: false,
        },
        {
            itemId: 'unprivileged',
            iconCls: 'fa fa-lock fa-fw',
            title: gettext('Unprivileged'),
            printBar: false,
            cbind: {
                hidden: '{isQemu}',
            },
        },
        {
            xtype: 'box',
            height: 15,
        },
        {
            itemId: 'cpu',
            iconCls: 'fa fa-fw pmx-itype-icon-processor pmx-icon',
            title: gettext('CPU usage'),
            valueField: 'cpu',
            maxField: 'cpus',
            renderer: Proxmox.Utils.render_cpu_usage,
            // in this specific api call
            // we already have the correct value for the usage
            calculate: Ext.identityFn,
        },
        {
            itemId: 'memory',
            iconCls: 'fa fa-fw pmx-itype-icon-memory pmx-icon',
            title: gettext('Memory usage'),
            valueField: 'mem',
            maxField: 'maxmem',
        },
        {
            itemId: 'swap',
            iconCls: 'fa fa-refresh fa-fw',
            title: gettext('SWAP usage'),
            valueField: 'swap',
            maxField: 'maxswap',
            cbind: {
                hidden: '{isQemu}',
                disabled: '{isQemu}',
            },
        },
        {
            itemId: 'rootfs',
            iconCls: 'fa fa-hdd-o fa-fw',
            title: gettext('Bootdisk size'),
            valueField: 'disk',
            maxField: 'maxdisk',
            printBar: false,
            renderer: function (used, max) {
                var me = this;
                me.setPrintBar(used > 0);
                if (used === 0) {
                    return Proxmox.Utils.render_size(max);
                } else {
                    return Proxmox.Utils.render_size_usage(used, max);
                }
            },
        },
        {
            xtype: 'box',
            height: 15,
        },
        {
            itemId: 'ips',
            xtype: 'pveAgentIPView',
            cbind: {
                rstore: '{rstore}',
                pveSelNode: '{pveSelNode}',
                hidden: '{isLxc}',
                disabled: '{isLxc}',
            },
        },
    ],

    updateTitle: function () {
        var me = this;
        var uptime = me.getRecordValue('uptime');

        var text = '';
        if (Number(uptime) > 0) {
            text =
                ' (' + gettext('Uptime') + ': ' + Proxmox.Utils.format_duration_long(uptime) + ')';
        }

        let title = `<div class="left-aligned">${me.getRecordValue('name') + text}</div>`;

        if (me.pveSelNode.data.type === 'lxc' && me.ostype && me.ostype !== 'unmanaged') {
            // Manual mappings for distros with special casing
            const namemap = {
                archlinux: 'Arch Linux',
                nixos: 'NixOS',
                opensuse: 'openSUSE',
                centos: 'CentOS',
            };

            const distro = namemap[me.ostype] ?? Ext.String.capitalize(me.ostype);
            title += `<div class="right-aligned">
		<i class="fl-${me.ostype} fl-fw"></i>&nbsp;${distro}</div>`;
        }

        me.setTitle(title);
    },
});
Ext.define('PVE.guest.Summary', {
    extend: 'Ext.panel.Panel',
    xtype: 'pveGuestSummary',

    scrollable: true,
    bodyPadding: 5,

    initComponent: function () {
        var me = this;

        var nodename = me.pveSelNode.data.node;
        if (!nodename) {
            throw 'no node name specified';
        }

        var vmid = me.pveSelNode.data.vmid;
        if (!vmid) {
            throw 'no VM ID specified';
        }

        if (!me.workspace) {
            throw 'no workspace specified';
        }

        if (!me.statusStore) {
            throw 'no status storage specified';
        }

        var type = me.pveSelNode.data.type;
        var template = !!me.pveSelNode.data.template;
        var rstore = me.statusStore;

        var items = [
            {
                xtype: template ? 'pveTemplateStatusView' : 'pveGuestStatusView',
                flex: 1,
                padding: template ? '5' : '0 5 0 0',
                itemId: 'gueststatus',
                pveSelNode: me.pveSelNode,
                rstore: rstore,
            },
            {
                xtype: 'pmxNotesView',
                flex: 1,
                padding: template ? '5' : '0 0 0 5',
                itemId: 'notesview',
                pveSelNode: me.pveSelNode,
            },
        ];

        var rrdstore;
        if (!template) {
            // in non-template mode put the two panels always together
            items = [
                {
                    xtype: 'container',
                    height: 300,
                    layout: {
                        type: 'hbox',
                        align: 'stretch',
                    },
                    items: items,
                },
            ];

            rrdstore = Ext.create('Proxmox.data.RRDStore', {
                rrdurl: `/api2/json/nodes/${nodename}/${type}/${vmid}/rrddata`,
                model: 'pve-rrd-guest',
            });

            items.push(
                {
                    xtype: 'proxmoxRRDChart',
                    title: gettext('CPU usage'),
                    pveSelNode: me.pveSelNode,
                    fields: ['cpu'],
                    fieldTitles: [gettext('CPU usage')],
                    unit: 'percent',
                    store: rrdstore,
                },
                {
                    xtype: 'proxmoxRRDChart',
                    title: gettext('Memory usage'),
                    pveSelNode: me.pveSelNode,
                    fields: ['maxmem', 'mem'],
                    fieldTitles: [gettext('Total'), gettext('RAM usage')],
                    unit: 'bytes',
                    powerOfTwo: true,
                    store: rrdstore,
                },
                {
                    xtype: 'proxmoxRRDChart',
                    title: gettext('Network traffic'),
                    pveSelNode: me.pveSelNode,
                    fields: ['netin', 'netout'],
                    store: rrdstore,
                },
                {
                    xtype: 'proxmoxRRDChart',
                    title: gettext('Disk IO'),
                    pveSelNode: me.pveSelNode,
                    fields: ['diskread', 'diskwrite'],
                    store: rrdstore,
                },
            );
        }

        Ext.apply(me, {
            tbar: ['->', { xtype: 'proxmoxRRDTypeSelector' }],
            items: [
                {
                    xtype: 'container',
                    itemId: 'itemcontainer',
                    layout: {
                        type: 'column',
                    },
                    minWidth: 700,
                    defaults: {
                        minHeight: 330,
                        padding: 5,
                    },
                    items: items,
                    listeners: {
                        resize: function (container) {
                            Proxmox.Utils.updateColumns(container);
                        },
                    },
                },
            ],
        });

        me.callParent();
        if (!template) {
            rrdstore.startUpdate();
            me.on('destroy', rrdstore.stopUpdate);
        }
        let sp = Ext.state.Manager.getProvider();
        me.mon(sp, 'statechange', function (provider, key, value) {
            if (key !== 'summarycolumns') {
                return;
            }
            Proxmox.Utils.updateColumns(me.getComponent('itemcontainer'));
        });
    },
});
Ext.define('PVE.panel.TemplateStatusView', {
    extend: 'Proxmox.panel.StatusView',
    alias: 'widget.pveTemplateStatusView',

    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    defaults: {
        xtype: 'pmxInfoWidget',
        printBar: false,
        padding: '2 25',
    },
    items: [
        {
            xtype: 'box',
            height: 20,
        },
        {
            itemId: 'hamanaged',
            iconCls: 'fa fa-heartbeat fa-fw',
            title: gettext('HA State'),
            printBar: false,
            textField: 'ha',
            renderer: PVE.Utils.format_ha,
        },
        {
            itemId: 'node',
            iconCls: 'fa fa-fw fa-building',
            title: gettext('Node'),
        },
        {
            xtype: 'box',
            height: 20,
        },
        {
            itemId: 'cpus',
            iconCls: 'fa fa-fw pmx-itype-icon-processor pmx-icon',
            title: gettext('Processors'),
            textField: 'cpus',
        },
        {
            itemId: 'memory',
            iconCls: 'fa fa-fw pmx-itype-icon-memory pmx-icon',
            title: gettext('Memory'),
            textField: 'maxmem',
            renderer: Proxmox.Utils.render_size,
        },
        {
            itemId: 'swap',
            iconCls: 'fa fa-refresh fa-fw',
            title: gettext('Swap'),
            textField: 'maxswap',
            renderer: Proxmox.Utils.render_size,
        },
        {
            itemId: 'disk',
            iconCls: 'fa fa-hdd-o fa-fw',
            title: gettext('Bootdisk size'),
            textField: 'maxdisk',
            renderer: Proxmox.Utils.render_size,
        },
        {
            xtype: 'box',
            height: 20,
        },
    ],

    initComponent: function () {
        var me = this;

        var name = me.pveSelNode.data.name;
        if (!name) {
            throw 'no name specified';
        }

        me.title = name;

        me.callParent();
        if (me.pveSelNode.data.type !== 'lxc') {
            me.remove(me.getComponent('swap'));
        }
        me.getComponent('node').updateValue(me.pveSelNode.data.node);
    },
});
Ext.define('PVE.panel.MultiDiskPanel', {
    extend: 'Ext.panel.Panel',

    setNodename: function (nodename) {
        this.items.each((panel) => panel.setNodename(nodename));
    },

    border: false,
    bodyBorder: false,

    layout: 'card',

    controller: {
        xclass: 'Ext.app.ViewController',

        vmconfig: {},

        onAdd: function () {
            let me = this;
            me.lookup('addButton').setDisabled(true);
            me.addDisk();
            let count = me.lookup('grid').getStore().getCount() + 1; // +1 is from ide2
            me.lookup('addButton').setDisabled(count >= me.maxCount);
        },

        getNextFreeDisk: function (vmconfig) {
            throw 'implement in subclass';
        },

        addPanel: function (itemId, vmconfig, nextFreeDisk) {
            throw 'implement in subclass';
        },

        // define in subclass
        diskSorter: undefined,

        addDisk: function () {
            let me = this;
            let grid = me.lookup('grid');
            let store = grid.getStore();

            // get free disk id
            let vmconfig = me.getVMConfig(true);
            let nextFreeDisk = me.getNextFreeDisk(vmconfig);
            if (!nextFreeDisk) {
                return;
            }

            // add store entry + panel
            let itemId = 'disk-card-' + ++Ext.idSeed;
            let rec = store.add({
                name: nextFreeDisk.confid,
                itemId,
            })[0];

            let panel = me.addPanel(itemId, vmconfig, nextFreeDisk);
            panel.updateVMConfig(vmconfig);

            // we need to setup a validitychange handler, so that we can show
            // that a disk has invalid fields
            let fields = panel.query('field');
            fields.forEach((el) =>
                el.on('validitychange', () => {
                    let valid = fields.every((field) => field.isValid());
                    rec.set('valid', valid);
                    me.checkValidity();
                }),
            );

            store.sort(me.diskSorter);

            // select if the panel added is the only one
            if (store.getCount() === 1) {
                grid.getSelectionModel().select(0, false);
            }
        },

        getBaseVMConfig: function () {
            throw 'implement in subclass';
        },

        getVMConfig: function (all) {
            let me = this;

            let vmconfig = me.getBaseVMConfig();

            me.lookup('grid')
                .getStore()
                .each((rec) => {
                    if (all || rec.get('valid')) {
                        vmconfig[rec.get('name')] = rec.get('itemId');
                    }
                });

            return vmconfig;
        },

        checkValidity: function () {
            let me = this;
            let valid = me.lookup('grid').getStore().findExact('valid', false) === -1;
            me.lookup('validationfield').setValue(valid);
        },

        updateVMConfig: function () {
            let me = this;
            let view = me.getView();
            let grid = me.lookup('grid');
            let store = grid.getStore();

            let vmconfig = me.getVMConfig();

            let valid = true;

            store.each((rec) => {
                let itemId = rec.get('itemId');
                let name = rec.get('name');
                let panel = view.getComponent(itemId);
                if (!panel) {
                    throw 'unexpected missing panel';
                }

                // copy config for each panel and remote its own id
                let panel_vmconfig = Ext.apply({}, vmconfig);
                if (panel_vmconfig[name] === itemId) {
                    delete panel_vmconfig[name];
                }

                if (!rec.get('valid')) {
                    valid = false;
                }

                panel.updateVMConfig(panel_vmconfig);
            });

            me.lookup('validationfield').setValue(valid);

            return vmconfig;
        },

        onChange: function (panel, newVal) {
            let me = this;
            let store = me.lookup('grid').getStore();

            let el = store.findRecord('itemId', panel.itemId, 0, false, true, true);
            if (el.get('name') === newVal) {
                // do not update if there was no change
                return;
            }

            el.set('name', newVal);
            el.commit();

            store.sort(me.diskSorter);

            // so that it happens after the layouting
            setTimeout(function () {
                me.updateVMConfig();
            }, 10);
        },

        onRemove: function (tableview, rowIndex, colIndex, item, event, record) {
            let me = this;
            let grid = me.lookup('grid');
            let store = grid.getStore();
            let removed_idx = store.indexOf(record);

            let selection = grid.getSelection()[0];
            let selected_idx = store.indexOf(selection);

            if (selected_idx === removed_idx) {
                let newidx = store.getCount() > removed_idx + 1 ? removed_idx + 1 : removed_idx - 1;
                grid.getSelectionModel().select(newidx, false);
            }

            store.remove(record);
            me.getView().remove(record.get('itemId'));
            me.lookup('addButton').setDisabled(false);
            me.updateVMConfig();
            me.checkValidity();
        },

        onSelectionChange: function (grid, selection) {
            let me = this;
            if (!selection || selection.length < 1) {
                return;
            }

            me.getView().setActiveItem(selection[0].data.itemId);
        },

        control: {
            inputpanel: {
                diskidchange: 'onChange',
            },
            'grid[reference=grid]': {
                selectionchange: 'onSelectionChange',
            },
        },

        init: function (view) {
            let me = this;
            me.onAdd();
            me.lookup('grid').getSelectionModel().select(0, false);
        },
    },

    dockedItems: [
        {
            xtype: 'container',
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            dock: 'left',
            border: false,
            width: 130,
            items: [
                {
                    xtype: 'grid',
                    hideHeaders: true,
                    reference: 'grid',
                    flex: 1,
                    emptyText: gettext('No Disks'),
                    margin: '0 0 5 0',
                    store: {
                        fields: ['name', 'itemId', 'valid'],
                        data: [],
                    },
                    columns: [
                        {
                            dataIndex: 'name',
                            renderer: function (val, md, rec) {
                                let warn = '';
                                if (!rec.get('valid')) {
                                    warn = ' <i class="fa warning fa-warning"></i>';
                                }
                                return val + warn;
                            },
                            flex: 1,
                        },
                        {
                            xtype: 'actioncolumn',
                            width: 30,
                            align: 'center',
                            menuDisabled: true,
                            items: [
                                {
                                    iconCls: 'x-fa fa-trash critical',
                                    tooltip: 'Delete',
                                    handler: 'onRemove',
                                    isActionDisabled: 'deleteDisabled',
                                },
                            ],
                        },
                    ],
                },
                {
                    xtype: 'button',
                    reference: 'addButton',
                    text: gettext('Add'),
                    iconCls: 'fa fa-plus-circle',
                    handler: 'onAdd',
                },
                {
                    // dummy field to control wizard validation
                    xtype: 'textfield',
                    hidden: true,
                    reference: 'validationfield',
                    submitValue: false,
                    value: true,
                    validator: (val) => !!val,
                },
            ],
        },
    ],
});
Ext.define('PVE.panel.TagConfig', {
    extend: 'PVE.panel.Config',
    alias: 'widget.pveTagConfig',

    //onlineHelp: 'gui_tags', // TODO: use this one once available
    onlineHelp: 'chapter_gui',
});
/*
 * Left Treepanel, containing all the resources we manage in this datacenter: server nodes, server storages, VMs and Containers
 */
Ext.define('PVE.tree.ResourceTree', {
    extend: 'Ext.tree.TreePanel',
    alias: ['widget.pveResourceTree'],

    userCls: 'proxmox-tags-circle',

    statics: {
        typeDefaults: {
            node: {
                iconCls: 'fa fa-building',
                text: gettext('Nodes'),
            },
            pool: {
                iconCls: 'fa fa-tags',
                text: gettext('Resource Pool'),
            },
            storage: {
                iconCls: 'fa fa-database',
                text: gettext('Storage'),
            },
            sdn: {
                iconCls: 'fa fa-th',
                text: gettext('SDN'),
            },
            qemu: {
                iconCls: 'fa fa-desktop',
                text: gettext('Virtual Machine'),
            },
            lxc: {
                //iconCls: 'x-tree-node-lxc',
                iconCls: 'fa fa-cube',
                text: gettext('LXC Container'),
            },
            template: {
                iconCls: 'fa fa-file-o',
            },
            tag: {
                iconCls: 'fa fa-tag',
            },
        },
    },

    useArrows: true,

    // private
    getTypeOrder: function (type) {
        switch (type) {
            case 'lxc':
                return 0;
            case 'qemu':
                return 1;
            case 'node':
                return 2;
            case 'sdn':
                return 3;
            case 'storage':
                return 4;
            default:
                return 9;
        }
    },

    // private
    nodeSortFn: function (node1, node2) {
        let me = this;
        let n1 = node1.data,
            n2 = node2.data;

        if (!n1.groupbyid === !n2.groupbyid) {
            let n1IsGuest = n1.type === 'qemu' || n1.type === 'lxc';
            let n2IsGuest = n2.type === 'qemu' || n2.type === 'lxc';
            if (me['group-guest-types'] || !n1IsGuest || !n2IsGuest) {
                // first sort (group) by type
                let res = me.getTypeOrder(n1.type) - me.getTypeOrder(n2.type);
                if (res !== 0) {
                    return res;
                }
            }

            // then sort (group) by ID
            if (n1IsGuest) {
                if (me['group-templates'] && !n1.template !== !n2.template) {
                    return n1.template ? 1 : -1; // sort templates after regular VMs
                }
                if (me['sort-field'] === 'vmid') {
                    if (n1.vmid > n2.vmid) {
                        // prefer VMID as metric for guests
                        return 1;
                    } else if (n1.vmid < n2.vmid) {
                        return -1;
                    }
                } else {
                    return n1.name.localeCompare(n2.name);
                }
            }
            // same types but not a guest
            return n1.id > n2.id ? 1 : n1.id < n2.id ? -1 : 0;
        } else if (n1.groupbyid) {
            return -1;
        } else if (n2.groupbyid) {
            return 1;
        }
        return 0; // should not happen
    },

    // private: fast binary search
    findInsertIndex: function (node, child, start, end) {
        let me = this;

        let diff = end - start;
        if (diff <= 0) {
            return start;
        }
        let mid = start + (diff >> 1);

        let res = me.nodeSortFn(child, node.childNodes[mid]);
        if (res <= 0) {
            return me.findInsertIndex(node, child, start, mid);
        } else {
            return me.findInsertIndex(node, child, mid + 1, end);
        }
    },

    setIconCls: function (info) {
        let cls = PVE.Utils.get_object_icon_class(info.type, info);
        if (cls !== '') {
            info.iconCls = cls;
        }
    },

    setText: function (info) {
        let _me = this;

        let status = '';
        if (info.type === 'storage') {
            let usage = info.disk / info.maxdisk;
            if (usage >= 0.0 && usage <= 1.0) {
                let barHeight = (usage * 100).toFixed(0);
                let remainingHeight = (100 - barHeight).toFixed(0);
                status = '<div class="usage-wrapper">';
                status += `<div class="usage-negative" style="height: ${remainingHeight}%"></div>`;
                status += `<div class="usage" style="height: ${barHeight}%"></div>`;
                status += '</div> ';
            }
        }
        if (Ext.isNumeric(info.vmid) && info.vmid > 0) {
            if (PVE.UIOptions.getTreeSortingValue('sort-field') !== 'vmid') {
                info.text = `${info.name} (${String(info.vmid)})`;
            }
        }
        info.text = `<span>${status}${info.text}</span>`;
        info.text += PVE.Utils.renderTags(info.tags, PVE.UIOptions.tagOverrides);
    },

    getToolTip: function (info) {
        let qtips = [];
        if (info.qmpstatus || info.status) {
            qtips.push(Ext.String.format(gettext('Status: {0}'), info.qmpstatus || info.status));
        }
        if (info.lock) {
            qtips.push(Ext.String.format(gettext('Config locked ({0})'), info.lock));
        }
        if (info.hastate !== 'unmanaged') {
            qtips.push(Ext.String.format(gettext('HA State: {0}'), info.hastate));
        }
        if (info.type === 'storage') {
            let usage = info.disk / info.maxdisk;
            if (usage >= 0.0 && usage <= 1.0) {
                qtips.push(Ext.String.format(gettext('Usage: {0}%'), (usage * 100).toFixed(2)));
            }
        }

        if (qtips.length === 0) {
            return undefined;
        }

        let tip = qtips.join(', ');
        info.tip = tip;
        return tip;
    },

    // private
    addChildSorted: function (node, info) {
        let me = this;

        me.setIconCls(info);
        me.setText(info);

        if (info.groupbyid) {
            if (me.viewFilter.groupRenderer) {
                info.text = me.viewFilter.groupRenderer(info);
            } else if (info.type === 'type') {
                let defaults = PVE.tree.ResourceTree.typeDefaults[info.groupbyid];
                if (defaults && defaults.text) {
                    info.text = defaults.text;
                }
            } else {
                info.text = info.groupbyid;
            }
        }
        let child = Ext.create('PVETree', info);

        if (node.childNodes) {
            let pos = me.findInsertIndex(node, child, 0, node.childNodes.length);
            node.insertBefore(child, node.childNodes[pos]);
        } else {
            node.insertBefore(child);
        }

        return child;
    },

    // private
    groupChild: function (node, info, groups, level) {
        let me = this;

        let groupBy = groups[level];
        let v = info[groupBy];

        if (v) {
            let group = node.findChild('groupbyid', v);
            if (!group) {
                let groupinfo;
                if (info.type === groupBy) {
                    groupinfo = info;
                } else {
                    groupinfo = {
                        type: groupBy,
                        id: groupBy + '/' + v,
                    };
                    if (groupBy !== 'type') {
                        groupinfo[groupBy] = v;
                    }
                }
                groupinfo.leaf = false;
                groupinfo.groupbyid = v;
                group = me.addChildSorted(node, groupinfo);
            }
            if (info.type === groupBy) {
                return group;
            }
            if (group) {
                return me.groupChild(group, info, groups, level + 1);
            }
        }

        return me.addChildSorted(node, info);
    },

    saveSortingOptions: function () {
        let me = this;
        let changed = false;
        for (const key of ['sort-field', 'group-templates', 'group-guest-types']) {
            let newValue = PVE.UIOptions.getTreeSortingValue(key);
            if (me[key] !== newValue) {
                me[key] = newValue;
                changed = true;
            }
        }
        return changed;
    },

    initComponent: function () {
        let me = this;
        me.saveSortingOptions();

        let rstore = PVE.data.ResourceStore;
        let sp = Ext.state.Manager.getProvider();

        if (!me.viewFilter) {
            me.viewFilter = {};
        }

        let pdata = {
            dataIndex: {},
            updateCount: 0,
        };

        let store = Ext.create('Ext.data.TreeStore', {
            model: 'PVETree',
            root: {
                expanded: true,
                id: 'root',
                text: gettext('Datacenter'),
                iconCls: 'fa fa-server',
            },
        });

        let stateid = 'rid';

        const changedFields = [
            'disk',
            'maxdisk',
            'vmid',
            'name',
            'type',
            'running',
            'template',
            'status',
            'qmpstatus',
            'hastate',
            'lock',
            'tags',
        ];

        // special case ids from the tag view, since they change the id in the state
        let idMapFn = function (id) {
            if (!id) {
                return undefined;
            }
            if (id.startsWith('qemu') || id.startsWith('lxc')) {
                let [realId, _tag] = id.split('-');
                return realId;
            }
            return id;
        };

        let findNode = function (rootNode, id) {
            if (!id) {
                return undefined;
            }
            let node = rootNode.findChild('id', id, true);
            if (!node) {
                node = rootNode.findChildBy(
                    (r) => idMapFn(r.data.id) === idMapFn(id),
                    undefined,
                    true,
                );
            }
            return node;
        };

        let firstUpdate = true;

        let updateTree = function () {
            store.suspendEvents();

            let rootnode;
            if (firstUpdate) {
                rootnode = Ext.create('PVETree', {
                    expanded: true,
                    id: 'root',
                    text: gettext('Datacenter'),
                    iconCls: 'fa fa-server',
                });
            } else {
                rootnode = me.store.getRootNode();
            }
            // remember selected node (and all parents)
            let sm = me.getSelectionModel();
            let lastsel = sm.getSelection()[0];
            let parents = [];
            let sorting_changed = me.saveSortingOptions();
            for (let node = lastsel; node; node = node.parentNode) {
                parents.push(node);
            }

            let groups = me.viewFilter.groups || [];
            // explicitly check for node/template, as those are not always grouping attributes
            let attrMoveChecks = me.viewFilter.attrMoveChecks ?? {};

            // also check for name for when the tree is sorted by name
            let moveCheckAttrs = groups.concat(['node', 'template', 'name']);
            let filterFn = me.viewFilter.getFilterFn ? me.viewFilter.getFilterFn() : Ext.identityFn;

            let reselect = false; // for disappeared nodes
            let index = pdata.dataIndex;
            // remove vanished or moved items and update changed items in-place
            for (const [key, olditem] of Object.entries(index)) {
                // getById() use find(), which is slow (ExtJS4 DP5)
                let oldid = olditem.data.id;
                let id = idMapFn(olditem.data.id);
                let item = rstore.data.get(id);

                let changed = sorting_changed,
                    moved = sorting_changed;
                if (item) {
                    // test if any grouping attributes changed, catches migrated tree-nodes in server view too
                    for (const attr of moveCheckAttrs) {
                        if (attrMoveChecks[attr]) {
                            if (attrMoveChecks[attr](olditem, item)) {
                                moved = true;
                                break;
                            }
                        } else if (item.data[attr] !== olditem.data[attr]) {
                            moved = true;
                            break;
                        }
                    }

                    // tree item has been updated
                    for (const field of changedFields) {
                        if (item.data[field] !== olditem.data[field]) {
                            changed = true;
                            break;
                        }
                    }
                    // FIXME: also test filterfn()?
                }

                if (changed) {
                    olditem.beginEdit();
                    let info = olditem.data;
                    Ext.apply(info, item.data);
                    if (info.id !== oldid) {
                        info.id = oldid;
                    }
                    me.setIconCls(info);
                    me.setText(info);
                    olditem.commit();
                }
                if ((!item || moved) && olditem.isLeaf()) {
                    delete index[key];
                    let parentNode = olditem.parentNode;
                    // a selected item moved (migration) or disappeared (destroyed), so deselect that
                    // node now and try to reselect the moved (or its parent) node later
                    if (lastsel && olditem.data.id === lastsel.data.id) {
                        reselect = true;
                        sm.deselect(olditem);
                    }
                    // store events are suspended, so remove the item manually
                    store.remove(olditem);
                    parentNode.removeChild(olditem, true);
                    if (parentNode.childNodes.length < 1 && parentNode.parentNode) {
                        let grandParent = parentNode.parentNode;
                        grandParent.removeChild(parentNode, true);
                    }
                }
            }

            let items = rstore.getData().items.flatMap(me.viewFilter.itemMap ?? Ext.identityFn);
            items.forEach(function (item) {
                // add new items
                let olditem = index[item.data.id];
                if (olditem) {
                    return;
                }
                if (filterFn && !filterFn(item)) {
                    return;
                }
                let info = Ext.apply({ leaf: true }, item.data);

                let child = me.groupChild(rootnode, info, groups, 0);
                if (child) {
                    index[item.data.id] = child;
                }
            });

            store.resumeEvents();
            store.fireEvent('refresh', store);

            let foundChild = findNode(rootnode, lastsel?.data.id);

            // select parent node if original selected node vanished
            if (lastsel && !foundChild) {
                lastsel = rootnode;
                for (const node of parents) {
                    if (rootnode.findChild('id', node.data.id, true)) {
                        lastsel = node;
                        break;
                    }
                }
                me.selectById(lastsel.data.id);
            } else if (lastsel && reselect) {
                me.selectById(lastsel.data.id);
            }

            if (firstUpdate) {
                me.store.setRoot(rootnode);
                firstUpdate = false;
            }

            // on first tree load set the selection from the stateful provider
            if (!pdata.updateCount) {
                rootnode.expand();
                me.applyState(sp.get(stateid));
            }

            pdata.updateCount++;
        };

        sp.on('statechange', (_sp, key, value) => {
            if (key === stateid) {
                me.applyState(value);
            }
        });

        Ext.apply(me, {
            allowSelection: true,
            store: store,
            viewConfig: {
                animate: false, // note: animate cause problems with applyState
            },
            listeners: {
                itemcontextmenu: PVE.Utils.createCmdMenu,
                destroy: function () {
                    rstore.un('load', updateTree);
                },
                beforecellmousedown: function (tree, td, cellIndex, record, tr, rowIndex, ev) {
                    let sm = me.getSelectionModel();
                    // disable selection when right clicking except if the record is already selected
                    me.allowSelection = ev.button !== 2 || sm.isSelected(record);
                },
                beforeselect: function (tree, record, index, eopts) {
                    let allow = me.allowSelection;
                    me.allowSelection = true;
                    return allow;
                },
                itemdblclick: PVE.Utils.openTreeConsole,
                afterrender: function () {
                    if (me.tip) {
                        return;
                    }
                    let selectors = [
                        '.x-tree-node-text > span:not(.proxmox-tag-dark):not(.proxmox-tag-light)',
                        '.x-tree-icon',
                    ];
                    me.tip = Ext.create('Ext.tip.ToolTip', {
                        target: me.el,
                        delegate: selectors.join(', '),
                        trackMouse: true,
                        renderTo: Ext.getBody(),
                        listeners: {
                            beforeshow: function (tip) {
                                let rec = me.getView().getRecord(tip.triggerElement);
                                let tipText = me.getToolTip(rec.data);
                                if (tipText) {
                                    tip.update(tipText);
                                    return true;
                                }
                                return false;
                            },
                        },
                    });
                },
            },
            setViewFilter: function (view) {
                me.viewFilter = view;
                me.clearTree();
                updateTree();
            },
            setDatacenterText: function (clustername) {
                let rootnode = me.store.getRootNode();

                let rnodeText = gettext('Datacenter');
                if (clustername !== undefined) {
                    rnodeText += ' (' + clustername + ')';
                }

                rootnode.beginEdit();
                rootnode.data.text = rnodeText;
                rootnode.commit();
            },
            clearTree: function () {
                pdata.updateCount = 0;
                let rootnode = me.store.getRootNode();
                rootnode.collapse();
                rootnode.removeAll();
                pdata.dataIndex = {};
                me.getSelectionModel().deselectAll();
            },
            selectExpand: function (node) {
                let sm = me.getSelectionModel();
                if (!sm.isSelected(node)) {
                    sm.select(node);
                    for (let iter = node; iter; iter = iter.parentNode) {
                        if (!iter.isExpanded()) {
                            iter.expand();
                        }
                    }
                    me.getView().focusRow(node);
                }
            },
            selectById: function (nodeid) {
                let rootnode = me.store.getRootNode();
                let node;
                if (nodeid === 'root') {
                    node = rootnode;
                } else {
                    node = findNode(rootnode, nodeid);
                }
                if (node) {
                    me.selectExpand(node);
                }
                return node;
            },
            applyState: function (state) {
                if (state && state.value) {
                    me.selectById(state.value);
                } else {
                    me.getSelectionModel().deselectAll();
                }
            },
        });

        me.callParent();

        me.getSelectionModel().on('select', (_sm, n) => sp.set(stateid, { value: n.data.id }));

        rstore.on('load', updateTree);
        rstore.startUpdate();

        me.mon(Ext.GlobalEvents, 'loadedUiOptions', () => {
            me.store.getRootNode().cascadeBy({
                before: function (node) {
                    if (node.data.groupbyid) {
                        node.beginEdit();
                        let info = node.data;
                        me.setIconCls(info);
                        me.setText(info);
                        if (me.viewFilter.groupRenderer) {
                            info.text = me.viewFilter.groupRenderer(info);
                        }
                        node.commit();
                    }
                    return true;
                },
            });
        });
    },
});
Ext.define('PVE.guest.SnapshotTree', {
    extend: 'Ext.tree.Panel',
    xtype: 'pveGuestSnapshotTree',

    stateful: true,
    stateId: 'grid-snapshots',

    viewModel: {
        data: {
            // should be 'qemu' or 'lxc'
            type: undefined,
            nodename: undefined,
            vmid: undefined,
            vmname: undefined,
            snapshotAllowed: false,
            rollbackAllowed: false,
            snapshotFeature: false,
            running: false,
            selected: '',
            load_delay: 3000,
        },
        formulas: {
            canSnapshot: (get) => get('snapshotAllowed') && get('snapshotFeature'),
            canRollback: (get) => get('rollbackAllowed') && get('isSnapshot'),
            canRemove: (get) => get('snapshotAllowed') && get('isSnapshot'),
            isSnapshot: (get) => get('selected') && get('selected') !== 'current',
            buttonText: (get) => (get('snapshotAllowed') ? gettext('Edit') : gettext('View')),
            showMemory: (get) => get('type') === 'qemu',
        },
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        newSnapshot: function () {
            this.run_editor(false);
        },

        editSnapshot: function () {
            this.run_editor(true);
        },

        run_editor: function (edit) {
            let me = this;
            let vm = me.getViewModel();
            let snapname;
            if (edit) {
                snapname = vm.get('selected');
                if (!snapname || snapname === 'current') {
                    return;
                }
            }
            let win = Ext.create('PVE.window.Snapshot', {
                nodename: vm.get('nodename'),
                vmid: vm.get('vmid'),
                vmname: vm.get('vmname'),
                viewonly: !vm.get('snapshotAllowed'),
                type: vm.get('type'),
                isCreate: !edit,
                submitText: !edit ? gettext('Take Snapshot') : undefined,
                snapname: snapname,
                running: vm.get('running'),
            });
            win.show();
            me.mon(win, 'destroy', me.reload, me);
        },

        snapshotAction: function (action, method) {
            let me = this;
            let view = me.getView();
            let vm = me.getViewModel();
            let snapname = vm.get('selected');
            if (!snapname) {
                return;
            }

            let nodename = vm.get('nodename');
            let type = vm.get('type');
            let vmid = vm.get('vmid');

            Proxmox.Utils.API2Request({
                url: `/nodes/${nodename}/${type}/${vmid}/snapshot/${snapname}/${action}`,
                method: method,
                waitMsgTarget: view,
                callback: function () {
                    me.reload();
                },
                failure: function (response, opts) {
                    Ext.Msg.alert(gettext('Error'), response.htmlStatus);
                },
                success: function (response, options) {
                    var upid = response.result.data;
                    var win = Ext.create('Proxmox.window.TaskProgress', { upid: upid });
                    win.show();
                },
            });
        },

        rollback: function () {
            this.snapshotAction('rollback', 'POST');
        },
        remove: function () {
            this.snapshotAction('', 'DELETE');
        },
        cancel: function () {
            this.load_task.cancel();
        },

        reload: function () {
            let me = this;
            let view = me.getView();
            let vm = me.getViewModel();
            let nodename = vm.get('nodename');
            let vmid = vm.get('vmid');
            let type = vm.get('type');
            let load_delay = vm.get('load_delay');

            Proxmox.Utils.API2Request({
                url: `/nodes/${nodename}/${type}/${vmid}/snapshot`,
                method: 'GET',
                failure: function (response, opts) {
                    if (me.destroyed) {
                        return;
                    }
                    Proxmox.Utils.setErrorMask(view, response.htmlStatus);
                    me.load_task.delay(load_delay);
                },
                success: function (response, opts) {
                    if (me.destroyed) {
                        // this is in a delayed task, avoid dragons if view has
                        // been destroyed already and go home.
                        return;
                    }
                    Proxmox.Utils.setErrorMask(view, false);
                    var digest = 'invalid';
                    var idhash = {};
                    var root = { name: '__root', expanded: true, children: [] };
                    Ext.Array.each(response.result.data, function (item) {
                        item.leaf = true;
                        item.children = [];
                        if (item.name === 'current') {
                            vm.set('running', !!item.running);
                            digest = item.digest + item.running;
                            item.iconCls = PVE.Utils.get_object_icon_class(vm.get('type'), item);
                        } else {
                            item.iconCls = 'fa fa-fw fa-history x-fa-tree';
                        }
                        idhash[item.name] = item;
                    });

                    if (digest !== me.old_digest) {
                        me.old_digest = digest;

                        Ext.Array.each(response.result.data, function (item) {
                            if (item.parent && idhash[item.parent]) {
                                let parent_item = idhash[item.parent];
                                parent_item.children.push(item);
                                parent_item.leaf = false;
                                parent_item.expanded = true;
                                parent_item.expandable = false;
                            } else {
                                root.children.push(item);
                            }
                        });

                        me.getView().setRootNode(root);
                    }

                    me.load_task.delay(load_delay);
                },
            });

            // if we do not have the permissions, we don't have to check
            // if we can create a snapshot, since the butten stays disabled
            if (!vm.get('snapshotAllowed')) {
                return;
            }

            Proxmox.Utils.API2Request({
                url: `/nodes/${nodename}/${type}/${vmid}/feature`,
                params: { feature: 'snapshot' },
                method: 'GET',
                success: function (response, options) {
                    if (me.destroyed) {
                        // this is in a delayed task, the current view could been
                        // destroyed already; then we mustn't do viemodel set
                        return;
                    }
                    let res = response.result.data;
                    vm.set('snapshotFeature', !!res.hasFeature);
                },
            });
        },

        select: function (grid, val) {
            let vm = this.getViewModel();
            if (val.length < 1) {
                vm.set('selected', '');
                return;
            }
            vm.set('selected', val[0].data.name);
        },

        init: function (view) {
            let me = this;
            let vm = me.getViewModel();
            me.load_task = new Ext.util.DelayedTask(me.reload, me);

            if (!view.type) {
                throw 'guest type not set';
            }
            vm.set('type', view.type);

            if (!view.pveSelNode.data.node) {
                throw 'no node name specified';
            }
            vm.set('nodename', view.pveSelNode.data.node);

            if (!view.pveSelNode.data.vmid) {
                throw 'no VM ID specified';
            }
            vm.set('vmid', view.pveSelNode.data.vmid);

            vm.set('vmname', view.pveSelNode.data.name);

            let caps = Ext.state.Manager.get('GuiCap');
            vm.set('snapshotAllowed', !!caps.vms['VM.Snapshot']);
            vm.set('rollbackAllowed', !!caps.vms['VM.Snapshot.Rollback']);

            view.getStore().sorters.add({
                property: 'order',
                direction: 'ASC',
            });

            me.reload();
        },
    },

    listeners: {
        selectionchange: 'select',
        itemdblclick: 'editSnapshot',
        beforedestroy: 'cancel',
    },

    layout: 'fit',
    rootVisible: false,
    animate: false,
    sortableColumns: false,

    tbar: [
        {
            xtype: 'proxmoxButton',
            text: gettext('Take Snapshot'),
            disabled: true,
            bind: {
                disabled: '{!canSnapshot}',
            },
            handler: 'newSnapshot',
        },
        '-',
        {
            xtype: 'proxmoxButton',
            text: gettext('Rollback'),
            disabled: true,
            bind: {
                disabled: '{!canRollback}',
            },
            confirmMsg: function () {
                let view = this.up('treepanel');
                let rec = view.getSelection()[0];
                let vmid = view.getViewModel().get('vmid');
                let vmname = view.getViewModel().get('vmname');
                let message =
                    PVE.Utils.formatGuestTaskConfirmation('qmrollback', vmid, vmname) +
                    ` '${rec.data.name}'? ${gettext('Current state will be lost.')}`;
                return Ext.htmlEncode(message);
            },
            handler: 'rollback',
        },
        '-',
        {
            xtype: 'proxmoxButton',
            text: gettext('Edit'),
            bind: {
                text: '{buttonText}',
                disabled: '{!isSnapshot}',
            },
            disabled: true,
            edit: true,
            handler: 'editSnapshot',
        },
        {
            xtype: 'proxmoxButton',
            text: gettext('Remove'),
            disabled: true,
            dangerous: true,
            bind: {
                disabled: '{!canRemove}',
            },
            confirmMsg: function () {
                let view = this.up('treepanel');
                let { data } = view.getSelection()[0];
                return Ext.String.format(
                    gettext('Are you sure you want to remove entry {0}'),
                    `'${data.name}'`,
                );
            },
            handler: 'remove',
        },
        {
            xtype: 'label',
            text: gettext('The current guest configuration does not support taking new snapshots'),
            hidden: true,
            bind: {
                hidden: '{canSnapshot}',
            },
        },
    ],

    columnLines: true,

    fields: [
        'name',
        'description',
        'snapstate',
        'vmstate',
        'running',
        { name: 'snaptime', type: 'date', dateFormat: 'timestamp' },
        {
            name: 'order',
            calculate: function (data) {
                return data.snaptime || (data.name === 'current' ? 'ZZZ' : data.snapstate);
            },
        },
    ],

    columns: [
        {
            xtype: 'treecolumn',
            text: gettext('Name'),
            dataIndex: 'name',
            width: 200,
            renderer: (value, _, { data }) => (data.name !== 'current' ? value : gettext('NOW')),
        },
        {
            text: gettext('RAM'),
            hidden: true,
            bind: {
                hidden: '{!showMemory}',
            },
            align: 'center',
            resizable: false,
            dataIndex: 'vmstate',
            width: 50,
            renderer: (value, _, { data }) =>
                data.name !== 'current' ? Proxmox.Utils.format_boolean(value) : '',
        },
        {
            text: gettext('Date') + '/' + gettext('Status'),
            dataIndex: 'snaptime',
            width: 150,
            renderer: function (value, metaData, record) {
                if (record.data.snapstate) {
                    return record.data.snapstate;
                } else if (value) {
                    return Ext.Date.format(value, 'Y-m-d H:i:s');
                }
                return '';
            },
        },
        {
            text: gettext('Description'),
            dataIndex: 'description',
            flex: 1,
            renderer: function (value, metaData, record) {
                if (record.data.name === 'current') {
                    return gettext('You are here!');
                } else {
                    return Ext.String.htmlEncode(value);
                }
            },
        },
    ],
});
Ext.define('PVE.tree.ResourceMapTree', {
    extend: 'Ext.tree.Panel',
    alias: 'widget.pveResourceMapTree',
    mixins: ['Proxmox.Mixin.CBind'],

    rootVisible: false,

    emptyText: gettext('No Mapping found'),

    // will be opened on edit
    editWindowClass: undefined,

    // The base url of the resource
    baseUrl: undefined,

    // icon class to show on the entries
    mapIconCls: undefined,

    // if given, should be a function that takes a nodename and returns
    // the url for getting the data to check the status
    getStatusCheckUrl: undefined,

    // the result of above api call and the nodename is passed and can set the status
    checkValidity: undefined,

    // the property that denotes a single map entry for a node
    entryIdProperty: undefined,

    cbindData: function (initialConfig) {
        let me = this;
        const caps = Ext.state.Manager.get('GuiCap');
        me.canConfigure = !!caps.mapping['Mapping.Modify'];

        return {};
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        addMapping: function () {
            let me = this;
            let view = me.getView();
            Ext.create(view.editWindowClass, {
                url: view.baseUrl,
                autoShow: true,
                listeners: {
                    destroy: () => me.load(),
                },
            });
        },

        add: function (_grid, _rI, _cI, _item, _e, rec) {
            let me = this;
            if (rec.data.type !== 'entry') {
                return;
            }

            me.openMapEditWindow(rec.data.name);
        },

        editDblClick: function () {
            let me = this;
            let view = me.getView();
            let selection = view.getSelection();
            if (!selection || selection.length < 1) {
                return;
            }

            me.edit(selection[0]);
        },

        editAction: function (_grid, _rI, _cI, _item, _e, rec) {
            this.edit(rec);
        },

        edit: function (rec) {
            let me = this;
            if (rec.data.type === 'map') {
                return;
            }

            me.openMapEditWindow(rec.data.name, rec.data.node, rec.data.type === 'entry');
        },

        openMapEditWindow: function (name, nodename, entryOnly) {
            let me = this;
            let view = me.getView();

            Ext.create(view.editWindowClass, {
                url: `${view.baseUrl}/${name}`,
                autoShow: true,
                autoLoad: true,
                entryOnly,
                nodename,
                name,
                listeners: {
                    destroy: () => me.load(),
                },
            });
        },

        remove: function (_grid, _rI, _cI, _item, _e, rec) {
            let me = this;
            let msg, id;
            let view = me.getView();
            let confirmMsg;
            switch (rec.data.type) {
                case 'entry':
                    msg = gettext("Are you sure you want to remove '{0}'");
                    confirmMsg = Ext.String.format(msg, rec.data.name);
                    break;
                case 'node':
                    msg = gettext("Are you sure you want to remove '{0}' entries for '{1}'");
                    confirmMsg = Ext.String.format(msg, rec.data.node, rec.data.name);
                    break;
                case 'map':
                    msg = gettext("Are you sure you want to remove '{0}' on '{1}' for '{2}'");
                    id = rec.data[view.entryIdProperty];
                    confirmMsg = Ext.String.format(msg, id, rec.data.node, rec.data.name);
                    break;
                default:
                    throw 'invalid type';
            }
            Ext.Msg.confirm(gettext('Confirm'), confirmMsg, function (btn) {
                if (btn === 'yes') {
                    me.executeRemove(rec.data);
                }
            });
        },

        executeRemove: function (data) {
            let me = this;
            let view = me.getView();

            let url = `${view.baseUrl}/${data.name}`;
            let method = 'PUT';
            let params = {
                digest: me.lookup[data.name].digest,
            };
            let map = me.lookup[data.name].map;
            switch (data.type) {
                case 'entry':
                    method = 'DELETE';
                    params = undefined;
                    break;
                case 'node':
                    params.map = PVE.Parser.filterPropertyStringList(
                        map,
                        (e) => e.node !== data.node,
                    );
                    break;
                case 'map':
                    params.map = PVE.Parser.filterPropertyStringList(map, (e) =>
                        Object.entries(e).some(([key, value]) => data[key] !== value),
                    );
                    break;
                default:
                    throw 'invalid type';
            }
            if (!params?.map.length) {
                method = 'DELETE';
                params = undefined;
            }
            Proxmox.Utils.API2Request({
                url,
                method,
                params,
                success: function () {
                    me.load();
                },
            });
        },

        load: function () {
            let me = this;
            let view = me.getView();
            Proxmox.Utils.API2Request({
                url: view.baseUrl,
                method: 'GET',
                failure: (response) => Ext.Msg.alert(gettext('Error'), response.htmlStatus),
                success: function ({ result: { data } }) {
                    let lookup = {};
                    data.forEach((entry) => {
                        lookup[entry.id] = Ext.apply({}, entry);
                        entry.iconCls = 'fa fa-fw fa-folder-o';
                        entry.name = entry.id;
                        entry.text = entry.id;
                        entry.type = 'entry';

                        let nodes = {};
                        for (const map of entry.map) {
                            let parsed = PVE.Parser.parsePropertyString(map);
                            parsed.iconCls = view.mapIconCls;
                            parsed.leaf = true;
                            parsed.name = entry.id;
                            parsed.text = parsed[view.entryIdProperty];
                            parsed.type = 'map';

                            if (nodes[parsed.node] === undefined) {
                                nodes[parsed.node] = {
                                    children: [],
                                    expanded: true,
                                    iconCls: 'fa fa-fw fa-building-o',
                                    leaf: false,
                                    name: entry.id,
                                    node: parsed.node,
                                    text: parsed.node,
                                    type: 'node',
                                };
                            }
                            nodes[parsed.node].children.push(parsed);
                        }
                        delete entry.id;
                        entry.children = Object.values(nodes);
                        entry.leaf = entry.children.length === 0;
                    });
                    me.lookup = lookup;
                    if (view.getStatusCheckUrl !== undefined && view.checkValidity !== undefined) {
                        me.loadStatusData();
                    }
                    view.setRootNode({
                        children: data,
                    });
                    let root = view.getRootNode();
                    root.expand();
                    root.childNodes.forEach((node) => node.expand());
                },
            });
        },

        nodeLoadingState: {},

        loadStatusData: function () {
            let me = this;
            let view = me.getView();
            PVE.data.ResourceStore.getNodes().forEach(({ node }) => {
                me.nodeLoadingState[node] = true;
                let url = view.getStatusCheckUrl(node);
                Proxmox.Utils.API2Request({
                    url,
                    method: 'GET',
                    failure: function (response) {
                        me.nodeLoadingState[node] = false;
                        view.getRootNode()?.cascade(function (rec) {
                            if (rec.data.node !== node) {
                                return;
                            }

                            rec.set('valid', 0);
                            rec.set('errmsg', response.htmlStatus);
                            rec.commit();
                        });
                    },
                    success: function ({ result: { data } }) {
                        me.nodeLoadingState[node] = false;
                        view.checkValidity(data, node);
                    },
                });
            });
        },

        renderStatus: function (value, _metadata, record) {
            let me = this;
            if (record.data.type !== 'map') {
                return '';
            }
            let iconCls;
            let status;
            if (value === undefined) {
                if (me.nodeLoadingState[record.data.node]) {
                    iconCls = 'fa-spinner fa-spin';
                    status = gettext('Loading...');
                } else {
                    iconCls = 'fa-question-circle';
                    status = gettext('Unknown Node');
                }
            } else {
                let state = value ? 'good' : 'critical';
                iconCls = PVE.Utils.get_health_icon(state, true);
                status = value
                    ? gettext('Mapping matches host data')
                    : record.data.errmsg || Proxmox.Utils.unknownText;
            }
            return `<i class="fa ${iconCls}"></i> ${status}`;
        },

        getAddClass: function (v, mD, rec) {
            let cls = 'fa fa-plus-circle';
            if (
                rec.data.type !== 'entry' ||
                rec.data.children?.length >= PVE.data.ResourceStore.getNodes().length
            ) {
                cls += ' pmx-action-hidden';
            }
            return cls;
        },

        isAddDisabled: function (v, r, c, i, rec) {
            return (
                rec.data.type !== 'entry' ||
                rec.data.children?.length >= PVE.data.ResourceStore.getNodes().length
            );
        },

        init: function (view) {
            let me = this;

            ['editWindowClass', 'baseUrl', 'mapIconCls', 'entryIdProperty'].forEach((property) => {
                if (view[property] === undefined) {
                    throw `No ${property} defined`;
                }
            });

            me.load();
        },
    },

    store: {
        sorters: 'text',
        data: {},
    },

    tbar: [
        {
            text: gettext('Add'),
            handler: 'addMapping',
            cbind: {
                disabled: '{!canConfigure}',
            },
        },
    ],

    listeners: {
        itemdblclick: 'editDblClick',
    },

    initComponent: function () {
        let me = this;

        let columns = [...me.columns];
        columns.splice(1, 0, {
            xtype: 'actioncolumn',
            text: gettext('Actions'),
            width: 80,
            items: [
                {
                    getTip: (v, m, { data }) =>
                        Ext.String.format(gettext("Add new host mapping for '{0}'"), data.name),
                    getClass: 'getAddClass',
                    isActionDisabled: 'isAddDisabled',
                    handler: 'add',
                },
                {
                    iconCls: 'fa fa-pencil',
                    getTip: (v, m, { data }) =>
                        data.type === 'entry'
                            ? Ext.String.format(gettext("Edit Mapping '{0}'"), data.name)
                            : Ext.String.format(
                                  gettext("Edit Mapping '{0}' for '{1}'"),
                                  data.name,
                                  data.node,
                              ),
                    getClass: (v, m, { data }) =>
                        data.type !== 'map' ? 'fa fa-pencil' : 'pmx-hidden',
                    isActionDisabled: (v, r, c, i, rec) => rec.data.type === 'map',
                    handler: 'editAction',
                },
                {
                    iconCls: 'fa fa-trash-o',
                    getTip: (v, m, { data }) =>
                        data.type === 'entry'
                            ? Ext.String.format(gettext("Remove '{0}'"), data.name)
                            : data.type === 'node'
                              ? Ext.String.format(gettext("Remove mapping for '{0}'"), data.node)
                              : Ext.String.format(gettext("Remove mapping '{0}'"), data.path),
                    handler: 'remove',
                },
            ],
        });
        me.columns = columns;

        me.callParent();
    },
});
Ext.define('PVE.sdn.DhcpTree', {
    extend: 'Ext.tree.Panel',
    xtype: 'pveDhcpTree',

    layout: 'fit',
    rootVisible: false,
    animate: false,

    store: {
        sorters: ['ip', 'name'],
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        reload: function () {
            let me = this;

            Proxmox.Utils.API2Request({
                url: `/cluster/sdn/ipams/pve/status`,
                method: 'GET',
                success: function (response, opts) {
                    let root = {
                        name: '__root',
                        expanded: true,
                        children: [],
                    };

                    let zones = {};
                    let vnets = {};
                    let subnets = {};

                    response.result.data.forEach((element) => {
                        element.leaf = true;

                        if (!(element.zone in zones)) {
                            let zone = {
                                name: element.zone,
                                type: 'zone',
                                iconCls: 'fa fa-th',
                                expanded: true,
                                children: [],
                            };

                            zones[element.zone] = zone;
                            root.children.push(zone);
                        }

                        if (!(element.vnet in vnets)) {
                            let vnet = {
                                name: element.vnet,
                                zone: element.zone,
                                type: 'vnet',
                                iconCls: 'fa fa-network-wired x-fa-treepanel',
                                expanded: true,
                                children: [],
                            };

                            vnets[element.vnet] = vnet;
                            zones[element.zone].children.push(vnet);
                        }

                        if (!(element.subnet in subnets)) {
                            let subnet = {
                                name: element.subnet,
                                zone: element.zone,
                                vnet: element.vnet,
                                type: 'subnet',
                                iconCls: 'x-tree-icon-none',
                                expanded: true,
                                children: [],
                            };

                            subnets[element.subnet] = subnet;
                            vnets[element.vnet].children.push(subnet);
                        }

                        element.type = 'mapping';
                        element.iconCls = 'x-tree-icon-none';
                        subnets[element.subnet].children.push(element);
                    });

                    me.getView().setRootNode(root);
                },
            });
        },

        init: function (view) {
            let me = this;
            me.reload();
        },

        onDelete: function (table, rI, cI, item, e, { data }) {
            let me = this;
            let view = me.getView();

            Ext.Msg.show({
                title: gettext('Confirm'),
                icon: Ext.Msg.WARNING,
                message: Ext.String.format(
                    gettext('Are you sure you want to remove DHCP mapping {0}'),
                    `${data.mac} / ${data.ip}`,
                ),
                buttons: Ext.Msg.YESNO,
                defaultFocus: 'no',
                callback: function (btn) {
                    if (btn !== 'yes') {
                        return;
                    }

                    let params = {
                        zone: data.zone,
                        mac: data.mac,
                        ip: data.ip,
                    };

                    let encodedParams = Ext.Object.toQueryString(params);

                    let url = `/cluster/sdn/vnets/${data.vnet}/ips?${encodedParams}`;

                    Proxmox.Utils.API2Request({
                        url,
                        method: 'DELETE',
                        waitMsgTarget: view,
                        failure: function (response, opts) {
                            Ext.Msg.alert(gettext('Error'), response.htmlStatus);
                        },
                        callback: me.reload.bind(me),
                    });
                },
            });
        },

        editAction: function (_grid, _rI, _cI, _item, _e, rec) {
            this.edit(rec);
        },

        editDblClick: function () {
            let me = this;

            let view = me.getView();
            let selection = view.getSelection();

            if (!selection || selection.length < 1) {
                return;
            }

            me.edit(selection[0]);
        },

        edit: function (rec) {
            let me = this;

            if (rec.data.type === 'mapping' && !rec.data.gateway) {
                me.openEditWindow(rec.data);
            }
        },

        openEditWindow: function (data) {
            let me = this;

            let extraRequestParams = {
                mac: data.mac,
                zone: data.zone,
                vnet: data.vnet,
            };

            if (data.vmid) {
                extraRequestParams.vmid = data.vmid;
            }

            Ext.create('PVE.sdn.IpamEdit', {
                autoShow: true,
                mapping: data,
                extraRequestParams,
                listeners: {
                    destroy: () => me.reload(),
                },
            });
        },
    },

    listeners: {
        itemdblclick: 'editDblClick',
    },

    tbar: [
        {
            xtype: 'proxmoxButton',
            text: gettext('Reload'),
            handler: 'reload',
        },
    ],

    columns: [
        {
            xtype: 'treecolumn',
            text: gettext('Name / VMID'),
            dataIndex: 'name',
            width: 200,
            renderer: function (value, meta, record) {
                if (record.get('gateway')) {
                    return gettext('Gateway');
                }

                return record.get('name') ?? record.get('vmid') ?? ' ';
            },
        },
        {
            text: gettext('IP Address'),
            dataIndex: 'ip',
            width: 200,
        },
        {
            text: 'MAC',
            dataIndex: 'mac',
            width: 200,
        },
        {
            text: gettext('Gateway'),
            dataIndex: 'gateway',
            width: 200,
        },
        {
            header: gettext('Actions'),
            xtype: 'actioncolumn',
            dataIndex: 'text',
            width: 150,
            items: [
                {
                    handler: function (table, rI, cI, item, e, { data }) {
                        let me = this;

                        Ext.create('PVE.sdn.IpamEdit', {
                            autoShow: true,
                            mapping: {},
                            isCreate: true,
                            extraRequestParams: {
                                vnet: data.name,
                                zone: data.zone,
                            },
                            listeners: {
                                destroy: () => {
                                    me.up('pveDhcpTree').controller.reload();
                                },
                            },
                        });
                    },
                    getTip: (v, m, rec) => gettext('Add'),
                    getClass: (v, m, { data }) => {
                        if (data.type === 'vnet') {
                            return 'fa fa-plus-square';
                        }

                        return 'pmx-hidden';
                    },
                },
                {
                    handler: 'editAction',
                    getTip: (v, m, rec) => gettext('Edit'),
                    getClass: (v, m, { data }) => {
                        if (data.type === 'mapping' && !data.gateway) {
                            return 'fa fa-pencil fa-fw';
                        }

                        return 'pmx-hidden';
                    },
                },
                {
                    handler: 'onDelete',
                    getTip: (v, m, rec) => gettext('Delete'),
                    getClass: (v, m, { data }) => {
                        if (data.type === 'mapping' && !data.gateway) {
                            return 'fa critical fa-trash-o';
                        }

                        return 'pmx-hidden';
                    },
                },
            ],
        },
    ],
});
Ext.define('PVE.window.Backup', {
    extend: 'Ext.window.Window',

    resizable: false,

    initComponent: function () {
        var me = this;

        if (!me.nodename) {
            throw 'no node name specified';
        }

        if (!me.vmid) {
            throw 'no VM ID specified';
        }

        if (!me.vmtype) {
            throw 'no VM type specified';
        }

        let compressionSelector = Ext.create('PVE.form.BackupCompressionSelector', {
            name: 'compress',
            value: 'zstd',
            fieldLabel: gettext('Compression'),
        });

        let modeSelector = Ext.create('PVE.form.BackupModeSelector', {
            fieldLabel: gettext('Mode'),
            value: 'snapshot',
            name: 'mode',
        });

        let mailtoField = Ext.create('Ext.form.field.Text', {
            fieldLabel: gettext('Send email to'),
            name: 'mailto',
            emptyText: Proxmox.Utils.noneText,
        });

        let notificationModeSelector = Ext.create({
            xtype: 'proxmoxKVComboBox',
            comboItems: [
                ['auto', gettext('Auto')],
                ['legacy-sendmail', gettext('Email (legacy)')],
                ['notification-system', gettext('Notification system')],
            ],
            fieldLabel: gettext('Notification mode'),
            name: 'notification-mode',
            value: 'auto',
            listeners: {
                change: function (field, value) {
                    mailtoField.setDisabled(value === 'notification-system');
                },
            },
        });

        let pbsChangeDetectionModeSelector = Ext.create({
            xtype: 'proxmoxKVComboBox',
            flex: 1,
            disabled: true,
            name: 'pbs-change-detection-mode',
            deleteEmpty: true,
            value: '__default__',
            comboItems: [
                ['__default__', 'Default'],
                ['data', 'Data'],
                ['metadata', 'Metadata'],
            ],
        });

        let pbsChangeDetection = Ext.create('Ext.form.FieldContainer', {
            fieldLabel: gettext('PBS change detection mode'),
            hidden: true,
            layout: {
                type: 'hbox',
                align: 'center',
            },
            items: [
                pbsChangeDetectionModeSelector,
                {
                    xtype: 'box',
                    html: `<i class="fa fa-question-circle" data-qtip="
			${gettext('Mode to detect file changes and switch archive encoding format for container backups to Proxmox Backup Server. Not available for VM backups.')}
		    "></i>`,
                    padding: 5,
                },
            ],
        });

        const keepNames = [
            ['keep-last', gettext('Keep Last')],
            ['keep-hourly', gettext('Keep Hourly')],
            ['keep-daily', gettext('Keep Daily')],
            ['keep-weekly', gettext('Keep Weekly')],
            ['keep-monthly', gettext('Keep Monthly')],
            ['keep-yearly', gettext('Keep Yearly')],
        ];

        let pruneSettings = keepNames.map((name) =>
            Ext.create('Ext.form.field.Display', {
                name: name[0],
                fieldLabel: name[1],
                hidden: true,
            }),
        );

        let removeCheckbox = Ext.create('Proxmox.form.Checkbox', {
            name: 'remove',
            checked: false,
            hidden: true,
            uncheckedValue: 0,
            fieldLabel: gettext('Prune'),
            autoEl: {
                tag: 'div',
                'data-qtip': gettext('Prune older backups afterwards'),
            },
            handler: function (checkbox, value) {
                pruneSettings.forEach((field) => field.setHidden(!value));
                me.down('label[name="pruneLabel"]').setHidden(!value);
            },
        });

        let initialDefaults = false;

        var storagesel = Ext.create('PVE.form.StorageSelector', {
            nodename: me.nodename,
            name: 'storage',
            fieldLabel: gettext('Storage'),
            storageContent: 'backup',
            allowBlank: false,
            listeners: {
                change: function (f, v) {
                    if (!initialDefaults) {
                        me.setLoading(false);
                    }

                    if (v === null || v === undefined || v === '') {
                        return;
                    }

                    let store = f.getStore();
                    let rec = store.findRecord('storage', v, 0, false, true, true);

                    if (rec && rec.data && rec.data.type === 'pbs') {
                        compressionSelector.setValue('zstd');
                        compressionSelector.setDisabled(true);
                        if (me.vmtype === 'lxc') {
                            pbsChangeDetectionModeSelector.setValue('__default__');
                            pbsChangeDetectionModeSelector.setDisabled(false);
                            pbsChangeDetection.setHidden(false);
                        } else {
                            pbsChangeDetectionModeSelector.setDisabled(true);
                            pbsChangeDetection.setHidden(true);
                        }
                    } else {
                        if (!compressionSelector.getEditable()) {
                            compressionSelector.setDisabled(false);
                        }
                        pbsChangeDetectionModeSelector.setDisabled(true);
                        pbsChangeDetection.setHidden(true);
                    }

                    Proxmox.Utils.API2Request({
                        url: `/nodes/${me.nodename}/vzdump/defaults`,
                        method: 'GET',
                        params: {
                            storage: v,
                        },
                        waitMsgTarget: me,
                        success: function (response, opts) {
                            const data = response.result.data;

                            if (!initialDefaults && data.mailto !== undefined) {
                                mailtoField.setValue(data.mailto);
                            }
                            if (!initialDefaults && data['notification-mode'] !== undefined) {
                                notificationModeSelector.setValue(data['notification-mode']);
                            }
                            if (!initialDefaults && data.mode !== undefined) {
                                modeSelector.setValue(data.mode);
                            }
                            if (!initialDefaults && (data['notes-template'] ?? false)) {
                                me.down('field[name=notes-template]').setValue(
                                    PVE.Utils.unEscapeNotesTemplate(data['notes-template']),
                                );
                            }

                            initialDefaults = true;

                            // always update storage dependent properties
                            if (data['prune-backups'] !== undefined) {
                                const keepParams = PVE.Parser.parsePropertyString(
                                    data['prune-backups'],
                                );
                                if (!keepParams['keep-all']) {
                                    removeCheckbox.setHidden(false);
                                    pruneSettings.forEach(function (field) {
                                        const keep = keepParams[field.name];
                                        if (keep) {
                                            field.setValue(keep);
                                        } else {
                                            field.reset();
                                        }
                                    });
                                    return;
                                }
                            }

                            // no defaults or keep-all=1
                            removeCheckbox.setHidden(true);
                            removeCheckbox.setValue(false);
                            pruneSettings.forEach((field) => field.reset());
                        },
                        failure: function (response, opts) {
                            initialDefaults = true;

                            removeCheckbox.setHidden(true);
                            removeCheckbox.setValue(false);
                            pruneSettings.forEach((field) => field.reset());

                            Ext.Msg.alert(gettext('Error'), response.htmlStatus);
                        },
                    });
                },
            },
        });

        let protectedCheckbox = Ext.create('Proxmox.form.Checkbox', {
            name: 'protected',
            checked: false,
            uncheckedValue: 0,
            fieldLabel: gettext('Protected'),
        });

        me.formPanel = Ext.create('Proxmox.panel.InputPanel', {
            bodyPadding: 10,
            border: false,
            column1: [storagesel, modeSelector, protectedCheckbox, pbsChangeDetection],
            column2: [compressionSelector, notificationModeSelector, mailtoField, removeCheckbox],
            columnB: [
                {
                    xtype: 'textareafield',
                    name: 'notes-template',
                    fieldLabel: gettext('Notes'),
                    anchor: '100%',
                    value: '{{guestname}}',
                },
                {
                    xtype: 'box',
                    style: {
                        margin: '8px 0px',
                        'line-height': '1.5em',
                    },
                    html: Ext.String.format(
                        gettext('Possible template variables are: {0}'),
                        PVE.Utils.notesTemplateVars.map((v) => `<code>{{${v}}}</code>`).join(', '),
                    ),
                },
                {
                    xtype: 'label',
                    name: 'pruneLabel',
                    text: gettext('Storage Retention Configuration') + ':',
                    hidden: true,
                },
                {
                    layout: 'hbox',
                    border: false,
                    defaults: {
                        border: false,
                        layout: 'anchor',
                        flex: 1,
                    },
                    items: [
                        {
                            padding: '0 10 0 0',
                            defaults: {
                                labelWidth: 110,
                            },
                            items: [pruneSettings[0], pruneSettings[2], pruneSettings[4]],
                        },
                        {
                            padding: '0 0 0 10',
                            defaults: {
                                labelWidth: 110,
                            },
                            items: [pruneSettings[1], pruneSettings[3], pruneSettings[5]],
                        },
                    ],
                },
            ],
        });

        var submitBtn = Ext.create('Ext.Button', {
            text: gettext('Backup'),
            handler: function () {
                var storage = storagesel.getValue();
                let values = me.formPanel.getValues();
                var params = {
                    storage: storage,
                    vmid: me.vmid,
                    mode: values.mode,
                    remove: values.remove,
                };

                if (values.mailto) {
                    params.mailto = values.mailto;
                }

                if (values['notification-mode']) {
                    params['notification-mode'] = values['notification-mode'];
                }

                if (values.compress) {
                    params.compress = values.compress;
                }

                if (values.protected) {
                    params.protected = values.protected;
                }

                if (values['pbs-change-detection-mode']) {
                    params['pbs-change-detection-mode'] = values['pbs-change-detection-mode'];
                }

                if (values['notes-template']) {
                    params['notes-template'] = PVE.Utils.escapeNotesTemplate(
                        values['notes-template'],
                    );
                }

                Proxmox.Utils.API2Request({
                    url: '/nodes/' + me.nodename + '/vzdump',
                    params: params,
                    method: 'POST',
                    failure: function (response, opts) {
                        Ext.Msg.alert('Error', response.htmlStatus);
                    },
                    success: function (response, options) {
                        // close later so we reload the grid
                        // after the task has completed
                        me.hide();

                        var upid = response.result.data;

                        var win = Ext.create('Proxmox.window.TaskViewer', {
                            upid: upid,
                            listeners: {
                                close: function () {
                                    me.close();
                                },
                            },
                        });
                        win.show();
                    },
                });
            },
        });

        var helpBtn = Ext.create('Proxmox.button.Help', {
            onlineHelp: 'chapter_vzdump',
            listenToGlobalEvent: false,
            hidden: false,
        });

        let guestTypeStr = me.vmtype === 'lxc' ? 'CT' : 'VM';
        let formattedGuestIdentifier = PVE.Utils.getFormattedGuestIdentifier(me.vmid, me.vmname);
        let title = `${gettext('Backup')} ${guestTypeStr} ${formattedGuestIdentifier}`;

        Ext.apply(me, {
            title: title,
            modal: true,
            layout: 'auto',
            border: false,
            width: 600,
            items: [me.formPanel],
            buttons: [helpBtn, '->', submitBtn],
            listeners: {
                afterrender: function () {
                    /// cleared within the storage selector's change listener
                    me.setLoading(gettext('Please wait...'));
                    storagesel.setValue(me.storage);
                },
            },
        });

        me.callParent();
    },
});
Ext.define('PVE.window.BackupConfig', {
    extend: 'Ext.window.Window',
    title: gettext('Configuration'),
    width: 600,
    height: 400,
    layout: 'fit',
    modal: true,
    items: {
        xtype: 'component',
        itemId: 'configtext',
        autoScroll: true,
        style: {
            'white-space': 'pre',
            'font-family': 'monospace',
            padding: '5px',
        },
    },

    initComponent: function () {
        var me = this;

        if (!me.volume) {
            throw 'no volume specified';
        }

        var nodename = me.pveSelNode.data.node;
        if (!nodename) {
            throw 'no node name specified';
        }

        me.callParent();

        Proxmox.Utils.API2Request({
            url: '/nodes/' + nodename + '/vzdump/extractconfig',
            method: 'GET',
            params: {
                volume: me.volume,
            },
            failure: function (response, opts) {
                me.close();
                Ext.Msg.alert('Error', response.htmlStatus);
            },
            success: function (response, options) {
                me.show();
                me.down('#configtext').update(Ext.htmlEncode(response.result.data));
            },
        });
    },
});
Ext.define('PVE.window.BulkAction', {
    extend: 'Ext.window.Window',

    resizable: true,
    width: 800,
    height: 600,
    modal: true,
    layout: {
        type: 'fit',
    },
    border: false,

    // the action to set, currently there are: `startall`, `migrateall`, `stopall`, `suspendall`
    action: undefined,

    submit: function (params) {
        let me = this;

        Proxmox.Utils.API2Request({
            params: params,
            url: `/nodes/${me.nodename}/${me.action}`,
            waitMsgTarget: me,
            method: 'POST',
            failure: (response) => Ext.Msg.alert('Error', response.htmlStatus),
            success: function ({ result }, options) {
                Ext.create('Proxmox.window.TaskViewer', {
                    autoShow: true,
                    upid: result.data,
                    listeners: {
                        destroy: () => me.close(),
                    },
                });
                me.hide();
            },
        });
    },

    initComponent: function () {
        let me = this;

        if (!me.nodename) {
            throw 'no node name specified';
        }
        if (!me.action) {
            throw 'no action specified';
        }
        if (!me.btnText) {
            throw 'no button text specified';
        }
        if (!me.title) {
            throw 'no title specified';
        }

        let items = [];
        if (me.action === 'migrateall') {
            items.push(
                {
                    xtype: 'fieldcontainer',
                    layout: 'hbox',
                    items: [
                        {
                            flex: 1,
                            xtype: 'pveNodeSelector',
                            name: 'target',
                            disallowedNodes: [me.nodename],
                            fieldLabel: gettext('Target node'),
                            labelWidth: 200,
                            allowBlank: false,
                            onlineValidator: true,
                            padding: '0 10 0 0',
                        },
                        {
                            xtype: 'proxmoxintegerfield',
                            name: 'maxworkers',
                            minValue: 1,
                            maxValue: 100,
                            value: 1,
                            fieldLabel: gettext('Parallel jobs'),
                            allowBlank: false,
                            flex: 1,
                        },
                    ],
                },
                {
                    xtype: 'fieldcontainer',
                    layout: 'hbox',
                    items: [
                        {
                            xtype: 'proxmoxcheckbox',
                            fieldLabel: gettext('Allow local disk migration'),
                            name: 'with-local-disks',
                            labelWidth: 200,
                            checked: true,
                            uncheckedValue: 0,
                            flex: 1,
                            padding: '0 10 0 0',
                        },
                        {
                            itemId: 'lxcwarning',
                            xtype: 'displayfield',
                            userCls: 'pmx-hint',
                            value: 'Warning: Running CTs will be migrated in Restart Mode.',
                            hidden: true, // only visible if running container chosen
                            flex: 1,
                        },
                    ],
                },
            );
        } else if (me.action === 'startall') {
            items.push({
                xtype: 'hiddenfield',
                name: 'force',
                value: 1,
            });
        } else if (me.action === 'stopall') {
            items.push({
                xtype: 'fieldcontainer',
                layout: 'hbox',
                items: [
                    {
                        xtype: 'proxmoxcheckbox',
                        name: 'force-stop',
                        labelWidth: 120,
                        fieldLabel: gettext('Force Stop'),
                        boxLabel: gettext('Force stop guest if shutdown times out.'),
                        checked: true,
                        uncheckedValue: 0,
                        flex: 1,
                    },
                    {
                        xtype: 'proxmoxintegerfield',
                        name: 'timeout',
                        fieldLabel: gettext('Timeout (s)'),
                        labelWidth: 120,
                        emptyText: '180',
                        minValue: 0,
                        maxValue: 7200,
                        allowBlank: true,
                        flex: 1,
                    },
                ],
            });
        }

        let refreshLxcWarning = function (vmids, records) {
            let showWarning = records.some(
                (item) =>
                    vmids.includes(item.data.vmid) &&
                    item.data.type === 'lxc' &&
                    item.data.status === 'running',
            );
            me.down('#lxcwarning').setVisible(showWarning);
        };

        let defaultStatus =
            me.action === 'migrateall' ? '' : me.action === 'startall' ? 'stopped' : 'running';
        let defaultType = me.action === 'suspendall' ? 'qemu' : '';

        let statusMap = [];
        let poolMap = [];
        let haMap = [];
        let tagMap = [];
        PVE.data.ResourceStore.each((rec) => {
            if (['qemu', 'lxc'].indexOf(rec.data.type) !== -1) {
                statusMap[rec.data.status] = true;
            }
            if (rec.data.type === 'pool') {
                poolMap[rec.data.pool] = true;
            }
            if (rec.data.hastate !== '') {
                haMap[rec.data.hastate] = true;
            }
            if (rec.data.tags !== '') {
                rec.data.tags.split(/[,; ]/).forEach((tag) => {
                    if (tag !== '') {
                        tagMap[tag] = true;
                    }
                });
            }
        });

        let statusList = Object.keys(statusMap).map((key) => [key, key]);
        statusList.unshift(['', gettext('All')]);
        let poolList = Object.keys(poolMap).map((key) => [key, key]);
        let tagList = Object.keys(tagMap).map((key) => ({ value: key }));
        let haList = Object.keys(haMap).map((key) => [key, key]);

        let clearFilters = function () {
            me.down('#namefilter').setValue('');
            [
                'name',
                'status',
                'pool',
                'type',
                'hastate',
                'includetag',
                'excludetag',
                'vmid',
            ].forEach((filter) => {
                me.down(`#${filter}filter`).setValue('');
            });
        };

        let filterChange = function () {
            let nameValue = me.down('#namefilter').getValue();
            let filterCount = 0;

            if (nameValue !== '') {
                filterCount++;
            }

            let arrayFiltersData = [];
            ['pool', 'hastate'].forEach((filter) => {
                let selected = me.down(`#${filter}filter`).getValue() ?? [];
                if (selected.length) {
                    filterCount++;
                    arrayFiltersData.push([filter, [...selected]]);
                }
            });

            let singleFiltersData = [];
            ['status', 'type'].forEach((filter) => {
                let selected = me.down(`#${filter}filter`).getValue() ?? '';
                if (selected.length) {
                    filterCount++;
                    singleFiltersData.push([filter, selected]);
                }
            });

            let includeTags = me.down('#includetagfilter').getValue() ?? [];
            if (includeTags.length) {
                filterCount++;
            }
            let excludeTags = me.down('#excludetagfilter').getValue() ?? [];
            if (excludeTags.length) {
                filterCount++;
            }

            let fieldSet = me.down('#filters');
            let clearBtn = me.down('#clearBtn');
            if (filterCount) {
                fieldSet.setTitle(Ext.String.format(gettext('Filters ({0})'), filterCount));
                clearBtn.setDisabled(false);
            } else {
                fieldSet.setTitle(gettext('Filters'));
                clearBtn.setDisabled(true);
            }

            let filterFn = function (value) {
                let name = value.data.name.toLowerCase().indexOf(nameValue.toLowerCase()) !== -1;
                let arrayFilters = arrayFiltersData.every(
                    ([filter, selected]) =>
                        !selected.length || selected.indexOf(value.data[filter]) !== -1,
                );
                let singleFilters = singleFiltersData.every(
                    ([filter, selected]) =>
                        !selected.length || value.data[filter].indexOf(selected) !== -1,
                );
                let tags = value.data.tags.split(/[;, ]/).filter((t) => !!t);
                let includeFilter =
                    !includeTags.length || tags.some((tag) => includeTags.indexOf(tag) !== -1);
                let excludeFilter =
                    !excludeTags.length || tags.every((tag) => excludeTags.indexOf(tag) === -1);

                return name && arrayFilters && singleFilters && includeFilter && excludeFilter;
            };
            let vmselector = me.down('#vms');
            vmselector.getStore().setFilters({
                id: 'customFilter',
                filterFn,
            });
            vmselector.checkChange();
            if (me.action === 'migrateall') {
                let records = vmselector.getSelection();
                refreshLxcWarning(vmselector.getValue(), records);
            }
        };

        items.push({
            xtype: 'fieldset',
            itemId: 'filters',
            collapsible: true,
            title: gettext('Filters'),
            layout: 'hbox',
            items: [
                {
                    xtype: 'container',
                    flex: 1,
                    padding: 5,
                    layout: {
                        type: 'vbox',
                        align: 'stretch',
                    },
                    defaults: {
                        listeners: {
                            change: filterChange,
                        },
                        isFormField: false,
                    },
                    items: [
                        {
                            fieldLabel: gettext('Name'),
                            itemId: 'namefilter',
                            xtype: 'textfield',
                        },
                        {
                            xtype: 'combobox',
                            itemId: 'statusfilter',
                            fieldLabel: gettext('Status'),
                            emptyText: gettext('All'),
                            editable: false,
                            value: defaultStatus,
                            store: statusList,
                        },
                        {
                            xtype: 'combobox',
                            itemId: 'poolfilter',
                            fieldLabel: gettext('Pool'),
                            emptyText: gettext('All'),
                            editable: false,
                            multiSelect: true,
                            store: poolList,
                        },
                    ],
                },
                {
                    xtype: 'container',
                    layout: {
                        type: 'vbox',
                        align: 'stretch',
                    },
                    flex: 1,
                    padding: 5,
                    defaults: {
                        listeners: {
                            change: filterChange,
                        },
                        isFormField: false,
                    },
                    items: [
                        {
                            xtype: 'combobox',
                            itemId: 'typefilter',
                            fieldLabel: gettext('Type'),
                            emptyText: gettext('All'),
                            editable: false,
                            value: defaultType,
                            store: [
                                ['', gettext('All')],
                                ['lxc', gettext('CT')],
                                ['qemu', gettext('VM')],
                            ],
                        },
                        {
                            xtype: 'proxmoxComboGrid',
                            itemId: 'includetagfilter',
                            fieldLabel: gettext('Include Tags'),
                            emptyText: gettext('All'),
                            editable: false,
                            multiSelect: true,
                            valueField: 'value',
                            displayField: 'value',
                            listConfig: {
                                userCls: 'proxmox-tags-full',
                                columns: [
                                    {
                                        dataIndex: 'value',
                                        flex: 1,
                                        renderer: (value) =>
                                            PVE.Utils.renderTags(value, PVE.UIOptions.tagOverrides),
                                    },
                                ],
                            },
                            store: {
                                data: tagList,
                            },
                            listeners: {
                                change: filterChange,
                            },
                        },
                        {
                            xtype: 'proxmoxComboGrid',
                            itemId: 'excludetagfilter',
                            fieldLabel: gettext('Exclude Tags'),
                            emptyText: gettext('None'),
                            multiSelect: true,
                            editable: false,
                            valueField: 'value',
                            displayField: 'value',
                            listConfig: {
                                userCls: 'proxmox-tags-full',
                                columns: [
                                    {
                                        dataIndex: 'value',
                                        flex: 1,
                                        renderer: (value) =>
                                            PVE.Utils.renderTags(value, PVE.UIOptions.tagOverrides),
                                    },
                                ],
                            },
                            store: {
                                data: tagList,
                            },
                            listeners: {
                                change: filterChange,
                            },
                        },
                    ],
                },
                {
                    xtype: 'container',
                    layout: {
                        type: 'vbox',
                        align: 'stretch',
                    },
                    flex: 1,
                    padding: 5,
                    defaults: {
                        listeners: {
                            change: filterChange,
                        },
                        isFormField: false,
                    },
                    items: [
                        {
                            xtype: 'combobox',
                            itemId: 'hastatefilter',
                            fieldLabel: gettext('HA status'),
                            emptyText: gettext('All'),
                            multiSelect: true,
                            editable: false,
                            store: haList,
                            listeners: {
                                change: filterChange,
                            },
                        },
                        {
                            xtype: 'container',
                            layout: {
                                type: 'vbox',
                                align: 'end',
                            },
                            items: [
                                {
                                    xtype: 'button',
                                    itemId: 'clearBtn',
                                    text: gettext('Clear Filters'),
                                    disabled: true,
                                    handler: clearFilters,
                                },
                            ],
                        },
                    ],
                },
            ],
        });

        items.push({
            xtype: 'vmselector',
            itemId: 'vms',
            name: 'vms',
            flex: 1,
            height: 300,
            selectAll: true,
            allowBlank: false,
            plugins: '',
            nodename: me.nodename,
            listeners: {
                selectionchange: function (vmselector, records) {
                    if (me.action === 'migrateall') {
                        let vmids = me.down('#vms').getValue();
                        refreshLxcWarning(vmids, records);
                    }
                },
            },
        });

        me.formPanel = Ext.create('Ext.form.Panel', {
            bodyPadding: 10,
            border: false,
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            fieldDefaults: {
                anchor: '100%',
            },
            items: items,
        });

        let form = me.formPanel.getForm();

        let submitBtn = Ext.create('Ext.Button', {
            text: me.btnText,
            handler: function () {
                form.isValid();
                me.submit(form.getValues());
            },
        });

        Ext.apply(me, {
            items: [me.formPanel],
            buttons: [submitBtn],
        });

        me.callParent();

        form.on('validitychange', function () {
            let valid = form.isValid();
            submitBtn.setDisabled(!valid);
        });
        form.isValid();

        filterChange();
    },
});
Ext.define('PVE.ceph.Install', {
    extend: 'Ext.window.Window',
    xtype: 'pveCephInstallWindow',
    mixins: ['Proxmox.Mixin.CBind'],

    width: 220,
    header: false,
    resizable: false,
    draggable: false,
    modal: true,
    nodename: undefined,
    shadow: false,
    border: false,
    bodyBorder: false,
    closable: false,
    cls: 'install-mask',
    bodyCls: 'install-mask',
    layout: {
        align: 'stretch',
        pack: 'center',
        type: 'vbox',
    },
    viewModel: {
        data: {
            isInstalled: false,
        },
        formulas: {
            buttonText: function (get) {
                if (get('isInstalled')) {
                    return gettext('Configure Ceph');
                } else {
                    return gettext('Install Ceph');
                }
            },
            windowText: function (get) {
                if (get('isInstalled')) {
                    return `<p class="install-mask">
		    ${gettext('Ceph is not initialized.')}
		    ${gettext('You need to create an initial config once.')}</p>`;
                } else {
                    return (
                        '<p class="install-mask">' +
                        gettext('Ceph is not installed on this node.') +
                        '<br>' +
                        gettext('Would you like to install it now?') +
                        '</p>'
                    );
                }
            },
        },
    },
    items: [
        {
            bind: {
                html: '{windowText}',
            },
            border: false,
            padding: 5,
            bodyCls: 'install-mask',
        },
        {
            xtype: 'button',
            bind: {
                text: '{buttonText}',
            },
            viewModel: {},
            cbind: {
                nodename: '{nodename}',
            },
            handler: function () {
                let view = this.up('pveCephInstallWindow');
                let wizard = Ext.create('PVE.ceph.CephInstallWizard', {
                    nodename: view.nodename,
                });
                wizard.getViewModel().set('isInstalled', this.getViewModel().get('isInstalled'));
                wizard.show();
                view.mon(wizard, 'beforeClose', function () {
                    view.fireEvent('cephInstallWindowClosed');
                    view.close();
                });
            },
        },
    ],
});
Ext.define('PVE.window.Clone', {
    extend: 'Ext.window.Window',

    resizable: false,

    isTemplate: false,

    onlineHelp: 'qm_copy_and_clone',

    controller: {
        xclass: 'Ext.app.ViewController',
        control: {
            'panel[reference=cloneform]': {
                validitychange: 'disableSubmit',
            },
        },
        disableSubmit: function (form) {
            this.lookupReference('submitBtn').setDisabled(!form.isValid());
        },
    },

    statics: {
        // display a snapshot selector only if needed
        wrap: function (nodename, vmid, vmname, isTemplate, guestType) {
            Proxmox.Utils.API2Request({
                url: '/nodes/' + nodename + '/' + guestType + '/' + vmid + '/snapshot',
                failure: function (response, opts) {
                    Ext.Msg.alert('Error', response.htmlStatus);
                },
                success: function (response, opts) {
                    var snapshotList = response.result.data;
                    var hasSnapshots = !(
                        snapshotList.length === 1 && snapshotList[0].name === 'current'
                    );

                    Ext.create('PVE.window.Clone', {
                        nodename: nodename,
                        guestType: guestType,
                        vmid: vmid,
                        vmname: vmname,
                        isTemplate: isTemplate,
                        hasSnapshots: hasSnapshots,
                    }).show();
                },
            });
        },
    },

    create_clone: function (values) {
        var me = this;

        var params = { newid: values.newvmid };

        if (values.snapname && values.snapname !== 'current') {
            params.snapname = values.snapname;
        }

        if (values.pool) {
            params.pool = values.pool;
        }

        if (values.name) {
            if (me.guestType === 'lxc') {
                params.hostname = values.name;
            } else {
                params.name = values.name;
            }
        }

        if (values.target) {
            params.target = values.target;
        }

        if (values.clonemode === 'copy') {
            params.full = 1;
            if (values.hdstorage) {
                params.storage = values.hdstorage;
                if (values.diskformat && me.guestType !== 'lxc') {
                    params.format = values.diskformat;
                }
            }
        }

        Proxmox.Utils.API2Request({
            params: params,
            url: '/nodes/' + me.nodename + '/' + me.guestType + '/' + me.vmid + '/clone',
            waitMsgTarget: me,
            method: 'POST',
            failure: function (response, opts) {
                Ext.Msg.alert('Error', response.htmlStatus);
            },
            success: function (response, options) {
                me.close();
            },
        });
    },

    // disable the Storage selector when clone mode is linked clone
    updateVisibility: function () {
        var me = this;
        var clonemode = me.lookupReference('clonemodesel').getValue();
        var disksel = me.lookup('diskselector');
        disksel.setDisabled(clonemode === 'clone');
    },

    // add to the list of valid nodes each node where
    // all the VM disks are available
    verifyFeature: function () {
        var me = this;

        var snapname = me.lookupReference('snapshotsel').getValue();
        var clonemode = me.lookupReference('clonemodesel').getValue();

        var params = { feature: clonemode };
        if (snapname !== 'current') {
            params.snapname = snapname;
        }

        Proxmox.Utils.API2Request({
            waitMsgTarget: me,
            url: '/nodes/' + me.nodename + '/' + me.guestType + '/' + me.vmid + '/feature',
            params: params,
            method: 'GET',
            failure: function (response, opts) {
                me.lookupReference('submitBtn').setDisabled(true);
                Ext.Msg.alert('Error', response.htmlStatus);
            },
            success: function (response, options) {
                var res = response.result.data;

                me.lookupReference('targetsel').allowedNodes = res.nodes;
                me.lookupReference('targetsel').validate();
            },
        });
    },

    initComponent: function () {
        var me = this;

        if (!me.nodename) {
            throw 'no node name specified';
        }

        if (!me.vmid) {
            throw 'no VM ID specified';
        }

        if (!me.snapname) {
            me.snapname = 'current';
        }

        if (!me.guestType) {
            throw 'no Guest Type specified';
        }

        var titletext = me.guestType === 'lxc' ? 'CT' : 'VM';
        if (me.isTemplate) {
            titletext += ' Template';
        }

        let formattedGuestIdentifier = PVE.Utils.getFormattedGuestIdentifier(me.vmid, me.vmname);
        me.title = `Clone ${titletext} ${formattedGuestIdentifier}`;

        var col1 = [];
        var col2 = [];

        col1.push({
            xtype: 'pveNodeSelector',
            name: 'target',
            reference: 'targetsel',
            fieldLabel: gettext('Target node'),
            selectCurNode: true,
            allowBlank: false,
            onlineValidator: true,
            listeners: {
                change: function (f, value) {
                    me.lookup('diskselector').getComponent('hdstorage').setTargetNode(value);
                },
            },
        });

        var modelist = [['copy', gettext('Full Clone')]];
        if (me.isTemplate) {
            modelist.push(['clone', gettext('Linked Clone')]);
        }

        col1.push(
            {
                xtype: 'pveGuestIDSelector',
                name: 'newvmid',
                guestType: me.guestType,
                value: '',
                loadNextFreeID: true,
                validateExists: false,
            },
            {
                xtype: 'textfield',
                name: 'name',
                vtype: 'DnsName',
                allowBlank: true,
                fieldLabel: me.guestType === 'lxc' ? gettext('Hostname') : gettext('Name'),
            },
            {
                xtype: 'pvePoolSelector',
                fieldLabel: gettext('Resource Pool'),
                name: 'pool',
                value: '',
                allowBlank: true,
            },
        );

        col2.push(
            {
                xtype: 'proxmoxKVComboBox',
                fieldLabel: gettext('Mode'),
                name: 'clonemode',
                reference: 'clonemodesel',
                allowBlank: false,
                hidden: !me.isTemplate,
                value: me.isTemplate ? 'clone' : 'copy',
                comboItems: modelist,
                listeners: {
                    change: function (t, value) {
                        me.updateVisibility();
                        me.verifyFeature();
                    },
                },
            },
            {
                xtype: 'PVE.form.SnapshotSelector',
                name: 'snapname',
                reference: 'snapshotsel',
                fieldLabel: gettext('Snapshot'),
                nodename: me.nodename,
                guestType: me.guestType,
                vmid: me.vmid,
                hidden: !!(me.isTemplate || !me.hasSnapshots),
                disabled: false,
                allowBlank: false,
                value: me.snapname,
                listeners: {
                    change: function (f, value) {
                        me.verifyFeature();
                    },
                },
            },
            {
                xtype: 'pveDiskStorageSelector',
                reference: 'diskselector',
                nodename: me.nodename,
                autoSelect: false,
                hideSize: true,
                hideSelection: true,
                storageLabel: gettext('Target Storage'),
                allowBlank: true,
                storageContent: me.guestType === 'qemu' ? 'images' : 'rootdir',
                emptyText: gettext('Same as source'),
                disabled: !!me.isTemplate, // because default mode is clone for templates
            },
        );

        var formPanel = Ext.create('Ext.form.Panel', {
            bodyPadding: 10,
            reference: 'cloneform',
            border: false,
            layout: 'hbox',
            defaultType: 'container',
            fieldDefaults: {
                labelWidth: 100,
                anchor: '100%',
            },
            items: [
                {
                    flex: 1,
                    padding: '0 10 0 0',
                    layout: 'anchor',
                    items: col1,
                },
                {
                    flex: 1,
                    padding: '0 0 0 10',
                    layout: 'anchor',
                    items: col2,
                },
            ],
        });

        Ext.apply(me, {
            modal: true,
            width: 600,
            height: 250,
            border: false,
            layout: 'fit',
            buttons: [
                {
                    xtype: 'proxmoxHelpButton',
                    listenToGlobalEvent: false,
                    hidden: false,
                    onlineHelp: me.onlineHelp,
                },
                '->',
                {
                    reference: 'submitBtn',
                    text: gettext('Clone'),
                    disabled: true,
                    handler: function () {
                        var cloneForm = me.lookupReference('cloneform');
                        if (cloneForm.isValid()) {
                            me.create_clone(cloneForm.getValues());
                        }
                    },
                },
            ],
            items: [formPanel],
        });

        me.callParent();

        me.verifyFeature();
    },
});
Ext.define('PVE.FirewallEnableEdit', {
    extend: 'Proxmox.window.Edit',
    alias: ['widget.pveFirewallEnableEdit'],
    mixins: ['Proxmox.Mixin.CBind'],

    subject: gettext('Firewall'),
    cbindData: {
        defaultValue: 0,
    },
    width: 350,

    items: [
        {
            xtype: 'proxmoxcheckbox',
            name: 'enable',
            uncheckedValue: 0,
            cbind: {
                defaultValue: '{defaultValue}',
                checked: '{defaultValue}',
            },
            deleteDefaultValue: false,
            fieldLabel: gettext('Firewall'),
        },
        {
            xtype: 'displayfield',
            name: 'warning',
            userCls: 'pmx-hint',
            value: gettext('Warning: Firewall still disabled at datacenter level!'),
            hidden: true,
        },
    ],

    beforeShow: function () {
        var me = this;

        Proxmox.Utils.API2Request({
            url: '/api2/extjs/cluster/firewall/options',
            method: 'GET',
            failure: function (response, opts) {
                Ext.Msg.alert(gettext('Error'), response.htmlStatus);
            },
            success: function (response, opts) {
                if (!response.result.data.enable) {
                    me.down('displayfield[name=warning]').setVisible(true);
                }
            },
        });
    },
});
Ext.define('PVE.FirewallLograteInputPanel', {
    extend: 'Proxmox.panel.InputPanel',
    xtype: 'pveFirewallLograteInputPanel',

    viewModel: {},

    items: [
        {
            xtype: 'proxmoxcheckbox',
            name: 'enable',
            reference: 'enable',
            fieldLabel: gettext('Enable'),
            value: true,
        },
        {
            layout: 'hbox',
            border: false,
            items: [
                {
                    xtype: 'numberfield',
                    name: 'rate',
                    fieldLabel: gettext('Log rate limit'),
                    minValue: 1,
                    maxValue: 99,
                    allowBlank: false,
                    flex: 2,
                    value: 1,
                },
                {
                    xtype: 'box',
                    html: '<div style="margin: auto; padding: 2.5px;"><b>/</b></div>',
                },
                {
                    xtype: 'proxmoxKVComboBox',
                    name: 'unit',
                    comboItems: [
                        ['second', 'second'],
                        ['minute', 'minute'],
                        ['hour', 'hour'],
                        ['day', 'day'],
                    ],
                    allowBlank: false,
                    flex: 1,
                    value: 'second',
                },
            ],
        },
        {
            xtype: 'numberfield',
            name: 'burst',
            fieldLabel: gettext('Log burst limit'),
            minValue: 1,
            maxValue: 99,
            value: 5,
        },
    ],

    onGetValues: function (values) {
        let _me = this;

        let cfg = {
            enable: values.enable !== undefined ? 1 : 0,
            rate: values.rate + '/' + values.unit,
            burst: values.burst,
        };
        let properties = PVE.Parser.printPropertyString(cfg, undefined);
        if (properties === '') {
            return { delete: 'log_ratelimit' };
        }
        return { log_ratelimit: properties };
    },

    setValues: function (values) {
        let me = this;

        let properties = {};
        if (values.log_ratelimit !== undefined) {
            properties = PVE.Parser.parsePropertyString(values.log_ratelimit, 'enable');
            if (properties.rate) {
                let matches = properties.rate.match(/^(\d+)\/(second|minute|hour|day)$/);
                if (matches) {
                    properties.rate = matches[1];
                    properties.unit = matches[2];
                }
            }
        }
        me.callParent([properties]);
    },
});

Ext.define('PVE.FirewallLograteEdit', {
    extend: 'Proxmox.window.Edit',
    xtype: 'pveFirewallLograteEdit',

    subject: gettext('Log rate limit'),

    items: [
        {
            xtype: 'pveFirewallLograteInputPanel',
        },
    ],
    autoLoad: true,
});
/*global u2f*/
Ext.define('PVE.window.LoginWindow', {
    extend: 'Ext.window.Window',

    viewModel: {
        data: {
            openid: false,
        },
        formulas: {
            button_text: function (get) {
                if (get('openid') === true) {
                    return gettext('Login (OpenID redirect)');
                } else {
                    return gettext('Login');
                }
            },
        },
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        init: async function () {
            if (Proxmox.ConsentText) {
                let oidc_auth_redirect = Proxmox.Utils.getOpenIDRedirectionAuthorization();
                if (oidc_auth_redirect === undefined) {
                    Ext.create('Proxmox.window.ConsentModal', {
                        autoShow: true,
                        consent: Proxmox.Markdown.parse(
                            Proxmox.Utils.base64ToUtf8(Proxmox.ConsentText),
                        ),
                    });
                }
            }
        },

        onLogon: async function () {
            var me = this;

            var form = this.lookupReference('loginForm');
            var unField = this.lookupReference('usernameField');
            var saveunField = this.lookupReference('saveunField');
            var view = this.getView();

            if (!form.isValid()) {
                return;
            }

            let creds = form.getValues();

            if (this.getViewModel().data.openid === true) {
                const redirectURL = location.origin;
                Proxmox.Utils.API2Request({
                    url: '/api2/extjs/access/openid/auth-url',
                    params: {
                        realm: creds.realm,
                        'redirect-url': redirectURL,
                    },
                    method: 'POST',
                    success: function (resp, opts) {
                        window.location = resp.result.data;
                    },
                    failure: function (resp, opts) {
                        Proxmox.Utils.authClear();
                        form.unmask();
                        Ext.MessageBox.alert(
                            gettext('Error'),
                            gettext('OpenID redirect failed.') + `<br>${resp.htmlStatus}`,
                        );
                    },
                });
                return;
            }

            view.el.mask(gettext('Please wait...'), 'x-mask-loading');

            // set or clear username
            var sp = Ext.state.Manager.getProvider();
            if (saveunField.getValue() === true) {
                sp.set(unField.getStateId(), unField.getValue());
            } else {
                sp.clear(unField.getStateId());
            }
            sp.set(saveunField.getStateId(), saveunField.getValue());

            try {
                // Request updated authentication mechanism:
                creds['new-format'] = 1;

                let resp = await Proxmox.Async.api2({
                    url: '/api2/extjs/access/ticket',
                    params: creds,
                    method: 'POST',
                });

                let data = resp.result.data;
                if (data.ticket.startsWith('PVE:!tfa!')) {
                    // Store first factor login information first:
                    data.LoggedOut = true;
                    Proxmox.Utils.setAuthData(data);

                    data = await me.performTFAChallenge(data);

                    // Fill in what we copy over from the 1st factor:
                    data.CSRFPreventionToken = Proxmox.CSRFPreventionToken;
                    data.username = Proxmox.UserName;
                    me.success(data);
                } else if (Ext.isDefined(data.NeedTFA)) {
                    // Store first factor login information first:
                    data.LoggedOut = true;
                    Proxmox.Utils.setAuthData(data);

                    if (Ext.isDefined(data.U2FChallenge)) {
                        me.perform_u2f(data);
                    } else {
                        me.perform_otp();
                    }
                } else {
                    me.success(data);
                }
            } catch (error) {
                me.failure(error);
            }
        },

        /* START NEW TFA CODE (pbs copy) */
        performTFAChallenge: async function (data) {
            let _me = this;

            let userid = data.username;
            let ticket = data.ticket;
            let challenge = JSON.parse(
                decodeURIComponent(ticket.split(':')[1].slice('!tfa!'.length)),
            );

            let resp = await new Promise((resolve, reject) => {
                Ext.create('Proxmox.window.TfaLoginWindow', {
                    userid,
                    ticket,
                    challenge,
                    onResolve: (value) => resolve(value),
                    onReject: reject,
                }).show();
            });

            return resp.result.data;
        },
        /* END NEW TFA CODE (pbs copy) */

        failure: function (resp) {
            var me = this;
            var view = me.getView();
            view.el.unmask();
            var handler = function () {
                var uf = me.lookupReference('usernameField');
                uf.focus(true, true);
            };

            let emsg = gettext('Login failed. Please try again');

            if (resp.failureType === 'connect') {
                emsg = gettext(
                    'Connection failure. Network error or Proxmox VE services not running?',
                );
            }

            Ext.MessageBox.alert(gettext('Error'), emsg, handler);
        },
        success: function (data) {
            var me = this;
            var view = me.getView();
            var handler = view.handler || Ext.emptyFn;
            handler.call(me, data);
            view.close();
        },

        perform_otp: function () {
            var me = this;
            var win = Ext.create('PVE.window.TFALoginWindow', {
                onLogin: function (value) {
                    me.finish_tfa(value);
                },
                onCancel: function () {
                    Proxmox.LoggedOut = false;
                    Proxmox.Utils.authClear();
                    me.getView().show();
                },
            });
            win.show();
        },

        perform_u2f: function (data) {
            var me = this;
            // Show the message:
            var msg = Ext.Msg.show({
                title: 'U2F: ' + gettext('Verification'),
                message: gettext('Please press the button on your U2F Device'),
                buttons: [],
            });
            var chlg = data.U2FChallenge;
            var key = {
                version: chlg.version,
                keyHandle: chlg.keyHandle,
            };
            u2f.sign(chlg.appId, chlg.challenge, [key], function (res) {
                msg.close();
                if (res.errorCode) {
                    Proxmox.Utils.authClear();
                    Ext.Msg.alert(gettext('Error'), PVE.Utils.render_u2f_error(res.errorCode));
                    return;
                }
                delete res.errorCode;
                me.finish_tfa(JSON.stringify(res));
            });
        },
        finish_tfa: function (res) {
            var me = this;
            var view = me.getView();
            view.el.mask(gettext('Please wait...'), 'x-mask-loading');
            Proxmox.Utils.API2Request({
                url: '/api2/extjs/access/tfa',
                params: {
                    response: res,
                },
                method: 'POST',
                timeout: 5000, // it'll delay both success & failure
                success: function (resp, opts) {
                    view.el.unmask();
                    // Fill in what we copy over from the 1st factor:
                    var data = resp.result.data;
                    data.CSRFPreventionToken = Proxmox.CSRFPreventionToken;
                    data.username = Proxmox.UserName;
                    // Finish logging in:
                    me.success(data);
                },
                failure: function (resp, opts) {
                    Proxmox.Utils.authClear();
                    me.failure(resp);
                },
            });
        },

        control: {
            'field[name=username]': {
                specialkey: function (f, e) {
                    if (e.getKey() === e.ENTER) {
                        let pf = this.lookupReference('passwordField');
                        if (!pf.getValue()) {
                            pf.focus(false);
                        }
                    }
                },
            },
            'field[name=lang]': {
                change: function (f, value) {
                    var dt = Ext.Date.add(new Date(), Ext.Date.YEAR, 10);
                    Ext.util.Cookies.set('PVELangCookie', value, dt);
                    this.getView().mask(gettext('Please wait...'), 'x-mask-loading');
                    window.location.reload();
                },
            },
            'field[name=realm]': {
                change: function (f, value) {
                    let record = f.store.getById(value);
                    if (record === undefined) {
                        return;
                    }
                    let data = record.data;
                    this.getViewModel().set('openid', data.type === 'openid');
                },
            },
            'button[reference=loginButton]': {
                click: 'onLogon',
            },
            '#': {
                show: function () {
                    var me = this;

                    var sp = Ext.state.Manager.getProvider();
                    var checkboxField = this.lookupReference('saveunField');
                    var unField = this.lookupReference('usernameField');

                    var checked = sp.get(checkboxField.getStateId());
                    checkboxField.setValue(checked);

                    if (checked === true) {
                        let username = sp.get(unField.getStateId());
                        unField.setValue(username);
                        let pwField = this.lookupReference('passwordField');
                        pwField.focus();
                    }

                    let auth = Proxmox.Utils.getOpenIDRedirectionAuthorization();
                    if (auth !== undefined) {
                        Proxmox.Utils.authClear();

                        let loginForm = this.lookupReference('loginForm');
                        loginForm.mask(gettext('OpenID login - please wait...'), 'x-mask-loading');

                        const redirectURL = location.origin;

                        Proxmox.Utils.API2Request({
                            url: '/api2/extjs/access/openid/login',
                            params: {
                                state: auth.state,
                                code: auth.code,
                                'redirect-url': redirectURL,
                            },
                            method: 'POST',
                            failure: function (response) {
                                loginForm.unmask();
                                let error = response.htmlStatus;
                                Ext.MessageBox.alert(
                                    gettext('Error'),
                                    gettext('OpenID login failed, please try again') +
                                        `<br>${error}`,
                                    () => {
                                        window.location = redirectURL;
                                    },
                                );
                            },
                            success: function (response, options) {
                                loginForm.unmask();
                                let data = response.result.data;
                                history.replaceState(null, '', redirectURL);
                                me.success(data);
                            },
                        });
                    }
                },
            },
        },
    },

    width: 400,
    modal: true,
    border: false,
    draggable: true,
    closable: false,
    resizable: false,
    layout: 'auto',

    title: gettext('Proxmox VE Login'),

    defaultFocus: 'usernameField',
    defaultButton: 'loginButton',

    items: [
        {
            xtype: 'form',
            layout: 'form',
            url: '/api2/extjs/access/ticket',
            reference: 'loginForm',

            fieldDefaults: {
                labelAlign: 'right',
                allowBlank: false,
            },

            items: [
                {
                    xtype: 'textfield',
                    fieldLabel: gettext('User name'),
                    name: 'username',
                    itemId: 'usernameField',
                    reference: 'usernameField',
                    stateId: 'login-username',
                    inputAttrTpl: 'autocomplete=username',
                    bind: {
                        visible: '{!openid}',
                        disabled: '{openid}',
                    },
                },
                {
                    xtype: 'textfield',
                    inputType: 'password',
                    fieldLabel: gettext('Password'),
                    name: 'password',
                    reference: 'passwordField',
                    inputAttrTpl: 'autocomplete=current-password',
                    bind: {
                        visible: '{!openid}',
                        disabled: '{openid}',
                    },
                },
                {
                    xtype: 'pmxRealmComboBox',
                    name: 'realm',
                },
                {
                    xtype: 'proxmoxLanguageSelector',
                    fieldLabel: gettext('Language'),
                    value: PVE.Utils.getUiLanguage(),
                    name: 'lang',
                    reference: 'langField',
                    submitValue: false,
                },
            ],
            buttons: [
                {
                    xtype: 'checkbox',
                    fieldLabel: gettext('Save User name'),
                    name: 'saveusername',
                    reference: 'saveunField',
                    stateId: 'login-saveusername',
                    labelWidth: 250,
                    labelAlign: 'right',
                    submitValue: false,
                    bind: {
                        visible: '{!openid}',
                    },
                },
                {
                    bind: {
                        text: '{button_text}',
                    },
                    reference: 'loginButton',
                },
            ],
        },
    ],
});
Ext.define('PVE.window.Migrate', {
    extend: 'Ext.window.Window',

    vmtype: undefined,
    nodename: undefined,
    vmid: undefined,
    vmname: undefined,
    maxHeight: 450,

    viewModel: {
        data: {
            vmid: undefined,
            nodename: undefined,
            vmtype: undefined,
            running: false,
            qemu: {
                onlineHelp: 'qm_migration',
                commonName: 'VM',
            },
            lxc: {
                onlineHelp: 'pct_migration',
                commonName: 'CT',
            },
            migration: {
                possible: true,
                preconditions: [],
                'with-local-disks': 0,
                mode: undefined,
                allowedNodes: undefined,
                overwriteLocalResourceCheck: false,
                hasLocalResources: false,
            },
        },

        formulas: {
            setMigrationMode: function (get) {
                if (get('running')) {
                    if (get('vmtype') === 'qemu') {
                        return gettext('Online');
                    } else {
                        return gettext('Restart Mode');
                    }
                } else {
                    return gettext('Offline');
                }
            },
            setStorageselectorHidden: function (get) {
                if (get('migration.with-local-disks') && get('running')) {
                    return false;
                } else {
                    return true;
                }
            },
            setLocalResourceCheckboxHidden: function (get) {
                if (
                    get('running') ||
                    !get('migration.hasLocalResources') ||
                    Proxmox.UserName !== 'root@pam'
                ) {
                    return true;
                } else {
                    return false;
                }
            },
        },
    },

    controller: {
        xclass: 'Ext.app.ViewController',
        control: {
            'panel[reference=formPanel]': {
                validityChange: function (panel, isValid) {
                    this.getViewModel().set('migration.possible', isValid);
                    this.checkMigratePreconditions();
                },
            },
        },

        init: function (view) {
            var me = this,
                vm = view.getViewModel();

            if (!view.nodename) {
                throw 'missing custom view config: nodename';
            }
            vm.set('nodename', view.nodename);

            if (!view.vmid) {
                throw 'missing custom view config: vmid';
            }
            vm.set('vmid', view.vmid);

            if (!view.vmtype) {
                throw 'missing custom view config: vmtype';
            }
            vm.set('vmtype', view.vmtype);

            let title = Ext.String.format(
                '{0} {1} {2}',
                gettext('Migrate'),
                vm.get(view.vmtype).commonName,
                PVE.Utils.getFormattedGuestIdentifier(view.vmid, view.vmname),
            );
            view.setTitle(title);

            me.lookup('proxmoxHelpButton').setHelpConfig({
                onlineHelp: vm.get(view.vmtype).onlineHelp,
            });
            me.lookup('formPanel').isValid();
        },

        onTargetChange: function (nodeSelector) {
            // Always display the storages of the currently selected migration target
            this.lookup('pveDiskStorageSelector').setNodename(nodeSelector.value);
            this.checkMigratePreconditions(true);
        },

        startMigration: function () {
            var me = this,
                view = me.getView(),
                vm = me.getViewModel();

            var values = me.lookup('formPanel').getValues();
            var params = {
                target: values.target,
            };

            if (vm.get('migration.mode')) {
                params[vm.get('migration.mode')] = 1;
            }
            if (vm.get('migration.with-local-disks')) {
                params['with-local-disks'] = 1;
            }
            //offline migration to a different storage currently might fail at a late stage
            //(i.e. after some disks have been moved), so don't expose it yet in the GUI
            if (vm.get('migration.with-local-disks') && vm.get('running') && values.targetstorage) {
                params.targetstorage = values.targetstorage;
            }

            if (vm.get('migration.overwriteLocalResourceCheck')) {
                params.force = 1;
            }

            Proxmox.Utils.API2Request({
                params: params,
                url:
                    '/nodes/' +
                    vm.get('nodename') +
                    '/' +
                    vm.get('vmtype') +
                    '/' +
                    vm.get('vmid') +
                    '/migrate',
                waitMsgTarget: view,
                method: 'POST',
                failure: function (response, opts) {
                    Ext.Msg.alert(Proxmox.Utils.errorText, response.htmlStatus);
                },
                success: function (response, options) {
                    var upid = response.result.data;
                    var extraTitle = Ext.String.format(
                        ' ({0} ---> {1})',
                        vm.get('nodename'),
                        params.target,
                    );

                    Ext.create('Proxmox.window.TaskViewer', {
                        upid: upid,
                        extraTitle: extraTitle,
                    }).show();

                    view.close();
                },
            });
        },

        checkMigratePreconditions: async function (resetMigrationPossible) {
            var me = this,
                vm = me.getViewModel();

            var vmrec = PVE.data.ResourceStore.findRecord(
                'vmid',
                vm.get('vmid'),
                0,
                false,
                false,
                true,
            );
            if (vmrec && vmrec.data && vmrec.data.running) {
                vm.set('running', true);
            }

            me.lookup('pveNodeSelector').disallowedNodes = [vm.get('nodename')];

            if (vm.get('vmtype') === 'qemu') {
                await me.checkQemuPreconditions(resetMigrationPossible);
            } else {
                me.checkLxcPreconditions(resetMigrationPossible);
            }

            // Only allow nodes where the local storage is available in case of offline migration
            // where storage migration is not possible
            me.lookup('pveNodeSelector').allowedNodes = vm.get('migration.allowedNodes');

            me.lookup('formPanel').isValid();
        },

        checkQemuPreconditions: async function (resetMigrationPossible) {
            let me = this,
                vm = me.getViewModel(),
                migrateStats;

            if (vm.get('running')) {
                vm.set('migration.mode', 'online');
            }

            try {
                if (
                    me.fetchingNodeMigrateInfo &&
                    me.fetchingNodeMigrateInfo === vm.get('nodename')
                ) {
                    return;
                }
                me.fetchingNodeMigrateInfo = vm.get('nodename');
                let { result } = await Proxmox.Async.api2({
                    url: `/nodes/${vm.get('nodename')}/${vm.get('vmtype')}/${vm.get('vmid')}/migrate`,
                    method: 'GET',
                });
                migrateStats = result.data;
                me.fetchingNodeMigrateInfo = false;
            } catch (error) {
                Ext.Msg.alert(Proxmox.Utils.errorText, error.htmlStatus);
                return;
            }

            if (migrateStats.running) {
                vm.set('running', true);
            }
            // Get migration object from viewmodel to prevent to many bind callbacks
            let migration = vm.get('migration');
            if (resetMigrationPossible) {
                migration.possible = true;
            }
            migration.preconditions = [];
            let target = me.lookup('pveNodeSelector').value;
            let disallowed = migrateStats.not_allowed_nodes?.[target] ?? {};

            if (migrateStats.allowed_nodes && !vm.get('running')) {
                migration.allowedNodes = migrateStats.allowed_nodes;
                if (target.length && !migrateStats.allowed_nodes.includes(target)) {
                    if (disallowed.unavailable_storages !== undefined) {
                        let missingStorages = disallowed.unavailable_storages.join(', ');
                        const text = Ext.String.format(
                            gettext(
                                'Storage(s) ({0}) not available on selected target. Start VM to use live storage migration or select other target node.',
                            ),
                            missingStorages,
                        );

                        migration.possible = false;
                        migration.preconditions.push({ text, severity: 'error' });
                    }
                }
            }

            if (disallowed['unavailable-resources'] !== undefined) {
                let unavailableResources = disallowed['unavailable-resources'].join(', ');
                const text = Ext.String.format(
                    gettext('Mapped Resources ({0}) not available on selected target.'),
                    unavailableResources,
                );

                migration.possible = false;
                migration.preconditions.push({ text, severity: 'error' });
            }

            let blockingResources = [];
            let mappedResources = migrateStats['mapped-resource-info'] ?? {};

            for (const res of migrateStats.local_resources) {
                if (!mappedResources[res]) {
                    blockingResources.push(res);
                }
            }

            if (blockingResources.length) {
                migration.hasLocalResources = true;
                if (!migration.overwriteLocalResourceCheck || vm.get('running')) {
                    const text = Ext.String.format(
                        gettext('Cannot migrate VM with local resources: {0}'),
                        blockingResources.join(', '),
                    );

                    migration.possible = false;
                    migration.preconditions.push({ text, severity: 'error' });
                } else {
                    const text = Ext.String.format(
                        gettext(
                            'Migrating VM with local resources: {0}. This might fail if the resources are not available on the target node.',
                        ),
                        blockingResources.join(', '),
                    );

                    migration.preconditions.push({ text, severity: 'warning' });
                }
            }

            if (vm.get('running')) {
                let allowed = [];
                let notAllowed = [];
                for (const [key, resource] of Object.entries(mappedResources)) {
                    if (resource['live-migration']) {
                        allowed.push(key);
                    } else {
                        notAllowed.push(key);
                    }
                }
                if (notAllowed.length > 0) {
                    const text = Ext.String.format(
                        gettext('Cannot migrate running VM with mapped resources: {0}'),
                        notAllowed.join(', '),
                    );

                    migration.possible = false;
                    migration.preconditions.push({ text, severity: 'error' });
                } else if (allowed.length > 0) {
                    const text = Ext.String.format(
                        gettext(
                            'Live-migrating running VM with mapped resources (Experimental): {0}',
                        ),
                        allowed.join(', '),
                    );

                    migration.preconditions.push({ text, severity: 'warning' });
                }
            }

            if (migrateStats.local_disks.length) {
                migrateStats.local_disks.forEach(function (disk) {
                    if (disk.cdrom && disk.cdrom === 1) {
                        if (!disk.volid.includes('vm-' + vm.get('vmid') + '-cloudinit')) {
                            migration.possible = false;
                            migration.preconditions.push({
                                text: gettext('Cannot migrate VM with local CD/DVD'),
                                severity: 'error',
                            });
                        }
                    } else {
                        let size = disk.size
                            ? '(' + Proxmox.Utils.render_size(disk.size) + ')'
                            : '';
                        const text = Ext.String.format(
                            gettext('Migration with local disk might take long: {0} {1}'),
                            disk.volid,
                            size,
                        );

                        migration['with-local-disks'] = 1;
                        migration.preconditions.push({ text, severity: 'warning' });
                    }
                });
            }

            vm.set('migration', migration);
        },
        checkLxcPreconditions: function (resetMigrationPossible) {
            let vm = this.getViewModel();
            if (vm.get('running')) {
                vm.set('migration.mode', 'restart');
            }
        },
    },

    width: 600,
    modal: true,
    layout: {
        type: 'vbox',
        align: 'stretch',
    },
    border: false,
    items: [
        {
            xtype: 'form',
            reference: 'formPanel',
            bodyPadding: 10,
            border: false,
            layout: 'hbox',
            items: [
                {
                    xtype: 'container',
                    flex: 1,
                    items: [
                        {
                            xtype: 'displayfield',
                            name: 'source',
                            fieldLabel: gettext('Source node'),
                            bind: {
                                value: '{nodename}',
                            },
                        },
                        {
                            xtype: 'displayfield',
                            reference: 'migrationMode',
                            fieldLabel: gettext('Mode'),
                            bind: {
                                value: '{setMigrationMode}',
                            },
                        },
                    ],
                },
                {
                    xtype: 'container',
                    flex: 1,
                    items: [
                        {
                            xtype: 'pveNodeSelector',
                            reference: 'pveNodeSelector',
                            name: 'target',
                            fieldLabel: gettext('Target node'),
                            allowBlank: false,
                            disallowedNodes: undefined,
                            onlineValidator: true,
                            listeners: {
                                change: 'onTargetChange',
                            },
                        },
                        {
                            xtype: 'pveStorageSelector',
                            reference: 'pveDiskStorageSelector',
                            name: 'targetstorage',
                            fieldLabel: gettext('Target storage'),
                            storageContent: 'images',
                            allowBlank: true,
                            autoSelect: false,
                            emptyText: gettext('Current layout'),
                            bind: {
                                hidden: '{setStorageselectorHidden}',
                            },
                        },
                        {
                            xtype: 'proxmoxcheckbox',
                            name: 'overwriteLocalResourceCheck',
                            fieldLabel: gettext('Force'),
                            autoEl: {
                                tag: 'div',
                                'data-qtip': gettext('Overwrite local resources unavailable check'),
                            },
                            bind: {
                                hidden: '{setLocalResourceCheckboxHidden}',
                                value: '{migration.overwriteLocalResourceCheck}',
                            },
                            listeners: {
                                change: {
                                    fn: 'checkMigratePreconditions',
                                    extraArg: true,
                                },
                            },
                        },
                    ],
                },
            ],
        },
        {
            xtype: 'gridpanel',
            reference: 'preconditionGrid',
            selectable: false,
            flex: 1,
            columns: [
                {
                    text: '',
                    dataIndex: 'severity',
                    renderer: function (v) {
                        switch (v) {
                            case 'warning':
                                return '<i class="fa fa-exclamation-triangle warning"></i> ';
                            case 'error':
                                return '<i class="fa fa-times critical"></i>';
                            default:
                                return v;
                        }
                    },
                    width: 35,
                },
                {
                    text: 'Info',
                    dataIndex: 'text',
                    cellWrap: true,
                    flex: 1,
                },
            ],
            bind: {
                hidden: '{!migration.preconditions.length}',
                store: {
                    fields: ['severity', 'text'],
                    data: '{migration.preconditions}',
                    sorters: 'text',
                },
            },
        },
    ],
    buttons: [
        {
            xtype: 'proxmoxHelpButton',
            reference: 'proxmoxHelpButton',
            onlineHelp: 'pct_migration',
            listenToGlobalEvent: false,
            hidden: false,
        },
        '->',
        {
            xtype: 'button',
            reference: 'submitButton',
            text: gettext('Migrate'),
            handler: 'startMigration',
            bind: {
                disabled: '{!migration.possible}',
            },
        },
    ],
});
Ext.define('pve-prune-list', {
    extend: 'Ext.data.Model',
    fields: [
        'type',
        'vmid',
        {
            name: 'ctime',
            type: 'date',
            dateFormat: 'timestamp',
        },
    ],
});

Ext.define('PVE.PruneInputPanel', {
    extend: 'Proxmox.panel.InputPanel',
    alias: 'widget.pvePruneInputPanel',
    mixins: ['Proxmox.Mixin.CBind'],

    onGetValues: function (values) {
        let me = this;

        // the API expects a single prune-backups property string
        let pruneBackups = PVE.Parser.printPropertyString(values);
        values = {
            'prune-backups': pruneBackups,
            type: me.backup_type,
            vmid: me.backup_id,
        };

        return values;
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        init: function (view) {
            if (!view.url) {
                throw 'no url specified';
            }
            if (!view.backup_type) {
                throw 'no backup_type specified';
            }
            if (!view.backup_id) {
                throw 'no backup_id specified';
            }

            this.reload(); // initial load
        },

        reload: function () {
            let view = this.getView();

            // helper to allow showing why a backup is kept
            let addKeepReasons = function (backups, params) {
                const rules = [
                    'keep-last',
                    'keep-hourly',
                    'keep-daily',
                    'keep-weekly',
                    'keep-monthly',
                    'keep-yearly',
                    'keep-all', // when all keep options are not set
                ];
                let counter = {};

                backups.sort((a, b) => b.ctime - a.ctime);

                let ruleIndex = -1;
                let nextRule = function () {
                    let rule;
                    do {
                        ruleIndex++;
                        rule = rules[ruleIndex];
                    } while (!params[rule] && rule !== 'keep-all');
                    counter[rule] = 0;
                    return rule;
                };

                let rule = nextRule();
                for (let backup of backups) {
                    if (backup.mark === 'keep') {
                        counter[rule]++;
                        if (rule !== 'keep-all') {
                            backup.keepReason = rule + ': ' + counter[rule];
                            if (counter[rule] >= params[rule]) {
                                rule = nextRule();
                            }
                        } else {
                            backup.keepReason = rule;
                        }
                    }
                }
            };

            let params = view.getValues();
            let keepParams = PVE.Parser.parsePropertyString(params['prune-backups']);

            Proxmox.Utils.API2Request({
                url: view.url,
                method: 'GET',
                params: params,
                callback: function () {
                    // for easy breakpoint setting
                },
                failure: function (response, opts) {
                    Ext.Msg.alert(gettext('Error'), response.htmlStatus);
                },
                success: function (response, options) {
                    var data = response.result.data;
                    addKeepReasons(data, keepParams);
                    view.pruneStore.setData(data);
                },
            });
        },

        control: {
            field: { change: 'reload' },
        },
    },

    column1: [
        {
            xtype: 'pmxPruneKeepField',
            name: 'keep-last',
            fieldLabel: gettext('keep-last'),
        },
        {
            xtype: 'pmxPruneKeepField',
            name: 'keep-hourly',
            fieldLabel: gettext('keep-hourly'),
        },
        {
            xtype: 'pmxPruneKeepField',
            name: 'keep-daily',
            fieldLabel: gettext('keep-daily'),
        },
        {
            xtype: 'pmxPruneKeepField',
            name: 'keep-weekly',
            fieldLabel: gettext('keep-weekly'),
        },
        {
            xtype: 'pmxPruneKeepField',
            name: 'keep-monthly',
            fieldLabel: gettext('keep-monthly'),
        },
        {
            xtype: 'pmxPruneKeepField',
            name: 'keep-yearly',
            fieldLabel: gettext('keep-yearly'),
        },
    ],

    initComponent: function () {
        var me = this;

        me.pruneStore = Ext.create('Ext.data.Store', {
            model: 'pve-prune-list',
            sorters: { property: 'ctime', direction: 'DESC' },
        });

        me.column2 = [
            {
                xtype: 'grid',
                height: 200,
                store: me.pruneStore,
                columns: [
                    {
                        header: gettext('Backup Time'),
                        sortable: true,
                        dataIndex: 'ctime',
                        renderer: function (value, metaData, record) {
                            let text = Ext.Date.format(value, 'Y-m-d H:i:s');
                            if (record.data.mark === 'remove') {
                                return (
                                    '<div style="text-decoration: line-through;">' + text + '</div>'
                                );
                            } else {
                                return text;
                            }
                        },
                        flex: 1,
                    },
                    {
                        text: 'Keep (reason)',
                        dataIndex: 'mark',
                        renderer: function (value, metaData, record) {
                            if (record.data.mark === 'keep') {
                                return 'true (' + record.data.keepReason + ')';
                            } else if (record.data.mark === 'protected') {
                                return 'true (protected)';
                            } else if (record.data.mark === 'renamed') {
                                return 'true (renamed)';
                            } else {
                                return 'false';
                            }
                        },
                        flex: 1,
                    },
                ],
            },
        ];

        me.callParent();
    },
});

Ext.define('PVE.window.Prune', {
    extend: 'Proxmox.window.Edit',

    method: 'DELETE',
    submitText: gettext('Prune'),

    fieldDefaults: { labelWidth: 130 },

    isCreate: true,

    initComponent: function () {
        var me = this;

        if (!me.nodename) {
            throw 'no nodename specified';
        }
        if (!me.storage) {
            throw 'no storage specified';
        }
        if (!me.backup_type) {
            throw 'no backup_type specified';
        }
        if (me.backup_type !== 'qemu' && me.backup_type !== 'lxc') {
            throw 'unknown backup type: ' + me.backup_type;
        }
        if (!me.backup_id) {
            throw 'no backup_id specified';
        }

        let title = Ext.String.format(
            gettext("Prune Backups for '{0}' on Storage '{1}'"),
            me.backup_type + '/' + me.backup_id,
            me.storage,
        );

        Ext.apply(me, {
            url: '/api2/extjs/nodes/' + me.nodename + '/storage/' + me.storage + '/prunebackups',
            title: title,
            items: [
                {
                    xtype: 'pvePruneInputPanel',
                    url:
                        '/api2/extjs/nodes/' +
                        me.nodename +
                        '/storage/' +
                        me.storage +
                        '/prunebackups',
                    backup_type: me.backup_type,
                    backup_id: me.backup_id,
                    storage: me.storage,
                },
            ],
        });

        me.callParent();
    },
});
Ext.define('PVE.window.Restore', {
    extend: 'Ext.window.Window', // fixme: Proxmox.window.Edit?

    resizable: false,
    width: 500,
    modal: true,
    layout: 'auto',
    border: false,

    controller: {
        xclass: 'Ext.app.ViewController',
        control: {
            '#liveRestore': {
                change: function (el, newVal) {
                    let liveWarning = this.lookupReference('liveWarning');
                    liveWarning.setHidden(!newVal);
                    let start = this.lookupReference('start');
                    start.setDisabled(newVal);
                },
            },
            form: {
                validitychange: function (f, valid) {
                    this.lookupReference('doRestoreBtn').setDisabled(!valid);
                },
            },
        },

        doRestore: function () {
            let me = this;
            let view = me.getView();

            let values = view.down('form').getForm().getValues();

            let params = {
                vmid: view.vmid || values.vmid,
                force: view.vmid ? 1 : 0,
            };
            if (values.unique) {
                params.unique = 1;
            }
            if (values.start && !values['live-restore']) {
                params.start = 1;
            }
            if (values['live-restore']) {
                params['live-restore'] = 1;
            }
            if (values.storage) {
                params.storage = values.storage;
            }

            ['bwlimit', 'cores', 'name', 'memory', 'sockets'].forEach((opt) => {
                if ((values[opt] ?? '') !== '') {
                    params[opt] = values[opt];
                }
            });

            if (params.name && view.vmtype === 'lxc') {
                params.hostname = params.name;
                delete params.name;
            }

            let taskDescription;
            if (view.vmtype === 'lxc') {
                params.ostemplate = view.volid;
                params.restore = 1;
                if (values.unprivileged !== 'keep') {
                    params.unprivileged = values.unprivileged;
                }
                taskDescription = Proxmox.Utils.format_task_description('vzrestore', params.vmid);
            } else if (view.vmtype === 'qemu') {
                params.archive = view.volid;
                taskDescription = Proxmox.Utils.format_task_description('qmrestore', params.vmid);
            } else {
                throw 'unknown VM type';
            }
            let confirmMsg = Ext.htmlEncode(taskDescription);

            let executeRestore = () => {
                Proxmox.Utils.API2Request({
                    url: `/nodes/${view.nodename}/${view.vmtype}`,
                    params: params,
                    method: 'POST',
                    waitMsgTarget: view,
                    failure: (response) => Ext.Msg.alert(gettext('Error'), response.htmlStatus),
                    success: function (response, options) {
                        Ext.create('Proxmox.window.TaskViewer', {
                            autoShow: true,
                            upid: response.result.data,
                        });
                        view.close();
                    },
                });
            };

            if (view.vmid) {
                confirmMsg += `. ${Ext.String.format(
                    gettext('This will permanently erase current {0} data.'),
                    view.vmtype === 'lxc' ? 'CT' : 'VM',
                )}`;
                if (view.vmtype === 'lxc') {
                    confirmMsg += `<br>${gettext('Mount point volumes are also erased.')}`;
                }
                Ext.Msg.confirm(gettext('Confirm'), confirmMsg, function (btn) {
                    if (btn === 'yes') {
                        executeRestore();
                    }
                });
            } else {
                executeRestore();
            }
        },

        afterRender: function () {
            let view = this.getView();

            Proxmox.Utils.API2Request({
                url: `/nodes/${view.nodename}/vzdump/extractconfig`,
                method: 'GET',
                waitMsgTarget: view,
                params: {
                    volume: view.volid,
                },
                failure: (response) => Ext.Msg.alert('Error', response.htmlStatus),
                success: function (response, options) {
                    let allStoragesAvailable = true;

                    response.result.data.split('\n').forEach((line) => {
                        let [_, key, value] = line.match(/^([^:]+):\s*(\S+)\s*$/) ?? [];

                        if (!key) {
                            return;
                        }

                        if (key === '#qmdump#map') {
                            let match = value.match(/^(\S+):(\S+):(\S*):(\S*):$/) ?? [];
                            // if a /dev/XYZ disk was backed up, there is no storage hint
                            allStoragesAvailable &&=
                                !!match[3] &&
                                !!PVE.data.ResourceStore.getById(
                                    `storage/${view.nodename}/${match[3]}`,
                                );
                        } else if (key === 'name' || key === 'hostname') {
                            view.lookupReference('nameField').setEmptyText(value);
                        } else if (key === 'memory' || key === 'cores' || key === 'sockets') {
                            view.lookupReference(`${key}Field`).setEmptyText(value);
                        }
                    });

                    if (!allStoragesAvailable) {
                        let storagesel = view.down('pveStorageSelector[name=storage]');
                        storagesel.allowBlank = false;
                        storagesel.setEmptyText('');
                    }
                },
            });
        },
    },

    initComponent: function () {
        let me = this;

        if (!me.nodename) {
            throw 'no node name specified';
        }
        if (!me.volid) {
            throw 'no volume ID specified';
        }
        if (!me.vmtype) {
            throw 'no vmtype specified';
        }

        let storagesel = Ext.create('PVE.form.StorageSelector', {
            nodename: me.nodename,
            name: 'storage',
            value: '',
            fieldLabel: gettext('Storage'),
            storageContent: me.vmtype === 'lxc' ? 'rootdir' : 'images',
            // when restoring a container without specifying a storage, the backend defaults
            // to 'local', which is unintuitive and 'rootdir' might not even be allowed on it
            allowBlank: me.vmtype !== 'lxc',
            emptyText: me.vmtype === 'lxc' ? '' : gettext('From backup configuration'),
            autoSelect: me.vmtype === 'lxc',
        });

        let items = [
            {
                xtype: 'displayfield',
                value: me.volidText || me.volid,
                fieldLabel: gettext('Source'),
            },
            storagesel,
            {
                xtype: 'pmxDisplayEditField',
                name: 'vmid',
                fieldLabel: me.vmtype === 'lxc' ? 'CT' : 'VM',
                value: me.vmid,
                editable: !me.vmid,
                editConfig: {
                    xtype: 'pveGuestIDSelector',
                    guestType: me.vmtype,
                    loadNextFreeID: true,
                    validateExists: false,
                },
            },
            {
                xtype: 'pveBandwidthField',
                name: 'bwlimit',
                backendUnit: 'KiB',
                allowZero: true,
                fieldLabel: gettext('Bandwidth Limit'),
                emptyText: gettext('Defaults to target storage restore limit'),
                autoEl: {
                    tag: 'div',
                    'data-qtip': gettext("Use '0' to disable all bandwidth limits."),
                },
            },
            {
                xtype: 'fieldcontainer',
                layout: 'hbox',
                items: [
                    {
                        xtype: 'proxmoxcheckbox',
                        name: 'unique',
                        fieldLabel: gettext('Unique'),
                        flex: 1,
                        autoEl: {
                            tag: 'div',
                            'data-qtip': gettext(
                                'Autogenerate unique properties, e.g., MAC addresses',
                            ),
                        },
                        checked: false,
                    },
                    {
                        xtype: 'proxmoxcheckbox',
                        name: 'start',
                        reference: 'start',
                        flex: 1,
                        fieldLabel: gettext('Start after restore'),
                        labelWidth: 105,
                        checked: false,
                    },
                ],
            },
        ];

        if (me.vmtype === 'lxc') {
            items.push({
                xtype: 'radiogroup',
                fieldLabel: gettext('Privilege Level'),
                reference: 'noVNCScalingGroup',
                height: '15px', // renders faster with value assigned
                layout: {
                    type: 'hbox',
                    algin: 'stretch',
                },
                autoEl: {
                    tag: 'div',
                    'data-qtip': gettext(
                        'Choose if you want to keep or override the privilege level of the restored Container.',
                    ),
                },
                items: [
                    {
                        xtype: 'radiofield',
                        name: 'unprivileged',
                        inputValue: 'keep',
                        boxLabel: gettext('From Backup'),
                        flex: 1,
                        checked: true,
                    },
                    {
                        xtype: 'radiofield',
                        name: 'unprivileged',
                        inputValue: '1',
                        boxLabel: gettext('Unprivileged'),
                        flex: 1,
                    },
                    {
                        xtype: 'radiofield',
                        name: 'unprivileged',
                        inputValue: '0',
                        boxLabel: gettext('Privileged'),
                        flex: 1,
                        //margin: '0 0 0 10',
                    },
                ],
            });
        } else if (me.vmtype === 'qemu') {
            items.push(
                {
                    xtype: 'proxmoxcheckbox',
                    name: 'live-restore',
                    itemId: 'liveRestore',
                    flex: 1,
                    fieldLabel: gettext('Live restore'),
                    checked: false,
                    hidden: !me.isPBS,
                },
                {
                    xtype: 'displayfield',
                    reference: 'liveWarning',
                    // TODO: Remove once more tested/stable?
                    value: gettext(
                        'Note: If anything goes wrong during the live-restore, new data written by the VM may be lost.',
                    ),
                    userCls: 'pmx-hint',
                    hidden: true,
                },
            );
        }

        items.push({
            xtype: 'fieldset',
            title: `${gettext('Override Settings')}:`,
            layout: 'hbox',
            defaults: {
                border: false,
                layout: 'anchor',
                flex: 1,
            },
            items: [
                {
                    padding: '0 10 0 0',
                    items: [
                        {
                            xtype: 'textfield',
                            fieldLabel: me.vmtype === 'lxc' ? gettext('Hostname') : gettext('Name'),
                            name: 'name',
                            vtype: 'DnsName',
                            reference: 'nameField',
                            allowBlank: true,
                        },
                        {
                            xtype: 'proxmoxintegerfield',
                            fieldLabel: gettext('Cores'),
                            name: 'cores',
                            reference: 'coresField',
                            minValue: 1,
                            maxValue: 128,
                            allowBlank: true,
                        },
                    ],
                },
                {
                    padding: '0 0 0 10',
                    items: [
                        {
                            xtype: 'pveMemoryField',
                            fieldLabel: gettext('Memory'),
                            name: 'memory',
                            reference: 'memoryField',
                            value: '',
                            allowBlank: true,
                        },
                        {
                            xtype: 'proxmoxintegerfield',
                            fieldLabel: gettext('Sockets'),
                            name: 'sockets',
                            reference: 'socketsField',
                            minValue: 1,
                            maxValue: 4,
                            allowBlank: true,
                            hidden: me.vmtype !== 'qemu',
                            disabled: me.vmtype !== 'qemu',
                        },
                    ],
                },
            ],
        });

        let title = gettext('Restore') + ': ' + (me.vmtype === 'lxc' ? 'CT' : 'VM');
        if (me.vmid) {
            let formattedGuestIdentifier = PVE.Utils.getFormattedGuestIdentifier(
                me.vmid,
                me.vmname,
            );
            title = `${gettext('Overwrite')} ${title} ${formattedGuestIdentifier}`;
        }

        Ext.apply(me, {
            title: title,
            items: [
                {
                    xtype: 'form',
                    bodyPadding: 10,
                    border: false,
                    fieldDefaults: {
                        labelWidth: 100,
                        anchor: '100%',
                    },
                    items: items,
                },
            ],
            buttons: [
                {
                    text: gettext('Restore'),
                    reference: 'doRestoreBtn',
                    handler: 'doRestore',
                },
            ],
        });

        me.callParent();
    },
});
/*
 * SafeDestroy window with additional checkboxes for removing guests
 */
Ext.define('PVE.window.SafeDestroyGuest', {
    extend: 'Proxmox.window.SafeDestroy',
    alias: 'widget.pveSafeDestroyGuest',

    additionalItems: [
        {
            xtype: 'proxmoxcheckbox',
            name: 'purge',
            reference: 'purgeCheckbox',
            boxLabel: gettext('Purge from job configurations'),
            checked: false,
            autoEl: {
                tag: 'div',
                'data-qtip': gettext('Remove from replication, HA and backup jobs'),
            },
        },
        {
            xtype: 'proxmoxcheckbox',
            name: 'destroyUnreferenced',
            reference: 'destroyUnreferencedCheckbox',
            boxLabel: gettext('Destroy unreferenced disks owned by guest'),
            checked: false,
            autoEl: {
                tag: 'div',
                'data-qtip': gettext(
                    'Scan all enabled storages for unreferenced disks and delete them.',
                ),
            },
        },
    ],

    note: gettext('Referenced disks will always be destroyed.'),

    getParams: function () {
        let me = this;

        const purgeCheckbox = me.lookupReference('purgeCheckbox');
        me.params.purge = purgeCheckbox.checked ? 1 : 0;

        const destroyUnreferencedCheckbox = me.lookupReference('destroyUnreferencedCheckbox');
        me.params['destroy-unreferenced-disks'] = destroyUnreferencedCheckbox.checked ? 1 : 0;

        return me.callParent();
    },
});
/*
 * SafeDestroy window with additional checkboxes for removing a storage on the disk level.
 */
Ext.define('PVE.window.SafeDestroyStorage', {
    extend: 'Proxmox.window.SafeDestroy',
    alias: 'widget.pveSafeDestroyStorage',

    showProgress: true,

    additionalItems: [
        {
            xtype: 'proxmoxcheckbox',
            name: 'wipeDisks',
            reference: 'wipeDisksCheckbox',
            boxLabel: gettext('Cleanup Disks'),
            checked: true,
            autoEl: {
                tag: 'div',
                'data-qtip': gettext('Wipe labels and other left-overs'),
            },
        },
        {
            xtype: 'proxmoxcheckbox',
            name: 'cleanupConfig',
            reference: 'cleanupConfigCheckbox',
            boxLabel: gettext('Cleanup Storage Configuration'),
            checked: true,
        },
    ],

    getParams: function () {
        let me = this;

        me.params['cleanup-disks'] = me.lookupReference('wipeDisksCheckbox').checked ? 1 : 0;
        me.params['cleanup-config'] = me.lookupReference('cleanupConfigCheckbox').checked ? 1 : 0;

        return me.callParent();
    },
});
Ext.define('PVE.window.Settings', {
    extend: 'Ext.window.Window',

    width: '800px',
    title: gettext('My Settings'),
    iconCls: 'fa fa-gear',
    modal: true,
    bodyPadding: 10,
    resizable: false,

    buttons: [
        {
            xtype: 'proxmoxHelpButton',
            onlineHelp: 'gui_my_settings',
            hidden: false,
        },
        '->',
        {
            text: gettext('Close'),
            handler: function () {
                this.up('window').close();
            },
        },
    ],

    layout: 'hbox',

    controller: {
        xclass: 'Ext.app.ViewController',

        init: function (view) {
            var me = this;
            var sp = Ext.state.Manager.getProvider();

            var username = sp.get('login-username') || Proxmox.Utils.noneText;
            me.lookupReference('savedUserName').setValue(Ext.String.htmlEncode(username));
            var vncMode = sp.get('novnc-scaling') || 'auto';
            me.lookupReference('noVNCScalingGroup').setValue({ noVNCScalingField: vncMode });

            let summarycolumns = sp.get('summarycolumns', 'auto');
            me.lookup('summarycolumns').setValue(summarycolumns);

            me.lookup('guestNotesCollapse').setValue(sp.get('guest-notes-collapse', 'never'));
            me.lookup('editNotesOnDoubleClick').setValue(
                sp.get('edit-notes-on-double-click', false),
            );

            var settings = ['fontSize', 'fontFamily', 'letterSpacing', 'lineHeight'];
            settings.forEach(function (setting) {
                var val = localStorage.getItem('pve-xterm-' + setting);
                if (val !== undefined && val !== null) {
                    let field = me.lookup(setting);
                    field.setValue(val);
                    field.resetOriginalValue();
                }
            });
        },

        set_button_status: function () {
            let me = this;
            let form = me.lookup('xtermform');

            let valid = form.isValid(),
                dirty = form.isDirty();
            let hasValues = Object.values(form.getValues()).some((v) => !!v);

            me.lookup('xtermsave').setDisabled(!dirty || !valid);
            me.lookup('xtermreset').setDisabled(!hasValues);
        },

        control: {
            '#xtermjs form': {
                dirtychange: 'set_button_status',
                validitychange: 'set_button_status',
            },
            '#xtermjs button': {
                click: function (button) {
                    var me = this;
                    var settings = ['fontSize', 'fontFamily', 'letterSpacing', 'lineHeight'];
                    settings.forEach(function (setting) {
                        var field = me.lookup(setting);
                        if (button.reference === 'xtermsave') {
                            let value = field.getValue();
                            if (value) {
                                localStorage.setItem('pve-xterm-' + setting, value);
                            } else {
                                localStorage.removeItem('pve-xterm-' + setting);
                            }
                        } else if (button.reference === 'xtermreset') {
                            field.setValue(undefined);
                            localStorage.removeItem('pve-xterm-' + setting);
                        }
                        field.resetOriginalValue();
                    });
                    me.set_button_status();
                },
            },
            'button[name=reset]': {
                click: function () {
                    let blacklist = ['GuiCap', 'login-username', 'dash-storages'];
                    let sp = Ext.state.Manager.getProvider();
                    for (const state of Object.keys(sp.state)) {
                        if (!blacklist.includes(state)) {
                            sp.clear(state);
                        }
                    }
                    window.location.reload();
                },
            },
            'button[name=clear-username]': {
                click: function () {
                    let me = this;
                    me.lookupReference('savedUserName').setValue(Proxmox.Utils.noneText);
                    Ext.state.Manager.getProvider().clear('login-username');
                },
            },
            'grid[reference=dashboard-storages]': {
                selectionchange: function (grid, selected) {
                    var _me = this;
                    var sp = Ext.state.Manager.getProvider();

                    // saves the selected storageids as "id1,id2,id3,..." or clears the variable
                    if (selected.length > 0) {
                        sp.set('dash-storages', Ext.Array.pluck(selected, 'id').join(','));
                    } else {
                        sp.clear('dash-storages');
                    }
                },
                afterrender: function (grid) {
                    let store = grid.getStore();
                    let storages = Ext.state.Manager.getProvider().get('dash-storages') || '';

                    let items = [];
                    storages.split(',').forEach((storage) => {
                        if (storage !== '') {
                            // we have to get the records to be able to select them
                            let item = store.getById(storage);
                            if (item) {
                                items.push(item);
                            }
                        }
                    });
                    grid.suspendEvent('selectionchange');
                    grid.getSelectionModel().select(items);
                    grid.resumeEvent('selectionchange');
                },
            },
            'field[reference=summarycolumns]': {
                change: (el, newValue) =>
                    Ext.state.Manager.getProvider().set('summarycolumns', newValue),
            },
            'field[reference=guestNotesCollapse]': {
                change: (e, v) => Ext.state.Manager.getProvider().set('guest-notes-collapse', v),
            },
            'field[reference=editNotesOnDoubleClick]': {
                change: (e, v) =>
                    Ext.state.Manager.getProvider().set('edit-notes-on-double-click', v),
            },
        },
    },

    items: [
        {
            xtype: 'fieldset',
            flex: 1,
            title: gettext('Webinterface Settings'),
            margin: '5',
            layout: {
                type: 'vbox',
                align: 'left',
            },
            defaults: {
                width: '100%',
                margin: '0 0 10 0',
            },
            items: [
                {
                    xtype: 'displayfield',
                    fieldLabel: gettext('Dashboard Storages'),
                    labelAlign: 'left',
                    labelWidth: '50%',
                },
                {
                    xtype: 'grid',
                    maxHeight: 150,
                    reference: 'dashboard-storages',
                    selModel: {
                        selType: 'checkboxmodel',
                    },
                    columns: [
                        {
                            header: gettext('Name'),
                            dataIndex: 'storage',
                            flex: 1,
                        },
                        {
                            header: gettext('Node'),
                            dataIndex: 'node',
                            flex: 1,
                        },
                    ],
                    store: {
                        type: 'diff',
                        field: ['type', 'storage', 'id', 'node'],
                        rstore: PVE.data.ResourceStore,
                        filters: [
                            {
                                property: 'type',
                                value: 'storage',
                            },
                        ],
                        sorters: ['node', 'storage'],
                    },
                },
                {
                    xtype: 'box',
                    autoEl: { tag: 'hr' },
                },
                {
                    xtype: 'container',
                    layout: 'hbox',
                    items: [
                        {
                            xtype: 'displayfield',
                            fieldLabel: gettext('Saved User Name') + ':',
                            labelWidth: 150,
                            stateId: 'login-username',
                            reference: 'savedUserName',
                            flex: 1,
                            value: '',
                        },
                        {
                            xtype: 'button',
                            cls: 'x-btn-default-toolbar-small proxmox-inline-button',
                            text: gettext('Reset'),
                            name: 'clear-username',
                        },
                    ],
                },
                {
                    xtype: 'box',
                    autoEl: { tag: 'hr' },
                },
                {
                    xtype: 'container',
                    layout: 'hbox',
                    items: [
                        {
                            xtype: 'displayfield',
                            fieldLabel: gettext('Layout') + ':',
                            flex: 1,
                        },
                        {
                            xtype: 'button',
                            cls: 'x-btn-default-toolbar-small proxmox-inline-button',
                            text: gettext('Reset'),
                            tooltip: gettext(
                                'Reset all layout changes (for example, column widths)',
                            ),
                            name: 'reset',
                        },
                    ],
                },
                {
                    xtype: 'box',
                    autoEl: { tag: 'hr' },
                },
                {
                    xtype: 'proxmoxKVComboBox',
                    fieldLabel: gettext('Summary columns') + ':',
                    labelWidth: 125,
                    stateId: 'summarycolumns',
                    reference: 'summarycolumns',
                    comboItems: [
                        ['auto', 'auto'],
                        ['1', '1'],
                        ['2', '2'],
                        ['3', '3'],
                    ],
                },
                {
                    xtype: 'proxmoxKVComboBox',
                    fieldLabel: gettext('Guest Notes') + ':',
                    labelWidth: 125,
                    stateId: 'guest-notes-collapse',
                    reference: 'guestNotesCollapse',
                    comboItems: [
                        ['never', 'Show by default'],
                        ['always', 'Collapse by default'],
                        ['auto', 'auto (Collapse if empty)'],
                    ],
                },
                {
                    xtype: 'checkbox',
                    fieldLabel: gettext('Notes'),
                    labelWidth: 125,
                    boxLabel: gettext('Open editor on double-click'),
                    reference: 'editNotesOnDoubleClick',
                    inputValue: true,
                    uncheckedValue: false,
                },
            ],
        },
        {
            xtype: 'container',
            layout: 'vbox',
            flex: 1,
            margin: '5',
            defaults: {
                width: '100%',
                // right margin ensures that the right border of the fieldsets
                // is shown
                margin: '0 2 10 0',
            },
            items: [
                {
                    xtype: 'fieldset',
                    itemId: 'xtermjs',
                    title: gettext('xterm.js Settings'),
                    items: [
                        {
                            xtype: 'form',
                            reference: 'xtermform',
                            border: false,
                            layout: {
                                type: 'vbox',
                                algin: 'left',
                            },
                            defaults: {
                                width: '100%',
                                margin: '0 0 10 0',
                            },
                            items: [
                                {
                                    xtype: 'textfield',
                                    name: 'fontFamily',
                                    reference: 'fontFamily',
                                    emptyText: Proxmox.Utils.defaultText,
                                    fieldLabel: gettext('Font-Family'),
                                },
                                {
                                    xtype: 'proxmoxintegerfield',
                                    emptyText: Proxmox.Utils.defaultText,
                                    name: 'fontSize',
                                    reference: 'fontSize',
                                    minValue: 1,
                                    fieldLabel: gettext('Font-Size'),
                                },
                                {
                                    xtype: 'numberfield',
                                    name: 'letterSpacing',
                                    reference: 'letterSpacing',
                                    emptyText: Proxmox.Utils.defaultText,
                                    fieldLabel: gettext('Letter Spacing'),
                                },
                                {
                                    xtype: 'numberfield',
                                    name: 'lineHeight',
                                    minValue: 0.1,
                                    reference: 'lineHeight',
                                    emptyText: Proxmox.Utils.defaultText,
                                    fieldLabel: gettext('Line Height'),
                                },
                                {
                                    xtype: 'container',
                                    layout: {
                                        type: 'hbox',
                                        pack: 'end',
                                    },
                                    defaults: {
                                        margin: '0 0 0 5',
                                    },
                                    items: [
                                        {
                                            xtype: 'button',
                                            reference: 'xtermreset',
                                            disabled: true,
                                            text: gettext('Reset'),
                                        },
                                        {
                                            xtype: 'button',
                                            reference: 'xtermsave',
                                            disabled: true,
                                            text: gettext('Save'),
                                        },
                                    ],
                                },
                            ],
                        },
                    ],
                },
                {
                    xtype: 'fieldset',
                    title: gettext('noVNC Settings'),
                    items: [
                        {
                            xtype: 'radiogroup',
                            fieldLabel: gettext('Scaling mode'),
                            reference: 'noVNCScalingGroup',
                            height: '15px', // renders faster with value assigned
                            layout: {
                                type: 'hbox',
                            },
                            items: [
                                {
                                    xtype: 'radiofield',
                                    name: 'noVNCScalingField',
                                    inputValue: 'auto',
                                    boxLabel: 'Auto',
                                },
                                {
                                    xtype: 'radiofield',
                                    name: 'noVNCScalingField',
                                    inputValue: 'scale',
                                    boxLabel: 'Local Scaling',
                                    margin: '0 0 0 10',
                                },
                                {
                                    xtype: 'radiofield',
                                    name: 'noVNCScalingField',
                                    inputValue: 'off',
                                    boxLabel: 'Off',
                                    margin: '0 0 0 10',
                                },
                            ],
                            listeners: {
                                change: function (el, { noVNCScalingField }) {
                                    let provider = Ext.state.Manager.getProvider();
                                    if (noVNCScalingField === 'auto') {
                                        provider.clear('novnc-scaling');
                                    } else {
                                        provider.set('novnc-scaling', noVNCScalingField);
                                    }
                                },
                            },
                        },
                    ],
                },
            ],
        },
    ],
});
Ext.define('PVE.window.Snapshot', {
    extend: 'Proxmox.window.Edit',

    viewModel: {
        data: {
            type: undefined,
            isCreate: undefined,
            running: false,
            guestAgentEnabled: false,
        },
        formulas: {
            runningWithoutGuestAgent: (get) =>
                get('type') === 'qemu' && get('running') && !get('guestAgentEnabled'),
            shouldWarnAboutFS: (get) =>
                get('isCreate') && get('runningWithoutGuestAgent') && get('!vmstate.checked'),
        },
    },

    onGetValues: function (values) {
        let me = this;

        if (me.type === 'lxc') {
            delete values.vmstate;
        }

        return values;
    },

    initComponent: function () {
        var me = this;
        var vm = me.getViewModel();

        if (!me.nodename) {
            throw 'no node name specified';
        }

        if (!me.vmid) {
            throw 'no VM ID specified';
        }

        if (!me.type) {
            throw 'no type specified';
        }

        vm.set('type', me.type);
        vm.set('running', me.running);
        vm.set('isCreate', me.isCreate);

        if (me.type === 'qemu' && me.isCreate) {
            Proxmox.Utils.API2Request({
                url: `/nodes/${me.nodename}/${me.type}/${me.vmid}/config`,
                params: { current: '1' },
                method: 'GET',
                success: function (response, options) {
                    let res = response.result.data;
                    let enabled = PVE.Parser.parsePropertyString(res.agent, 'enabled');
                    vm.set('guestAgentEnabled', !!PVE.Parser.parseBoolean(enabled.enabled));
                },
            });
        }

        me.items = [
            {
                xtype: me.isCreate ? 'textfield' : 'displayfield',
                name: 'snapname',
                value: me.snapname,
                fieldLabel: gettext('Name'),
                vtype: 'ConfigId',
                allowBlank: false,
            },
            {
                xtype: 'displayfield',
                hidden: me.isCreate,
                disabled: me.isCreate,
                name: 'snaptime',
                renderer: PVE.Utils.render_timestamp_human_readable,
                fieldLabel: gettext('Timestamp'),
            },
            {
                xtype: 'proxmoxcheckbox',
                hidden: me.type !== 'qemu' || !me.isCreate || !me.running,
                disabled: me.type !== 'qemu' || !me.isCreate || !me.running,
                name: 'vmstate',
                reference: 'vmstate',
                uncheckedValue: 0,
                defaultValue: 0,
                checked: 1,
                fieldLabel: gettext('Include RAM'),
            },
            {
                xtype: 'textareafield',
                grow: true,
                editable: !me.viewonly,
                name: 'description',
                fieldLabel: gettext('Description'),
            },
            {
                xtype: 'displayfield',
                userCls: 'pmx-hint',
                name: 'fswarning',
                hidden: true,
                value: gettext(
                    'It is recommended to either include the RAM or use the QEMU Guest Agent when taking a snapshot of a running VM to avoid inconsistencies.',
                ),
                bind: {
                    hidden: '{!shouldWarnAboutFS}',
                },
            },
            {
                title: gettext('Settings'),
                hidden: me.isCreate,
                xtype: 'grid',
                itemId: 'summary',
                border: true,
                height: 200,
                store: {
                    model: 'KeyValue',
                    sorters: [
                        {
                            property: 'key',
                            direction: 'ASC',
                        },
                    ],
                },
                columns: [
                    {
                        header: gettext('Key'),
                        width: 150,
                        dataIndex: 'key',
                    },
                    {
                        header: gettext('Value'),
                        flex: 1,
                        dataIndex: 'value',
                    },
                ],
            },
        ];

        me.url = `/nodes/${me.nodename}/${me.type}/${me.vmid}/snapshot`;

        let subject;
        if (me.isCreate) {
            let guestTypeStr = me.type === 'qemu' ? 'VM' : 'CT';
            let formattedGuestIdentifier = PVE.Utils.getFormattedGuestIdentifier(
                me.vmid,
                me.vmname,
            );
            subject = `${guestTypeStr} ${formattedGuestIdentifier} ${gettext('Snapshot')}}`;
            me.method = 'POST';
            me.showTaskViewer = true;
        } else {
            subject = `${gettext('Snapshot')} ${me.snapname}`;
            me.url += `/${me.snapname}/config`;
        }

        Ext.apply(me, {
            subject: subject,
            width: me.isCreate ? 450 : 620,
            height: me.isCreate ? undefined : 420,
        });

        me.callParent();

        if (!me.snapname) {
            return;
        }

        me.load({
            success: function (response) {
                let kvarray = [];
                Ext.Object.each(response.result.data, function (key, value) {
                    if (key === 'description' || key === 'snaptime') {
                        return;
                    }
                    kvarray.push({ key: key, value: value });
                });

                let summarystore = me.down('#summary').getStore();
                summarystore.suspendEvents();
                summarystore.add(kvarray);
                summarystore.sort();
                summarystore.resumeEvents();
                summarystore.fireEvent('refresh', summarystore);

                me.setValues(response.result.data);
            },
        });
    },
});
Ext.define('PVE.panel.StartupInputPanel', {
    extend: 'Proxmox.panel.InputPanel',
    onlineHelp: 'qm_startup_and_shutdown',

    onGetValues: function (values) {
        var _me = this;

        var res = PVE.Parser.printStartup(values);

        if (res === undefined || res === '') {
            return { delete: 'startup' };
        }

        return { startup: res };
    },

    setStartup: function (value) {
        var me = this;

        var startup = PVE.Parser.parseStartup(value);
        if (startup) {
            me.setValues(startup);
        }
    },

    initComponent: function () {
        var me = this;

        me.items = [
            {
                xtype: 'textfield',
                name: 'order',
                defaultValue: '',
                emptyText: 'any',
                fieldLabel: gettext('Start/Shutdown order'),
            },
            {
                xtype: 'textfield',
                name: 'up',
                defaultValue: '',
                emptyText: 'default',
                fieldLabel: gettext('Startup delay'),
            },
            {
                xtype: 'textfield',
                name: 'down',
                defaultValue: '',
                emptyText: 'default',
                fieldLabel: gettext('Shutdown timeout'),
            },
        ];

        me.callParent();
    },
});

Ext.define('PVE.window.StartupEdit', {
    extend: 'Proxmox.window.Edit',
    alias: 'widget.pveWindowStartupEdit',
    onlineHelp: undefined,

    initComponent: function () {
        let me = this;

        let ipanelConfig = me.onlineHelp ? { onlineHelp: me.onlineHelp } : {};
        let ipanel = Ext.create('PVE.panel.StartupInputPanel', ipanelConfig);

        Ext.applyIf(me, {
            subject: gettext('Start/Shutdown order'),
            fieldDefaults: {
                labelWidth: 120,
            },
            items: [ipanel],
        });

        me.callParent();

        me.load({
            success: function (response, options) {
                me.vmconfig = response.result.data;
                ipanel.setStartup(me.vmconfig.startup);
            },
        });
    },
});
Ext.define('PVE.window.DownloadUrlToStorage', {
    extend: 'Proxmox.window.Edit',
    alias: 'widget.pveStorageDownloadUrl',
    mixins: ['Proxmox.Mixin.CBind'],

    isCreate: true,

    method: 'POST',

    showTaskViewer: true,

    title: gettext('Download from URL'),
    submitText: gettext('Download'),

    cbindData: function (initialConfig) {
        var me = this;
        return {
            nodename: me.nodename,
            storage: me.storage,
            content: me.content,
        };
    },

    cbind: {
        url: '/nodes/{nodename}/storage/{storage}/download-url',
    },

    viewModel: {
        data: {
            size: '-',
            mimetype: '-',
            enableQuery: true,
        },
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        urlChange: function (field) {
            this.resetMetaInfo();
            this.setQueryEnabled();
        },
        setQueryEnabled: function () {
            this.getViewModel().set('enableQuery', true);
        },
        resetMetaInfo: function () {
            let vm = this.getViewModel();
            vm.set('size', '-');
            vm.set('mimetype', '-');
        },

        urlCheck: function (field) {
            let me = this;
            let view = me.getView();

            const queryParam = view.getValues();

            me.getViewModel().set('enableQuery', false);
            me.resetMetaInfo();
            let urlField = view.down('[name=url]');

            Proxmox.Utils.API2Request({
                url: `/nodes/${view.nodename}/query-url-metadata`,
                method: 'GET',
                params: {
                    url: queryParam.url,
                    'verify-certificates': queryParam['verify-certificates'],
                },
                waitMsgTarget: view,
                failure: (res) => {
                    urlField.setValidation(res.result.message);
                    urlField.validate();
                    Ext.MessageBox.alert(gettext('Error'), res.htmlStatus);
                    // re-enable so one can directly requery, e.g., if it was just a network hiccup
                    me.setQueryEnabled();
                },
                success: function (res, opt) {
                    urlField.setValidation();
                    urlField.validate();

                    let data = res.result.data;

                    let filename = data.filename || '';
                    let compression = '__default__';
                    if (view.content === 'iso') {
                        const matches = filename.match(/^(.+)\.(gz|lzo|zst|bz2)$/i);
                        if (matches) {
                            filename = matches[1];
                            compression = matches[2].toLowerCase();
                        }
                    } else if (view.content === 'import') {
                        if (filename.endsWith('.img')) {
                            filename += '.raw';
                        }
                    }

                    view.setValues({
                        filename,
                        compression,
                        size:
                            (data.size && Proxmox.Utils.format_size(data.size)) ||
                            gettext('Unknown'),
                        mimetype: data.mimetype || gettext('Unknown'),
                    });
                },
            });
        },

        hashChange: function (field) {
            let checksum = Ext.getCmp('downloadUrlChecksum');
            if (field.getValue() === '__default__') {
                checksum.setDisabled(true);
                checksum.setValue('');
                checksum.allowBlank = true;
            } else {
                checksum.setDisabled(false);
                checksum.allowBlank = false;
            }
        },
    },

    items: [
        {
            xtype: 'inputpanel',
            border: false,
            onGetValues: function (values) {
                if (typeof values.checksum === 'string') {
                    values.checksum = values.checksum.trim();
                }
                return values;
            },
            columnT: [
                {
                    xtype: 'fieldcontainer',
                    layout: 'hbox',
                    fieldLabel: gettext('URL'),
                    items: [
                        {
                            xtype: 'textfield',
                            name: 'url',
                            emptyText: gettext('Enter URL to download'),
                            allowBlank: false,
                            flex: 1,
                            listeners: {
                                change: 'urlChange',
                            },
                        },
                        {
                            xtype: 'button',
                            name: 'check',
                            text: gettext('Query URL'),
                            margin: '0 0 0 5',
                            bind: {
                                disabled: '{!enableQuery}',
                            },
                            listeners: {
                                click: 'urlCheck',
                            },
                        },
                    ],
                },
                {
                    xtype: 'textfield',
                    name: 'filename',
                    allowBlank: false,
                    fieldLabel: gettext('File name'),
                    emptyText: gettext('Please (re-)query URL to get meta information'),
                },
            ],
            column1: [
                {
                    xtype: 'displayfield',
                    name: 'size',
                    fieldLabel: gettext('File size'),
                    bind: {
                        value: '{size}',
                    },
                },
            ],
            column2: [
                {
                    xtype: 'displayfield',
                    name: 'mimetype',
                    fieldLabel: gettext('MIME type'),
                    bind: {
                        value: '{mimetype}',
                    },
                },
            ],
            advancedColumn1: [
                {
                    xtype: 'pveHashAlgorithmSelector',
                    name: 'checksum-algorithm',
                    fieldLabel: gettext('Hash algorithm'),
                    allowBlank: true,
                    hasNoneOption: true,
                    value: '__default__',
                    listeners: {
                        change: 'hashChange',
                    },
                },
                {
                    xtype: 'textfield',
                    name: 'checksum',
                    fieldLabel: gettext('Checksum'),
                    allowBlank: true,
                    disabled: true,
                    emptyText: gettext('none'),
                    id: 'downloadUrlChecksum',
                },
            ],
            advancedColumn2: [
                {
                    xtype: 'proxmoxcheckbox',
                    name: 'verify-certificates',
                    fieldLabel: gettext('Verify certificates'),
                    uncheckedValue: 0,
                    checked: true,
                    listeners: {
                        change: 'setQueryEnabled',
                    },
                },
                {
                    xtype: 'proxmoxKVComboBox',
                    name: 'compression',
                    fieldLabel: gettext('Decompression algorithm'),
                    allowBlank: true,
                    hasNoneOption: true,
                    deleteEmpty: false,
                    value: '__default__',
                    comboItems: [
                        ['__default__', Proxmox.Utils.NoneText],
                        ['lzo', 'LZO'],
                        ['gz', 'GZIP'],
                        ['zst', 'ZSTD'],
                        ['bz2', 'BZIP2'],
                    ],
                    cbind: {
                        hidden: (get) => get('content') !== 'iso',
                    },
                },
            ],
        },
        {
            xtype: 'hiddenfield',
            name: 'content',
            cbind: {
                value: '{content}',
            },
        },
    ],

    initComponent: function () {
        var me = this;

        if (!me.nodename) {
            throw 'no node name specified';
        }
        if (!me.storage) {
            throw 'no storage ID specified';
        }
        me.callParent();
    },
});
Ext.define('PVE.window.UploadToStorage', {
    extend: 'Ext.window.Window',
    alias: 'widget.pveStorageUpload',
    mixins: ['Proxmox.Mixin.CBind'],

    resizable: false,
    modal: true,

    title: gettext('Upload'),

    acceptedExtensions: {
        import: ['.ova', '.qcow2', '.raw', '.vmdk'],
        iso: ['.img', '.iso'],
        vztmpl: ['.tar.gz', '.tar.xz', '.tar.zst'],
    },

    // accepted for file selection, will be renamed to real extension
    extensionAliases: {
        import: {
            '.img': '.raw',
        },
    },

    cbindData: function (initialConfig) {
        const me = this;
        const ext = me.acceptedExtensions[me.content] || [];

        me.url = `/nodes/${me.nodename}/storage/${me.storage}/upload`;

        let fileSelectorExt = ext.concat(Object.keys(me.extensionAliases[me.content] ?? {}));

        return {
            extensions: fileSelectorExt.join(', '),
            filenameRegex: new RegExp('^.*(?:' + ext.join('|').replaceAll('.', '\\.') + ')$', 'i'),
        };
    },

    viewModel: {
        data: {
            size: '-',
            mimetype: '-',
            filename: '',
        },
    },

    controller: {
        submit: function (button) {
            const view = this.getView();
            const form = this.lookup('formPanel').getForm();
            const abortBtn = this.lookup('abortBtn');
            const pbar = this.lookup('progressBar');

            const updateProgress = function (per, bytes) {
                let text = (per * 100).toFixed(2) + '%';
                if (bytes) {
                    text += ' (' + Proxmox.Utils.format_size(bytes) + ')';
                }
                pbar.updateProgress(per, text);
            };

            const fd = new FormData();

            button.setDisabled(true);
            abortBtn.setDisabled(false);

            fd.append('content', view.content);

            const fileField = form.findField('file');
            const file = fileField.fileInputEl.dom.files[0];
            fileField.setDisabled(true);

            const filenameField = form.findField('filename');
            const filename = filenameField.getValue();
            filenameField.setDisabled(true);

            const algorithmField = form.findField('checksum-algorithm');
            algorithmField.setDisabled(true);
            if (algorithmField.getValue() !== '__default__') {
                fd.append('checksum-algorithm', algorithmField.getValue());

                const checksumField = form.findField('checksum');
                fd.append('checksum', checksumField.getValue()?.trim());
                checksumField.setDisabled(true);
            }

            fd.append('filename', file, filename);

            pbar.setVisible(true);
            updateProgress(0);

            const xhr = new XMLHttpRequest();
            view.xhr = xhr;

            xhr.addEventListener(
                'load',
                function (e) {
                    if (xhr.status === 200) {
                        view.hide();

                        const result = JSON.parse(xhr.response);
                        const upid = result.data;
                        Ext.create('Proxmox.window.TaskViewer', {
                            autoShow: true,
                            upid: upid,
                            taskDone: view.taskDone,
                            listeners: {
                                destroy: function () {
                                    view.close();
                                },
                            },
                        });

                        return;
                    }
                    const err = Ext.htmlEncode(xhr.statusText);
                    let msg = `${gettext('Error')} ${xhr.status.toString()}: ${err}`;
                    if (xhr.responseText !== '') {
                        const result = Ext.decode(xhr.responseText);
                        result.message = msg;
                        msg = Proxmox.Utils.extractRequestError(result, true);
                    }
                    Ext.Msg.alert(gettext('Error'), msg, (btn) => view.close());
                },
                false,
            );

            xhr.addEventListener('error', function (e) {
                const err = e.target.status.toString();
                const msg = `Error '${err}' occurred while receiving the document.`;
                Ext.Msg.alert(gettext('Error'), msg, (btn) => view.close());
            });

            xhr.upload.addEventListener(
                'progress',
                function (evt) {
                    if (evt.lengthComputable) {
                        const percentComplete = evt.loaded / evt.total;
                        updateProgress(percentComplete, evt.loaded);
                    }
                },
                false,
            );

            xhr.open('POST', `/api2/json${view.url}`, true);
            xhr.send(fd);
        },

        validitychange: function (f, valid) {
            const submitBtn = this.lookup('submitBtn');
            submitBtn.setDisabled(!valid);
        },

        fileChange: function (input) {
            const me = this;
            const vm = me.getViewModel();
            const view = me.getView();
            let name = input.value.replace(/^.*(\/|\\)/, '');
            for (const [alias, real] of Object.entries(view.extensionAliases[view.content] ?? {})) {
                if (name.endsWith(alias)) {
                    name += real;
                }
            }
            const fileInput = input.fileInputEl.dom;
            vm.set('filename', name);
            vm.set(
                'size',
                (fileInput.files[0] && Proxmox.Utils.format_size(fileInput.files[0].size)) || '-',
            );
            vm.set('mimetype', (fileInput.files[0] && fileInput.files[0].type) || '-');
        },

        hashChange: function (field, value) {
            const checksum = this.lookup('downloadUrlChecksum');
            if (value === '__default__') {
                checksum.setDisabled(true);
                checksum.setValue('');
            } else {
                checksum.setDisabled(false);
            }
        },
    },

    items: [
        {
            xtype: 'form',
            reference: 'formPanel',
            method: 'POST',
            waitMsgTarget: true,
            bodyPadding: 10,
            border: false,
            width: 400,
            fieldDefaults: {
                labelWidth: 100,
                anchor: '100%',
            },
            items: [
                {
                    xtype: 'filefield',
                    name: 'file',
                    buttonText: gettext('Select File'),
                    allowBlank: false,
                    fieldLabel: gettext('File'),
                    cbind: {
                        accept: '{extensions}',
                    },
                    listeners: {
                        change: 'fileChange',
                    },
                },
                {
                    xtype: 'textfield',
                    name: 'filename',
                    allowBlank: false,
                    fieldLabel: gettext('File name'),
                    bind: {
                        value: '{filename}',
                    },
                    cbind: {
                        regex: '{filenameRegex}',
                    },
                    regexText: gettext('Wrong file extension'),
                },
                {
                    xtype: 'displayfield',
                    name: 'size',
                    fieldLabel: gettext('File size'),
                    bind: {
                        value: '{size}',
                    },
                },
                {
                    xtype: 'displayfield',
                    name: 'mimetype',
                    fieldLabel: gettext('MIME type'),
                    bind: {
                        value: '{mimetype}',
                    },
                },
                {
                    xtype: 'pveHashAlgorithmSelector',
                    name: 'checksum-algorithm',
                    fieldLabel: gettext('Hash algorithm'),
                    allowBlank: true,
                    hasNoneOption: true,
                    value: '__default__',
                    listeners: {
                        change: 'hashChange',
                    },
                },
                {
                    xtype: 'textfield',
                    name: 'checksum',
                    fieldLabel: gettext('Checksum'),
                    allowBlank: false,
                    disabled: true,
                    emptyText: gettext('none'),
                    reference: 'downloadUrlChecksum',
                },
                {
                    xtype: 'displayfield',
                    userCls: 'pmx-hint',
                    value: gettext(
                        "Uploads are stored temporarily in '/var/tmp/', make sure there is enough free space.",
                    ),
                },
                {
                    xtype: 'progressbar',
                    text: 'Ready',
                    hidden: true,
                    reference: 'progressBar',
                },
                {
                    xtype: 'hiddenfield',
                    name: 'content',
                    cbind: {
                        value: '{content}',
                    },
                },
            ],
            listeners: {
                validitychange: 'validitychange',
            },
        },
    ],

    buttons: [
        {
            xtype: 'button',
            text: gettext('Abort'),
            reference: 'abortBtn',
            disabled: true,
            handler: function () {
                const me = this;
                me.up('pveStorageUpload').close();
            },
        },
        {
            text: gettext('Upload'),
            reference: 'submitBtn',
            disabled: true,
            handler: 'submit',
        },
    ],

    listeners: {
        close: function () {
            const me = this;
            if (me.xhr) {
                me.xhr.abort();
                delete me.xhr;
            }
        },
    },

    initComponent: function () {
        const me = this;

        if (!me.nodename) {
            throw 'no node name specified';
        }
        if (!me.storage) {
            throw 'no storage ID specified';
        }
        if (!me.acceptedExtensions[me.content]) {
            throw 'content type not supported';
        }

        me.callParent();
    },
});
Ext.define('PVE.window.ScheduleSimulator', {
    extend: 'Ext.window.Window',

    title: gettext('Job Schedule Simulator'),

    viewModel: {
        data: {
            simulatedOnce: false,
        },
        formulas: {
            gridEmptyText: (get) =>
                get('simulatedOnce') ? Proxmox.Utils.NoneText : gettext('No simulation done'),
        },
    },

    controller: {
        xclass: 'Ext.app.ViewController',
        close: function () {
            this.getView().close();
        },
        simulate: function () {
            let me = this;
            let schedule = me.lookup('schedule').getValue();
            if (!schedule) {
                return;
            }
            let iterations = me.lookup('iterations').getValue() || 10;
            Proxmox.Utils.API2Request({
                url: '/cluster/jobs/schedule-analyze',
                method: 'GET',
                params: {
                    schedule,
                    iterations,
                },
                failure: (response) => {
                    me.getViewModel().set('simulatedOnce', true);
                    me.lookup('grid').getStore().setData([]);
                    Ext.Msg.alert(gettext('Error'), response.htmlStatus);
                },
                success: function (response) {
                    let schedules = response.result.data;
                    me.lookup('grid').getStore().setData(schedules);
                    me.getViewModel().set('simulatedOnce', true);
                },
            });
        },

        scheduleChanged: function (field, value) {
            this.lookup('simulateBtn').setDisabled(!value);
        },

        renderDate: function (value) {
            let date = new Date(value * 1000);
            return date.toLocaleDateString();
        },

        renderTime: function (value) {
            let date = new Date(value * 1000);
            return date.toLocaleTimeString();
        },

        init: function (view) {
            let me = this;
            if (view.schedule) {
                me.lookup('schedule').setValue(view.schedule);
            }
        },
    },

    bodyPadding: 10,
    modal: true,
    resizable: false,
    width: 600,

    layout: 'fit',

    items: [
        {
            xtype: 'inputpanel',
            column1: [
                {
                    xtype: 'pveCalendarEvent',
                    reference: 'schedule',
                    fieldLabel: gettext('Schedule'),
                    listeners: {
                        change: 'scheduleChanged',
                    },
                },
                {
                    xtype: 'proxmoxintegerfield',
                    reference: 'iterations',
                    fieldLabel: gettext('Iterations'),
                    minValue: 1,
                    maxValue: 100,
                    value: 10,
                },
                {
                    xtype: 'container',
                    layout: 'hbox',
                    items: [
                        {
                            xtype: 'box',
                            flex: 1,
                        },
                        {
                            xtype: 'button',
                            reference: 'simulateBtn',
                            text: gettext('Simulate'),
                            handler: 'simulate',
                            disabled: true,
                        },
                    ],
                },
            ],

            column2: [
                {
                    xtype: 'grid',
                    reference: 'grid',
                    bind: {
                        emptyText: '{gridEmptyText}',
                    },
                    scrollable: true,
                    height: 300,
                    columns: [
                        {
                            text: gettext('Date'),
                            renderer: 'renderDate',
                            dataIndex: 'timestamp',
                            flex: 1,
                        },
                        {
                            text: gettext('Time'),
                            renderer: 'renderTime',
                            dataIndex: 'timestamp',
                            align: 'right',
                            flex: 1,
                        },
                    ],
                    store: {
                        fields: ['timestamp'],
                        data: [],
                        sorter: 'timestamp',
                    },
                },
            ],
        },
    ],

    buttons: [
        {
            text: gettext('Done'),
            handler: 'close',
        },
    ],
});
Ext.define('PVE.window.Wizard', {
    extend: 'Ext.window.Window',

    activeTitle: '', // used for automated testing

    width: 720,
    height: 540,

    modal: true,
    border: false,

    draggable: true,
    closable: true,
    resizable: false,

    layout: 'border',

    getValues: function (dirtyOnly) {
        let me = this;

        let values = {};

        me.down('form')
            .getForm()
            .getFields()
            .each((field) => {
                if (!field.up('inputpanel') && (!dirtyOnly || field.isDirty())) {
                    Proxmox.Utils.assemble_field_data(values, field.getSubmitData());
                }
            });

        me.query('inputpanel').forEach((panel) => {
            Proxmox.Utils.assemble_field_data(values, panel.getValues(dirtyOnly));
        });

        return values;
    },

    initComponent: function () {
        var me = this;

        var tabs = me.items || [];
        delete me.items;

        /*
         * Items may have the following functions:
         * validator(): per tab custom validation
         * onSubmit(): submit handler
         * onGetValues(): overwrite getValues results
         */

        Ext.Array.each(tabs, function (tab) {
            tab.disabled = true;
        });
        tabs[0].disabled = false;

        let maxidx = 0,
            curidx = 0;

        let check_card = function (card) {
            let fields = card.query('field, fieldcontainer');
            if (card.isXType('fieldcontainer')) {
                fields.unshift(card);
            }
            let valid = true;
            for (const field of fields) {
                // Note: not all fielcontainer have isValid()
                if (Ext.isFunction(field.isValid) && !field.isValid()) {
                    valid = false;
                }
            }
            if (Ext.isFunction(card.validator)) {
                return card.validator();
            }
            return valid;
        };

        let disableTab = function (card) {
            let tp = me.down('#wizcontent');
            for (let idx = tp.items.indexOf(card); idx < tp.items.getCount(); idx++) {
                let tab = tp.items.getAt(idx);
                if (tab) {
                    tab.disable();
                }
            }
        };

        let tabchange = function (tp, newcard, oldcard) {
            if (newcard.onSubmit) {
                me.down('#next').setVisible(false);
                me.down('#submit').setVisible(true);
            } else {
                me.down('#next').setVisible(true);
                me.down('#submit').setVisible(false);
            }
            let valid = check_card(newcard);
            me.down('#next').setDisabled(!valid);
            me.down('#submit').setDisabled(!valid);
            me.down('#back').setDisabled(tp.items.indexOf(newcard) === 0);

            let idx = tp.items.indexOf(newcard);
            if (idx > maxidx) {
                maxidx = idx;
            }
            curidx = idx;

            let ntab = tp.items.getAt(idx + 1);
            if (valid && ntab && !newcard.onSubmit) {
                ntab.enable();
            }
        };

        if (me.subject && !me.title) {
            me.title = Proxmox.Utils.dialog_title(me.subject, true, false);
        }

        let sp = Ext.state.Manager.getProvider();
        let advancedOn = sp.get('proxmox-advanced-cb');

        Ext.apply(me, {
            items: [
                {
                    xtype: 'form',
                    region: 'center',
                    layout: 'fit',
                    border: false,
                    margins: '5 5 0 5',
                    fieldDefaults: {
                        labelWidth: 100,
                        anchor: '100%',
                    },
                    items: [
                        {
                            itemId: 'wizcontent',
                            xtype: 'tabpanel',
                            activeItem: 0,
                            bodyPadding: 0,
                            listeners: {
                                afterrender: function (tp) {
                                    tabchange(tp, this.getActiveTab());
                                },
                                tabchange: function (tp, newcard, oldcard) {
                                    tabchange(tp, newcard, oldcard);
                                },
                            },
                            defaults: {
                                padding: 10,
                            },
                            items: tabs,
                        },
                    ],
                },
            ],
            fbar: [
                {
                    xtype: 'proxmoxHelpButton',
                    itemId: 'help',
                },
                '->',
                {
                    xtype: 'proxmoxcheckbox',
                    boxLabelAlign: 'before',
                    boxLabel: gettext('Advanced'),
                    value: advancedOn,
                    listeners: {
                        change: function (_, value) {
                            let tp = me.down('#wizcontent');
                            tp.query('inputpanel').forEach(function (ip) {
                                ip.setAdvancedVisible(value);
                            });
                            sp.set('proxmox-advanced-cb', value);
                        },
                    },
                },
                {
                    text: gettext('Back'),
                    disabled: true,
                    itemId: 'back',
                    minWidth: 60,
                    handler: function () {
                        let tp = me.down('#wizcontent');
                        let prev = tp.items.indexOf(tp.getActiveTab()) - 1;
                        if (prev < 0) {
                            return;
                        }
                        let ntab = tp.items.getAt(prev);
                        if (ntab) {
                            tp.setActiveTab(ntab);
                        }
                    },
                },
                {
                    text: gettext('Next'),
                    disabled: true,
                    itemId: 'next',
                    minWidth: 60,
                    handler: function () {
                        let tp = me.down('#wizcontent');
                        let activeTab = tp.getActiveTab();
                        if (!check_card(activeTab)) {
                            return;
                        }
                        let next = tp.items.indexOf(activeTab) + 1;
                        let ntab = tp.items.getAt(next);
                        if (ntab) {
                            ntab.enable();
                            tp.setActiveTab(ntab);
                        }
                    },
                },
                {
                    text: gettext('Finish'),
                    minWidth: 60,
                    hidden: true,
                    itemId: 'submit',
                    handler: function () {
                        let tp = me.down('#wizcontent');
                        tp.getActiveTab().onSubmit();
                    },
                },
            ],
        });
        me.callParent();

        Ext.Array.each(me.query('inputpanel'), function (panel) {
            panel.setAdvancedVisible(advancedOn);
        });

        Ext.Array.each(me.query('field'), function (field) {
            let validcheck = function () {
                let tp = me.down('#wizcontent');

                // check validity for current to last enabled tab, as local change may affect validity of a later one
                for (let i = curidx; i <= maxidx && i < tp.items.getCount(); i++) {
                    let tab = tp.items.getAt(i);
                    let valid = check_card(tab);

                    // only set the buttons on the current panel
                    if (i === curidx) {
                        me.down('#next').setDisabled(!valid);
                        me.down('#submit').setDisabled(!valid);
                    }
                    // if a panel is invalid, then disable all following, else enable the next tab
                    let nextTab = tp.items.getAt(i + 1);
                    if (!valid) {
                        disableTab(nextTab);
                        return;
                    } else if (nextTab && !tab.onSubmit) {
                        nextTab.enable();
                    }
                }
            };
            field.on('change', validcheck);
            field.on('validitychange', validcheck);
        });
    },
});
Ext.define('PVE.window.GuestDiskReassign', {
    extend: 'Proxmox.window.Edit',
    mixins: ['Proxmox.Mixin.CBind'],

    resizable: false,
    modal: true,
    width: 350,
    border: false,
    layout: 'fit',
    showReset: false,
    showProgress: true,
    method: 'POST',

    viewModel: {
        data: {
            mpType: '',
        },
        formulas: {
            mpMaxCount: (get) =>
                get('mpType') === 'mp'
                    ? PVE.Utils.lxc_mp_counts.mps - 1
                    : PVE.Utils.lxc_mp_counts.unused - 1,
        },
    },

    cbindData: function () {
        let me = this;
        return {
            vmid: me.vmid,
            disk: me.disk,
            isQemu: me.type === 'qemu',
            nodename: me.nodename,
            url: () => {
                let endpoint = me.type === 'qemu' ? 'move_disk' : 'move_volume';
                return `/nodes/${me.nodename}/${me.type}/${me.vmid}/${endpoint}`;
            },
        };
    },

    cbind: {
        title: (get) => (get('isQemu') ? gettext('Reassign Disk') : gettext('Reassign Volume')),
        submitText: (get) => get('title'),
        qemu: '{isQemu}',
        url: '{url}',
    },

    getValues: function () {
        let me = this;
        let values = me.formPanel.getForm().getValues();

        let params = {
            vmid: me.vmid,
            'target-vmid': values.targetVmid,
        };

        params[me.qemu ? 'disk' : 'volume'] = me.disk;

        if (me.qemu) {
            params['target-disk'] = `${values.controller}${values.deviceid}`;
        } else {
            params['target-volume'] = `${values.mpType}${values.mpId}`;
        }
        return params;
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        initViewModel: function (model) {
            let view = this.getView();
            let mpTypeValue = view.disk.match(/^unused\d+/) ? 'unused' : 'mp';
            model.set('mpType', mpTypeValue);
        },

        onMpTypeChange: function (value) {
            let view = this.getView();
            view.getViewModel().set('mpType', value.getValue());
            view.lookup('mpIdSelector').validate();
        },

        onTargetVMChange: function (f, vmid) {
            let me = this;
            let view = me.getView();
            let diskSelector = view.lookup('diskSelector');
            if (!vmid) {
                diskSelector.setVMConfig(null);
                me.VMConfig = null;
                return;
            }

            let url = `/nodes/${view.nodename}/${view.type}/${vmid}/config`;
            Proxmox.Utils.API2Request({
                url: url,
                method: 'GET',
                failure: (response) => Ext.Msg.alert(gettext('Error'), response.htmlStatus),
                success: function ({ result }, options) {
                    if (view.qemu) {
                        diskSelector.setVMConfig(result.data);
                        diskSelector.setDisabled(false);
                    } else {
                        let mpIdSelector = view.lookup('mpIdSelector');
                        let mpType = view.lookup('mpType');

                        view.VMConfig = result.data;

                        mpIdSelector.setValue(
                            PVE.Utils.nextFreeLxcMP(
                                view.getViewModel().get('mpType'),
                                view.VMConfig,
                            ).id,
                        );

                        mpType.setDisabled(false);
                        mpIdSelector.setDisabled(false);
                        mpIdSelector.validate();
                    }
                },
            });
        },
    },

    defaultFocus: 'sourceDisk',
    items: [
        {
            xtype: 'displayfield',
            name: 'sourceDisk',
            fieldLabel: gettext('Source'),
            cbind: {
                name: (get) => (get('isQemu') ? 'disk' : 'volume'),
                value: '{disk}',
            },
            allowBlank: false,
        },
        {
            xtype: 'vmComboSelector',
            name: 'targetVmid',
            allowBlank: false,
            fieldLabel: gettext('Target Guest'),
            store: {
                model: 'PVEResources',
                autoLoad: true,
                sorters: 'vmid',
                cbind: {}, // for nested cbinds
                filters: [
                    {
                        property: 'type',
                        cbind: { value: '{type}' },
                    },
                    {
                        property: 'node',
                        cbind: { value: '{nodename}' },
                    },
                    // FIXME: remove, artificial restriction that doesn't gains us anything..
                    {
                        property: 'vmid',
                        operator: '!=',
                        cbind: { value: '{vmid}' },
                    },
                    {
                        property: 'template',
                        value: 0,
                    },
                ],
            },
            listeners: { change: 'onTargetVMChange' },
        },
        {
            xtype: 'pveControllerSelector',
            reference: 'diskSelector',
            withUnused: true,
            disabled: true,
            cbind: {
                hidden: '{!isQemu}',
            },
        },
        {
            xtype: 'container',
            layout: 'hbox',
            cbind: {
                hidden: '{isQemu}',
                disabled: '{isQemu}',
            },
            items: [
                {
                    xtype: 'pmxDisplayEditField',
                    cbind: {
                        editable: (get) => !get('disk').match(/^unused\d+/),
                        value: (get) => (get('disk').match(/^unused\d+/) ? 'unused' : 'mp'),
                    },
                    disabled: true,
                    name: 'mpType',
                    reference: 'mpType',
                    fieldLabel: gettext('Add as'),
                    submitValue: true,
                    flex: 4,
                    editConfig: {
                        xtype: 'proxmoxKVComboBox',
                        name: 'mpTypeCombo',
                        deleteEmpty: false,
                        cbind: {
                            hidden: '{isQemu}',
                        },
                        comboItems: [
                            ['mp', gettext('Mount Point')],
                            ['unused', gettext('Unused')],
                        ],
                        listeners: { change: 'onMpTypeChange' },
                    },
                },
                {
                    xtype: 'proxmoxintegerfield',
                    name: 'mpId',
                    reference: 'mpIdSelector',
                    minValue: 0,
                    flex: 1,
                    allowBlank: false,
                    validateOnChange: true,
                    disabled: true,
                    bind: {
                        maxValue: '{mpMaxCount}',
                    },
                    validator: function (value) {
                        let view = this.up('window');
                        let type = view.getViewModel().get('mpType');
                        if (Ext.isDefined(view.VMConfig[`${type}${value}`])) {
                            return 'Mount point is already in use.';
                        }
                        return true;
                    },
                },
            ],
        },
    ],

    initComponent: function () {
        let me = this;

        if (!me.nodename) {
            throw 'no node name specified';
        }

        if (!me.vmid) {
            throw 'no VM ID specified';
        }

        if (!me.type) {
            throw 'no type specified';
        }

        me.callParent();
    },
});
Ext.define('PVE.GuestStop', {
    extend: 'Ext.window.MessageBox',

    closeAction: 'destroy',

    initComponent: function () {
        let me = this;

        if (!me.nodename) {
            throw 'no node name specified';
        }
        if (!me.vm) {
            throw 'no vm specified';
        }

        let isQemuVM = me.vm.type === 'qemu';
        let overruleTaskType = isQemuVM ? 'qmshutdown' : 'vzshutdown';

        me.taskType = isQemuVM ? 'qmstop' : 'vzstop';
        me.url = `/nodes/${me.nodename}/${me.vm.type}/${me.vm.vmid}/status/stop`;

        let caps = Ext.state.Manager.get('GuiCap');
        let hasSysModify = !!caps.nodes['Sys.Modify'];

        // offer to overrule if there is at least one matching shutdown task and the guest is not
        // HA-enabled. Also allow users to abort tasks started by one of their API tokens.
        let activeShutdownTask =
            Ext.getStore('pve-cluster-tasks')?.findBy(
                (task) =>
                    (hasSysModify || task.data.user === Proxmox.UserName) &&
                    task.data.id === me.vm.vmid.toString() &&
                    task.data.status === undefined &&
                    task.data.type === overruleTaskType,
            ) !== -1;
        let haEnabled = me.vm.hastate && me.vm.hastate !== 'unmanaged';

        me.callParent();

        // message box has its actual content in a sub-container, the top one is just for layouting
        me.promptContainer.add({
            xtype: 'proxmoxcheckbox',
            name: 'overrule-shutdown',
            checked: !haEnabled && activeShutdownTask,
            boxLabel: gettext('Overrule active shutdown tasks'),
            hidden: !(hasSysModify || activeShutdownTask),
            disabled: !(hasSysModify || activeShutdownTask) || haEnabled,
            padding: '3 0 0 0',
        });
    },

    handler: function (btn) {
        let me = this;
        if (btn === 'yes') {
            let overruleField = me.promptContainer.down('proxmoxcheckbox[name=overrule-shutdown]');
            let params =
                !overruleField.isDisabled() && overruleField.getSubmitValue()
                    ? { 'overrule-shutdown': 1 }
                    : undefined;
            Proxmox.Utils.API2Request({
                url: me.url,
                waitMsgTarget: me,
                method: 'POST',
                params: params,
                failure: (response) => Ext.Msg.alert('Error', response.htmlStatus),
            });
        }
    },

    show: function () {
        let me = this;
        let cfg = {
            title: gettext('Confirm'),
            icon: Ext.Msg.WARNING,
            msg: PVE.Utils.formatGuestTaskConfirmation(me.taskType, me.vm.vmid, me.vm.name),
            buttons: Ext.Msg.YESNO,
            callback: (btn) => me.handler(btn),
        };
        me.callParent([cfg]);
    },
});
Ext.define('PVE.window.TreeSettingsEdit', {
    extend: 'Proxmox.window.Edit',
    alias: 'widget.pveTreeSettingsEdit',

    title: gettext('Tree Settings'),
    isCreate: false,

    url: '#', // ignored as submit() gets overridden here, but the parent class requires it

    width: 450,
    fieldDefaults: {
        labelWidth: 150,
    },

    items: [
        {
            xtype: 'inputpanel',
            items: [
                {
                    xtype: 'proxmoxKVComboBox',
                    name: 'sort-field',
                    fieldLabel: gettext('Sort Key'),
                    comboItems: [
                        ['__default__', `${Proxmox.Utils.defaultText} (VMID)`],
                        ['vmid', 'VMID'],
                        ['name', gettext('Name')],
                    ],
                    defaultValue: '__default__',
                    value: '__default__',
                    deleteEmpty: false,
                },
                {
                    xtype: 'proxmoxKVComboBox',
                    name: 'group-templates',
                    fieldLabel: gettext('Group Templates'),
                    comboItems: [
                        ['__default__', `${Proxmox.Utils.defaultText} (${gettext('Yes')})`],
                        [1, gettext('Yes')],
                        [0, gettext('No')],
                    ],
                    defaultValue: '__default__',
                    value: '__default__',
                    deleteEmpty: false,
                },
                {
                    xtype: 'proxmoxKVComboBox',
                    name: 'group-guest-types',
                    fieldLabel: gettext('Group Guest Types'),
                    comboItems: [
                        ['__default__', `${Proxmox.Utils.defaultText} (${gettext('Yes')})`],
                        [1, gettext('Yes')],
                        [0, gettext('No')],
                    ],
                    defaultValue: '__default__',
                    value: '__default__',
                    deleteEmpty: false,
                },
                {
                    xtype: 'displayfield',
                    userCls: 'pmx-hint',
                    value: gettext('Settings are saved in the local storage of the browser'),
                },
            ],
        },
    ],

    submit: function () {
        let me = this;

        let localStorage = Ext.state.Manager.getProvider();
        localStorage.set('pve-tree-sorting', me.down('inputpanel').getValues() || null);

        me.apiCallDone();
        me.close();
    },

    initComponent: function () {
        let me = this;

        me.callParent();

        let localStorage = Ext.state.Manager.getProvider();
        me.down('inputpanel').setValues(localStorage.get('pve-tree-sorting'));
    },
});
Ext.define('PVE.window.PCIMapEditWindow', {
    extend: 'Proxmox.window.Edit',

    mixins: ['Proxmox.Mixin.CBind'],

    width: 800,

    subject: gettext('PCI mapping'),

    onlineHelp: 'resource_mapping',

    method: 'POST',

    cbindData: function (initialConfig) {
        let me = this;
        me.isCreate = (!me.name || !me.nodename) && !me.entryOnly;
        me.method = me.name ? 'PUT' : 'POST';
        me.hideMapping = !!me.entryOnly;
        me.globalEdit = !me.name || me.entryOnly;
        me.hideNodeSelector = me.nodename || me.entryOnly;
        me.hideNode = !me.nodename || !me.hideNodeSelector;
        return {
            name: me.name,
            nodename: me.nodename,
        };
    },

    submitUrl: function (_url, data) {
        let me = this;
        let name = me.method === 'PUT' ? me.name : '';
        return `/cluster/mapping/pci/${name}`;
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        onGetValues: function (values) {
            let me = this;
            let view = me.getView();
            if (view.method === 'POST') {
                delete me.digest;
            }

            if (values.iommugroup === -1) {
                delete values.iommugroup;
            }

            let nodename = values.node ?? view.nodename;
            delete values.node;
            if (me.originalMap) {
                let otherMaps = PVE.Parser.filterPropertyStringList(
                    me.originalMap,
                    (e) => e.node !== nodename,
                );
                if (otherMaps.length) {
                    values.map = values.map.concat(otherMaps);
                }
            }

            return values;
        },

        onSetValues: function (values) {
            let me = this;
            let view = me.getView();
            me.originalMap = [...values.map];
            let configuredNodes = [];
            values.map = PVE.Parser.filterPropertyStringList(values.map, (e) => {
                configuredNodes.push(e.node);
                return e.node === view.nodename;
            });

            me.lookup('nodeselector').disallowedNodes = configuredNodes;
            return values;
        },

        checkIommu: function (store, records, success) {
            let me = this;
            if (!success || !records.length) {
                return;
            }
            me.lookup('iommu_warning').setVisible(
                records.every((val) => val.data.iommugroup === -1),
            );

            let value = me.lookup('pciselector').getValue();
            me.checkIsolated(value);
        },

        checkIsolated: function (value) {
            let me = this;

            let store = me.lookup('pciselector').getStore();

            let isIsolated = function (entry) {
                let isolated = true;
                let parsed = PVE.Parser.parsePropertyString(entry);
                parsed.iommugroup = parseInt(parsed.iommugroup, 10);
                if (!parsed.iommugroup) {
                    return isolated;
                }
                store.each(({ data }) => {
                    let isSubDevice = data.id.startsWith(parsed.path);
                    if (
                        data.iommugroup === parsed.iommugroup &&
                        data.id !== parsed.path &&
                        !isSubDevice
                    ) {
                        isolated = false;
                        return false;
                    }
                    return true;
                });
                return isolated;
            };

            let showWarning = false;
            if (Ext.isArray(value)) {
                for (const entry of value) {
                    if (!isIsolated(entry)) {
                        showWarning = true;
                        break;
                    }
                }
            } else {
                showWarning = isIsolated(value);
            }
            me.lookup('group_warning').setVisible(showWarning);
        },

        mdevChange: function (mdevField, value) {
            this.lookup('pciselector').setMdev(value);
        },

        nodeChange: function (field, value) {
            if (!field.isDisabled()) {
                this.lookup('pciselector').setNodename(value);
            }
        },

        pciChange: function (_field, value) {
            let me = this;
            me.lookup('multiple_warning').setVisible(Ext.isArray(value) && value.length > 1);
            me.checkIsolated(value);
        },

        control: {
            'field[name=mdev]': {
                change: 'mdevChange',
            },
            pveNodeSelector: {
                change: 'nodeChange',
            },
            pveMultiPCISelector: {
                change: 'pciChange',
            },
        },
    },

    items: [
        {
            xtype: 'inputpanel',
            onGetValues: function (values) {
                return this.up('window').getController().onGetValues(values);
            },

            onSetValues: function (values) {
                return this.up('window').getController().onSetValues(values);
            },

            columnT: [
                {
                    xtype: 'displayfield',
                    reference: 'iommu_warning',
                    hidden: true,
                    columnWidth: 1,
                    padding: '0 0 10 0',
                    value: gettext(
                        'No IOMMU detected, please activate it. See Documentation for further information.',
                    ),
                    userCls: 'pmx-hint',
                },
                {
                    xtype: 'displayfield',
                    reference: 'multiple_warning',
                    hidden: true,
                    columnWidth: 1,
                    padding: '0 0 10 0',
                    value: gettext(
                        'When multiple devices are selected, the first free one will be chosen on guest start.',
                    ),
                    userCls: 'pmx-hint',
                },
                {
                    xtype: 'displayfield',
                    reference: 'group_warning',
                    hidden: true,
                    columnWidth: 1,
                    padding: '0 0 10 0',
                    itemId: 'iommuwarning',
                    value: gettext(
                        'A selected device is not in a separate IOMMU group, make sure this is intended.',
                    ),
                    userCls: 'pmx-hint',
                },
            ],

            column1: [
                {
                    xtype: 'pmxDisplayEditField',
                    fieldLabel: gettext('Name'),
                    labelWidth: 120,
                    cbind: {
                        editable: '{!name}',
                        value: '{name}',
                        submitValue: '{isCreate}',
                    },
                    name: 'id',
                    allowBlank: false,
                },
                {
                    xtype: 'displayfield',
                    fieldLabel: gettext('Mapping on Node'),
                    labelWidth: 120,
                    name: 'node',
                    cbind: {
                        value: '{nodename}',
                        disabled: '{hideNode}',
                        hidden: '{hideNode}',
                    },
                    allowBlank: false,
                },
                {
                    xtype: 'pveNodeSelector',
                    reference: 'nodeselector',
                    fieldLabel: gettext('Mapping on Node'),
                    labelWidth: 120,
                    name: 'node',
                    cbind: {
                        disabled: '{hideNodeSelector}',
                        hidden: '{hideNodeSelector}',
                    },
                    allowBlank: false,
                },
            ],

            column2: [
                {
                    xtype: 'proxmoxcheckbox',
                    fieldLabel: gettext('Use with Mediated Devices'),
                    labelWidth: 200,
                    reference: 'mdev',
                    name: 'mdev',
                    cbind: {
                        deleteEmpty: '{!isCreate}',
                        disabled: '{!globalEdit}',
                    },
                },
                {
                    xtype: 'proxmoxcheckbox',
                    fieldLabel: gettext('Live Migration Capable'),
                    labelWidth: 200,
                    boxLabel: `<i class="fa fa-exclamation-triangle warning"></i> ${gettext('Experimental')}`,
                    reference: 'live-migration-capable',
                    name: 'live-migration-capable',
                    cbind: {
                        deleteEmpty: '{!isCreate}',
                        disabled: '{!globalEdit}',
                    },
                },
            ],

            columnB: [
                {
                    xtype: 'pveMultiPCISelector',
                    fieldLabel: gettext('Device'),
                    labelWidth: 120,
                    height: 300,
                    reference: 'pciselector',
                    name: 'map',
                    cbind: {
                        nodename: '{nodename}',
                        disabled: '{hideMapping}',
                        hidden: '{hideMapping}',
                    },
                    allowBlank: false,
                    onLoadCallBack: 'checkIommu',
                    margin: '0 0 10 0',
                },
                {
                    xtype: 'proxmoxtextfield',
                    fieldLabel: gettext('Comment'),
                    labelWidth: 120,
                    submitValue: true,
                    name: 'description',
                    cbind: {
                        deleteEmpty: '{!isCreate}',
                        disabled: '{!globalEdit}',
                        hidden: '{!globalEdit}',
                    },
                },
            ],
        },
    ],
});
Ext.define('PVE.window.USBMapEditWindow', {
    extend: 'Proxmox.window.Edit',

    mixins: ['Proxmox.Mixin.CBind'],

    cbindData: function (initialConfig) {
        let me = this;
        me.isCreate = !me.name;
        me.method = me.isCreate ? 'POST' : 'PUT';
        me.hideMapping = !!me.entryOnly;
        me.hideComment = me.name && !me.entryOnly;
        me.hideNodeSelector = me.nodename || me.entryOnly;
        me.hideNode = !me.nodename || !me.hideNodeSelector;
        return {
            name: me.name,
            nodename: me.nodename,
        };
    },

    submitUrl: function (_url, data) {
        let me = this;
        let name = me.isCreate ? '' : me.name;
        return `/cluster/mapping/usb/${name}`;
    },

    title: gettext('Add USB mapping'),

    onlineHelp: 'resource_mapping',

    method: 'POST',

    controller: {
        xclass: 'Ext.app.ViewController',

        onGetValues: function (values) {
            let me = this;
            let view = me.getView();
            values.node ??= view.nodename;

            let type = me.getView().down('radiofield').getGroupValue();
            let name = values.name;
            let description = values.description;
            delete values.description;
            delete values.name;

            if (type === 'path') {
                let usbsel = me.lookup(type);
                let usbDev = usbsel
                    .getStore()
                    .findRecord('usbid', values[type], 0, false, true, true);

                if (!usbDev) {
                    return {};
                }
                values.id = `${usbDev.data.vendid}:${usbDev.data.prodid}`;
            }

            let map = [];
            if (me.originalMap) {
                map = PVE.Parser.filterPropertyStringList(
                    me.originalMap,
                    (e) => e.node !== values.node,
                );
            }
            if (values.id) {
                map.push(PVE.Parser.printPropertyString(values));
            }

            values = { map };
            if (description) {
                values.description = description;
            }

            if (view.isCreate) {
                values.id = name;
            }

            return values;
        },

        onSetValues: function (values) {
            let me = this;
            let view = me.getView();
            me.originalMap = [...values.map];
            let configuredNodes = [];
            PVE.Parser.filterPropertyStringList(values.map, (e) => {
                configuredNodes.push(e.node);
                if (e.node === view.nodename) {
                    values = e;
                }
                return false;
            });

            me.lookup('nodeselector').disallowedNodes = configuredNodes;
            if (values.path) {
                values.usb = 'path';
            }

            return values;
        },

        modeChange: function (field, value) {
            let me = this;
            let type = field.inputValue;
            let usbsel = me.lookup(type);
            usbsel.setDisabled(!value);
        },

        nodeChange: function (field, value) {
            if (!field.isDisabled()) {
                this.lookup('id').setNodename(value);
                this.lookup('path').setNodename(value);
            }
        },

        init: function (view) {
            let _me = this;

            if (!view.nodename) {
                //throw "no nodename given";
            }
        },

        control: {
            radiofield: {
                change: 'modeChange',
            },
            pveNodeSelector: {
                change: 'nodeChange',
            },
        },
    },

    items: [
        {
            xtype: 'inputpanel',
            onGetValues: function (values) {
                return this.up('window').getController().onGetValues(values);
            },

            onSetValues: function (values) {
                return this.up('window').getController().onSetValues(values);
            },

            column1: [
                {
                    xtype: 'pmxDisplayEditField',
                    fieldLabel: gettext('Name'),
                    cbind: {
                        editable: '{!name}',
                        value: '{name}',
                        submitValue: '{isCreate}',
                    },
                    name: 'name',
                    allowBlank: false,
                },
                {
                    xtype: 'displayfield',
                    fieldLabel: gettext('Mapping on Node'),
                    labelWidth: 120,
                    name: 'node',
                    cbind: {
                        value: '{nodename}',
                        disabled: '{hideNode}',
                        hidden: '{hideNode}',
                    },
                    allowBlank: false,
                },
                {
                    xtype: 'pveNodeSelector',
                    reference: 'nodeselector',
                    fieldLabel: gettext('Mapping on Node'),
                    labelWidth: 120,
                    name: 'node',
                    cbind: {
                        disabled: '{hideNodeSelector}',
                        hidden: '{hideNodeSelector}',
                    },
                    allowBlank: false,
                },
            ],

            column2: [
                {
                    xtype: 'fieldcontainer',
                    defaultType: 'radiofield',
                    layout: 'fit',
                    cbind: {
                        disabled: '{hideMapping}',
                        hidden: '{hideMapping}',
                    },
                    items: [
                        {
                            name: 'usb',
                            inputValue: 'id',
                            checked: true,
                            boxLabel: gettext('Use USB Vendor/Device ID'),
                            submitValue: false,
                        },
                        {
                            xtype: 'pveUSBSelector',
                            type: 'device',
                            reference: 'id',
                            name: 'id',
                            cbind: {
                                nodename: '{nodename}',
                                disabled: '{hideMapping}',
                            },
                            editable: true,
                            allowBlank: false,
                            fieldLabel: gettext('Choose Device'),
                            labelAlign: 'right',
                        },
                        {
                            name: 'usb',
                            inputValue: 'path',
                            boxLabel: gettext('Use USB Port'),
                            submitValue: false,
                        },
                        {
                            xtype: 'pveUSBSelector',
                            disabled: true,
                            name: 'path',
                            reference: 'path',
                            cbind: {
                                nodename: '{nodename}',
                            },
                            editable: true,
                            type: 'port',
                            allowBlank: false,
                            fieldLabel: gettext('Choose Port'),
                            labelAlign: 'right',
                        },
                    ],
                },
            ],

            columnB: [
                {
                    xtype: 'proxmoxtextfield',
                    fieldLabel: gettext('Comment'),
                    submitValue: true,
                    name: 'description',
                    cbind: {
                        disabled: '{hideComment}',
                        hidden: '{hideComment}',
                    },
                },
            ],
        },
    ],
});
Ext.define('PVE.window.DirMapEditWindow', {
    extend: 'Proxmox.window.Edit',

    mixins: ['Proxmox.Mixin.CBind'],

    cbindData: function (initialConfig) {
        let me = this;
        me.isCreate = !me.name;
        me.method = me.isCreate ? 'POST' : 'PUT';
        me.hideMapping = !!me.entryOnly;
        me.hideComment = me.name && !me.entryOnly;
        me.hideNodeSelector = me.nodename || me.entryOnly;
        me.hideNode = !me.nodename || !me.hideNodeSelector;
        return {
            name: me.name,
            nodename: me.nodename,
        };
    },

    submitUrl: function (_url, data) {
        let me = this;
        let name = me.isCreate ? '' : me.name;
        return `/cluster/mapping/dir/${name}`;
    },

    title: gettext('Add Directory Mapping'),

    onlineHelp: 'resource_mapping',

    method: 'POST',

    controller: {
        xclass: 'Ext.app.ViewController',

        onGetValues: function (values) {
            let me = this;
            let view = me.getView();
            values.node ??= view.nodename;

            let name = values.name;
            let description = values.description;
            let deletes = values.delete;

            delete values.description;
            delete values.name;
            delete values.delete;

            let map = [];
            if (me.originalMap) {
                map = PVE.Parser.filterPropertyStringList(
                    me.originalMap,
                    (e) => e.node !== values.node,
                );
            }
            if (values.path) {
                // TODO: Remove this when property string supports quotation of properties
                if (!/^\/[^;,=()]+/.test(values.path)) {
                    let errMsg =
                        'Value does not look like a valid absolute path.' +
                        ' These symbols are currently not allowed in path: ;,=()\n';
                    Ext.Msg.alert(gettext('Error'), errMsg);
                    // prevent sending a broken property string to the API
                    throw errMsg;
                }
                map.push(PVE.Parser.printPropertyString(values));
            }
            values = { map };

            if (description) {
                values.description = description;
            }
            if (deletes && !view.isCreate) {
                values.delete = deletes;
            }
            if (view.isCreate) {
                values.id = name;
            }

            return values;
        },

        onSetValues: function (values) {
            let me = this;
            let view = me.getView();
            me.originalMap = [...values.map];
            let configuredNodes = [];
            PVE.Parser.filterPropertyStringList(values.map, (e) => {
                configuredNodes.push(e.node);
                if (e.node === view.nodename) {
                    values = e;
                }
                return false;
            });

            me.lookup('nodeselector').disallowedNodes = configuredNodes;

            return values;
        },

        init: function (view) {
            let _me = this;

            if (!view.nodename) {
                //throw "no nodename given";
            }
        },
    },

    items: [
        {
            xtype: 'inputpanel',
            onGetValues: function (values) {
                return this.up('window').getController().onGetValues(values);
            },

            onSetValues: function (values) {
                return this.up('window').getController().onSetValues(values);
            },

            columnT: [
                {
                    xtype: 'displayfield',
                    reference: 'directory-hint',
                    columnWidth: 1,
                    value: 'Make sure the directory exists.',
                    cbind: {
                        disabled: '{hideMapping}',
                        hidden: '{hideMapping}',
                    },
                    userCls: 'pmx-hint',
                },
            ],

            column1: [
                {
                    xtype: 'pmxDisplayEditField',
                    fieldLabel: gettext('Name'),
                    cbind: {
                        editable: '{!name}',
                        value: '{name}',
                        submitValue: '{isCreate}',
                    },
                    name: 'name',
                    allowBlank: false,
                },
                {
                    xtype: 'pveNodeSelector',
                    reference: 'nodeselector',
                    fieldLabel: gettext('Node'),
                    name: 'node',
                    cbind: {
                        disabled: '{hideNodeSelector}',
                        hidden: '{hideNodeSelector}',
                    },
                    allowBlank: false,
                },
            ],

            column2: [
                {
                    xtype: 'fieldcontainer',
                    defaultType: 'radiofield',
                    layout: 'fit',
                    cbind: {
                        disabled: '{hideMapping}',
                        hidden: '{hideMapping}',
                    },
                    items: [
                        {
                            xtype: 'textfield',
                            name: 'path',
                            reference: 'path',
                            value: '',
                            emptyText: gettext('/some/path'),
                            cbind: {
                                nodename: '{nodename}',
                                disabled: '{hideMapping}',
                            },
                            allowBlank: false,
                            fieldLabel: gettext('Path'),
                        },
                    ],
                },
            ],

            columnB: [
                {
                    xtype: 'fieldcontainer',
                    defaultType: 'radiofield',
                    layout: 'fit',
                    cbind: {
                        disabled: '{hideComment}',
                        hidden: '{hideComment}',
                    },
                    items: [
                        {
                            xtype: 'proxmoxtextfield',
                            fieldLabel: gettext('Comment'),
                            submitValue: true,
                            name: 'description',
                            deleteEmpty: true,
                        },
                    ],
                },
            ],
        },
    ],
});
Ext.define('PVE.window.GuestImport', {
    extend: 'Proxmox.window.Edit', // fixme: Proxmox.window.Edit?
    alias: 'widget.pveGuestImportWindow',

    title: gettext('Import Guest'),

    onlineHelp: 'qm_import_virtual_machines',

    width: 720,
    bodyPadding: 0,

    submitUrl: function () {
        let me = this;
        return `/nodes/${me.nodename}/qemu`;
    },

    isAdd: true,
    isCreate: true,
    submitText: gettext('Import'),
    showTaskViewer: true,
    method: 'POST',

    loadUrl: function (_url, { storage, nodename, volumeName }) {
        let args = Ext.Object.toQueryString({ volume: volumeName });
        return `/nodes/${nodename}/storage/${storage}/import-metadata?${args}`;
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        setNodename: function (_column, widget) {
            let me = this;
            let view = me.getView();
            widget.setNodename(view.nodename);
        },

        diskStorageChange: function (storageSelector, value) {
            let me = this;

            let grid = me.lookup('diskGrid');
            let rec = storageSelector.getWidgetRecord();
            let validFormats = storageSelector.store.getById(value)?.data.format;
            grid.query('pveDiskFormatSelector').some((selector) => {
                if (selector.getWidgetRecord().data.id !== rec.data.id) {
                    return false;
                }

                if (validFormats?.[0]?.qcow2) {
                    selector.setDisabled(false);
                    selector.setValue('qcow2');
                } else {
                    selector.setValue('raw');
                    selector.setDisabled(true);
                }

                return true;
            });
        },

        isoStorageChange: function (storageSelector, value) {
            let me = this;

            let grid = me.lookup('cdGrid');
            let rec = storageSelector.getWidgetRecord();
            grid.query('pveFileSelector').some((selector) => {
                if (selector.getWidgetRecord().data.id !== rec.data.id) {
                    return false;
                }

                selector.setStorage(value);
                if (!value) {
                    selector.setValue('');
                }

                return true;
            });
        },

        onOSBaseChange: function (_field, value) {
            let me = this;
            let ostype = me.lookup('ostype');
            let store = ostype.getStore();
            store.setData(PVE.Utils.kvm_ostypes[value]);
            let old_val = ostype.getValue();
            if (old_val && store.find('val', old_val) !== -1) {
                ostype.setValue(old_val);
            } else {
                ostype.setValue(store.getAt(0));
            }
        },

        calculateConfig: function () {
            let me = this;
            let inputPanel = me.lookup('mainInputPanel');
            let summaryGrid = me.lookup('summaryGrid');
            let values = inputPanel.getValues();
            summaryGrid
                .getStore()
                .setData(Object.entries(values).map(([key, value]) => ({ key, value })));
        },

        calculateAdditionalCDIdx: function () {
            let me = this;

            let maxIde = me.getMaxControllerId('ide');
            let maxSata = me.getMaxControllerId('sata');
            // only ide0 and ide2 can be used reliably for isos (e.g. for q35)
            if (maxIde < 0) {
                return 'ide0';
            }
            if (maxIde < 2) {
                return 'ide2';
            }
            if (maxSata < PVE.Utils.diskControllerMaxIDs.sata - 1) {
                return `sata${maxSata + 1}`;
            }

            return '';
        },

        // assume assigned sata disks indices are continuous, so without holes
        getMaxControllerId: function (controller) {
            let me = this;
            let view = me.getView();
            if (!controller) {
                return -1;
            }

            let max = view[`max${controller}`];
            if (max !== undefined) {
                return max;
            }

            max = -1;
            for (const key of Object.keys(me.getView().vmConfig)) {
                if (!key.toLowerCase().startsWith(controller)) {
                    continue;
                }
                let idx = parseInt(key.slice(controller.length), 10);
                if (idx > max) {
                    max = idx;
                }
            }
            me.lookup('diskGrid')
                .getStore()
                .each((rec) => {
                    if (!rec.data.id.toLowerCase().startsWith(controller)) {
                        return;
                    }
                    let idx = parseInt(rec.data.id.slice(controller.length), 10);
                    if (idx > max) {
                        max = idx;
                    }
                });
            me.lookup('cdGrid')
                .getStore()
                .each((rec) => {
                    if (!rec.data.id.toLowerCase().startsWith(controller) || rec.data.hidden) {
                        return;
                    }
                    let idx = parseInt(rec.data.id.slice(controller.length), 10);
                    if (idx > max) {
                        max = idx;
                    }
                });

            view[`max${controller}`] = max;
            return max;
        },

        renderDisk: function (value, metaData, record, rowIndex, colIndex, store, tableView) {
            let diskGrid = tableView.grid ?? this.lookup('diskGrid');
            if (diskGrid.diskMap) {
                let mappedID = diskGrid.diskMap[value];
                if (mappedID) {
                    let prefix = '';
                    if (mappedID === value) {
                        // mapped to the same value means we ran out of IDs
                        let warning = gettext('Too many disks, could not map to SATA.');
                        prefix = `<i data-qtip="${warning}" class="fa fa-exclamation-triangle warning"></i> `;
                    }
                    return `${prefix}${mappedID}`;
                }
            }
            return value;
        },

        refreshGrids: function () {
            this.lookup('diskGrid').reconfigure();
            this.lookup('cdGrid').reconfigure();
            this.lookup('netGrid').reconfigure();
        },

        onOSTypeChange: function (_cb, value) {
            let me = this;
            if (!value) {
                return;
            }
            let store = me.lookup('cdGrid').getStore();
            let collection = store.getData().getSource() ?? store.getData();
            let rec = collection.find('autogenerated', true);

            let isWindows = (value ?? '').startsWith('w');
            if (rec) {
                rec.set('hidden', !isWindows);
                rec.commit();
            }
            let prepareVirtio = me.lookup('prepareForVirtIO').getValue();
            let defaultScsiHw = me.getView().vmConfig.scsihw ?? '__default__';
            me.lookup('scsihw').setValue(
                prepareVirtio && isWindows ? 'virtio-scsi-single' : defaultScsiHw,
            );

            me.refreshGrids();
        },

        onPrepareVirtioChange: function (_cb, value) {
            let me = this;
            let view = me.getView();
            let diskGrid = me.lookup('diskGrid');

            diskGrid.diskMap = {};
            if (value) {
                const hasAdditionalSataCDROM =
                    me.getViewModel().get('isWindows') && view.additionalCdIdx?.startsWith('sata');

                diskGrid.getStore().each((rec) => {
                    let diskID = rec.data.id;
                    if (!diskID.toLowerCase().startsWith('scsi')) {
                        return; // continue
                    }
                    let offset = parseInt(diskID.slice(4), 10);
                    let newIdx = offset + me.getMaxControllerId('sata') + 1;
                    if (hasAdditionalSataCDROM) {
                        newIdx++;
                    }
                    let mappedID = `sata${newIdx}`;
                    if (newIdx >= PVE.Utils.diskControllerMaxIDs.sata) {
                        mappedID = diskID; // map to self so that the renderer can detect that we're out of IDs
                    }
                    diskGrid.diskMap[diskID] = mappedID;
                });
            }

            let scsihw = me.lookup('scsihw');
            scsihw.suspendEvents();
            scsihw.setValue(value ? 'virtio-scsi-single' : me.getView().vmConfig.scsihw);
            scsihw.resumeEvents();

            me.refreshGrids();
        },

        onScsiHwChange: function (_field, value) {
            let me = this;
            me.getView().vmConfig.scsihw = value;
        },

        onUniqueMACChange: function (_cb, value) {
            let me = this;

            me.getViewModel().set('uniqueMACAdresses', value);

            me.lookup('netGrid').reconfigure();
        },

        renderMacAddress: function (value, metaData, record, rowIndex, colIndex, store, view) {
            let me = this;
            let vm = me.getViewModel();

            return !vm.get('uniqueMACAdresses') && value ? value : 'auto';
        },

        control: {
            'grid field': {
                // update records from widgetcolumns
                change: function (widget, value) {
                    let rec = widget.getWidgetRecord();
                    rec.set(widget.name, value);
                    rec.commit();
                },
            },
            'grid[reference=diskGrid] pveStorageSelector': {
                change: 'diskStorageChange',
            },
            'grid[reference=cdGrid] pveStorageSelector': {
                change: 'isoStorageChange',
            },
            'field[name=osbase]': {
                change: 'onOSBaseChange',
            },
            'panel[reference=summaryTab]': {
                activate: 'calculateConfig',
            },
            'proxmoxcheckbox[reference=prepareForVirtIO]': {
                change: 'onPrepareVirtioChange',
            },
            'combobox[name=ostype]': {
                change: 'onOSTypeChange',
            },
            pveScsiHwSelector: {
                change: 'onScsiHwChange',
            },
            'proxmoxcheckbox[name=uniqueMACs]': {
                change: 'onUniqueMACChange',
            },
        },
    },

    viewModel: {
        data: {
            coreCount: 1,
            socketCount: 1,
            liveImport: false,
            os: 'l26',
            maxCdDrives: false,
            uniqueMACAdresses: false,
            isOva: false,
            warnings: [],
        },

        formulas: {
            totalCoreCount: (get) => get('socketCount') * get('coreCount'),
            hideWarnings: (get) => get('warnings').length === 0,
            warningsText: (get) =>
                '<ul style="margin: 0; padding-left: 20px;">' +
                get('warnings')
                    .map((w) => `<li>${w}</li>`)
                    .join('') +
                '</ul>',
            liveImportNote: (get) =>
                !get('liveImport')
                    ? ''
                    : gettext(
                          'Note: If anything goes wrong during the live-import, new data written by the VM may be lost.',
                      ),
            isWindows: (get) => (get('os') ?? '').startsWith('w'),
            liveImportText: (get) =>
                get('isOva')
                    ? gettext('Starts a VM and imports the disks in the background')
                    : gettext(
                          'Starts a previously stopped VM on Proxmox VE and imports the disks in the background.',
                      ),
        },
    },

    items: [
        {
            xtype: 'tabpanel',
            defaults: {
                bodyPadding: 10,
            },
            items: [
                {
                    title: gettext('General'),
                    xtype: 'inputpanel',
                    reference: 'mainInputPanel',
                    onGetValues: function (values) {
                        let me = this;
                        let view = me.up('pveGuestImportWindow');
                        let vm = view.getViewModel();
                        let diskGrid = view.lookup('diskGrid');

                        // from pveDiskStorageSelector
                        let defaultStorage = values.hdstorage;
                        let defaultFormat = values.diskformat;
                        delete values.hdstorage;
                        delete values.diskformat;

                        let defaultBridge = values.defaultBridge;
                        delete values.defaultBridge;

                        let config = { ...view.vmConfig };
                        Ext.apply(config, values);

                        if (config.scsi0) {
                            config.scsi0 = config.scsi0.replace(
                                'local:0,',
                                'local:0,format=qcow2,',
                            );
                        }

                        let parsedBoot = PVE.Parser.parsePropertyString(config.boot ?? '');
                        if (parsedBoot.order) {
                            parsedBoot.order = parsedBoot.order.split(';');
                        }

                        let diskMap = diskGrid.diskMap ?? {};
                        diskGrid.getStore().each((rec) => {
                            if (!rec.data.enable) {
                                return;
                            }
                            let id = diskMap[rec.data.id] ?? rec.data.id;
                            if (id !== rec.data.id && parsedBoot?.order) {
                                let idx = parsedBoot.order.indexOf(rec.data.id);
                                if (idx !== -1) {
                                    parsedBoot.order[idx] = id;
                                }
                            }
                            let data = {
                                ...rec.data,
                            };
                            delete data.enable;
                            delete data.id;
                            delete data.size;
                            if (!data.file) {
                                data.file = defaultStorage;
                                data.format = defaultFormat;
                            }
                            data.file += ':0'; // for our special api format
                            if (id === 'efidisk0') {
                                data.efitype = '4m';
                                delete data['import-from'];
                            }
                            config[id] = PVE.Parser.printQemuDrive(data);
                        });

                        if (parsedBoot.order) {
                            parsedBoot.order = parsedBoot.order.join(';');
                        }
                        config.boot = PVE.Parser.printPropertyString(parsedBoot);

                        view.lookup('netGrid')
                            .getStore()
                            .each((rec) => {
                                if (!rec.data.enable) {
                                    return;
                                }
                                let id = rec.data.id;
                                let data = {
                                    ...rec.data,
                                };
                                delete data.enable;
                                delete data.id;
                                if (!data.bridge) {
                                    data.bridge = defaultBridge;
                                }
                                if (vm.get('uniqueMACAdresses')) {
                                    data.macaddr = undefined;
                                }
                                config[id] = PVE.Parser.printQemuNetwork(data);
                            });

                        view.lookup('cdGrid')
                            .getStore()
                            .each((rec) => {
                                if (!rec.data.enable) {
                                    return;
                                }
                                let id = rec.data.id;
                                let cd = {
                                    media: 'cdrom',
                                    file: rec.data.file ? rec.data.file : 'none',
                                };
                                config[id] = PVE.Parser.printPropertyString(cd);
                            });

                        config.scsihw = view.lookup('scsihw').getValue();

                        if (view.lookup('liveimport').getValue()) {
                            config['live-restore'] = 1;
                        }

                        // remove __default__ values
                        for (const [key, value] of Object.entries(config)) {
                            if (value === '__default__') {
                                delete config[key];
                            }
                        }

                        if (config['import-working-storage'] === '') {
                            delete config['import-working-storage'];
                        }

                        return config;
                    },

                    column1: [
                        {
                            xtype: 'pveGuestIDSelector',
                            name: 'vmid',
                            fieldLabel: 'VM',
                            guestType: 'qemu',
                            loadNextFreeID: true,
                            validateExists: false,
                        },
                        {
                            xtype: 'proxmoxintegerfield',
                            fieldLabel: gettext('Sockets'),
                            name: 'sockets',
                            reference: 'socketsField',
                            value: 1,
                            minValue: 1,
                            maxValue: 128,
                            allowBlank: true,
                            bind: {
                                value: '{socketCount}',
                            },
                        },
                        {
                            xtype: 'proxmoxintegerfield',
                            fieldLabel: gettext('Cores'),
                            name: 'cores',
                            reference: 'coresField',
                            value: 1,
                            minValue: 1,
                            maxValue: 1024,
                            allowBlank: true,
                            bind: {
                                value: '{coreCount}',
                            },
                        },
                        {
                            xtype: 'pveMemoryField',
                            fieldLabel: gettext('Memory') + ' (MiB)',
                            name: 'memory',
                            reference: 'memoryField',
                            value: 512,
                            allowBlank: true,
                        },
                        { xtype: 'displayfield' }, // spacer
                        { xtype: 'displayfield' }, // spacer
                        {
                            xtype: 'pveDiskStorageSelector',
                            reference: 'defaultStorage',
                            storageLabel: gettext('Default Storage'),
                            storageContent: 'images',
                            autoSelect: true,
                            hideSize: true,
                            name: 'defaultStorage',
                        },
                    ],

                    column2: [
                        {
                            xtype: 'textfield',
                            fieldLabel: gettext('Name'),
                            name: 'name',
                            vtype: 'DnsName',
                            reference: 'nameField',
                            allowBlank: true,
                        },
                        {
                            xtype: 'CPUModelSelector',
                            name: 'cpu',
                            reference: 'cputype',
                            value: 'x86-64-v2-AES',
                            fieldLabel: gettext('CPU Type'),
                        },
                        {
                            xtype: 'displayfield',
                            fieldLabel: gettext('Total cores'),
                            name: 'totalcores',
                            isFormField: false,
                            bind: {
                                value: '{totalCoreCount}',
                            },
                        },
                        {
                            xtype: 'combobox',
                            submitValue: false,
                            name: 'osbase',
                            fieldLabel: gettext('OS Type'),
                            editable: false,
                            queryMode: 'local',
                            value: 'Linux',
                            store: Object.keys(PVE.Utils.kvm_ostypes),
                        },
                        {
                            xtype: 'combobox',
                            name: 'ostype',
                            reference: 'ostype',
                            fieldLabel: gettext('Version'),
                            value: 'l26',
                            allowBlank: false,
                            editable: false,
                            queryMode: 'local',
                            valueField: 'val',
                            displayField: 'desc',
                            bind: {
                                value: '{os}',
                            },
                            store: {
                                fields: ['desc', 'val'],
                                data: PVE.Utils.kvm_ostypes.Linux,
                            },
                        },
                        { xtype: 'displayfield' }, // spacer
                        {
                            xtype: 'PVE.form.BridgeSelector',
                            reference: 'defaultBridge',
                            name: 'defaultBridge',
                            allowBlank: false,
                            fieldLabel: gettext('Default Bridge'),
                        },
                        {
                            xtype: 'pveStorageSelector',
                            reference: 'extractionStorage',
                            fieldLabel: gettext('Import Working Storage'),
                            storageContent: 'images',
                            emptyText: gettext('Source Storage'),
                            autoSelect: false,
                            name: 'import-working-storage',
                            disabled: true,
                            hidden: true,
                            allowBlank: true,
                            bind: {
                                disabled: '{!isOva}',
                                hidden: '{!isOva}',
                            },
                        },
                    ],

                    columnB: [
                        {
                            xtype: 'proxmoxcheckbox',
                            fieldLabel: gettext('Live Import'),
                            reference: 'liveimport',
                            isFormField: false,
                            bind: {
                                value: '{liveImport}',
                                boxLabel: '{liveImportText}',
                            },
                        },
                        {
                            xtype: 'displayfield',
                            userCls: 'pmx-hint black',
                            value: gettext(
                                'Note: If anything goes wrong during the live-import, new data written by the VM may be lost.',
                            ),
                            bind: {
                                hidden: '{!liveImport}',
                            },
                        },
                        {
                            xtype: 'displayfield',
                            fieldLabel: gettext('Warnings'),
                            labelWidth: 200,
                            hidden: true,
                            bind: {
                                hidden: '{hideWarnings}',
                            },
                        },
                        {
                            xtype: 'displayfield',
                            reference: 'warningText',
                            userCls: 'pmx-hint',
                            hidden: true,
                            bind: {
                                hidden: '{hideWarnings}',
                                value: '{warningsText}',
                            },
                        },
                    ],
                },
                {
                    title: gettext('Advanced'),
                    xtype: 'inputpanel',

                    // the first inputpanel handles all values, so prevent value leakage here
                    onGetValues: () => ({}),

                    columnT: [
                        {
                            xtype: 'displayfield',
                            fieldLabel: gettext('Disks'),
                            labelWidth: 200,
                        },
                        {
                            xtype: 'grid',
                            reference: 'diskGrid',
                            minHeight: 60,
                            maxHeight: 150,
                            store: {
                                data: [],
                                sorters: ['id'],
                            },
                            columns: [
                                {
                                    xtype: 'checkcolumn',
                                    header: gettext('Use'),
                                    width: 50,
                                    dataIndex: 'enable',
                                    listeners: {
                                        checkchange: function (
                                            _column,
                                            _rowIndex,
                                            _checked,
                                            record,
                                        ) {
                                            record.commit();
                                        },
                                    },
                                },
                                {
                                    text: gettext('Disk'),
                                    dataIndex: 'id',
                                    renderer: 'renderDisk',
                                },
                                {
                                    text: gettext('Source'),
                                    dataIndex: 'import-from',
                                    flex: 1,
                                    renderer: function (value) {
                                        return value.replace(/^.*\//, '');
                                    },
                                },
                                {
                                    text: gettext('Size'),
                                    dataIndex: 'size',
                                    renderer: (value) => {
                                        if (Ext.isNumeric(value)) {
                                            return Proxmox.Utils.render_size(value);
                                        }
                                        return value ?? Proxmox.Utils.unknownText;
                                    },
                                },
                                {
                                    text: gettext('Storage'),
                                    dataIndex: 'file',
                                    xtype: 'widgetcolumn',
                                    width: 150,
                                    widget: {
                                        xtype: 'pveStorageSelector',
                                        isFormField: false,
                                        autoSelect: false,
                                        allowBlank: true,
                                        emptyText: gettext('From Default'),
                                        name: 'file',
                                        storageContent: 'images',
                                    },
                                    onWidgetAttach: 'setNodename',
                                },
                                {
                                    text: gettext('Format'),
                                    dataIndex: 'format',
                                    xtype: 'widgetcolumn',
                                    width: 150,
                                    widget: {
                                        xtype: 'pveDiskFormatSelector',
                                        name: 'format',
                                        disabled: true,
                                        isFormField: false,
                                        matchFieldWidth: false,
                                    },
                                },
                            ],
                        },
                    ],

                    column1: [
                        {
                            xtype: 'proxmoxcheckbox',
                            boxLabel: gettext('Prepare for VirtIO-SCSI'),
                            reference: 'prepareForVirtIO',
                            name: 'prepareForVirtIO',
                            submitValue: false,
                            disabled: true,
                            bind: {
                                disabled: '{!isWindows}',
                            },
                            autoEl: {
                                tag: 'div',
                                'data-qtip': gettext(
                                    'Maps SCSI disks to SATA and changes the SCSI Controller. Useful for a quicker switch to VirtIO-SCSI attached disks',
                                ),
                            },
                        },
                    ],

                    column2: [
                        {
                            xtype: 'pveScsiHwSelector',
                            reference: 'scsihw',
                            name: 'scsihw',
                            value: '__default__',
                            submitValue: false,
                            fieldLabel: gettext('SCSI Controller'),
                        },
                    ],

                    columnB: [
                        {
                            xtype: 'displayfield',
                            fieldLabel: gettext('CD/DVD Drives'),
                            labelWidth: 200,
                        },
                        {
                            xtype: 'grid',
                            reference: 'cdGrid',
                            minHeight: 60,
                            maxHeight: 150,
                            store: {
                                data: [],
                                sorters: ['id'],
                                filters: [
                                    function (rec) {
                                        return !rec.data.hidden;
                                    },
                                ],
                            },
                            columns: [
                                {
                                    xtype: 'checkcolumn',
                                    header: gettext('Use'),
                                    width: 50,
                                    dataIndex: 'enable',
                                    listeners: {
                                        checkchange: function (
                                            _column,
                                            _rowIndex,
                                            _checked,
                                            record,
                                        ) {
                                            record.commit();
                                        },
                                    },
                                },
                                {
                                    text: gettext('Slot'),
                                    dataIndex: 'id',
                                    sorted: true,
                                },
                                {
                                    text: gettext('Storage'),
                                    xtype: 'widgetcolumn',
                                    width: 150,
                                    widget: {
                                        xtype: 'pveStorageSelector',
                                        isFormField: false,
                                        autoSelect: false,
                                        allowBlank: true,
                                        emptyText: Proxmox.Utils.noneText,
                                        storageContent: 'iso',
                                    },
                                    onWidgetAttach: 'setNodename',
                                },
                                {
                                    text: gettext('ISO'),
                                    dataIndex: 'file',
                                    xtype: 'widgetcolumn',
                                    flex: 1,
                                    widget: {
                                        xtype: 'pveFileSelector',
                                        name: 'file',
                                        isFormField: false,
                                        allowBlank: true,
                                        emptyText: Proxmox.Utils.noneText,
                                        storageContent: 'iso',
                                    },
                                    onWidgetAttach: 'setNodename',
                                },
                            ],
                        },
                        {
                            xtype: 'displayfield',
                            fieldLabel: gettext('Network Interfaces'),
                            labelWidth: 200,
                            style: {
                                paddingTop: '10px',
                            },
                        },
                        {
                            xtype: 'grid',
                            minHeight: 58,
                            maxHeight: 150,
                            reference: 'netGrid',
                            store: {
                                data: [],
                                sorters: ['id'],
                            },
                            columns: [
                                {
                                    xtype: 'checkcolumn',
                                    header: gettext('Use'),
                                    width: 50,
                                    dataIndex: 'enable',
                                    listeners: {
                                        checkchange: function (
                                            _column,
                                            _rowIndex,
                                            _checked,
                                            record,
                                        ) {
                                            record.commit();
                                        },
                                    },
                                },
                                {
                                    text: gettext('ID'),
                                    dataIndex: 'id',
                                },
                                {
                                    text: gettext('MAC address'),
                                    flex: 7,
                                    dataIndex: 'macaddr',
                                    renderer: 'renderMacAddress',
                                },
                                {
                                    text: gettext('Model'),
                                    flex: 7,
                                    dataIndex: 'model',
                                    xtype: 'widgetcolumn',
                                    widget: {
                                        xtype: 'pveNetworkCardSelector',
                                        name: 'model',
                                        isFormField: false,
                                        allowBlank: false,
                                    },
                                },
                                {
                                    text: gettext('Bridge'),
                                    dataIndex: 'bridge',
                                    xtype: 'widgetcolumn',
                                    flex: 6,
                                    widget: {
                                        xtype: 'PVE.form.BridgeSelector',
                                        name: 'bridge',
                                        isFormField: false,
                                        autoSelect: false,
                                        allowBlank: true,
                                        emptyText: gettext('From Default'),
                                    },
                                    onWidgetAttach: 'setNodename',
                                },
                                {
                                    text: gettext('VLAN Tag'),
                                    dataIndex: 'tag',
                                    xtype: 'widgetcolumn',
                                    flex: 5,
                                    widget: {
                                        xtype: 'pveVlanField',
                                        fieldLabel: undefined,
                                        name: 'tag',
                                        isFormField: false,
                                        allowBlank: true,
                                    },
                                },
                            ],
                        },
                        {
                            xtype: 'proxmoxcheckbox',
                            name: 'uniqueMACs',
                            boxLabel: gettext('Unique MAC addresses'),
                            uncheckedValue: false,
                            value: false,
                        },
                    ],
                },
                {
                    title: gettext('Resulting Config'),
                    reference: 'summaryTab',
                    items: [
                        {
                            xtype: 'grid',
                            reference: 'summaryGrid',
                            maxHeight: 400,
                            scrollable: true,
                            store: {
                                model: 'KeyValue',
                                sorters: [
                                    {
                                        property: 'key',
                                        direction: 'ASC',
                                    },
                                ],
                            },
                            columns: [
                                { header: 'Key', width: 150, dataIndex: 'key' },
                                { header: 'Value', flex: 1, dataIndex: 'value' },
                            ],
                        },
                    ],
                },
            ],
        },
    ],

    initComponent: function () {
        let me = this;

        if (!me.volumeName) {
            throw 'no volumeName given';
        }

        if (!me.storage) {
            throw 'no storage given';
        }

        if (!me.nodename) {
            throw 'no nodename given';
        }

        me.callParent();

        me.setTitle(
            Ext.String.format(gettext('Import Guest - {0}'), `${me.storage}:${me.volumeName}`),
        );

        me.lookup('defaultStorage').setNodename(me.nodename);
        me.lookup('defaultBridge').setNodename(me.nodename);
        me.lookup('extractionStorage').setNodename(me.nodename);

        let renderWarning = (w) => {
            const warningsCatalogue = {
                'cdrom-image-ignored': gettext(
                    "CD-ROM images cannot get imported, if required you can reconfigure the '{0}' drive in the 'Advanced' tab.",
                ),
                'nvme-unsupported': gettext(
                    "NVMe disks are currently not supported, '{0}' will get attached as SCSI",
                ),
                'ovmf-with-lsi-unsupported': gettext(
                    "OVMF is built without LSI drivers, scsi hardware was set to '{1}'",
                ),
                'serial-port-socket-only': gettext(
                    "Serial socket '{0}' will be mapped to a socket",
                ),
                'guest-is-running': gettext(
                    'Virtual guest seems to be running on source host. Import might fail or have inconsistent state!',
                ),
                'efi-state-lost': Ext.String.format(
                    gettext(
                        'EFI state cannot be imported, you may need to reconfigure the boot order (see {0})',
                    ),
                    '<a href="https://pve.proxmox.com/wiki/OVMF/UEFI_Boot_Entries">OVMF/UEFI Boot Entries</a>',
                ),
                'ova-needs-extracting': gettext(
                    'Importing an OVA temporarily requires extra space on the working storage while extracting the contained disks for further processing.',
                ),
            };
            let message = warningsCatalogue[w.type];
            if (!w.type || !message) {
                return w.message ?? w.type ?? gettext('Unknown warning');
            }
            return Ext.String.format(message, w.key ?? 'unknown', w.value ?? 'unknown');
        };

        me.load({
            success: function (response) {
                let data = response.result.data;
                me.vmConfig = data['create-args'];

                let disks = [];
                for (const [id, value] of Object.entries(data.disks ?? {})) {
                    let volid = Ext.htmlEncode('<none>');
                    let size = 'auto';
                    if (Ext.isObject(value)) {
                        volid = value.volid;
                        size = value.size;
                    }
                    disks.push({
                        id,
                        enable: true,
                        size,
                        'import-from': volid,
                        format: 'raw',
                    });
                }

                let nets = [];
                for (const [id, parsed] of Object.entries(data.net ?? {})) {
                    parsed.id = id;
                    parsed.enable = true;
                    nets.push(parsed);
                }

                let cdroms = [];
                for (const [id, value] of Object.entries(me.vmConfig)) {
                    if (!Ext.isString(value) || !value.match(/media=cdrom/)) {
                        continue;
                    }
                    cdroms.push({
                        enable: true,
                        hidden: false,
                        id,
                    });
                    delete me.vmConfig[id];
                }

                me.lookup('diskGrid').getStore().setData(disks);
                me.lookup('netGrid').getStore().setData(nets);
                me.lookup('cdGrid').getStore().setData(cdroms);

                let additionalCdIdx = me.getController().calculateAdditionalCDIdx();
                if (additionalCdIdx === '') {
                    me.getViewModel().set('maxCdDrives', true);
                } else if (cdroms.length === 0) {
                    me.additionalCdIdx = additionalCdIdx;
                    me.lookup('cdGrid')
                        .getStore()
                        .add({
                            enable: true,
                            hidden: !(me.vmConfig.ostype ?? '').startsWith('w'),
                            id: additionalCdIdx,
                            autogenerated: true,
                        });
                }

                me.getViewModel().set(
                    'warnings',
                    data.warnings.map((w) => renderWarning(w)),
                );
                me.getViewModel().set(
                    'isOva',
                    data.warnings.map((w) => w.type).indexOf('ova-needs-extracting') !== -1,
                );

                let osinfo = PVE.Utils.get_kvm_osinfo(me.vmConfig.ostype ?? '');
                let prepareForVirtIO =
                    (me.vmConfig.ostype ?? '').startsWith('w') &&
                    (me.vmConfig.bios ?? '').indexOf('ovmf') !== -1;

                me.setValues({
                    osbase: osinfo.base,
                    ...me.vmConfig,
                });

                me.lookup('prepareForVirtIO').setValue(prepareForVirtIO);
            },
        });
    },
});
Ext.define(
    'PVE.ha.FencingView',
    {
        extend: 'Ext.grid.GridPanel',
        alias: ['widget.pveFencingView'],

        onlineHelp: 'ha_manager_fencing',

        initComponent: function () {
            var me = this;

            var store = new Ext.data.Store({
                model: 'pve-ha-fencing',
                data: [],
            });

            Ext.apply(me, {
                store: store,
                stateful: false,
                viewConfig: {
                    trackOver: false,
                    deferEmptyText: false,
                    emptyText: gettext('Use watchdog based fencing.'),
                },
                columns: [
                    {
                        header: gettext('Node'),
                        width: 100,
                        sortable: true,
                        dataIndex: 'node',
                    },
                    {
                        header: gettext('Command'),
                        flex: 1,
                        dataIndex: 'command',
                    },
                ],
            });

            me.callParent();
        },
    },
    function () {
        Ext.define('pve-ha-fencing', {
            extend: 'Ext.data.Model',
            fields: ['node', 'command', 'digest'],
        });
    },
);
Ext.define('PVE.ha.GroupInputPanel', {
    extend: 'Proxmox.panel.InputPanel',
    onlineHelp: 'ha_manager_groups',

    groupId: undefined,

    onGetValues: function (values) {
        var me = this;

        if (me.isCreate) {
            values.type = 'group';
        }

        return values;
    },

    initComponent: function () {
        var me = this;

        let update_nodefield, update_node_selection;

        let sm = Ext.create('Ext.selection.CheckboxModel', {
            mode: 'SIMPLE',
            listeners: {
                selectionchange: function (model, selected) {
                    update_nodefield(selected);
                },
            },
        });

        let store = Ext.create('Ext.data.Store', {
            fields: ['node', 'mem', 'cpu', 'priority'],
            data: PVE.data.ResourceStore.getNodes(), // use already cached data to avoid an API call
            proxy: {
                type: 'memory',
                reader: { type: 'json' },
            },
            sorters: [
                {
                    property: 'node',
                    direction: 'ASC',
                },
            ],
        });

        var nodegrid = Ext.createWidget('grid', {
            store: store,
            border: true,
            height: 300,
            selModel: sm,
            columns: [
                {
                    header: gettext('Node'),
                    flex: 1,
                    dataIndex: 'node',
                },
                {
                    header: gettext('Memory usage') + ' %',
                    renderer: PVE.Utils.render_mem_usage_percent,
                    sortable: true,
                    width: 150,
                    dataIndex: 'mem',
                },
                {
                    header: gettext('CPU usage'),
                    renderer: Proxmox.Utils.render_cpu,
                    sortable: true,
                    width: 150,
                    dataIndex: 'cpu',
                },
                {
                    header: gettext('Priority'),
                    xtype: 'widgetcolumn',
                    dataIndex: 'priority',
                    sortable: true,
                    stopSelection: true,
                    widget: {
                        xtype: 'proxmoxintegerfield',
                        minValue: 0,
                        maxValue: 1000,
                        isFormField: false,
                        listeners: {
                            change: function (numberfield, value, old_value) {
                                let record = numberfield.getWidgetRecord();
                                record.set('priority', value);
                                update_nodefield(sm.getSelection());
                                record.commit();
                            },
                        },
                    },
                },
            ],
        });

        let nodefield = Ext.create('Ext.form.field.Hidden', {
            name: 'nodes',
            value: '',
            listeners: {
                change: function (field, value) {
                    update_node_selection(value);
                },
            },
            isValid: function () {
                let value = this.getValue();
                return value && value.length !== 0;
            },
        });

        update_node_selection = function (string) {
            sm.deselectAll(true);

            string.split(',').forEach(function (e, idx, array) {
                let [node, priority] = e.split(':');
                store.each(function (record) {
                    if (record.get('node') === node) {
                        sm.select(record, true);
                        record.set('priority', priority);
                        record.commit();
                    }
                });
            });
            nodegrid.reconfigure(store);
        };

        update_nodefield = function (selected) {
            let nodes = selected
                .map(({ data }) => data.node + (data.priority ? `:${data.priority}` : ''))
                .join(',');

            // nodefield change listener calls us again, which results in a
            // endless recursion, suspend the event temporary to avoid this
            nodefield.suspendEvent('change');
            nodefield.setValue(nodes);
            nodefield.resumeEvent('change');
        };

        me.column1 = [
            {
                xtype: me.isCreate ? 'textfield' : 'displayfield',
                name: 'group',
                value: me.groupId || '',
                fieldLabel: 'ID',
                vtype: 'StorageId',
                allowBlank: false,
            },
            nodefield,
        ];

        me.column2 = [
            {
                xtype: 'proxmoxcheckbox',
                name: 'restricted',
                uncheckedValue: 0,
                fieldLabel: 'restricted',
            },
            {
                xtype: 'proxmoxcheckbox',
                name: 'nofailback',
                uncheckedValue: 0,
                fieldLabel: 'nofailback',
            },
        ];

        me.columnB = [
            {
                xtype: 'textfield',
                name: 'comment',
                fieldLabel: gettext('Comment'),
            },
            nodegrid,
        ];

        me.callParent();
    },
});

Ext.define('PVE.ha.GroupEdit', {
    extend: 'Proxmox.window.Edit',

    groupId: undefined,

    initComponent: function () {
        var me = this;

        me.isCreate = !me.groupId;

        if (me.isCreate) {
            me.url = '/api2/extjs/cluster/ha/groups';
            me.method = 'POST';
        } else {
            me.url = '/api2/extjs/cluster/ha/groups/' + me.groupId;
            me.method = 'PUT';
        }

        var ipanel = Ext.create('PVE.ha.GroupInputPanel', {
            isCreate: me.isCreate,
            groupId: me.groupId,
        });

        Ext.apply(me, {
            subject: gettext('HA Group'),
            items: [ipanel],
        });

        me.callParent();

        if (!me.isCreate) {
            me.load({
                success: function (response, options) {
                    var values = response.result.data;

                    ipanel.setValues(values);
                },
            });
        }
    },
});
Ext.define(
    'PVE.ha.GroupSelector',
    {
        extend: 'Proxmox.form.ComboGrid',
        alias: ['widget.pveHAGroupSelector'],

        autoSelect: false,
        valueField: 'group',
        displayField: 'group',
        listConfig: {
            columns: [
                {
                    header: gettext('Group'),
                    width: 100,
                    sortable: true,
                    dataIndex: 'group',
                },
                {
                    header: gettext('Nodes'),
                    width: 100,
                    sortable: false,
                    dataIndex: 'nodes',
                },
                {
                    header: gettext('Comment'),
                    flex: 1,
                    dataIndex: 'comment',
                    renderer: Ext.String.htmlEncode,
                },
            ],
        },
        store: {
            model: 'pve-ha-groups',
            sorters: {
                property: 'group',
                direction: 'ASC',
            },
        },

        initComponent: function () {
            var me = this;
            me.callParent();
            me.getStore().load();
        },
    },
    function () {
        Ext.define('pve-ha-groups', {
            extend: 'Ext.data.Model',
            fields: [
                'group',
                'type',
                'digest',
                'nodes',
                'comment',
                {
                    name: 'restricted',
                    type: 'boolean',
                },
                {
                    name: 'nofailback',
                    type: 'boolean',
                },
            ],
            proxy: {
                type: 'proxmox',
                url: '/api2/json/cluster/ha/groups',
            },
            idProperty: 'group',
        });
    },
);
Ext.define('PVE.ha.GroupsView', {
    extend: 'Ext.grid.GridPanel',
    alias: ['widget.pveHAGroupsView'],

    onlineHelp: 'ha_manager_groups',

    stateful: true,
    stateId: 'grid-ha-groups',

    initComponent: function () {
        var me = this;

        var caps = Ext.state.Manager.get('GuiCap');

        var store = new Ext.data.Store({
            model: 'pve-ha-groups',
            sorters: {
                property: 'group',
                direction: 'ASC',
            },
        });

        var reload = function () {
            store.load();
        };

        var sm = Ext.create('Ext.selection.RowModel', {});

        let run_editor = function () {
            let rec = sm.getSelection()[0];
            Ext.create('PVE.ha.GroupEdit', {
                groupId: rec.data.group,
                listeners: {
                    destroy: () => store.load(),
                },
                autoShow: true,
            });
        };

        let remove_btn = Ext.create('Proxmox.button.StdRemoveButton', {
            selModel: sm,
            baseurl: '/cluster/ha/groups/',
            callback: () => store.load(),
        });
        let edit_btn = new Proxmox.button.Button({
            text: gettext('Edit'),
            disabled: true,
            selModel: sm,
            handler: run_editor,
        });

        Ext.apply(me, {
            store: store,
            selModel: sm,
            viewConfig: {
                trackOver: false,
            },
            tbar: [
                {
                    text: gettext('Create'),
                    disabled: !caps.nodes['Sys.Console'],
                    handler: function () {
                        Ext.create('PVE.ha.GroupEdit', {
                            listeners: {
                                destroy: () => store.load(),
                            },
                            autoShow: true,
                        });
                    },
                },
                edit_btn,
                remove_btn,
            ],
            columns: [
                {
                    header: gettext('Group'),
                    width: 150,
                    sortable: true,
                    dataIndex: 'group',
                },
                {
                    header: 'restricted',
                    width: 100,
                    sortable: true,
                    renderer: Proxmox.Utils.format_boolean,
                    dataIndex: 'restricted',
                },
                {
                    header: 'nofailback',
                    width: 100,
                    sortable: true,
                    renderer: Proxmox.Utils.format_boolean,
                    dataIndex: 'nofailback',
                },
                {
                    header: gettext('Nodes'),
                    flex: 1,
                    sortable: false,
                    dataIndex: 'nodes',
                },
                {
                    header: gettext('Comment'),
                    flex: 1,
                    renderer: Ext.String.htmlEncode,
                    dataIndex: 'comment',
                },
            ],
            listeners: {
                activate: reload,
                beforeselect: (grid, record, index, eOpts) => caps.nodes['Sys.Console'],
                itemdblclick: run_editor,
            },
        });

        me.callParent();
    },
});
Ext.define('PVE.ha.VMResourceInputPanel', {
    extend: 'Proxmox.panel.InputPanel',
    onlineHelp: 'ha_manager_resource_config',
    vmid: undefined,

    onGetValues: function (values) {
        var me = this;

        if (values.vmid) {
            values.sid = values.vmid;
        }
        delete values.vmid;

        PVE.Utils.delete_if_default(values, 'group', '', me.isCreate);
        PVE.Utils.delete_if_default(values, 'max_restart', '1', me.isCreate);
        PVE.Utils.delete_if_default(values, 'max_relocate', '1', me.isCreate);

        return values;
    },

    initComponent: function () {
        var me = this;
        var MIN_QUORUM_VOTES = 3;

        var disabledHint = Ext.createWidget({
            xtype: 'displayfield', // won't get submitted by default
            userCls: 'pmx-hint',
            value:
                'Disabling the resource will stop the guest system. ' +
                'See the online help for details.',
            hidden: true,
        });

        var fewVotesHint = Ext.createWidget({
            itemId: 'fewVotesHint',
            xtype: 'displayfield',
            userCls: 'pmx-hint',
            value: 'At least three quorum votes are recommended for reliable HA.',
            hidden: true,
        });

        Proxmox.Utils.API2Request({
            url: '/cluster/config/nodes',
            method: 'GET',
            failure: function (response) {
                Ext.Msg.alert(gettext('Error'), response.htmlStatus);
            },
            success: function (response) {
                var nodes = response.result.data;
                var votes = 0;
                Ext.Array.forEach(nodes, function (node) {
                    var vote = parseInt(node.quorum_votes, 10); // parse as base 10
                    votes += vote || 0; // parseInt might return NaN, which is false
                });

                if (votes < MIN_QUORUM_VOTES) {
                    fewVotesHint.setVisible(true);
                }
            },
        });

        var vmidStore = me.vmid
            ? {}
            : {
                  model: 'PVEResources',
                  autoLoad: true,
                  sorters: 'vmid',
                  filters: [
                      {
                          property: 'type',
                          value: /lxc|qemu/,
                      },
                      {
                          property: 'hastate',
                          value: /unmanaged/,
                      },
                  ],
              };

        // value is a string above, but a number below
        me.column1 = [
            {
                xtype: me.vmid ? 'displayfield' : 'vmComboSelector',
                submitValue: me.isCreate,
                name: 'vmid',
                fieldLabel: me.vmid && me.guestType === 'ct' ? 'CT' : 'VM',
                value: me.vmid,
                store: vmidStore,
                validateExists: true,
            },
            {
                xtype: 'proxmoxintegerfield',
                name: 'max_restart',
                fieldLabel: gettext('Max. Restart'),
                value: 1,
                minValue: 0,
                maxValue: 10,
                allowBlank: false,
            },
            {
                xtype: 'proxmoxintegerfield',
                name: 'max_relocate',
                fieldLabel: gettext('Max. Relocate'),
                value: 1,
                minValue: 0,
                maxValue: 10,
                allowBlank: false,
            },
        ];

        me.column2 = [
            {
                xtype: 'pveHAGroupSelector',
                name: 'group',
                fieldLabel: gettext('Group'),
            },
            {
                xtype: 'proxmoxKVComboBox',
                name: 'state',
                value: 'started',
                fieldLabel: gettext('Request State'),
                comboItems: [
                    ['started', 'started'],
                    ['stopped', 'stopped'],
                    ['ignored', 'ignored'],
                    ['disabled', 'disabled'],
                ],
                listeners: {
                    change: function (field, newValue) {
                        if (newValue === 'disabled') {
                            disabledHint.setVisible(true);
                        } else if (disabledHint.isVisible()) {
                            disabledHint.setVisible(false);
                        }
                    },
                },
            },
            disabledHint,
        ];

        me.columnB = [
            {
                xtype: 'textfield',
                name: 'comment',
                fieldLabel: gettext('Comment'),
            },
            fewVotesHint,
        ];

        me.callParent();
    },
});

Ext.define('PVE.ha.VMResourceEdit', {
    extend: 'Proxmox.window.Edit',

    vmid: undefined,
    guestType: undefined,
    isCreate: undefined,

    initComponent: function () {
        var me = this;

        if (me.isCreate === undefined) {
            me.isCreate = !me.vmid;
        }

        if (me.isCreate) {
            me.url = '/api2/extjs/cluster/ha/resources';
            me.method = 'POST';
        } else {
            me.url = '/api2/extjs/cluster/ha/resources/' + me.vmid;
            me.method = 'PUT';
        }

        var ipanel = Ext.create('PVE.ha.VMResourceInputPanel', {
            isCreate: me.isCreate,
            vmid: me.vmid,
            guestType: me.guestType,
        });

        Ext.apply(me, {
            subject:
                gettext('Resource') +
                ': ' +
                gettext('Container') +
                '/' +
                gettext('Virtual Machine'),
            isAdd: true,
            items: [ipanel],
        });

        me.callParent();

        if (!me.isCreate) {
            me.load({
                success: function (response, options) {
                    var values = response.result.data;

                    var regex = /^(\S+):(\S+)$/;
                    var res = regex.exec(values.sid);

                    if (res[1] !== 'vm' && res[1] !== 'ct') {
                        throw 'got unexpected resource type';
                    }

                    values.vmid = res[2];

                    ipanel.setValues(values);
                },
            });
        }
    },
});
Ext.define('PVE.ha.ResourcesView', {
    extend: 'Ext.grid.GridPanel',
    alias: ['widget.pveHAResourcesView'],

    onlineHelp: 'ha_manager_resources',

    stateful: true,
    stateId: 'grid-ha-resources',

    initComponent: function () {
        let me = this;

        if (!me.rstore) {
            throw 'no store given';
        }

        Proxmox.Utils.monStoreErrors(me, me.rstore);
        let store = Ext.create('Proxmox.data.DiffStore', {
            rstore: me.rstore,
            filters: {
                property: 'type',
                value: 'service',
            },
        });

        let sm = Ext.create('Ext.selection.RowModel', {});

        let run_editor = function () {
            let rec = sm.getSelection()[0];
            let sid = rec.data.sid;

            let res = sid.match(/^(\S+):(\S+)$/);
            if (!res || (res[1] !== 'vm' && res[1] !== 'ct')) {
                console.warn(`unknown HA service ID type ${sid}`);
                return;
            }
            let [, guestType, vmid] = res;
            Ext.create('PVE.ha.VMResourceEdit', {
                guestType: guestType,
                vmid: vmid,
                listeners: {
                    destroy: () => me.rstore.load(),
                },
                autoShow: true,
            });
        };

        let caps = Ext.state.Manager.get('GuiCap');

        Ext.apply(me, {
            store: store,
            selModel: sm,
            viewConfig: {
                trackOver: false,
            },
            tbar: [
                {
                    text: gettext('Add'),
                    disabled: !caps.nodes['Sys.Console'],
                    handler: function () {
                        Ext.create('PVE.ha.VMResourceEdit', {
                            listeners: {
                                destroy: () => me.rstore.load(),
                            },
                            autoShow: true,
                        });
                    },
                },
                {
                    xtype: 'proxmoxButton',
                    text: gettext('Edit'),
                    disabled: true,
                    selModel: sm,
                    handler: run_editor,
                },
                {
                    xtype: 'proxmoxStdRemoveButton',
                    selModel: sm,
                    getUrl: function (rec) {
                        return `/cluster/ha/resources/${rec.get('sid')}`;
                    },
                    callback: () => me.rstore.load(),
                },
            ],
            columns: [
                {
                    header: 'ID',
                    width: 100,
                    sortable: true,
                    dataIndex: 'sid',
                },
                {
                    header: gettext('State'),
                    width: 100,
                    sortable: true,
                    dataIndex: 'state',
                },
                {
                    header: gettext('Node'),
                    width: 100,
                    sortable: true,
                    dataIndex: 'node',
                },
                {
                    header: gettext('Request State'),
                    width: 100,
                    hidden: true,
                    sortable: true,
                    renderer: (v) => v || 'started',
                    dataIndex: 'request_state',
                },
                {
                    header: gettext('CRM State'),
                    width: 100,
                    hidden: true,
                    sortable: true,
                    dataIndex: 'crm_state',
                },
                {
                    header: gettext('Name'),
                    width: 100,
                    sortable: true,
                    dataIndex: 'vname',
                },
                {
                    header: gettext('Max. Restart'),
                    width: 100,
                    sortable: true,
                    renderer: (v) => (v === undefined ? '1' : v),
                    dataIndex: 'max_restart',
                },
                {
                    header: gettext('Max. Relocate'),
                    width: 100,
                    sortable: true,
                    renderer: (v) => (v === undefined ? '1' : v),
                    dataIndex: 'max_relocate',
                },
                {
                    header: gettext('Group'),
                    width: 200,
                    sortable: true,
                    renderer: function (value, metaData, { data }) {
                        if (data.errors && data.errors.group) {
                            metaData.tdCls = 'proxmox-invalid-row';
                            let html = Ext.htmlEncode(
                                `<p>${Ext.htmlEncode(data.errors.group)}</p>`,
                            );
                            metaData.tdAttr =
                                'data-qwidth=600 data-qtitle="ERROR" data-qtip="' + html + '"';
                        }
                        return value;
                    },
                    dataIndex: 'group',
                },
                {
                    header: gettext('Description'),
                    flex: 1,
                    renderer: Ext.String.htmlEncode,
                    dataIndex: 'comment',
                },
            ],
            listeners: {
                beforeselect: (grid, record, index, eOpts) => caps.nodes['Sys.Console'],
                itemdblclick: run_editor,
            },
        });

        me.callParent();
    },
});
Ext.define('PVE.ha.Status', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.pveHAStatus',

    onlineHelp: 'chapter_ha_manager',
    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    initComponent: function () {
        var me = this;

        me.rstore = Ext.create('Proxmox.data.ObjectStore', {
            interval: me.interval,
            model: 'pve-ha-status',
            storeid: 'pve-store-' + ++Ext.idSeed,
            groupField: 'type',
            proxy: {
                type: 'proxmox',
                url: '/api2/json/cluster/ha/status/current',
            },
        });

        me.items = [
            {
                xtype: 'pveHAStatusView',
                title: gettext('Status'),
                rstore: me.rstore,
                border: 0,
                collapsible: true,
                padding: '0 0 20 0',
            },
            {
                xtype: 'pveHAResourcesView',
                flex: 1,
                collapsible: true,
                title: gettext('Resources'),
                border: 0,
                rstore: me.rstore,
            },
        ];

        me.callParent();
        me.on('activate', me.rstore.startUpdate);
    },
});
Ext.define(
    'PVE.ha.StatusView',
    {
        extend: 'Ext.grid.GridPanel',
        alias: ['widget.pveHAStatusView'],

        onlineHelp: 'chapter_ha_manager',

        sortPriority: {
            quorum: 1,
            master: 2,
            lrm: 3,
            service: 4,
        },

        initComponent: function () {
            var me = this;

            if (!me.rstore) {
                throw 'no rstore given';
            }

            Proxmox.Utils.monStoreErrors(me, me.rstore);

            var store = Ext.create('Proxmox.data.DiffStore', {
                rstore: me.rstore,
                sortAfterUpdate: true,
                sorters: [
                    {
                        sorterFn: function (rec1, rec2) {
                            var p1 = me.sortPriority[rec1.data.type];
                            var p2 = me.sortPriority[rec2.data.type];
                            return p1 !== p2 ? (p1 > p2 ? 1 : -1) : 0;
                        },
                    },
                ],
                filters: {
                    property: 'type',
                    value: 'service',
                    operator: '!=',
                },
            });

            Ext.apply(me, {
                store: store,
                stateful: false,
                viewConfig: {
                    trackOver: false,
                },
                columns: [
                    {
                        header: gettext('Type'),
                        width: 80,
                        dataIndex: 'type',
                    },
                    {
                        header: gettext('Status'),
                        width: 80,
                        flex: 1,
                        dataIndex: 'status',
                    },
                ],
            });

            me.callParent();

            me.on('activate', me.rstore.startUpdate);
            me.on('destroy', me.rstore.stopUpdate);
        },
    },
    function () {
        Ext.define('pve-ha-status', {
            extend: 'Ext.data.Model',
            fields: [
                'id',
                'type',
                'node',
                'status',
                'sid',
                'state',
                'group',
                'comment',
                'max_restart',
                'max_relocate',
                'type',
                'crm_state',
                'request_state',
                {
                    name: 'vname',
                    convert: function (value, record) {
                        let sid = record.data.sid;
                        if (!sid) {
                            return '';
                        }

                        let res = sid.match(/^(\S+):(\S+)$/);
                        if (res[1] !== 'vm' && res[1] !== 'ct') {
                            return '-';
                        }
                        let vmid = res[2];
                        return PVE.data.ResourceStore.guestName(vmid);
                    },
                },
            ],
            idProperty: 'id',
        });
    },
);
Ext.define('PVE.dc.ACLAdd', {
    extend: 'Proxmox.window.Edit',
    alias: ['widget.pveACLAdd'],

    url: '/access/acl',
    method: 'PUT',
    isAdd: true,
    isCreate: true,

    width: 400,

    initComponent: function () {
        let me = this;

        let items = [
            {
                xtype: me.path ? 'hiddenfield' : 'pvePermPathSelector',
                name: 'path',
                value: me.path,
                allowBlank: false,
                fieldLabel: gettext('Path'),
            },
        ];

        if (me.aclType === 'group') {
            me.subject = gettext('Group Permission');
            items.push({
                xtype: 'pveGroupSelector',
                name: 'groups',
                fieldLabel: gettext('Group'),
            });
        } else if (me.aclType === 'user') {
            me.subject = gettext('User Permission');
            items.push({
                xtype: 'pmxUserSelector',
                name: 'users',
                fieldLabel: gettext('User'),
            });
        } else if (me.aclType === 'token') {
            me.subject = gettext('API Token Permission');
            items.push({
                xtype: 'pveTokenSelector',
                name: 'tokens',
                fieldLabel: gettext('API Token'),
            });
        } else {
            throw 'unknown ACL type';
        }

        items.push({
            xtype: 'pmxRoleSelector',
            name: 'roles',
            value: 'NoAccess',
            fieldLabel: gettext('Role'),
        });

        if (!me.path) {
            items.push({
                xtype: 'proxmoxcheckbox',
                name: 'propagate',
                checked: true,
                uncheckedValue: 0,
                fieldLabel: gettext('Propagate'),
            });
        }

        let ipanel = Ext.create('Proxmox.panel.InputPanel', {
            items: items,
            onlineHelp: 'pveum_permission_management',
        });

        Ext.apply(me, {
            items: [ipanel],
        });

        me.callParent();
    },
});

Ext.define(
    'PVE.dc.ACLView',
    {
        extend: 'Ext.grid.GridPanel',

        alias: ['widget.pveACLView'],

        onlineHelp: 'chapter_user_management',

        stateful: true,
        stateId: 'grid-acls',

        // use fixed path
        path: undefined,

        initComponent: function () {
            let me = this;

            let store = Ext.create('Ext.data.Store', {
                model: 'pve-acl',
                proxy: {
                    type: 'proxmox',
                    url: '/api2/json/access/acl',
                },
                sorters: {
                    property: 'path',
                    direction: 'ASC',
                },
            });

            if (me.path) {
                store.addFilter(
                    Ext.create('Ext.util.Filter', {
                        filterFn: (item) => item.data.path === me.path,
                    }),
                );
            }

            let render_ugid = function (ugid, metaData, record) {
                if (record.data.type === 'group') {
                    return '@' + ugid;
                }

                return Ext.String.htmlEncode(ugid);
            };

            let columns = [
                {
                    header: gettext('User') + '/' + gettext('Group') + '/' + gettext('API Token'),
                    flex: 1,
                    sortable: true,
                    renderer: render_ugid,
                    dataIndex: 'ugid',
                },
                {
                    header: gettext('Role'),
                    flex: 1,
                    sortable: true,
                    dataIndex: 'roleid',
                },
            ];

            if (!me.path) {
                columns.unshift({
                    header: gettext('Path'),
                    flex: 1,
                    sortable: true,
                    dataIndex: 'path',
                });
                columns.push({
                    header: gettext('Propagate'),
                    width: 80,
                    sortable: true,
                    dataIndex: 'propagate',
                });
            }

            let sm = Ext.create('Ext.selection.RowModel', {});

            let remove_btn = new Proxmox.button.Button({
                text: gettext('Remove'),
                disabled: true,
                selModel: sm,
                confirmMsg: gettext('Are you sure you want to remove this entry'),
                handler: function (btn, event, rec) {
                    var params = {
                        delete: 1,
                        path: rec.data.path,
                        roles: rec.data.roleid,
                    };
                    if (rec.data.type === 'group') {
                        params.groups = rec.data.ugid;
                    } else if (rec.data.type === 'user') {
                        params.users = rec.data.ugid;
                    } else if (rec.data.type === 'token') {
                        params.tokens = rec.data.ugid;
                    } else {
                        throw 'unknown data type';
                    }

                    Proxmox.Utils.API2Request({
                        url: '/access/acl',
                        params: params,
                        method: 'PUT',
                        waitMsgTarget: me,
                        callback: () => store.load(),
                        failure: (response) => Ext.Msg.alert(gettext('Error'), response.htmlStatus),
                    });
                },
            });

            Proxmox.Utils.monStoreErrors(me, store);

            Ext.apply(me, {
                store: store,
                selModel: sm,
                tbar: [
                    {
                        text: gettext('Add'),
                        menu: {
                            xtype: 'menu',
                            items: [
                                {
                                    text: gettext('Group Permission'),
                                    iconCls: 'fa fa-fw fa-group',
                                    handler: function () {
                                        var win = Ext.create('PVE.dc.ACLAdd', {
                                            aclType: 'group',
                                            path: me.path,
                                        });
                                        win.on('destroy', () => store.load());
                                        win.show();
                                    },
                                },
                                {
                                    text: gettext('User Permission'),
                                    iconCls: 'fa fa-fw fa-user',
                                    handler: function () {
                                        var win = Ext.create('PVE.dc.ACLAdd', {
                                            aclType: 'user',
                                            path: me.path,
                                        });
                                        win.on('destroy', () => store.load());
                                        win.show();
                                    },
                                },
                                {
                                    text: gettext('API Token Permission'),
                                    iconCls: 'fa fa-fw fa-user-o',
                                    handler: function () {
                                        let win = Ext.create('PVE.dc.ACLAdd', {
                                            aclType: 'token',
                                            path: me.path,
                                        });
                                        win.on('destroy', () => store.load());
                                        win.show();
                                    },
                                },
                            ],
                        },
                    },
                    remove_btn,
                ],
                viewConfig: {
                    trackOver: false,
                },
                columns: columns,
                listeners: {
                    activate: () => store.load(),
                },
            });

            me.callParent();
        },
    },
    function () {
        Ext.define('pve-acl', {
            extend: 'Ext.data.Model',
            fields: [
                'path',
                'type',
                'ugid',
                'roleid',
                {
                    name: 'propagate',
                    type: 'boolean',
                },
            ],
        });
    },
);
Ext.define('pve-acme-accounts', {
    extend: 'Ext.data.Model',
    fields: ['name'],
    proxy: {
        type: 'proxmox',
        url: '/api2/json/cluster/acme/account',
    },
    idProperty: 'name',
});

Ext.define('pve-acme-plugins', {
    extend: 'Ext.data.Model',
    fields: ['type', 'plugin', 'api'],
    proxy: {
        type: 'proxmox',
        url: '/api2/json/cluster/acme/plugins',
    },
    idProperty: 'plugin',
});

Ext.define('PVE.dc.ACMEClusterView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.pveACMEClusterView',

    onlineHelp: 'sysadmin_certificate_management',

    items: [
        {
            region: 'north',
            border: false,
            xtype: 'pmxACMEAccounts',
            acmeUrl: '/cluster/acme',
        },
        {
            region: 'center',
            border: false,
            xtype: 'pmxACMEPluginView',
            acmeUrl: '/cluster/acme',
        },
    ],
});
Ext.define('PVE.panel.AuthBase', {
    extend: 'Proxmox.panel.InputPanel',
    xtype: 'pveAuthBasePanel',

    type: '',

    onGetValues: function (values) {
        let me = this;

        if (!values.port) {
            if (!me.isCreate) {
                Proxmox.Utils.assemble_field_data(values, { delete: 'port' });
            }
            delete values.port;
        }

        if (me.isCreate) {
            values.type = me.type;
        }

        return values;
    },

    initComponent: function () {
        let me = this;

        let options = PVE.Utils.authSchema[me.type];

        if (!me.column1) {
            me.column1 = [];
        }
        if (!me.column2) {
            me.column2 = [];
        }
        if (!me.columnB) {
            me.columnB = [];
        }

        // first field is name
        me.column1.unshift({
            xtype: me.isCreate ? 'textfield' : 'displayfield',
            name: 'realm',
            fieldLabel: gettext('Realm'),
            value: me.realm,
            allowBlank: false,
        });

        // last field is default'
        me.column1.push({
            xtype: 'proxmoxcheckbox',
            fieldLabel: gettext('Default'),
            name: 'default',
            uncheckedValue: 0,
        });

        if (options.tfa) {
            // last field of column2is tfa
            me.column2.push({
                xtype: 'pveTFASelector',
                deleteEmpty: !me.isCreate,
            });
        }

        me.columnB.push({
            xtype: 'textfield',
            name: 'comment',
            fieldLabel: gettext('Comment'),
        });

        me.callParent();
    },
});

Ext.define('PVE.dc.AuthEditBase', {
    extend: 'Proxmox.window.Edit',

    onlineHelp: 'pveum_authentication_realms',

    isAdd: true,

    fieldDefaults: {
        labelWidth: 120,
    },

    initComponent: function () {
        var me = this;

        me.isCreate = !me.realm;

        if (me.isCreate) {
            me.url = '/api2/extjs/access/domains';
            me.method = 'POST';
        } else {
            me.url = '/api2/extjs/access/domains/' + me.realm;
            me.method = 'PUT';
        }

        let authConfig = PVE.Utils.authSchema[me.authType];
        if (!authConfig) {
            throw 'unknown auth type';
        } else if (!authConfig.add && me.isCreate) {
            throw 'trying to add non addable realm';
        }

        me.subject = authConfig.name;

        let items;
        let bodyPadding;
        if (authConfig.syncipanel) {
            bodyPadding = 0;
            items = {
                xtype: 'tabpanel',
                region: 'center',
                layout: 'fit',
                bodyPadding: 10,
                items: [
                    {
                        title: gettext('General'),
                        realm: me.realm,
                        xtype: authConfig.ipanel,
                        isCreate: me.isCreate,
                        type: me.authType,
                    },
                    {
                        title: gettext('Sync Options'),
                        realm: me.realm,
                        xtype: authConfig.syncipanel,
                        isCreate: me.isCreate,
                        type: me.authType,
                    },
                ],
            };
        } else {
            items = [
                {
                    realm: me.realm,
                    xtype: authConfig.ipanel,
                    isCreate: me.isCreate,
                    type: me.authType,
                },
            ];
        }

        Ext.apply(me, {
            items,
            bodyPadding,
        });

        me.callParent();

        if (!me.isCreate) {
            me.load({
                success: function (response, options) {
                    var data = response.result.data || {};
                    // just to be sure (should not happen)
                    if (data.type !== me.authType) {
                        me.close();
                        throw 'got wrong auth type';
                    }
                    me.setValues(data);
                },
            });
        }
    },
});
Ext.define('PVE.panel.ADInputPanel', {
    extend: 'PVE.panel.AuthBase',
    xtype: 'pveAuthADPanel',

    initComponent: function () {
        let me = this;

        if (me.type !== 'ad') {
            throw 'invalid type';
        }

        me.column1 = [
            {
                xtype: 'textfield',
                name: 'domain',
                fieldLabel: gettext('Domain'),
                emptyText: 'company.net',
                allowBlank: false,
            },
            {
                xtype: 'proxmoxcheckbox',
                fieldLabel: gettext('Case-Sensitive'),
                name: 'case-sensitive',
                uncheckedValue: 0,
                checked: true,
            },
        ];

        me.column2 = [
            {
                xtype: 'textfield',
                fieldLabel: gettext('Server'),
                name: 'server1',
                allowBlank: false,
            },
            {
                xtype: 'proxmoxtextfield',
                fieldLabel: gettext('Fallback Server'),
                deleteEmpty: !me.isCreate,
                name: 'server2',
            },
            {
                xtype: 'proxmoxintegerfield',
                name: 'port',
                fieldLabel: gettext('Port'),
                minValue: 1,
                maxValue: 65535,
                emptyText: gettext('Default'),
                submitEmptyText: false,
            },
            {
                xtype: 'proxmoxKVComboBox',
                name: 'mode',
                fieldLabel: gettext('Mode'),
                editable: false,
                comboItems: [
                    ['__default__', Proxmox.Utils.defaultText + ' (LDAP)'],
                    ['ldap', 'LDAP'],
                    ['ldap+starttls', 'STARTTLS'],
                    ['ldaps', 'LDAPS'],
                ],
                value: '__default__',
                deleteEmpty: !me.isCreate,
                listeners: {
                    change: function (field, newValue) {
                        let verifyCheckbox = field.nextSibling('proxmoxcheckbox[name=verify]');
                        if (newValue === 'ldap' || newValue === '__default__') {
                            verifyCheckbox.disable();
                            verifyCheckbox.setValue(0);
                        } else {
                            verifyCheckbox.enable();
                        }
                    },
                },
            },
            {
                xtype: 'proxmoxcheckbox',
                fieldLabel: gettext('Verify Certificate'),
                name: 'verify',
                uncheckedValue: 0,
                disabled: true,
                checked: false,
                autoEl: {
                    tag: 'div',
                    'data-qtip': gettext('Verify TLS certificate of the server'),
                },
            },
        ];

        me.advancedItems = [
            {
                xtype: 'proxmoxcheckbox',
                fieldLabel: gettext('Check connection'),
                name: 'check-connection',
                uncheckedValue: 0,
                checked: true,
                autoEl: {
                    tag: 'div',
                    'data-qtip': gettext(
                        'Verify connection parameters and bind credentials on save',
                    ),
                },
            },
        ];

        me.callParent();
    },
    onGetValues: function (values) {
        let me = this;

        if (!values.verify) {
            if (!me.isCreate) {
                Proxmox.Utils.assemble_field_data(values, { delete: 'verify' });
            }
            delete values.verify;
        }

        if (!me.isCreate) {
            // Delete old `secure` parameter. It has been deprecated in favor to the
            // `mode` parameter. Migration happens automatically in `onSetValues`.
            Proxmox.Utils.assemble_field_data(values, { delete: 'secure' });
        }

        return me.callParent([values]);
    },

    onSetValues(values) {
        let me = this;

        if (values.secure !== undefined && !values.mode) {
            // If `secure` is set, use it to determine the correct setting for `mode`
            // `secure` is later deleted by `onSetValues` .
            // In case *both* are set, we simply ignore `secure` and use
            // whatever `mode` is set to.
            values.mode = values.secure ? 'ldaps' : 'ldap';
        }

        return me.callParent([values]);
    },
});
Ext.define('PVE.panel.LDAPInputPanel', {
    extend: 'PVE.panel.AuthBase',
    xtype: 'pveAuthLDAPPanel',

    initComponent: function () {
        let me = this;

        if (me.type !== 'ldap') {
            throw 'invalid type';
        }

        me.column1 = [
            {
                xtype: 'textfield',
                name: 'base_dn',
                fieldLabel: gettext('Base Domain Name'),
                emptyText: 'CN=Users,DC=Company,DC=net',
                allowBlank: false,
            },
            {
                xtype: 'textfield',
                name: 'user_attr',
                emptyText: 'uid / sAMAccountName',
                fieldLabel: gettext('User Attribute Name'),
                allowBlank: false,
            },
        ];

        me.column2 = [
            {
                xtype: 'textfield',
                fieldLabel: gettext('Server'),
                name: 'server1',
                allowBlank: false,
            },
            {
                xtype: 'proxmoxtextfield',
                fieldLabel: gettext('Fallback Server'),
                deleteEmpty: !me.isCreate,
                name: 'server2',
            },
            {
                xtype: 'proxmoxintegerfield',
                name: 'port',
                fieldLabel: gettext('Port'),
                minValue: 1,
                maxValue: 65535,
                emptyText: gettext('Default'),
                submitEmptyText: false,
            },
            {
                xtype: 'proxmoxKVComboBox',
                name: 'mode',
                fieldLabel: gettext('Mode'),
                editable: false,
                comboItems: [
                    ['__default__', Proxmox.Utils.defaultText + ' (LDAP)'],
                    ['ldap', 'LDAP'],
                    ['ldap+starttls', 'STARTTLS'],
                    ['ldaps', 'LDAPS'],
                ],
                value: '__default__',
                deleteEmpty: !me.isCreate,
                listeners: {
                    change: function (field, newValue) {
                        let verifyCheckbox = field.nextSibling('proxmoxcheckbox[name=verify]');
                        if (newValue === 'ldap' || newValue === '__default__') {
                            verifyCheckbox.disable();
                            verifyCheckbox.setValue(0);
                        } else {
                            verifyCheckbox.enable();
                        }
                    },
                },
            },
            {
                xtype: 'proxmoxcheckbox',
                fieldLabel: gettext('Verify Certificate'),
                name: 'verify',
                uncheckedValue: 0,
                disabled: true,
                checked: false,
                autoEl: {
                    tag: 'div',
                    'data-qtip': gettext('Verify TLS certificate of the server'),
                },
            },
        ];

        me.advancedItems = [
            {
                xtype: 'proxmoxcheckbox',
                fieldLabel: gettext('Check connection'),
                name: 'check-connection',
                uncheckedValue: 0,
                checked: true,
                autoEl: {
                    tag: 'div',
                    'data-qtip': gettext(
                        'Verify connection parameters and bind credentials on save',
                    ),
                },
            },
        ];

        me.callParent();
    },
    onGetValues: function (values) {
        let me = this;

        if (!values.verify) {
            if (!me.isCreate) {
                Proxmox.Utils.assemble_field_data(values, { delete: 'verify' });
            }
            delete values.verify;
        }

        if (!me.isCreate) {
            // Delete old `secure` parameter. It has been deprecated in favor to the
            // `mode` parameter. Migration happens automatically in `onSetValues`.
            Proxmox.Utils.assemble_field_data(values, { delete: 'secure' });
        }

        return me.callParent([values]);
    },

    onSetValues(values) {
        let me = this;

        if (values.secure !== undefined && !values.mode) {
            // If `secure` is set, use it to determine the correct setting for `mode`
            // `secure` is later deleted by `onSetValues` .
            // In case *both* are set, we simply ignore `secure` and use
            // whatever `mode` is set to.
            values.mode = values.secure ? 'ldaps' : 'ldap';
        }

        return me.callParent([values]);
    },
});

Ext.define('PVE.panel.LDAPSyncInputPanel', {
    extend: 'Proxmox.panel.InputPanel',
    xtype: 'pveAuthLDAPSyncPanel',

    editableAttributes: ['email'],
    editableDefaults: ['scope', 'enable-new'],
    default_opts: {},
    sync_attributes: {},

    // (de)construct the sync-attributes from the list above,
    // not touching all others
    onGetValues: function (values) {
        let me = this;
        me.editableDefaults.forEach((attr) => {
            if (values[attr]) {
                me.default_opts[attr] = values[attr];
                delete values[attr];
            } else {
                delete me.default_opts[attr];
            }
        });
        let vanished_opts = [];
        ['acl', 'entry', 'properties'].forEach((prop) => {
            if (values[`remove-vanished-${prop}`]) {
                vanished_opts.push(prop);
            }
            delete values[`remove-vanished-${prop}`];
        });
        me.default_opts['remove-vanished'] = vanished_opts.join(';');

        values['sync-defaults-options'] = PVE.Parser.printPropertyString(me.default_opts);
        me.editableAttributes.forEach((attr) => {
            if (values[attr]) {
                me.sync_attributes[attr] = values[attr];
                delete values[attr];
            } else {
                delete me.sync_attributes[attr];
            }
        });
        values.sync_attributes = PVE.Parser.printPropertyString(me.sync_attributes);

        PVE.Utils.delete_if_default(values, 'sync-defaults-options');
        PVE.Utils.delete_if_default(values, 'sync_attributes');

        // Force values.delete to be an array
        if (typeof values.delete === 'string') {
            values.delete = values.delete.split(',');
        }

        if (me.isCreate) {
            delete values.delete; // on create we cannot delete values
        }

        return values;
    },

    setValues: function (values) {
        let me = this;
        if (values.sync_attributes) {
            me.sync_attributes = PVE.Parser.parsePropertyString(values.sync_attributes);
            delete values.sync_attributes;
            me.editableAttributes.forEach((attr) => {
                if (me.sync_attributes[attr]) {
                    values[attr] = me.sync_attributes[attr];
                }
            });
        }
        if (values['sync-defaults-options']) {
            me.default_opts = PVE.Parser.parsePropertyString(values['sync-defaults-options']);
            delete values.default_opts;
            me.editableDefaults.forEach((attr) => {
                if (me.default_opts[attr]) {
                    values[attr] = me.default_opts[attr];
                }
            });

            if (me.default_opts['remove-vanished']) {
                let opts = me.default_opts['remove-vanished'].split(';');
                for (const opt of opts) {
                    values[`remove-vanished-${opt}`] = 1;
                }
            }
        }
        return me.callParent([values]);
    },

    column1: [
        {
            xtype: 'proxmoxtextfield',
            name: 'bind_dn',
            deleteEmpty: true,
            emptyText: Proxmox.Utils.noneText,
            fieldLabel: gettext('Bind User'),
        },
        {
            xtype: 'proxmoxtextfield',
            inputType: 'password',
            name: 'password',
            emptyText: gettext('Unchanged'),
            fieldLabel: gettext('Bind Password'),
        },
        {
            xtype: 'proxmoxtextfield',
            name: 'email',
            fieldLabel: gettext('E-Mail attribute'),
        },
        {
            xtype: 'proxmoxtextfield',
            name: 'group_name_attr',
            deleteEmpty: true,
            fieldLabel: gettext('Groupname attr.'),
        },
        {
            xtype: 'displayfield',
            value: gettext('Default Sync Options'),
        },
        {
            xtype: 'proxmoxKVComboBox',
            name: 'scope',
            emptyText: Proxmox.Utils.NoneText,
            fieldLabel: gettext('Scope'),
            value: '__default__',
            deleteEmpty: false,
            comboItems: [
                ['__default__', Proxmox.Utils.NoneText],
                ['users', gettext('Users')],
                ['groups', gettext('Groups')],
                ['both', gettext('Users and Groups')],
            ],
        },
    ],

    column2: [
        {
            xtype: 'proxmoxtextfield',
            name: 'user_classes',
            fieldLabel: gettext('User classes'),
            deleteEmpty: true,
            emptyText: 'inetorgperson, posixaccount, person, user',
        },
        {
            xtype: 'proxmoxtextfield',
            name: 'group_classes',
            fieldLabel: gettext('Group classes'),
            deleteEmpty: true,
            emptyText: 'groupOfNames, group, univentionGroup, ipausergroup',
        },
        {
            xtype: 'proxmoxtextfield',
            name: 'filter',
            fieldLabel: gettext('User Filter'),
            deleteEmpty: true,
        },
        {
            xtype: 'proxmoxtextfield',
            name: 'group_filter',
            fieldLabel: gettext('Group Filter'),
            deleteEmpty: true,
        },
        {
            // fake for spacing
            xtype: 'displayfield',
            value: ' ',
        },
        {
            xtype: 'proxmoxKVComboBox',
            value: '__default__',
            deleteEmpty: false,
            comboItems: [
                [
                    '__default__',
                    Ext.String.format(
                        gettext('{0} ({1})'),
                        Proxmox.Utils.yesText,
                        Proxmox.Utils.defaultText,
                    ),
                ],
                ['1', Proxmox.Utils.yesText],
                ['0', Proxmox.Utils.noText],
            ],
            name: 'enable-new',
            fieldLabel: gettext('Enable new users'),
        },
    ],

    columnB: [
        {
            xtype: 'fieldset',
            title: gettext('Remove Vanished Options'),
            items: [
                {
                    xtype: 'proxmoxcheckbox',
                    fieldLabel: gettext('ACL'),
                    name: 'remove-vanished-acl',
                    boxLabel: gettext('Remove ACLs of vanished users and groups.'),
                },
                {
                    xtype: 'proxmoxcheckbox',
                    fieldLabel: gettext('Entry'),
                    name: 'remove-vanished-entry',
                    boxLabel: gettext('Remove vanished user and group entries.'),
                },
                {
                    xtype: 'proxmoxcheckbox',
                    fieldLabel: gettext('Properties'),
                    name: 'remove-vanished-properties',
                    boxLabel: gettext('Remove vanished properties from synced users.'),
                },
            ],
        },
    ],
});
Ext.define('PVE.panel.OpenIDInputPanel', {
    extend: 'PVE.panel.AuthBase',
    xtype: 'pveAuthOpenIDPanel',
    mixins: ['Proxmox.Mixin.CBind'],

    onGetValues: function (values) {
        let me = this;

        if (!values.verify) {
            if (!me.isCreate) {
                Proxmox.Utils.assemble_field_data(values, { delete: 'verify' });
            }
            delete values.verify;
        }

        return me.callParent([values]);
    },

    columnT: [
        {
            xtype: 'textfield',
            name: 'issuer-url',
            fieldLabel: gettext('Issuer URL'),
            allowBlank: false,
        },
    ],

    column1: [
        {
            xtype: 'proxmoxtextfield',
            fieldLabel: gettext('Client ID'),
            name: 'client-id',
            allowBlank: false,
        },
        {
            xtype: 'proxmoxtextfield',
            fieldLabel: gettext('Client Key'),
            cbind: {
                deleteEmpty: '{!isCreate}',
            },
            name: 'client-key',
        },
        {
            xtype: 'proxmoxtextfield',
            name: 'scopes',
            fieldLabel: gettext('Scopes'),
            emptyText: `${Proxmox.Utils.defaultText} (email profile)`,
            submitEmpty: false,
            cbind: {
                deleteEmpty: '{!isCreate}',
            },
        },
    ],

    column2: [
        {
            xtype: 'proxmoxcheckbox',
            fieldLabel: gettext('Autocreate Users'),
            name: 'autocreate',
            value: 0,
            cbind: {
                deleteEmpty: '{!isCreate}',
            },
        },
        {
            xtype: 'pmxDisplayEditField',
            name: 'username-claim',
            fieldLabel: gettext('Username Claim'),
            editConfig: {
                xtype: 'proxmoxKVComboBox',
                editable: true,
                comboItems: [
                    ['__default__', Proxmox.Utils.defaultText],
                    ['subject', 'subject'],
                    ['username', 'username'],
                    ['email', 'email'],
                ],
            },
            cbind: {
                value: (get) => (get('isCreate') ? '__default__' : Proxmox.Utils.defaultText),
                deleteEmpty: '{!isCreate}',
                editable: '{isCreate}',
            },
        },
        {
            xtype: 'proxmoxcheckbox',
            fieldLabel: gettext('Autocreate Groups'),
            name: 'groups-autocreate',
            value: 0,
            cbind: {
                deleteEmpty: '{!isCreate}',
            },
        },
        {
            xtype: 'proxmoxtextfield',
            name: 'groups-claim',
            fieldLabel: gettext('Groups Claim'),
            emptyText: `${Proxmox.Utils.defaultText} ${gettext('(none)')}`,
            submitEmpty: false,
            cbind: {
                deleteEmpty: '{!isCreate}',
            },
        },
        {
            xtype: 'proxmoxcheckbox',
            fieldLabel: gettext('Overwrite Groups'),
            name: 'groups-overwrite',
            value: 0,
            cbind: {
                deleteEmpty: '{!isCreate}',
            },
        },
        {
            xtype: 'proxmoxKVComboBox',
            name: 'prompt',
            fieldLabel: gettext('Prompt'),
            editable: true,
            emptyText: gettext('Auth-Provider Default'),
            comboItems: [
                ['__default__', gettext('Auth-Provider Default')],
                ['none', 'none'],
                ['login', 'login'],
                ['consent', 'consent'],
                ['select_account', 'select_account'],
            ],
            cbind: {
                deleteEmpty: '{!isCreate}',
            },
        },
    ],

    advancedColumnB: [
        {
            xtype: 'proxmoxtextfield',
            name: 'acr-values',
            fieldLabel: gettext('ACR Values'),
            submitEmpty: false,
            cbind: {
                deleteEmpty: '{!isCreate}',
            },
        },
        {
            xtype: 'proxmoxcheckbox',
            fieldLabel: gettext('Query userinfo endpoint'),
            name: 'query-userinfo',
            checked: true,
            uncheckedValue: 0,
            cbind: {
                deleteEmpty: '{!isCreate}',
            },
        },
    ],

    initComponent: function () {
        let me = this;

        if (me.type !== 'openid') {
            throw 'invalid type';
        }

        me.callParent();
    },
});
Ext.define('PVE.dc.AuthView', {
    extend: 'Ext.grid.GridPanel',

    alias: ['widget.pveAuthView'],

    onlineHelp: 'pveum_authentication_realms',

    stateful: true,
    stateId: 'grid-authrealms',

    viewConfig: {
        trackOver: false,
    },

    columns: [
        {
            header: gettext('Realm'),
            width: 100,
            sortable: true,
            dataIndex: 'realm',
        },
        {
            header: gettext('Type'),
            width: 100,
            sortable: true,
            dataIndex: 'type',
        },
        {
            header: gettext('TFA'),
            width: 100,
            sortable: true,
            dataIndex: 'tfa',
        },
        {
            header: gettext('Comment'),
            sortable: false,
            dataIndex: 'comment',
            renderer: Ext.String.htmlEncode,
            flex: 1,
        },
    ],

    store: {
        model: 'pmx-domains',
        sorters: {
            property: 'realm',
            direction: 'ASC',
        },
    },

    openEditWindow: function (authType, realm) {
        let me = this;
        Ext.create('PVE.dc.AuthEditBase', {
            authType,
            realm,
            listeners: {
                destroy: () => me.reload(),
            },
        }).show();
    },

    reload: function () {
        let me = this;
        me.getStore().load();
    },

    run_editor: function () {
        let me = this;
        let rec = me.getSelection()[0];
        if (!rec) {
            return;
        }
        me.openEditWindow(rec.data.type, rec.data.realm);
    },

    open_sync_window: function () {
        let me = this;
        let rec = me.getSelection()[0];
        if (!rec) {
            return;
        }
        Ext.create('PVE.dc.SyncWindow', {
            realm: rec.data.realm,
            listeners: {
                destroy: () => me.reload(),
            },
        }).show();
    },

    initComponent: function () {
        var me = this;

        let items = [];
        for (const [authType, config] of Object.entries(PVE.Utils.authSchema)) {
            if (!config.add) {
                continue;
            }
            items.push({
                text: config.name,
                iconCls: 'fa fa-fw ' + (config.iconCls || 'fa-address-book-o'),
                handler: () => me.openEditWindow(authType),
            });
        }

        Ext.apply(me, {
            tbar: [
                {
                    text: gettext('Add'),
                    menu: {
                        items: items,
                    },
                },
                {
                    xtype: 'proxmoxButton',
                    text: gettext('Edit'),
                    disabled: true,
                    handler: () => me.run_editor(),
                },
                {
                    xtype: 'proxmoxStdRemoveButton',
                    baseurl: '/access/domains/',
                    enableFn: (rec) => PVE.Utils.authSchema[rec.data.type].add,
                    callback: () => me.reload(),
                },
                '-',
                {
                    xtype: 'proxmoxButton',
                    text: gettext('Sync'),
                    disabled: true,
                    enableFn: (rec) => Boolean(PVE.Utils.authSchema[rec.data.type].syncipanel),
                    handler: () => me.open_sync_window(),
                },
            ],
            listeners: {
                itemdblclick: () => me.run_editor(),
            },
        });

        me.callParent();
        me.reload();
    },
});
Ext.define('PVE.dc.BackupDiskTree', {
    extend: 'Ext.tree.Panel',
    alias: 'widget.pveBackupDiskTree',

    folderSort: true,
    rootVisible: false,

    store: {
        sorters: 'id',
        data: {},
    },

    tools: [
        {
            type: 'expand',
            tooltip: gettext('Expand All'),
            callback: (panel) => panel.expandAll(),
        },
        {
            type: 'collapse',
            tooltip: gettext('Collapse All'),
            callback: (panel) => panel.collapseAll(),
        },
    ],

    columns: [
        {
            xtype: 'treecolumn',
            text: gettext('Guest Image'),
            renderer: function (value, meta, record) {
                if (record.data.type) {
                    // guest level
                    let ret = value;
                    if (record.data.name) {
                        ret += ' (' + record.data.name + ')';
                    }
                    return ret;
                } else {
                    // extJS needs unique IDs but we only want to show the volumes key from "vmid:key"
                    return value.split(':')[1] + ' - ' + record.data.name;
                }
            },
            dataIndex: 'id',
            flex: 6,
        },
        {
            text: gettext('Type'),
            dataIndex: 'type',
            flex: 1,
        },
        {
            text: gettext('Backup Job'),
            renderer: PVE.Utils.render_backup_status,
            dataIndex: 'included',
            flex: 3,
        },
    ],

    reload: function () {
        let me = this;
        let sm = me.getSelectionModel();

        Proxmox.Utils.API2Request({
            url: `/cluster/backup/${me.jobid}/included_volumes`,
            waitMsgTarget: me,
            method: 'GET',
            failure: function (response, opts) {
                Proxmox.Utils.setErrorMask(me, response.htmlStatus);
            },
            success: function (response, opts) {
                sm.deselectAll();
                me.setRootNode(response.result.data);
                me.expandAll();
            },
        });
    },

    initComponent: function () {
        var me = this;

        if (!me.jobid) {
            throw 'no job id specified';
        }

        var sm = Ext.create('Ext.selection.TreeModel', {});

        Ext.apply(me, {
            selModel: sm,
            fields: [
                'id',
                'type',
                {
                    type: 'string',
                    name: 'iconCls',
                    calculate: function (data) {
                        var txt = 'fa x-fa-tree fa-';
                        if (data.leaf && !data.type) {
                            return txt + 'hdd-o';
                        } else if (data.type === 'qemu') {
                            return txt + 'desktop';
                        } else if (data.type === 'lxc') {
                            return txt + 'cube';
                        } else {
                            return txt + 'question-circle';
                        }
                    },
                },
            ],
            header: {
                items: [
                    {
                        xtype: 'textfield',
                        fieldLabel: gettext('Search'),
                        labelWidth: 50,
                        emptyText: 'Name, VMID, Type',
                        width: 200,
                        padding: '0 5 0 0',
                        enableKeyEvents: true,
                        listeners: {
                            buffer: 500,
                            keyup: function (field) {
                                let searchValue = field.getValue().toLowerCase();
                                me.store.clearFilter(true);
                                me.store.filterBy(function (record) {
                                    let data = {};
                                    if (record.data.depth === 0) {
                                        return true;
                                    } else if (record.data.depth === 1) {
                                        data = record.data;
                                    } else if (record.data.depth === 2) {
                                        data = record.parentNode.data;
                                    }

                                    for (const property of ['name', 'id', 'type']) {
                                        if (!data[property]) {
                                            continue;
                                        }
                                        let v = data[property].toString();
                                        if (v !== undefined) {
                                            v = v.toLowerCase();
                                            if (v.includes(searchValue)) {
                                                return true;
                                            }
                                        }
                                    }
                                    return false;
                                });
                            },
                        },
                    },
                ],
            },
        });

        me.callParent();

        me.reload();
    },
});

Ext.define('PVE.dc.BackupInfo', {
    extend: 'Proxmox.panel.InputPanel',
    alias: 'widget.pveBackupInfo',

    viewModel: {
        data: {
            retentionType: 'none',
        },
        formulas: {
            hasRetention: (get) => get('retentionType') !== 'none',
            retentionKeepAll: (get) => get('retentionType') === 'all',
        },
    },

    padding: '5 0 5 10',

    column1: [
        {
            xtype: 'displayfield',
            name: 'node',
            fieldLabel: gettext('Node'),
            renderer: (value) => value || `-- ${gettext('All')} --`,
        },
        {
            xtype: 'displayfield',
            name: 'storage',
            fieldLabel: gettext('Storage'),
        },
        {
            xtype: 'displayfield',
            name: 'schedule',
            fieldLabel: gettext('Schedule'),
        },
        {
            xtype: 'displayfield',
            name: 'next-run',
            fieldLabel: gettext('Next Run'),
            renderer: PVE.Utils.render_next_event,
        },
        {
            xtype: 'displayfield',
            name: 'selMode',
            fieldLabel: gettext('Selection mode'),
        },
    ],
    column2: [
        {
            xtype: 'displayfield',
            name: 'notification-policy',
            fieldLabel: gettext('Notification'),
            renderer: function (value) {
                let record = this.up('pveBackupInfo')?.record;

                // Fall back to old value, in case this option is not migrated yet.
                let policy = value || record?.mailnotification || 'always';

                let when = gettext('Always');
                if (policy === 'failure') {
                    when = gettext('On failure only');
                } else if (policy === 'never') {
                    when = gettext('Never');
                }

                // Notification-target takes precedence
                let target =
                    record?.['notification-target'] ||
                    record?.mailto ||
                    gettext('No target configured');

                return `${when} (${target})`;
            },
        },
        {
            xtype: 'displayfield',
            name: 'compress',
            fieldLabel: gettext('Compression'),
        },
        {
            xtype: 'displayfield',
            name: 'mode',
            fieldLabel: gettext('Mode'),
            renderer: function (value) {
                const modeToDisplay = {
                    snapshot: gettext('Snapshot'),
                    stop: gettext('Stop'),
                    suspend: gettext('Suspend'),
                };
                return modeToDisplay[value] ?? gettext('Unknown');
            },
        },
        {
            xtype: 'displayfield',
            name: 'enabled',
            fieldLabel: gettext('Enabled'),
            renderer: (v) =>
                PVE.Parser.parseBoolean(v.toString()) ? gettext('Yes') : gettext('No'),
        },
        {
            xtype: 'displayfield',
            name: 'pool',
            fieldLabel: gettext('Pool to backup'),
        },
    ],

    columnB: [
        {
            xtype: 'displayfield',
            name: 'comment',
            fieldLabel: gettext('Comment'),
            renderer: Ext.String.htmlEncode,
        },
        {
            xtype: 'fieldset',
            title: gettext('Retention Configuration'),
            layout: 'hbox',
            collapsible: true,
            defaults: {
                border: false,
                layout: 'anchor',
                flex: 1,
            },
            bind: {
                hidden: '{!hasRetention}',
            },
            items: [
                {
                    padding: '0 10 0 0',
                    defaults: {
                        labelWidth: 110,
                    },
                    items: [
                        {
                            xtype: 'displayfield',
                            name: 'keep-all',
                            fieldLabel: gettext('Keep All'),
                            renderer: Proxmox.Utils.format_boolean,
                            bind: {
                                hidden: '{!retentionKeepAll}',
                            },
                        },
                    ].concat(
                        [
                            ['keep-last', gettext('Keep Last')],
                            ['keep-hourly', gettext('Keep Hourly')],
                        ].map((name) => ({
                            xtype: 'displayfield',
                            name: name[0],
                            fieldLabel: name[1],
                            bind: {
                                hidden: '{!hasRetention || retentionKeepAll}',
                            },
                        })),
                    ),
                },
                {
                    padding: '0 0 0 10',
                    defaults: {
                        labelWidth: 110,
                    },
                    items: [
                        ['keep-daily', gettext('Keep Daily')],
                        ['keep-weekly', gettext('Keep Weekly')],
                    ].map((name) => ({
                        xtype: 'displayfield',
                        name: name[0],
                        fieldLabel: name[1],
                        bind: {
                            hidden: '{!hasRetention || retentionKeepAll}',
                        },
                    })),
                },
                {
                    padding: '0 0 0 10',
                    defaults: {
                        labelWidth: 110,
                    },
                    items: [
                        ['keep-monthly', gettext('Keep Monthly')],
                        ['keep-yearly', gettext('Keep Yearly')],
                    ].map((name) => ({
                        xtype: 'displayfield',
                        name: name[0],
                        fieldLabel: name[1],
                        bind: {
                            hidden: '{!hasRetention || retentionKeepAll}',
                        },
                    })),
                },
            ],
        },
    ],

    setValues: function (values) {
        var me = this;
        let vm = me.getViewModel();

        Ext.iterate(values, function (fieldId, val) {
            let field = me.query('[isFormField][name=' + fieldId + ']')[0];
            if (field) {
                field.setValue(val);
            }
        });

        if (values['prune-backups'] || values.maxfiles !== undefined) {
            let keepValues;
            if (values['prune-backups']) {
                keepValues = values['prune-backups'];
            } else if (values.maxfiles > 0) {
                keepValues = { 'keep-last': values.maxfiles };
            } else {
                keepValues = { 'keep-all': 1 };
            }

            vm.set('retentionType', keepValues['keep-all'] ? 'all' : 'other');

            // set values of all keep-X fields
            ['all', 'last', 'hourly', 'daily', 'weekly', 'monthly', 'yearly'].forEach((time) => {
                let name = `keep-${time}`;
                me.query(`[isFormField][name=${name}]`)[0]?.setValue(keepValues[name]);
            });
        } else {
            vm.set('retentionType', 'none');
        }

        // selection Mode depends on the presence/absence of several keys
        let selModeField = me.query('[isFormField][name=selMode]')[0];
        let selMode = 'none';
        if (values.vmid) {
            selMode = gettext('Include selected VMs');
        }
        if (values.all) {
            selMode = gettext('All');
        }
        if (values.exclude) {
            selMode = gettext('Exclude selected VMs');
        }
        if (values.pool) {
            selMode = gettext('Pool based');
        }
        selModeField.setValue(selMode);

        if (!values.pool) {
            let poolField = me.query('[isFormField][name=pool]')[0];
            poolField.setVisible(0);
        }
    },

    initComponent: function () {
        var me = this;

        if (!me.record) {
            throw 'no data provided';
        }
        me.callParent();

        me.setValues(me.record);
    },
});

Ext.define('PVE.dc.BackedGuests', {
    extend: 'Ext.grid.GridPanel',
    alias: 'widget.pveBackedGuests',

    stateful: true,
    stateId: 'grid-dc-backed-guests',

    textfilter: '',

    columns: [
        {
            header: gettext('Type'),
            dataIndex: 'type',
            renderer: PVE.Utils.render_resource_type,
            flex: 1,
            sortable: true,
        },
        {
            header: 'VMID',
            dataIndex: 'vmid',
            flex: 1,
            sortable: true,
        },
        {
            header: gettext('Name'),
            dataIndex: 'name',
            flex: 2,
            sortable: true,
        },
    ],
    viewConfig: {
        stripeRows: true,
        trackOver: false,
    },

    initComponent: function () {
        let me = this;

        me.store.clearFilter(true);

        Ext.apply(me, {
            tbar: [
                '->',
                gettext('Search') + ':',
                ' ',
                {
                    xtype: 'textfield',
                    width: 200,
                    emptyText: 'Name, VMID, Type',
                    enableKeyEvents: true,
                    listeners: {
                        buffer: 500,
                        keyup: function (field) {
                            let searchValue = field.getValue().toLowerCase();
                            me.store.clearFilter(true);
                            me.store.filterBy(function (record) {
                                let data = record.data;
                                for (const property of ['name', 'vmid', 'type']) {
                                    if (data[property] === null) {
                                        continue;
                                    }
                                    let v = data[property].toString();
                                    if (v !== undefined) {
                                        if (v.toLowerCase().includes(searchValue)) {
                                            return true;
                                        }
                                    }
                                }
                                return false;
                            });
                        },
                    },
                },
            ],
        });
        me.callParent();
    },
});
Ext.define('PVE.dc.BackupEdit', {
    extend: 'Proxmox.window.Edit',
    alias: ['widget.pveDcBackupEdit'],

    mixins: ['Proxmox.Mixin.CBind'],

    defaultFocus: undefined,

    subject: gettext('Backup Job'),
    width: 720,
    bodyPadding: 0,

    url: '/api2/extjs/cluster/backup',
    method: 'POST',
    isCreate: true,

    cbindData: function () {
        let me = this;
        if (me.jobid) {
            me.isCreate = false;
            me.method = 'PUT';
            me.url += `/${me.jobid}`;
        }
        return {};
    },

    controller: {
        xclass: 'Ext.app.ViewController',

        onGetValues: function (values) {
            let me = this;
            let isCreate = me.getView().isCreate;
            if (!values.node) {
                if (!isCreate) {
                    Proxmox.Utils.assemble_field_data(values, { delete: 'node' });
                }
                delete values.node;
            }

            // Get rid of new-old parameters for notification settings.
            // These should only be set for those selected few who ran
            // pve-manager from pvetest.
            if (!isCreate) {
                Proxmox.Utils.assemble_field_data(values, { delete: 'notification-policy' });
                Proxmox.Utils.assemble_field_data(values, { delete: 'notification-target' });
            }

            let selMode = values.selMode;
            delete values.selMode;

            if (selMode === 'all') {
                values.all = 1;
                values.exclude = '';
                delete values.vmid;
            } else if (selMode === 'exclude') {
                values.all = 1;
                values.exclude = values.vmid;
                delete values.vmid;
            } else if (selMode === 'pool') {
                delete values.vmid;
            }

            if (selMode !== 'pool') {
                delete values.pool;
            }
            return values;
        },

        nodeChange: function (f, value) {
            let me = this;
            me.lookup('storageSelector').setNodename(value);
            let vmgrid = me.lookup('vmgrid');
            let store = vmgrid.getStore();

            store.clearFilter();
            store.filterBy(function (rec) {
                return !value || rec.get('node') === value;
            });

            let mode = me.lookup('modeSelector').getValue();
            if (mode === 'all') {
                vmgrid.selModel.selectAll(true);
            }
            if (mode === 'pool') {
                me.selectPoolMembers();
            }
        },

        storageChange: function (f, v) {
            let me = this;
            let rec = f.getStore().findRecord('storage', v, 0, false, true, true);
            let compressionSelector = me.lookup('compressionSelector');

            if (rec?.data?.type === 'pbs') {
                compressionSelector.setValue('zstd');
                compressionSelector.setDisabled(true);
            } else if (!compressionSelector.getEditable()) {
                compressionSelector.setDisabled(false);
            }
        },

        selectPoolMembers: function () {
            let me = this;
            let mode = me.lookup('modeSelector').getValue();

            if (mode !== 'pool') {
                return;
            }

            let vmgrid = me.lookup('vmgrid');
            let poolid = me.lookup('poolSelector').getValue();

            vmgrid.getSelectionModel().deselectAll(true);
            if (!poolid) {
                return;
            }
            vmgrid.getStore().filter([
                {
                    id: 'poolFilter',
                    property: 'pool',
                    value: poolid,
                },
            ]);
            vmgrid.selModel.selectAll(true);
        },

        modeChange: function (f, value, oldValue) {
            let me = this;
            let vmgrid = me.lookup('vmgrid');
            vmgrid.getStore().removeFilter('poolFilter');

            if (oldValue === 'all' && value !== 'all') {
                vmgrid.getSelectionModel().deselectAll(true);
            }

            if (value === 'all') {
                vmgrid.getSelectionModel().selectAll(true);
            }

            if (value === 'pool') {
                me.selectPoolMembers();
            }
        },

        compressionChange: function (f, value, oldValue) {
            this.getView().lookup('backupAdvanced').updateCompression(value, f.isDisabled());
        },

        compressionDisable: function (f) {
            this.getView().lookup('backupAdvanced').updateCompression(f.getValue(), true);
        },

        compressionEnable: function (f) {
            this.getView().lookup('backupAdvanced').updateCompression(f.getValue(), false);
        },

        prepareValues: function (data) {
            let me = this;
            let viewModel = me.getViewModel();

            // Migrate 'new'-old notification-policy back to old-old mailnotification.
            // Only should affect users who used pve-manager from pvetest. This was a remnant of
            // notifications before the  overhaul.
            let policy = data['notification-policy'];
            if (policy === 'always' || policy === 'failure') {
                data.mailnotification = policy;
            }

            if (data.exclude) {
                data.vmid = data.exclude;
                data.selMode = 'exclude';
            } else if (data.all) {
                data.vmid = '';
                data.selMode = 'all';
            } else if (data.pool) {
                data.selMode = 'pool';
                data.selPool = data.pool;
            } else {
                data.selMode = 'include';
            }
            viewModel.set('selMode', data.selMode);

            if (data['prune-backups']) {
                Object.assign(data, data['prune-backups']);
                delete data['prune-backups'];
            } else if (data.maxfiles !== undefined) {
                if (data.maxfiles > 0) {
                    data['keep-last'] = data.maxfiles;
                } else {
                    data['keep-all'] = 1;
                }
                delete data.maxfiles;
            }

            if (data['notes-template']) {
                data['notes-template'] = PVE.Utils.unEscapeNotesTemplate(data['notes-template']);
            }

            if (data.performance) {
                Object.assign(data, data.performance);
                delete data.performance;
            }

            return data;
        },

        init: function (view) {
            let me = this;

            if (view.isCreate) {
                me.lookup('modeSelector').setValue('include');
            } else {
                view.load({
                    success: function (response, _options) {
                        let values = me.prepareValues(response.result.data);
                        view.setValues(values);
                    },
                });
            }
        },
    },

    viewModel: {
        data: {
            selMode: 'include',
            notificationMode: '__default__',
            mailto: '',
            mailNotification: 'always',
        },

        formulas: {
            poolMode: (get) => get('selMode') === 'pool',
            disableVMSelection: (get) =>
                get('selMode') !== 'include' && get('selMode') !== 'exclude',
            showMailtoFields: (get) =>
                ['auto', 'legacy-sendmail', '__default__'].includes(get('notificationMode')),
            enableMailnotificationField: (get) => {
                let mode = get('notificationMode');
                let mailto = get('mailto');

                return (
                    (['auto', '__default__'].includes(mode) && mailto) || mode === 'legacy-sendmail'
                );
            },
        },
    },

    items: [
        {
            xtype: 'tabpanel',
            region: 'center',
            layout: 'fit',
            bodyPadding: 10,
            items: [
                {
                    xtype: 'container',
                    title: gettext('General'),
                    region: 'center',
                    layout: {
                        type: 'vbox',
                        align: 'stretch',
                    },
                    items: [
                        {
                            xtype: 'inputpanel',
                            onlineHelp: 'chapter_vzdump',
                            column1: [
                                {
                                    xtype: 'pveNodeSelector',
                                    name: 'node',
                                    fieldLabel: gettext('Node'),
                                    allowBlank: true,
                                    editable: true,
                                    autoSelect: false,
                                    emptyText: '-- ' + gettext('All') + ' --',
                                    listeners: {
                                        change: 'nodeChange',
                                    },
                                },
                                {
                                    xtype: 'pveStorageSelector',
                                    reference: 'storageSelector',
                                    fieldLabel: gettext('Storage'),
                                    clusterView: true,
                                    storageContent: 'backup',
                                    allowBlank: false,
                                    name: 'storage',
                                    listeners: {
                                        change: 'storageChange',
                                    },
                                },
                                {
                                    xtype: 'pveCalendarEvent',
                                    fieldLabel: gettext('Schedule'),
                                    allowBlank: false,
                                    name: 'schedule',
                                },
                                {
                                    xtype: 'proxmoxKVComboBox',
                                    reference: 'modeSelector',
                                    comboItems: [
                                        ['include', gettext('Include selected VMs')],
                                        ['all', gettext('All')],
                                        ['exclude', gettext('Exclude selected VMs')],
                                        ['pool', gettext('Pool based')],
                                    ],
                                    fieldLabel: gettext('Selection mode'),
                                    name: 'selMode',
                                    value: '',
                                    bind: {
                                        value: '{selMode}',
                                    },
                                    listeners: {
                                        change: 'modeChange',
                                    },
                                },
                                {
                                    xtype: 'pvePoolSelector',
                                    reference: 'poolSelector',
                                    fieldLabel: gettext('Pool to backup'),
                                    hidden: true,
                                    allowBlank: false,
                                    name: 'pool',
                                    listeners: {
                                        change: 'selectPoolMembers',
                                    },
                                    bind: {
                                        hidden: '{!poolMode}',
                                        disabled: '{!poolMode}',
                                    },
                                },
                            ],
                            column2: [
                                {
                                    xtype: 'proxmoxKVComboBox',
                                    comboItems: [
                                        [
                                            '__default__',
                                            Ext.String.format(
                                                gettext('{0} (Auto)'),
                                                Proxmox.Utils.defaultText,
                                            ),
                                        ],
                                        ['auto', gettext('Auto')],
                                        ['legacy-sendmail', gettext('Email (legacy)')],
                                        ['notification-system', gettext('Notification system')],
                                    ],
                                    fieldLabel: gettext('Notification mode'),
                                    name: 'notification-mode',
                                    value: '__default__',
                                    cbind: {
                                        deleteEmpty: '{!isCreate}',
                                    },
                                    bind: {
                                        value: '{notificationMode}',
                                    },
                                },
                                {
                                    xtype: 'textfield',
                                    fieldLabel: gettext('Send email to'),
                                    name: 'mailto',
                                    bind: {
                                        hidden: '{!showMailtoFields}',
                                        value: '{mailto}',
                                    },
                                },
                                {
                                    xtype: 'pveEmailNotificationSelector',
                                    fieldLabel: gettext('Send email'),
                                    name: 'mailnotification',
                                    cbind: {
                                        value: (get) => (get('isCreate') ? 'always' : ''),
                                        deleteEmpty: '{!isCreate}',
                                    },
                                    bind: {
                                        hidden: '{!showMailtoFields}',
                                        disabled: '{!enableMailnotificationField}',
                                        value: '{mailNotification}',
                                    },
                                },
                                {
                                    xtype: 'pveBackupCompressionSelector',
                                    reference: 'compressionSelector',
                                    fieldLabel: gettext('Compression'),
                                    name: 'compress',
                                    cbind: {
                                        deleteEmpty: '{!isCreate}',
                                    },
                                    value: 'zstd',
                                    listeners: {
                                        change: 'compressionChange',
                                        disable: 'compressionDisable',
                                        enable: 'compressionEnable',
                                    },
                                },
                                {
                                    xtype: 'pveBackupModeSelector',
                                    fieldLabel: gettext('Mode'),
                                    value: 'snapshot',
                                    name: 'mode',
                                },
                                {
                                    xtype: 'proxmoxcheckbox',
                                    fieldLabel: gettext('Enable'),
                                    name: 'enabled',
                                    uncheckedValue: 0,
                                    defaultValue: 1,
                                    checked: true,
                                },
                            ],
                            columnB: [
                                {
                                    xtype: 'proxmoxtextfield',
                                    name: 'comment',
                                    fieldLabel: gettext('Job Comment'),
                                    cbind: {
                                        deleteEmpty: '{!isCreate}',
                                    },
                                    autoEl: {
                                        tag: 'div',
                                        'data-qtip': gettext('Description of the job'),
                                    },
                                },
                                {
                                    xtype: 'vmselector',
                                    reference: 'vmgrid',
                                    height: 300,
                                    name: 'vmid',
                                    disabled: true,
                                    allowBlank: false,
                                    columnSelection: ['vmid', 'node', 'status', 'name', 'type'],
                                    bind: {
                                        disabled: '{disableVMSelection}',
                                    },
                                },
                            ],
                            onGetValues: function (values) {
                                return this.up('window').getController().onGetValues(values);
                            },
                        },
                    ],
                },
                {
                    xtype: 'pveBackupJobPrunePanel',
                    title: gettext('Retention'),
                    cbind: {
                        isCreate: '{isCreate}',
                    },
                    keepAllDefaultForCreate: false,
                    showPBSHint: false,
                    fallbackHintHtml: gettext(
                        "Without any keep option, the storage's configuration or node's vzdump.conf is used as fallback",
                    ),
                },
                {
                    xtype: 'inputpanel',
                    title: gettext('Note Template'),
                    region: 'center',
                    layout: {
                        type: 'vbox',
                        align: 'stretch',
                    },
                    onGetValues: function (values) {
                        if (values['notes-template']) {
                            values['notes-template'] = PVE.Utils.escapeNotesTemplate(
                                values['notes-template'],
                            );
                        }
                        return values;
                    },
                    items: [
                        {
                            xtype: 'textarea',
                            name: 'notes-template',
                            fieldLabel: gettext('Backup Notes'),
                            height: 100,
                            maxLength: 512,
                            cbind: {
                                deleteEmpty: '{!isCreate}',
                                value: (get) => (get('isCreate') ? '{{guestname}}' : undefined),
                            },
                        },
                        {
                            xtype: 'box',
                            style: {
                                margin: '8px 0px',
                                'line-height': '1.5em',
                            },
                            html:
                                gettext('The notes are added to each backup created by this job.') +
                                '<br>' +
                                Ext.String.format(
                                    gettext('Possible template variables are: {0}'),
                                    PVE.Utils.notesTemplateVars
                                        .map((v) => `<code>{{${v}}}</code>`)
                                        .join(', '),
                                ),
                        },
                    ],
                },
                {
                    xtype: 'pveBackupAdvancedOptionsPanel',
                    reference: 'backupAdvanced',
                    title: gettext('Advanced'),
                    cbind: {
                        isCreate: '{isCreate}',
                    },
                },
            ],
        },
    ],
});

Ext.define(
    'PVE.dc.BackupView',
    {
        extend: 'Ext.grid.GridPanel',

        alias: ['widget.pveDcBackupView'],

        onlineHelp: 'chapter_vzdump',

        allText: '-- ' + gettext('All') + ' --',

        initComponent: function () {
            let me = this;

            let store = new Ext.data.Store({
                model: 'pve-cluster-backup',
                proxy: {
                    type: 'proxmox',
                    url: '/api2/json/cluster/backup',
                },
            });

            let not_backed_store = new Ext.data.Store({
                sorters: 'vmid',
                proxy: {
                    type: 'proxmox',
                    url: 'api2/json/cluster/backup-info/not-backed-up',
                },
            });

            let noBackupJobInfoButton;
            let reload = function () {
                store.load();
                not_backed_store.load({
                    callback: (records) => noBackupJobInfoButton.setVisible(records.length > 0),
                });
            };

            let sm = Ext.create('Ext.selection.RowModel', {});

            let run_editor = function () {
                let rec = sm.getSelection()[0];
                if (!rec) {
                    return;
                }

                Ext.create('PVE.dc.BackupEdit', {
                    autoShow: true,
                    jobid: rec.data.id,
                    listeners: {
                        destroy: () => reload(),
                    },
                });
            };

            let run_detail = function () {
                let record = sm.getSelection()[0];
                if (!record) {
                    return;
                }
                Ext.create('Ext.window.Window', {
                    modal: true,
                    width: 800,
                    height: Ext.getBody().getViewSize().height > 1000 ? 800 : 600, // factor out as common infra?
                    resizable: true,
                    layout: 'fit',
                    title: gettext('Backup Details'),
                    items: [
                        {
                            xtype: 'panel',
                            region: 'center',
                            layout: {
                                type: 'vbox',
                                align: 'stretch',
                            },
                            items: [
                                {
                                    xtype: 'pveBackupInfo',
                                    flex: 0,
                                    layout: 'fit',
                                    record: record.data,
                                },
                                {
                                    xtype: 'pveBackupDiskTree',
                                    title: gettext('Included disks'),
                                    flex: 1,
                                    jobid: record.data.id,
                                },
                            ],
                        },
                    ],
                }).show();
            };

            let run_backup_now = function (job) {
                job = Ext.clone(job);

                let jobNode = job.node;
                // Remove properties related to scheduling
                delete job.enabled;
                delete job.starttime;
                delete job.dow;
                delete job.id;
                delete job.schedule;
                delete job.type;
                delete job.node;
                delete job.comment;
                delete job['next-run'];
                delete job['repeat-missed'];
                job.all = job.all === true ? 1 : 0;

                ['performance', 'prune-backups', 'fleecing'].forEach((key) => {
                    if (job[key]) {
                        job[key] = PVE.Parser.printPropertyString(job[key]);
                    }
                });

                let allNodes = PVE.data.ResourceStore.getNodes();
                let nodes = allNodes
                    .filter((node) => node.status === 'online')
                    .map((node) => node.node);
                let errors = [];

                if (jobNode !== undefined) {
                    if (!nodes.includes(jobNode)) {
                        Ext.Msg.alert(
                            'Error',
                            "Node '" + jobNode + "' from backup job isn't online!",
                        );
                        return;
                    }
                    nodes = [jobNode];
                } else {
                    let unkownNodes = allNodes.filter((node) => node.status !== 'online');
                    if (unkownNodes.length > 0) {
                        errors.push(
                            unkownNodes.map(
                                (node) => node.node + ': ' + gettext('Node is offline'),
                            ),
                        );
                    }
                }
                let jobTotalCount = nodes.length,
                    jobsStarted = 0;

                Ext.Msg.show({
                    title: gettext('Please wait...'),
                    closable: false,
                    progress: true,
                    progressText: '0/' + jobTotalCount,
                });

                let postRequest = function () {
                    jobsStarted++;
                    Ext.Msg.updateProgress(
                        jobsStarted / jobTotalCount,
                        jobsStarted + '/' + jobTotalCount,
                    );

                    if (jobsStarted === jobTotalCount) {
                        Ext.Msg.hide();
                        if (errors.length > 0) {
                            Ext.Msg.alert(
                                'Error',
                                'Some errors have been encountered:<br />' + errors.join('<br />'),
                            );
                        }
                    }
                };

                nodes.forEach((node) =>
                    Proxmox.Utils.API2Request({
                        url: '/nodes/' + node + '/vzdump',
                        method: 'POST',
                        params: job,
                        failure: function (response, opts) {
                            errors.push(node + ': ' + response.htmlStatus);
                            postRequest();
                        },
                        success: postRequest,
                    }),
                );
            };

            var edit_btn = new Proxmox.button.Button({
                text: gettext('Edit'),
                disabled: true,
                selModel: sm,
                handler: run_editor,
            });

            var run_btn = new Proxmox.button.Button({
                text: gettext('Run now'),
                disabled: true,
                selModel: sm,
                handler: function () {
                    var rec = sm.getSelection()[0];
                    if (!rec) {
                        return;
                    }

                    Ext.Msg.show({
                        title: gettext('Confirm'),
                        icon: Ext.Msg.QUESTION,
                        msg: gettext('Start the selected backup job now?'),
                        buttons: Ext.Msg.YESNO,
                        callback: function (btn) {
                            if (btn !== 'yes') {
                                return;
                            }
                            run_backup_now(rec.data);
                        },
                    });
                },
            });

            var remove_btn = Ext.create('Proxmox.button.StdRemoveButton', {
                selModel: sm,
                baseurl: '/cluster/backup',
                callback: function () {
                    reload();
                },
            });

            var detail_btn = new Proxmox.button.Button({
                text: gettext('Job Detail'),
                disabled: true,
                tooltip: gettext(
                    'Show job details and which guests and volumes are affected by the backup job',
                ),
                selModel: sm,
                handler: run_detail,
            });

            noBackupJobInfoButton = new Proxmox.button.Button({
                text: `${gettext('Show')}: ${gettext('Guests Without Backup Job')}`,
                tooltip: gettext('Some guests are not covered by any backup job.'),
                iconCls: 'fa fa-fw fa-exclamation-circle',
                hidden: true,
                handler: () => {
                    Ext.create('Ext.window.Window', {
                        autoShow: true,
                        modal: true,
                        width: 600,
                        height: 500,
                        resizable: true,
                        layout: 'fit',
                        title: gettext('Guests Without Backup Job'),
                        items: [
                            {
                                xtype: 'panel',
                                region: 'center',
                                layout: {
                                    type: 'vbox',
                                    align: 'stretch',
                                },
                                items: [
                                    {
                                        xtype: 'pveBackedGuests',
                                        flex: 1,
                                        layout: 'fit',
                                        store: not_backed_store,
                                    },
                                ],
                            },
                        ],
                    });
                },
            });

            Proxmox.Utils.monStoreErrors(me, store);

            Ext.apply(me, {
                store: store,
                selModel: sm,
                stateful: true,
                stateId: 'grid-dc-backup',
                viewConfig: {
                    trackOver: false,
                },
                dockedItems: [
                    {
                        xtype: 'toolbar',
                        overflowHandler: 'scroller',
                        dock: 'top',
                        items: [
                            {
                                text: gettext('Add'),
                                handler: function () {
                                    var win = Ext.create('PVE.dc.BackupEdit', {});
                                    win.on('destroy', reload);
                                    win.show();
                                },
                            },
                            '-',
                            remove_btn,
                            edit_btn,
                            detail_btn,
                            '-',
                            run_btn,
                            '->',
                            noBackupJobInfoButton,
                            '-',
                            {
                                xtype: 'proxmoxButton',
                                selModel: null,
                                text: gettext('Schedule Simulator'),
                                handler: () => {
                                    let record = sm.getSelection()[0];
                                    let schedule;
                                    if (record) {
                                        schedule = record.data.schedule;
                                    }
                                    Ext.create('PVE.window.ScheduleSimulator', {
                                        autoShow: true,
                                        schedule,
                                    });
                                },
                            },
                        ],
                    },
                ],
                columns: [
                    {
                        header: gettext('Enabled'),
                        width: 80,
                        dataIndex: 'enabled',
                        align: 'center',
                        renderer: Proxmox.Utils.renderEnabledIcon,
                        sortable: true,
                    },
                    {
                        header: gettext('ID'),
                        dataIndex: 'id',
                        hidden: true,
                    },
                    {
                        header: gettext('Node'),
                        width: 100,
                        sortable: true,
                        dataIndex: 'node',
                        renderer: function (value) {
                            if (value) {
                                return value;
                            }
                            return me.allText;
                        },
                    },
                    {
                        header: gettext('Schedule'),
                        width: 150,
                        dataIndex: 'schedule',
                    },
                    {
                        text: gettext('Next Run'),
                        dataIndex: 'next-run',
                        width: 150,
                        renderer: PVE.Utils.render_next_event,
                    },
                    {
                        header: gettext('Storage'),
                        width: 100,
                        sortable: true,
                        dataIndex: 'storage',
                    },
                    {
                        header: gettext('Comment'),
                        dataIndex: 'comment',
                        renderer: Ext.htmlEncode,
                        sorter: (a, b) =>
                            (a.data.comment || '').localeCompare(b.data.comment || ''),
                        flex: 1,
                    },
                    {
                        header: gettext('Retention'),
                        dataIndex: 'prune-backups',
                        renderer: (v) =>
                            v
                                ? PVE.Parser.printPropertyString(v)
                                : gettext('Fallback from storage config'),
                        flex: 2,
                    },
                    {
                        header: gettext('Selection'),
                        flex: 4,
                        sortable: false,
                        dataIndex: 'vmid',
                        renderer: PVE.Utils.render_backup_selection,
                    },
                ],
                listeners: {
                    activate: reload,
                    itemdblclick: run_editor,
                },
            });

            me.callParent();
        },
    },
    function () {
        Ext.define('pve-cluster-backup', {
            extend: 'Ext.data.Model',
            fields: [
                'id',
                'compress',
                'dow',
                'exclude',
                'mailto',
                'mode',
                'node',
                'pool',
                'prune-backups',
                'starttime',
                'storage',
                'vmid',
                { name: 'enabled', type: 'boolean' },
                { name: 'all', type: 'boolean' },
            ],
        });
    },
);
Ext.define('pve-cluster-nodes', {
    extend: 'Ext.data.Model',
    fields: [
        'node',
        { type: 'integer', name: 'nodeid' },
        'ring0_addr',
        'ring1_addr',
        { type: 'integer', name: 'quorum_votes' },
    ],
    proxy: {
        type: 'proxmox',
        url: '/api2/json/cluster/config/nodes',
    },
    idProperty: 'nodeid',
});

Ext.define('pve-cluster-info', {
    extend: 'Ext.data.Model',
    proxy: {
        type: 'proxmox',
        url: '/api2/json/cluster/config/join',
    },
});

Ext.define('PVE.ClusterAdministration', {
    extend: 'Ext.panel.Panel',
    xtype: 'pveClusterAdministration',

    title: gettext('Cluster Administration'),
    onlineHelp: 'chapter_pvecm',

    border: false,
    defaults: { border: false },

    viewModel: {
        parent: null,
        data: {
            totem: {},
            nodelist: [],
            preferred_node: {
                name: '',
                fp: '',
                addr: '',
            },
            isInCluster: false,
            nodecount: 0,
        },
    },

    items: [
        {
            xtype: 'panel',
            title: gettext('Cluster Information'),
            controller: {
                xclass: 'Ext.app.ViewController',

                init: function (view) {
                    view.store = Ext.create('Proxmox.data.UpdateStore', {
                        autoStart: true,
                        interval: 15 * 1000,
                        storeid: 'pve-cluster-info',
                        model: 'pve-cluster-info',
                    });
                    view.store.on('load', this.onLoad, this);
                    view.on('destroy', view.store.stopUpdate);
                },

                onLoad: function (store, records, success, operation) {
                    let vm = this.getViewModel();

                    let data = records?.[0]?.data;
                    if (!success || !data || !data.nodelist?.length) {
                        let error = operation.getError();
                        if (error) {
                            let msg = Proxmox.Utils.getResponseErrorMessage(error);
                            if (error.status !== 424 && !msg.match(/node is not in a cluster/i)) {
                                // an actual error, not just the "not in a cluster one", so show it!
                                Proxmox.Utils.setErrorMask(this.getView(), msg);
                            }
                        }
                        vm.set('totem', {});
                        vm.set('isInCluster', false);
                        vm.set('nodelist', []);
                        vm.set('preferred_node', {
                            name: '',
                            addr: '',
                            fp: '',
                        });
                        return;
                    }
                    vm.set('totem', data.totem);
                    vm.set('isInCluster', !!data.totem.cluster_name);
                    vm.set('nodelist', data.nodelist);

                    let nodeinfo = data.nodelist.find((el) => el.name === data.preferred_node);

                    let links = {};
                    let ring_addr = [];
                    PVE.Utils.forEachCorosyncLink(nodeinfo, (num, link) => {
                        links[num] = link;
                        ring_addr.push(link);
                    });

                    vm.set('preferred_node', {
                        name: data.preferred_node,
                        addr: nodeinfo.pve_addr,
                        peerLinks: links,
                        ring_addr: ring_addr,
                        fp: nodeinfo.pve_fp,
                    });
                },

                onCreate: function () {
                    let view = this.getView();
                    view.store.stopUpdate();
                    Ext.create('PVE.ClusterCreateWindow', {
                        autoShow: true,
                        listeners: {
                            destroy: function () {
                                view.store.startUpdate();
                            },
                        },
                    });
                },

                onClusterInfo: function () {
                    let vm = this.getViewModel();
                    Ext.create('PVE.ClusterInfoWindow', {
                        autoShow: true,
                        joinInfo: {
                            ipAddress: vm.get('preferred_node.addr'),
                            fingerprint: vm.get('preferred_node.fp'),
                            peerLinks: vm.get('preferred_node.peerLinks'),
                            ring_addr: vm.get('preferred_node.ring_addr'),
                            totem: vm.get('totem'),
                        },
                    });
                },

                onJoin: function () {
                    let view = this.getView();
                    view.store.stopUpdate();
                    Ext.create('PVE.ClusterJoinNodeWindow', {
                        autoShow: true,
                        listeners: {
                            destroy: function () {
                                view.store.startUpdate();
                            },
                        },
                    });
                },
            },
            tbar: [
                {
                    text: gettext('Create Cluster'),
                    reference: 'createButton',
                    handler: 'onCreate',
                    bind: {
                        disabled: '{isInCluster}',
                    },
                },
                {
                    text: gettext('Join Information'),
                    reference: 'addButton',
                    handler: 'onClusterInfo',
                    bind: {
                        disabled: '{!isInCluster}',
                    },
                },
                {
                    text: gettext('Join Cluster'),
                    reference: 'joinButton',
                    handler: 'onJoin',
                    bind: {
                        disabled: '{isInCluster}',
                    },
                },
            ],
            layout: 'hbox',
            bodyPadding: 5,
            items: [
                {
                    xtype: 'displayfield',
                    fieldLabel: gettext('Cluster Name'),
                    bind: {
                        value: '{totem.cluster_name}',
                        hidden: '{!isInCluster}',
                    },
                    flex: 1,
                },
                {
                    xtype: 'displayfield',
                    fieldLabel: gettext('Config Version'),
                    bind: {
                        value: '{totem.config_version}',
                        hidden: '{!isInCluster}',
                    },
                    flex: 1,
                },
                {
                    xtype: 'displayfield',
                    fieldLabel: gettext('Number of Nodes'),
                    labelWidth: 120,
                    bind: {
                        value: '{nodecount}',
                        hidden: '{!isInCluster}',
                    },
                    flex: 1,
                },
                {
                    xtype: 'displayfield',
                    value: gettext('Standalone node - no cluster defined'),
                    bind: {
                        hidden: '{isInCluster}',
                    },
                    flex: 1,
                },
            ],
        },
        {
            xtype: 'grid',
            title: gettext('Cluster Nodes'),
            autoScroll: true,
            enableColumnHide: false,
            controller: {
                xclass: 'Ext.app.ViewController',

                init: function (view) {
                    view.rstore = Ext.create('Proxmox.data.UpdateStore', {
                        autoLoad: true,
                        xtype: 'update',
                        interval: 5 * 1000,
                        autoStart: true,
                        storeid: 'pve-cluster-nodes',
                        model: 'pve-cluster-nodes',
                    });
                    view.setStore(
                        Ext.create('Proxmox.data.DiffStore', {
                            rstore: view.rstore,
                            sorters: {
                                property: 'nodeid',
                                direction: 'ASC',
                            },
                        }),
                    );
                    Proxmox.Utils.monStoreErrors(view, view.rstore);
                    view.rstore.on('load', this.onLoad, this);
                    view.on('destroy', view.rstore.stopUpdate);
                },

                onLoad: function (store, records, success) {
                    let view = this.getView();
                    let vm = this.getViewModel();

                    if (!success || !records || !records.length) {
                        vm.set('nodecount', 0);
                        return;
                    }
                    vm.set('nodecount', records.length);

                    // show/hide columns according to used links
                    let linkIndex = view.columns.length;
                    Ext.each(view.columns, (col, i) => {
                        if (col.linkNumber !== undefined) {
                            col.setHidden(true);
                            // save offset at which link columns start, so we can address them directly below
                            if (i < linkIndex) {
                                linkIndex = i;
                            }
                        }
                    });

                    PVE.Utils.forEachCorosyncLink(records[0].data, (linknum, val) => {
                        if (linknum > 7) {
                            return;
                        }
                        view.columns[linkIndex + linknum].setHidden(false);
                    });
                },
            },
            columns: {
                items: [
                    {
                        header: gettext('Nodename'),
                        hidden: false,
                        dataIndex: 'name',
                    },
                    {
                        header: gettext('ID'),
                        minWidth: 100,
                        width: 100,
                        flex: 0,
                        hidden: false,
                        dataIndex: 'nodeid',
                    },
                    {
                        header: gettext('Votes'),
                        minWidth: 100,
                        width: 100,
                        flex: 0,
                        hidden: false,
                        dataIndex: 'quorum_votes',
                    },
                    {
                        header: Ext.String.format(gettext('Link {0}'), 0),
                        dataIndex: 'ring0_addr',
                        linkNumber: 0,
                    },
                    {
                        header: Ext.String.format(gettext('Link {0}'), 1),
                        dataIndex: 'ring1_addr',
                        linkNumber: 1,
                    },
                    {
                        header: Ext.String.format(gettext('Link {0}'), 2),
                        dataIndex: 'ring2_addr',
                        linkNumber: 2,
                    },
                    {
                        header: Ext.String.format(gettext('Link {0}'), 3),
                        dataIndex: 'ring3_addr',
                        linkNumber: 3,
                    },
                    {
                        header: Ext.String.format(gettext('Link {0}'), 4),
                        dataIndex: 'ring4_addr',
                        linkNumber: 4,
                    },
                    {
                        header: Ext.String.format(gettext('Link {0}'), 5),
                        dataIndex: 'ring5_addr',
                        linkNumber: 5,
                    },
                    {
                        header: Ext.String.format(gettext('Link {0}'), 6),
                        dataIndex: 'ring6_addr',
                        linkNumber: 6,
                    },
                    {
                        header: Ext.String.format(gettext('Link {0}'), 7),
                        dataIndex: 'ring7_addr',
                        linkNumber: 7,
                    },
                ],
                defaults: {
                    flex: 1,
                    hidden: true,
                    minWidth: 150,
                },
            },
        },
    ],
});
Ext.define('PVE.ClusterCreateWindow', {
    extend: 'Proxmox.window.Edit',
    xtype: 'pveClusterCreateWindow',

    title: gettext('Create Cluster'),
    width: 600,

    method: 'POST',
    url: '/cluster/config',

    isCreate: true,
    subject: gettext('Cluster'),
    showTaskViewer: true,

    onlineHelp: 'pvecm_create_cluster',

    items: {
        xtype: 'inputpanel',
        items: [
            {
                xtype: 'textfield',
                fieldLabel: gettext('Cluster Name'),
                allowBlank: false,
                maxLength: 15,
                name: 'clustername',
            },
            {
                xtype: 'fieldcontainer',
                fieldLabel: gettext('Cluster Network'),
                items: [
                    {
                        xtype: 'pveCorosyncLinkEditor',
                        infoText: gettext(
                            'Multiple links are used as failover, lower numbers have higher priority.',
                        ),
                        name: 'links',
                    },
                ],
            },
        ],
    },
});

Ext.define('PVE.ClusterInfoWindow', {
    extend: 'Ext.window.Window',
    xtype: 'pveClusterInfoWindow',
    mixins: ['Proxmox.Mixin.CBind'],

    width: 800,
    modal: true,
    resizable: false,
    title: gettext('Cluster Join Information'),

    joinInfo: {
        ipAddress: undefined,
        fingerprint: undefined,
        totem: {},
    },

    items: [
        {
            xtype: 'component',
            border: false,
            padding: '10 10 10 10',
            html: gettext('Copy the Join Information here and use it on the node you want to add.'),
        },
        {
            xtype: 'container',
            layout: 'form',
            border: false,
            padding: '0 10 10 10',
            items: [
                {
                    xtype: 'textfield',
                    fieldLabel: gettext('IP Address'),
                    cbind: {
                        value: '{joinInfo.ipAddress}',
                    },
                    editable: false,
                },
                {
                    xtype: 'textfield',
                    fieldLabel: gettext('Fingerprint'),
                    cbind: {
                        value: '{joinInfo.fingerprint}',
                    },
                    editable: false,
                },
                {
                    xtype: 'textarea',
                    inputId: 'pveSerializedClusterInfo',
                    fieldLabel: gettext('Join Information'),
                    grow: true,
                    cbind: {
                        joinInfo: '{joinInfo}',
                    },
                    editable: false,
                    listeners: {
                        afterrender: function (field) {
                            if (!field.joinInfo) {
                                return;
                            }
                            var jsons = Ext.JSON.encode(field.joinInfo);
                            var base64s = Ext.util.Base64.encode(jsons);
                            field.setValue(base64s);
                        },
                    },
                },
            ],
        },
    ],
    dockedItems: [
        {
            dock: 'bottom',
            xtype: 'toolbar',
            items: [
                {
                    xtype: 'button',
                    handler: function (b) {
                        var el = document.getElementById('pveSerializedClusterInfo');
                        el.select();
                        document.execCommand('copy');
                    },
                    text: gettext('Copy Information'),
                    iconCls: 'fa fa-clipboard',
                },
            ],
        },
    ],
});

Ext.define('PVE.ClusterJoinNodeWindow', {
    extend: 'Proxmox.window.Edit',
    xtype: 'pveClusterJoinNodeWindow',

    title: gettext('Cluster Join'),
    width: 800,

    method: 'POST',
    url: '/cluster/config/join',

    defaultFocus: 'textarea[name=serializedinfo]',
    isCreate: true,
    bind: {
        submitText: '{submittxt}',
    },
    showTaskViewer: true,

    onlineHelp: 'pvecm_join_node_to_cluster',

    viewModel: {
        parent: null,
        data: {
            info: {
                fp: '',
                ip: '',
                clusterName: '',
            },
            hasAssistedInfo: false,
        },
        formulas: {
            submittxt: function (get) {
                let cn = get('info.clusterName');
                if (cn) {
                    return Ext.String.format(gettext('Join {0}'), `'${cn}'`);
                }
                return gettext('Join');
            },
            showClusterFields: (get) => {
                let manualMode = !get('assistedEntry.checked');
                return get('hasAssistedInfo') || manualMode;
            },
        },
    },

    controller: {
        xclass: 'Ext.app.ViewController',
        control: {
            '#': {
                close: function () {
                    delete PVE.Utils.silenceAuthFailures;
                },
            },
            'proxmoxcheckbox[name=assistedEntry]': {
                change: 'onInputTypeChange',
            },
            'textarea[name=serializedinfo]': {
                change: 'recomputeSerializedInfo',
                enable: 'resetField',
            },
            textfield: {
                disable: 'resetField',
            },
        },
        resetField: function (field) {
            field.reset();
        },
        onInputTypeChange: function (field, assistedInput) {
            let linkEditor = this.lookup('linkEditor');

            // this also clears all links
            linkEditor.setAllowNumberEdit(!assistedInput);

            if (!assistedInput) {
                linkEditor.setInfoText();
                linkEditor.setDefaultLinks();
            }
        },
        recomputeSerializedInfo: function (field, value) {
            let vm = this.getViewModel();

            let assistedEntryBox = this.lookup('assistedEntry');

            if (!assistedEntryBox.getValue()) {
                // not in assisted entry mode, nothing to do
                vm.set('hasAssistedInfo', false);
                return;
            }

            let linkEditor = this.lookup('linkEditor');

            let jsons = Ext.util.Base64.decode(value);
            let joinInfo = Ext.JSON.decode(jsons, true);

            let info = {
                fp: '',
                ip: '',
                clusterName: '',
            };

            if (!(joinInfo && joinInfo.totem)) {
                field.valid = false;
                linkEditor.setLinks([]);
                linkEditor.setInfoText();
                vm.set('hasAssistedInfo', false);
            } else {
                let interfaces = joinInfo.totem.interface;
                let links = Object.values(interfaces).map((iface) => {
                    let linkNumber = iface.linknumber;
                    let peerLink;
                    if (joinInfo.peerLinks) {
                        peerLink = joinInfo.peerLinks[linkNumber];
                    }
                    return {
                        number: linkNumber,
                        value: '',
                        text: peerLink
                            ? Ext.String.format(gettext("peer's link address: {0}"), peerLink)
                            : '',
                        allowBlank: false,
                    };
                });

                linkEditor.setInfoText();
                if (
                    links.length === 1 &&
                    joinInfo.ring_addr !== undefined &&
                    joinInfo.ring_addr[0] === joinInfo.ipAddress
                ) {
                    links[0].allowBlank = true;
                    links[0].emptyText = gettext("IP resolved by node's hostname");
                }

                linkEditor.setLinks(links);

                info = {
                    ip: joinInfo.ipAddress,
                    fp: joinInfo.fingerprint,
                    clusterName: joinInfo.totem.cluster_name,
                };
                field.valid = true;
                vm.set('hasAssistedInfo', true);
            }
            vm.set('info', info);
        },
    },

    submit: function () {
        // joining may produce temporarily auth failures, ignore as long the task runs
        PVE.Utils.silenceAuthFailures = true;
        this.callParent();
    },

    taskDone: function (success) {
        delete PVE.Utils.silenceAuthFailures;
        if (success) {
            // reload always (if user wasn't faster), but wait a bit for pveproxy
            Ext.defer(function () {
                window.location.reload(true);
            }, 5000);
            let txt = gettext(
                'Cluster join task finished, node certificate may have changed, reload GUI!',
            );
            // ensure user cannot do harm
            Ext.getBody().mask(txt, ['pve-static-mask']);
            // TaskView may hide above mask, so tell him directly
            Ext.Msg.show({
                title: gettext('Join Task Finished'),
                icon: Ext.Msg.INFO,
                msg: txt,
            });
        }
    },

    items: [
        {
            xtype: 'proxmoxcheckbox',
            reference: 'assistedEntry',
            name: 'assistedEntry',
            itemId: 'assistedEntry',
            submitValue: false,
            value: true,
            autoEl: {
                tag: 'div',
                'data-qtip': gettext(
                    'Select if join information should be extracted from pasted cluster information, deselect for manual entering',
                ),
            },
            boxLabel: gettext(
                'Assisted join: Paste encoded cluster join information and enter password.',
            ),
        },
        {
            xtype: 'textarea',
            name: 'serializedinfo',
            submitValue: false,
            allowBlank: false,
            fieldLabel: gettext('Information'),
            emptyText: gettext('Paste encoded Cluster Information here'),
            validator: function (val) {
                return (
                    val === '' ||
                    this.valid ||
                    gettext('Does not seem like a valid encoded Cluster Information!')
                );
            },
            bind: {
                disabled: '{!assistedEntry.checked}',
                hidden: '{!assistedEntry.checked}',
            },
            value: '',
        },
        {
            xtype: 'panel',
            width: 776,
            layout: {
                type: 'hbox',
                align: 'center',
            },
            bind: {
                hidden: '{!showClusterFields}',
            },
            items: [
                {
                    xtype: 'textfield',
                    flex: 1,
                    margin: '0 5px 0 0',
                    fieldLabel: gettext('Peer Address'),
                    allowBlank: false,
                    bind: {
                        value: '{info.ip}',
                        readOnly: '{assistedEntry.checked}',
                    },
                    name: 'hostname',
                },
                {
                    xtype: 'textfield',
                    flex: 1,
                    margin: '0 0 10px 5px',
                    inputType: 'password',
                    emptyText: gettext("Peer's root password"),
                    fieldLabel: gettext('Password'),
                    allowBlank: false,
                    name: 'password',
                },
            ],
        },
        {
            xtype: 'textfield',
            fieldLabel: gettext('Fingerprint'),
            allowBlank: false,
            bind: {
                value: '{info.fp}',
                readOnly: '{assistedEntry.checked}',
                hidden: '{!showClusterFields}',
            },
            name: 'fingerprint',
        },
        {
            xtype: 'fieldcontainer',
            fieldLabel: gettext('Cluster Network'),
            bind: {
                hidden: '{!showClusterFields}',
            },
            items: [
                {
                    xtype: 'pveCorosyncLinkEditor',
                    itemId: 'linkEditor',
                    reference: 'linkEditor',
                    allowNumberEdit: false,
                },
            ],
        },
    ],
});
/*
 * Datacenter config panel, located in the center of the ViewPort after the Datacenter view is selected
 */

Ext.define('PVE.dc.Config', {
    extend: 'PVE.panel.Config',
    alias: 'widget.PVE.dc.Config',

    onlineHelp: 'pve_admin_guide',

    initComponent: function () {
        var me = this;

        var caps = Ext.state.Manager.get('GuiCap');

        me.items = [];

        Ext.apply(me, {
            title: gettext('Datacenter'),
            hstateid: 'dctab',
        });

        if (caps.dc['Sys.Audit']) {
            me.items.push(
                {
                    title: gettext('Summary'),
                    xtype: 'pveDcSummary',
                    iconCls: 'fa fa-book',
                    itemId: 'summary',
                },
                {
                    xtype: 'pmxNotesView',
                    title: gettext('Notes'),
                    iconCls: 'fa fa-sticky-note-o',
                    itemId: 'notes',
                },
                {
                    title: gettext('Cluster'),
                    xtype: 'pveClusterAdministration',
                    iconCls: 'fa fa-server',
                    itemId: 'cluster',
                },
                {
                    title: 'Ceph',
                    itemId: 'ceph',
                    iconCls: 'fa fa-ceph',
                    xtype: 'pveNodeCephStatus',
                },
                {
                    xtype: 'pveDcOptionView',
                    title: gettext('Options'),
                    iconCls: 'fa fa-gear',
                    itemId: 'options',
                },
            );
        }

        if (caps.storage['Datastore.Allocate'] || caps.dc['Sys.Audit']) {
            me.items.push({
                xtype: 'pveStorageView',
                title: gettext('Storage'),
                iconCls: 'fa fa-database',
                itemId: 'storage',
            });
        }

        if (caps.dc['Sys.Audit']) {
            me.items.push(
                {
                    xtype: 'pveDcBackupView',
                    iconCls: 'fa fa-floppy-o',
                    title: gettext('Backup'),
                    itemId: 'backup',
                },
                {
                    xtype: 'pveReplicaView',
                    iconCls: 'fa fa-retweet',
                    title: gettext('Replication'),
                    itemId: 'replication',
                },
                {
                    xtype: 'pveACLView',
                    title: gettext('Permissions'),
                    iconCls: 'fa fa-unlock',
                    itemId: 'permissions',
                    expandedOnInit: true,
                },
            );
        }

        me.items.push({
            xtype: 'pveUserView',
            groups: ['permissions'],
            iconCls: 'fa fa-user',
            title: gettext('Users'),
            itemId: 'users',
        });

        me.items.push({
            xtype: 'pveTokenView',
            groups: ['permissions'],
            iconCls: 'fa fa-user-o',
            title: gettext('API Tokens'),
            itemId: 'apitokens',
        });

        me.items.push({
            xtype: 'pmxTfaView',
            title: gettext('Two Factor'),
            groups: ['permissions'],
            iconCls: 'fa fa-key',
            itemId: 'tfa',
            yubicoEnabled: true,
            issuerName: `Proxmox VE - ${PVE.ClusterName || Proxmox.NodeName}`,
        });

        if (caps.dc['Sys.Audit']) {
            me.items.push(
                {
                    xtype: 'pveGroupView',
                    title: gettext('Groups'),
                    iconCls: 'fa fa-users',
                    groups: ['permissions'],
                    itemId: 'groups',
                },
                {
                    xtype: 'pvePoolView',
                    title: gettext('Pools'),
                    iconCls: 'fa fa-tags',
                    groups: ['permissions'],
                    itemId: 'pools',
                },
                {
                    xtype: 'pveRoleView',
                    title: gettext('Roles'),
                    iconCls: 'fa fa-male',
                    groups: ['permissions'],
                    itemId: 'roles',
                },
                {
                    title: gettext('Realms'),
                    xtype: 'panel',
                    layout: {
                        type: 'border',
                    },
                    groups: ['permissions'],
                    iconCls: 'fa fa-address-book-o',
                    itemId: 'domains',
                    items: [
                        {
                            xtype: 'pveAuthView',
                            region: 'center',
                            border: false,
                        },
                        {
                            xtype: 'pveRealmSyncJobView',
                            title: gettext('Realm Sync Jobs'),
                            region: 'south',
                            collapsible: true,
                            animCollapse: false,
                            border: false,
                            height: '50%',
                        },
                    ],
                },
                {
                    xtype: 'pveHAStatus',
                    title: 'HA',
                    iconCls: 'fa fa-heartbeat',
                    itemId: 'ha',
                },
                {
                    title: gettext('Groups'),
                    groups: ['ha'],
                    xtype: 'pveHAGroupsView',
                    iconCls: 'fa fa-object-group',
                    itemId: 'ha-groups',
                },
                {
                    title: gettext('Fencing'),
                    groups: ['ha'],
                    iconCls: 'fa fa-bolt',
                    xtype: 'pveFencingView',
                    itemId: 'ha-fencing',
                },
            );
            // always show on initial load, will be hiddea later if the SDN API calls don't exist,
            // else it won't be shown at first if the user initially loads with DC selected
            if (PVE.SDNInfo || PVE.SDNInfo === undefined) {
                me.items.push(
                    {
                        xtype: 'pveSDNStatus',
                        title: gettext('SDN'),
                        iconCls: 'fa fa-sdn x-fa-sdn-treelist',
                        hidden: true,
                        itemId: 'sdn',
                        expandedOnInit: true,
                    },
                    {
                        xtype: 'pveSDNZoneView',
                        groups: ['sdn'],
                        title: gettext('Zones'),
                        hidden: true,
                        iconCls: 'fa fa-th',
                        itemId: 'sdnzone',
                    },
                    {
                        xtype: 'pveSDNVnet',
                        groups: ['sdn'],
                        title: 'VNets',
                        hidden: true,
                        iconCls: 'fa fa-network-wired x-fa-sdn-treelist',
                        itemId: 'sdnvnet',
                    },
                    {
                        xtype: 'pveSDNOptions',
                        groups: ['sdn'],
                        title: gettext('Options'),
                        hidden: true,
                        iconCls: 'fa fa-gear',
                        itemId: 'sdnoptions',
                    },
                    {
                        xtype: 'pveDhcpTree',
                        groups: ['sdn'],
                        title: gettext('IPAM'),
                        hidden: true,
                        iconCls: 'fa fa-map-signs',
                        itemId: 'sdnmappings',
                    },
                    {
                        xtype: 'pveSDNFirewall',
                        groups: ['sdn'],
                        title: gettext('VNet Firewall'),
                        hidden: true,
                        iconCls: 'fa fa-shield',
                        itemId: 'sdnfirewall',
                    },
                );
            }

            if (Proxmox.UserName === 'root@pam') {
                me.items.push({
                    xtype: 'pveACMEClusterView',
                    title: 'ACME',
                    iconCls: 'fa fa-certificate',
                    itemId: 'acme',
                });
            }

            me.items.push(
                {
                    xtype: 'pveFirewallRules',
                    title: gettext('Firewall'),
                    allow_iface: true,
                    base_url: '/cluster/firewall/rules',
                    list_refs_url: '/cluster/firewall/refs',
                    iconCls: 'fa fa-shield',
                    itemId: 'firewall',
                    firewall_type: 'dc',
                },
                {
                    xtype: 'pveFirewallOptions',
                    title: gettext('Options'),
                    groups: ['firewall'],
                    iconCls: 'fa fa-gear',
                    base_url: '/cluster/firewall/options',
                    onlineHelp: 'pve_firewall_cluster_wide_setup',
                    fwtype: 'dc',
                    itemId: 'firewall-options',
                },
                {
                    xtype: 'pveSecurityGroups',
                    title: gettext('Security Group'),
                    groups: ['firewall'],
                    iconCls: 'fa fa-group',
                    itemId: 'firewall-sg',
                },
                {
                    xtype: 'pveFirewallAliases',
                    title: gettext('Alias'),
                    groups: ['firewall'],
                    iconCls: 'fa fa-external-link',
                    base_url: '/cluster/firewall/aliases',
                    itemId: 'firewall-aliases',
                },
                {
                    xtype: 'pveIPSet',
                    title: 'IPSet',
                    groups: ['firewall'],
                    iconCls: 'fa fa-list-ol',
                    base_url: '/cluster/firewall/ipset',
                    list_refs_url: '/cluster/firewall/refs',
                    itemId: 'firewall-ipset',
                },
                {
                    xtype: 'pveMetricServerView',
                    title: gettext('Metric Server'),
                    iconCls: 'fa fa-bar-chart',
                    itemId: 'metricservers',
                    onlineHelp: 'external_metric_server',
                },
            );
        }

        if (
            caps.mapping['Mapping.Audit'] ||
            caps.mapping['Mapping.Use'] ||
            caps.mapping['Mapping.Modify']
        ) {
            me.items.push(
                {
                    xtype: 'container',
                    onlineHelp: 'resource_mapping',
                    title: gettext('Resource Mappings'),
                    itemId: 'resources',
                    iconCls: 'fa fa-folder-o',
                    layout: {
                        type: 'vbox',
                        align: 'stretch',
                        multi: true,
                    },
                    scrollable: true,
                    defaults: {
                        border: false,
                    },
                    items: [
                        {
                            xtype: 'pveDcPCIMapView',
                            title: gettext('PCI Devices'),
                            flex: 1,
                        },
                        {
                            xtype: 'splitter',
                            collapsible: false,
                            performCollapse: false,
                        },
                        {
                            xtype: 'pveDcUSBMapView',
                            title: gettext('USB Devices'),
                            flex: 1,
                        },
                    ],
                },
                {
                    xtype: 'pveDcDirMapView',
                    itemId: 'directories',
                    title: gettext('Directory Mappings'),
                    iconCls: 'fa fa-folder',
                },
            );
        }

        if (
            caps.mapping['Mapping.Audit'] ||
            caps.mapping['Mapping.Use'] ||
            caps.mapping['Mapping.Modify']
        ) {
            me.items.push({
                xtype: 'pmxNotificationConfigView',
                title: gettext('Notifications'),
                itemId: 'notification-targets',
                iconCls: 'fa fa-bell-o',
                baseUrl: '/cluster/notifications',
            });
        }

        if (caps.dc['Sys.Audit']) {
            me.items.push({
                xtype: 'pveDcSupport',
                title: gettext('Support'),
                itemId: 'support',
                iconCls: 'fa fa-comments-o',
            });
        }

        me.callParent();
    },
});
Ext.define('PVE.form.CorosyncLinkEditorController', {
    extend: 'Ext.app.ViewController',
    alias: 'controller.pveCorosyncLinkEditorController',

    addLinkIfEmpty: function () {
        let view = this.getView();
        if (view.items || view.items.length === 0) {
            this.addLink();
        }
    },

    addEmptyLink: function () {
        this.addLink(); // discard parameters to allow being called from 'handler'
    },

    addLink: function (link) {
        let me = this;
        let view = me.getView();
        let vm = view.getViewModel();

        let linkCount = vm.get('linkCount');
        if (linkCount >= vm.get('maxLinkCount')) {
            return;
        }

        link = link || {};

        if (link.number === undefined) {
            link.number = me.getNextFreeNumber();
        }
        if (link.value === undefined) {
            link.value = me.getNextFreeNetwork();
        }

        let linkSelector = Ext.create('PVE.form.CorosyncLinkSelector', {
            maxLinkNumber: vm.get('maxLinkCount') - 1,
            allowNumberEdit: vm.get('allowNumberEdit'),
            allowBlankNetwork: link.allowBlank,
            initNumber: link.number,
            initNetwork: link.value,
            text: link.text,
            emptyText: link.emptyText,

            // needs to be set here, because we need to update the viewmodel
            removeBtnHandler: function () {
                let curLinkCount = vm.get('linkCount');

                if (curLinkCount <= 1) {
                    return;
                }

                vm.set('linkCount', curLinkCount - 1);

                // 'this' is the linkSelector here
                view.remove(this);

                me.updateDeleteButtonState();
            },
        });

        view.add(linkSelector);

        linkCount++;
        vm.set('linkCount', linkCount);

        me.updateDeleteButtonState();
    },

    // ExtJS trips on binding this for some reason, so do it manually
    updateDeleteButtonState: function () {
        let view = this.getView();
        let vm = view.getViewModel();

        let disabled = vm.get('linkCount') <= 1;

        let deleteButtons = view.query('button[cls=removeLinkBtn]');
        Ext.Array.each(deleteButtons, (btn) => {
            btn.setDisabled(disabled);
        });
    },

    getNextFreeNetwork: function () {
        let view = this.getView();
        let vm = view.getViewModel();

        let networksInUse = view.query('proxmoxNetworkSelector').map((selector) => selector.value);

        for (const network of vm.get('networks')) {
            if (!networksInUse.includes(network)) {
                return network;
            }
        }
        return undefined; // default to empty field, user has to set up link manually
    },

    getNextFreeNumber: function () {
        let view = this.getView();
        let vm = view.getViewModel();

        let numbersInUse = view.query('numberfield').map((field) => field.value);

        for (let i = 0; i < vm.get('maxLinkCount'); i++) {
            if (!numbersInUse.includes(i)) {
                return i;
            }
        }
        // all numbers in use, this should never happen since add button is disabled automatically
        return 0;
    },
});

Ext.define('PVE.form.CorosyncLinkSelector', {
    extend: 'Ext.panel.Panel',
    xtype: 'pveCorosyncLinkSelector',

    mixins: ['Proxmox.Mixin.CBind'],
    cbindData: [],

    // config
    maxLinkNumber: 7,
    allowNumberEdit: true,
    allowBlankNetwork: false,
    removeBtnHandler: undefined,
    emptyText: '',

    // values
    initNumber: 0,
    initNetwork: '',
    text: '',

    layout: 'hbox',
    bodyPadding: 5,
    border: 0,

    items: [
        {
            xtype: 'displayfield',
            fieldLabel: 'Link',
            cbind: {
                hidden: '{allowNumberEdit}',
                value: '{initNumber}',
            },
            width: 45,
            labelWidth: 30,
            allowBlank: false,
        },
        {
            xtype: 'numberfield',
            fieldLabel: 'Link',
            cbind: {
                maxValue: '{maxLinkNumber}',
                hidden: '{!allowNumberEdit}',
                value: '{initNumber}',
            },
            width: 80,
            labelWidth: 30,
            minValue: 0,
            submitValue: false, // see getSubmitValue of network selector
            allowBlank: false,
        },
        {
            xtype: 'proxmoxNetworkSelector',
            cbind: {
                allowBlank: '{allowBlankNetwork}',
                value: '{initNetwork}',
                emptyText: '{emptyText}',
            },
            autoSelect: false,
            valueField: 'address',
            displayField: 'address',
            width: 220,
            margin: '0 5px 0 5px',
            getSubmitValue: function () {
                let me = this;
                // link number is encoded into key, so we need to set field name before value retrieval
                let linkNumber = me.prev('numberfield').getValue(); // always the correct one
                me.name = 'link' + linkNumber;
                return me.getValue();
            },
        },
        {
            xtype: 'button',
            iconCls: 'fa fa-trash-o',
            cls: 'removeLinkBtn',
            cbind: {
                hidden: '{!allowNumberEdit}',
            },
            handler: function () {
                let me = this;
                let parent = me.up('pveCorosyncLinkSelector');
                if (parent.removeBtnHandler !== undefined) {
                    parent.removeBtnHandler();
                }
            },
        },
        {
            xtype: 'label',
            margin: '-1px 0 0 5px',

            // for muted effect
            cls: 'x-form-item-label-default',

            cbind: {
                text: '{text}',
            },
        },
    ],

    initComponent: function () {
        let me = this;

        me.callParent();

        let numSelect = me.down('numberfield');
        let netSelect = me.down('proxmoxNetworkSelector');

        numSelect.validator = me.createNoDuplicatesValidator(
            'numberfield',
            gettext('Duplicate link number not allowed.'),
        );

        netSelect.validator = me.createNoDuplicatesValidator(
            'proxmoxNetworkSelector',
            gettext('Duplicate link address not allowed.'),
        );
    },

    createNoDuplicatesValidator: function (queryString, errorMsg) {
        // linkSelector generator
        let view = this;
        /** @this is the field itself, as the validator this is called from scopes it that way */
        return function (val) {
            let me = this;
            let form = view.up('form');
            let linkEditor = view.up('pveCorosyncLinkEditor');

            if (!form.validating) {
                // avoid recursion/double validation by setting temporary states
                me.validating = true;
                form.validating = true;

                // validate all other fields as well, to always mark both
                // parties involved in a 'duplicate' error
                form.isValid();

                form.validating = false;
                me.validating = false;
            } else if (me.validating) {
                // we'll be validated by the original call in the other if-branch, avoid double work
                return true;
            }

            if (val === undefined || (val instanceof String && val.length === 0)) {
                return true; // let this be caught by allowBlank, if at all
            }

            let allFields = linkEditor.query(queryString);
            for (const field of allFields) {
                if (field !== me && String(field.getValue()) === String(val)) {
                    return errorMsg;
                }
            }
            return true;
        };
    },
});

Ext.define('PVE.form.CorosyncLinkEditor', {
    extend: 'Ext.panel.Panel',
    xtype: 'pveCorosyncLinkEditor',

    controller: 'pveCorosyncLinkEditorController',

    // only initial config, use setter otherwise
    allowNumberEdit: true,

    viewModel: {
        data: {
            linkCount: 0,
            maxLinkCount: 8,
            networks: null,
            allowNumberEdit: true,
            infoText: '',
        },
        formulas: {
            addDisabled: function (get) {
                return !get('allowNumberEdit') || get('linkCount') >= get('maxLinkCount');
            },
            dockHidden: function (get) {
                return !(get('allowNumberEdit') || get('infoText'));
            },
        },
    },

    dockedItems: [
        {
            xtype: 'toolbar',
            dock: 'bottom',
            defaultButtonUI: 'default',
            border: false,
            padding: '6 0 6 0',
            bind: {
                hidden: '{dockHidden}',
            },
            items: [
                {
                    xtype: 'button',
                    text: gettext('Add'),
                    bind: {
                        disabled: '{addDisabled}',
                        hidden: '{!allowNumberEdit}',
                    },
                    handler: 'addEmptyLink',
                },
                {
                    xtype: 'label',
                    bind: {
                        text: '{infoText}',
                    },
                },
            ],
        },
    ],

    setInfoText: function (text) {
        let me = this;
        let vm = me.getViewModel();

        vm.set('infoText', text || '');
    },

    setLinks: function (links) {
        let me = this;
        let controller = me.getController();
        let vm = me.getViewModel();

        me.removeAll();
        vm.set('linkCount', 0);

        Ext.Array.each(links, (link) => controller.addLink(link));
    },

    setDefaultLinks: function () {
        let me = this;
        let controller = me.getController();
        let vm = me.getViewModel();

        me.removeAll();
        vm.set('linkCount', 0);
        controller.addLink();
    },

    // clears all links
    setAllowNumberEdit: function (allow) {
        let me = this;
        let vm = me.getViewModel();
        vm.set('allowNumberEdit', allow);
        me.removeAll();
        vm.set('linkCount', 0);
    },

    items: [
        {
            // No links is never a valid scenario, but can occur during a slow load
            xtype: 'hiddenfield',
            submitValue: false,
            isValid: function () {
                let me = this;
                let vm = me.up('pveCorosyncLinkEditor').getViewModel();
                return vm.get('linkCount') > 0;
            },
        },
    ],

    initComponent: function () {
        let me = this;
        let vm = me.getViewModel();
        let controller = me.getController();

        vm.set('allowNumberEdit', me.allowNumberEdit);
        vm.set('infoText', me.infoText || '');

        me.callParent();

        // Request local node networks to pre-populate first link.
        Proxmox.Utils.API2Request({
            url: '/nodes/localhost/network',
            method: 'GET',
            waitMsgTarget: me,
            success: (response) => {
                let data = response.result.data;
                if (data.length > 0) {
                    data.sort((a, b) => a.iface.localeCompare(b.iface));
                    let addresses = [];
                    for (let net of data) {
                        if (net.address) {
                            addresses.push(net.address);
                        }
                        if (net.address6) {
                            addresses.push(net.address6);
                        }
                    }

                    vm.set('networks', addresses);
                }

                // Always have at least one link, but account for delay in API,
                // someone might have called 'setLinks' in the meantime -
                // except if 'allowNumberEdit' is false, in which case we're
                // probably waiting for the user to input the join info
                if (vm.get('allowNumberEdit')) {
                    controller.addLinkIfEmpty();
                }
            },
            failure: () => {
                if (vm.get('allowNumberEdit')) {
                    controller.addLinkIfEmpty();
                }
            },
        });
    },
});
Ext.define('PVE.dc.GroupEdit', {
    extend: 'Proxmox.window.Edit',
    alias: ['widget.pveDcGroupEdit'],

    initComponent: function () {
        var me = this;

        me.isCreate = !me.groupid;

        var url;
        var method;

        if (me.isCreate) {
            url = '/api2/extjs/access/groups';
            method = 'POST';
        } else {
            url = '/api2/extjs/access/groups/' + me.groupid;
            method = 'PUT';
        }

        Ext.applyIf(me, {
            subject: gettext('Group'),
            url: url,
            method: method,
            items: [
                {
                    xtype: me.isCreate ? 'proxmoxtextfield' : 'displayfield',
                    fieldLabel: gettext('Name'),
                    name: 'groupid',
                    value: me.groupid,
                    allowBlank: false,
                },
                {
                    xtype: 'textfield',
                    fieldLabel: gettext('Comment'),
                    name: 'comment',
                    allowBlank: true,
                },
            ],
        });

        me.callParent();

        if (!me.isCreate) {
            me.load();
        }
    },
});
Ext.define('PVE.dc.GroupView', {
    extend: 'Ext.grid.GridPanel',

    alias: ['widget.pveGroupView'],

    onlineHelp: 'pveum_groups',

    stateful: true,
    stateId: 'grid-groups',

    initComponent: function () {
        var me = this;

        var store = new Ext.data.Store({
            model: 'pve-groups',
            sorters: {
                property: 'groupid',
                direction: 'ASC',
            },
        });

        var reload = function () {
            store.load();
        };

        var sm = Ext.create('Ext.selection.RowModel', {});

        var remove_btn = Ext.create('Proxmox.button.StdRemoveButton', {
            selModel: sm,
            callback: function () {
                reload();
            },
            baseurl: '/access/groups/',
        });

        var run_editor = function () {
            var rec = sm.getSelection()[0];
            if (!rec) {
                return;
            }

            var win = Ext.create('PVE.dc.GroupEdit', {
                groupid: rec.data.groupid,
            });
            win.on('destroy', reload);
            win.show();
        };

        var edit_btn = new Proxmox.button.Button({
            text: gettext('Edit'),
            disabled: true,
            selModel: sm,
            handler: run_editor,
        });

        var tbar = [
            {
                text: gettext('Create'),
                handler: function () {
                    var win = Ext.create('PVE.dc.GroupEdit', {});
                    win.on('destroy', reload);
                    win.show();
                },
            },
            edit_btn,
            remove_btn,
        ];

        Proxmox.Utils.monStoreErrors(me, store);

        Ext.apply(me, {
            store: store,
            selModel: sm,
            tbar: tbar,
            viewConfig: {
                trackOver: false,
            },
            columns: [
                {
                    header: gettext('Name'),
                    width: 200,
                    sortable: true,
                    dataIndex: 'groupid',
                },
                {
                    header: gettext('Comment'),
                    sortable: false,
                    renderer: Ext.String.htmlEncode,
                    dataIndex: 'comment',
                    flex: 1,
                },
                {
                    header: gettext('Users'),
                    sortable: false,
                    dataIndex: 'users',
                    renderer: Ext.String.htmlEncode,
                    flex: 1,
                },
            ],
            listeners: {
                activate: reload,
                itemdblclick: run_editor,
            },
        });

        me.callParent();
    },
});
Ext.define('PVE.dc.Guests', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.pveDcGuests',

    title: gettext('Guests'),
    height: 250,
    layout: {
        type: 'table',
        columns: 2,
        tableAttrs: {
            style: {
                width: '100%',
            },
        },
    },
    bodyPadding: '0 20 20 20',

    defaults: {
        xtype: 'box',
        padding: '0 50 0 50',
        style: {
            'text-align': 'center',
            'line-height': '1.5em',
            'font-size': '14px',
        },
    },
    items: [
        {
            itemId: 'qemu',
            data: {
                running: 0,
                paused: 0,
                stopped: 0,
                template: 0,
            },
            cls: 'centered-flex-column',
            tpl: [
                '<h3>' + gettext('Virtual Machines') + '</h3>',
                '<div>',
                '<div class="left-aligned">',
                '<i class="good fa fa-fw fa-play-circle">&nbsp;</i>',
                gettext('Running'),
                '</div>',
                '<div class="right-aligned">{running}</div>',
                '</div>',
                '<tpl if="paused &gt; 0">',
                '<div>',
                '<div class="left-aligned">',
                '<i class="warning fa fa-fw fa-pause-circle">&nbsp;</i>',
                gettext('Paused'),
                '</div>',
                '<div class="right-aligned">{paused}</div>',
                '</div>',
                '</tpl>',
                '<div>',
                '<div class="left-aligned">',
                '<i class="faded fa fa-fw fa-stop-circle">&nbsp;</i>',
                gettext('Stopped'),
                '</div>',
                '<div class="right-aligned">{stopped}</div>',
                '</div>',
                '<tpl if="template &gt; 0">',
                '<div>',
                '<div class="left-aligned">',
                '<i class="fa fa-fw fa-circle-o">&nbsp;</i>',
                gettext('Templates'),
                '</div>',
                '<div class="right-aligned">{template}</div>',
                '</div>',
                '</tpl>',
            ],
        },
        {
            itemId: 'lxc',
            data: {
                running: 0,
                paused: 0,
                stopped: 0,
                template: 0,
            },
            cls: 'centered-flex-column',
            tpl: [
                '<h3>' + gettext('LXC Container') + '</h3>',
                '<div>',
                '<div class="left-aligned">',
                '<i class="good fa fa-fw fa-play-circle">&nbsp;</i>',
                gettext('Running'),
                '</div>',
                '<div class="right-aligned">{running}</div>',
                '</div>',
                '<tpl if="paused &gt; 0">',
                '<div>',
                '<div class="left-aligned">',
                '<i class="warning fa fa-fw fa-pause-circle">&nbsp;</i>',
                gettext('Paused'),
                '</div>',
                '<div class="right-aligned">{paused}</div>',
                '</div>',
                '</tpl>',
                '<div>',
                '<div class="left-aligned">',
                '<i class="faded fa fa-fw fa-stop-circle">&nbsp;</i>',
                gettext('Stopped'),
                '</div>',
                '<div class="right-aligned">{stopped}</div>',
                '</div>',
                '<tpl if="template &gt; 0">',
                '<div>',
                '<div class="left-aligned">',
                '<i class="fa fa-fw fa-circle-o">&nbsp;</i>',
                gettext('Templates'),
                '</div>',
                '<div class="right-aligned">{template}</div>',
                '</div>',
                '</tpl>',
            ],
        },
        {
            itemId: 'error',
            colspan: 2,
            data: {
                num: 0,
            },
            columnWidth: 1,
            padding: '10 250 0 250',
            tpl: [
                '<tpl if="num &gt; 0">',
                '<div class="left-aligned">',
                '<i class="critical fa fa-fw fa-times-circle">&nbsp;</i>',
                gettext('Error'),
                '</div>',
                '<div class="right-aligned">{num}</div>',
                '</tpl>',
            ],
        },
    ],

    updateValues: function (qemu, lxc, error) {
        let me = this;

        let lazyUpdate = (query, newData) => {
            let el = me.getComponent(query);
            let currentData = el.data;

            let keys = Object.keys(newData);
            if (keys.length === Object.keys(currentData).length) {
                if (keys.every((k) => newData[k] === currentData[k])) {
                    return; // all stayed the same here, return early to avoid bogus regeneration
                }
            }
            el.update(newData);
        };
        lazyUpdate('qemu', qemu);
        lazyUpdate('lxc', lxc);
        lazyUpdate('error', { num: error });
    },
});
Ext.define('PVE.dc.Health', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.pveDcHealth',

    title: gettext('Health'),

    bodyPadding: 10,
    height: 250,
    layout: {
        type: 'hbox',
        align: 'stretch',
    },

    defaults: {
        flex: 1,
        xtype: 'box',
        style: {
            'text-align': 'center',
        },
    },

    nodeList: [],
    nodeIndex: 0,

    updateStatus: function (store, records, success) {
        let me = this;
        if (!success) {
            return;
        }

        let cluster = {
            iconCls: PVE.Utils.get_health_icon('good', true),
            text: gettext('Standalone node - no cluster defined'),
        };
        let nodes = {
            online: 0,
            offline: 0,
        };
        let numNodes = 1; // by default we have one node
        for (const { data } of records) {
            if (data.type === 'node') {
                nodes[data.online === 1 ? 'online' : 'offline']++;
            } else if (data.type === 'cluster') {
                cluster.text = `${gettext('Cluster')}: ${data.name}, ${gettext('Quorate')}: `;
                cluster.text += Proxmox.Utils.format_boolean(data.quorate);
                if (data.quorate !== 1) {
                    cluster.iconCls = PVE.Utils.get_health_icon('critical', true);
                }
                numNodes = data.nodes;
            }
        }

        if (numNodes !== nodes.online + nodes.offline) {
            nodes.offline = numNodes - nodes.online;
        }

        me.getComponent('clusterstatus').updateHealth(cluster);
        me.getComponent('nodestatus').update(nodes);
    },

    updateCeph: function (store, records, success) {
        let me = this;
        let cephstatus = me.getComponent('ceph');
        if (!success || records.length < 1) {
            if (cephstatus.isVisible()) {
                return; // if ceph status is already visible don't stop to update
            }
            // try all nodes until we either get a successful api call, or we tried all nodes
            if (++me.nodeIndex >= me.nodeList.length) {
                me.cephstore.stopUpdate();
            } else {
                store
                    .getProxy()
                    .setUrl(`/api2/json/nodes/${me.nodeList[me.nodeIndex].node}/ceph/status`);
            }
            return;
        }

        let state = PVE.Utils.render_ceph_health(records[0].data.health || {});
        cephstatus.updateHealth(state);
        cephstatus.setVisible(true);
    },

    listeners: {
        destroy: function () {
            let me = this;
            me.cephstore.stopUpdate();
        },
    },

    items: [
        {
            itemId: 'clusterstatus',
            xtype: 'pveHealthWidget',
            title: gettext('Status'),
        },
        {
            itemId: 'nodestatus',
            data: {
                online: 0,
                offline: 0,
            },
            tpl: [
                '<h3>' + gettext('Nodes') + '</h3><br />',
                '<div style="width: 150px;margin: auto;font-size: 12pt">',
                '<div class="left-aligned">',
                '<i class="good fa fa-fw fa-check">&nbsp;</i>',
                gettext('Online'),
                '</div>',
                '<div class="right-aligned">{online}</div>',
                '<br /><br />',
                '<div class="left-aligned">',
                '<i class="critical fa fa-fw fa-times">&nbsp;</i>',
                gettext('Offline'),
                '</div>',
                '<div class="right-aligned">{offline}</div>',
                '</div>',
            ],
        },
        {
            itemId: 'ceph',
            width: 250,
            columnWidth: undefined,
            userCls: 'pointer',
            title: 'Ceph',
            xtype: 'pveHealthWidget',
            hidden: true,
            listeners: {
                element: 'el',
                click: function () {
                    Ext.state.Manager.getProvider().set('dctab', { value: 'ceph' }, true);
                },
            },
        },
    ],

    initComponent: function () {
        let me = this;

        me.nodeList = PVE.data.ResourceStore.getNodes();
        me.nodeIndex = 0;
        me.cephstore = Ext.create('Proxmox.data.UpdateStore', {
            interval: 3000,
            storeid: 'pve-cluster-ceph',
            proxy: {
                type: 'proxmox',
                url: `/api2/json/nodes/${me.nodeList[me.nodeIndex].node}/ceph/status`,
            },
        });
        me.callParent();
        me.mon(me.cephstore, 'load', me.updateCeph, me);
        me.cephstore.startUpdate();
    },
});
/* This class defines the "Cluster log" tab of the bottom status panel
 * A log entry is a timestamp associated with an action on a cluster
 */

Ext.define('PVE.dc.Log', {
    extend: 'Ext.grid.GridPanel',

    alias: ['widget.pveClusterLog'],

    initComponent: function () {
        let me = this;

        let logstore = Ext.create('Proxmox.data.UpdateStore', {
            storeid: 'pve-cluster-log',
            model: 'proxmox-cluster-log',
            proxy: {
                type: 'proxmox',
                url: '/api2/json/cluster/log',
            },
        });
        let store = Ext.create('Proxmox.data.DiffStore', {
            rstore: logstore,
            appendAtStart: true,
        });

        Ext.apply(me, {
            store: store,
            stateful: false,

            viewConfig: {
                trackOver: false,
                stripeRows: true,
                getRowClass: function (record, index) {
                    let pri = record.get('pri');
                    if (pri && pri <= 3) {
                        return 'proxmox-invalid-row';
                    }
                    return undefined;
                },
            },
            sortableColumns: false,
            columns: [
                {
                    header: gettext('Time'),
                    dataIndex: 'time',
                    width: 150,
                    renderer: function (value) {
                        return Ext.Date.format(value, 'M d H:i:s');
                    },
                },
                {
                    header: gettext('Node'),
                    dataIndex: 'node',
                    width: 15